/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramCache;

public class AssertionOrderModulation<LETTER> {
    private static final ITraceCheckPreferences.AssertCodeBlockOrder[] DEFAULT_ORDER = new ITraceCheckPreferences.AssertCodeBlockOrder[]{ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, new ITraceCheckPreferences.AssertCodeBlockOrder(ITraceCheckPreferences.AssertCodeBlockOrderType.OUTSIDE_LOOP_FIRST1), new ITraceCheckPreferences.AssertCodeBlockOrder(ITraceCheckPreferences.AssertCodeBlockOrderType.OUTSIDE_LOOP_FIRST2), new ITraceCheckPreferences.AssertCodeBlockOrder(ITraceCheckPreferences.AssertCodeBlockOrderType.TERMS_WITH_SMALL_CONSTANTS_FIRST), new ITraceCheckPreferences.AssertCodeBlockOrder(ITraceCheckPreferences.AssertCodeBlockOrderType.INSIDE_LOOP_FIRST1), new ITraceCheckPreferences.AssertCodeBlockOrder(ITraceCheckPreferences.AssertCodeBlockOrderType.MIX_INSIDE_OUTSIDE)};
    private final ITraceCheckPreferences.AssertCodeBlockOrder[] mOrder;
    private final ILogger mLogger;
    private final PathProgramCache<LETTER> mPathProgramCache;

    public AssertionOrderModulation(PathProgramCache<LETTER> pathProgramCache, ILogger iLogger) {
        this(pathProgramCache, iLogger, DEFAULT_ORDER);
    }

    public AssertionOrderModulation(PathProgramCache<LETTER> pathProgramCache, ILogger iLogger, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
        this.mPathProgramCache = pathProgramCache;
        this.mLogger = iLogger;
        this.mOrder = assertCodeBlockOrderArray == null || assertCodeBlockOrderArray.length == 0 ? DEFAULT_ORDER : assertCodeBlockOrderArray;
    }

    public ITraceCheckPreferences.AssertCodeBlockOrder get(Word<LETTER> word, InterpolationTechnique interpolationTechnique) {
        ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder;
        int n = this.mPathProgramCache.getPathProgramCount(word);
        int n2 = this.toIndex(n - 1);
        int n3 = this.toIndex(n - 2);
        ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder2 = this.getOrder(interpolationTechnique, n3);
        if (assertCodeBlockOrder2 != (assertCodeBlockOrder = this.getOrder(interpolationTechnique, n2))) {
            this.mLogger.info((Object)("Changing assertion order to " + String.valueOf(assertCodeBlockOrder)));
        } else {
            this.mLogger.info((Object)("Keeping assertion order " + String.valueOf(assertCodeBlockOrder)));
        }
        return assertCodeBlockOrder;
    }

    private int toIndex(int n) {
        if (n <= 0) {
            return 0;
        }
        return n % this.mOrder.length;
    }

    private ITraceCheckPreferences.AssertCodeBlockOrder getOrder(InterpolationTechnique interpolationTechnique, int n) {
        if (interpolationTechnique == null) {
            return ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY;
        }
        return switch (interpolationTechnique) {
            case InterpolationTechnique.Craig_NestedInterpolation, InterpolationTechnique.PDR -> ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY;
            case InterpolationTechnique.Craig_TreeInterpolation, InterpolationTechnique.ForwardPredicates, InterpolationTechnique.BackwardPredicates, InterpolationTechnique.FPandBP, InterpolationTechnique.FPandBPonlyIfFpWasNotPerfect, InterpolationTechnique.PathInvariants -> this.mOrder[n];
            default -> throw new MatchException(null, null);
        };
    }
}

