/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public final class GetRandomNwa
extends GeneralOperation<String, String, IStateFactory<String>> {
    private static final long DEFAULT_SEED = 0L;
    private final Random mRandom;
    private final INestedWordAutomaton<String, String> mResult;
    private final int mAlphabetSize;
    private final int mSize;
    private final double mInternalTransitionDensity;
    private final double mCallTransitionDensity;
    private final double mReturnTransitionDensity;
    private final double mAcceptanceDensity;

    public GetRandomNwa(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4, int n5, int n6) {
        this(automataLibraryServices, n, n2, (double)n3 / 1000.0, (double)n4 / 1000.0, (double)n5 / 1000.0, (double)n6 / 1000.0, 0L);
    }

    public GetRandomNwa(AutomataLibraryServices automataLibraryServices, int n, int n2, double d, double d2, double d3, double d4, long l) {
        super(automataLibraryServices);
        this.mRandom = new Random(l);
        this.mAlphabetSize = n;
        this.mSize = n2;
        this.mInternalTransitionDensity = d;
        this.mCallTransitionDensity = d2;
        this.mReturnTransitionDensity = d3;
        this.mAcceptanceDensity = d4;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.generateAutomaton();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return MessageFormat.format("Start {0}. Alphabet size {1} Number of states {2} Density internal transition {3} Density call transition {4} Density return transition {5} Acceptance density {6}", this.getOperationName(), this.mAlphabetSize, this.mSize, this.mInternalTransitionDensity, this.mCallTransitionDensity, this.mReturnTransitionDensity, this.mAcceptanceDensity);
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation() + ".";
    }

    @Override
    public INestedWordAutomaton<String, String> getResult() {
        return this.mResult;
    }

    private INestedWordAutomaton<String, String> generateAutomaton() {
        this.checkUserInput();
        int n = this.mSize * this.mAlphabetSize * this.mSize;
        int n2 = (int)Math.round(this.mInternalTransitionDensity * (double)n);
        if (n2 < this.mSize - 1 && this.mLogger.isWarnEnabled()) {
            this.mLogger.warn((Object)("You specified density " + this.mInternalTransitionDensity + " for internal transition. This is not sufficient to connect all states with internal transitions."));
        }
        int n3 = (int)Math.round(this.mAcceptanceDensity * (double)this.mSize);
        ArrayList<String> arrayList = new ArrayList<String>(this.mSize);
        int n4 = 0;
        while (n4 < this.mSize) {
            arrayList.add("q" + n4);
            ++n4;
        }
        String string = (String)arrayList.get(0);
        ArrayList<String> arrayList2 = new ArrayList<String>(this.mAlphabetSize);
        int n5 = 0;
        while (n5 < this.mAlphabetSize) {
            arrayList2.add("a" + n5);
            ++n5;
        }
        boolean bl = this.mCallTransitionDensity == 0.0 && this.mReturnTransitionDensity == 0.0;
        NestedWordAutomaton<String, String> nestedWordAutomaton = bl ? new NestedWordAutomaton<String, String>(this.mServices, new VpAlphabet(new HashSet(arrayList2)), new StringFactory()) : new NestedWordAutomaton(this.mServices, new VpAlphabet(new HashSet(arrayList2), new HashSet(arrayList2), new HashSet(arrayList2)), new StringFactory());
        this.addStates(n3, arrayList, string, nestedWordAutomaton);
        this.addInternalTransitions(n, n2, arrayList, arrayList2, nestedWordAutomaton);
        if (!bl) {
            this.addCallReturnTransitions(arrayList, arrayList2, nestedWordAutomaton);
        }
        return nestedWordAutomaton;
    }

    private void checkUserInput() {
        if (this.mSize <= 0) {
            throw new IllegalArgumentException("Automaton size must be strictly positive.");
        }
        if (this.mAlphabetSize <= 0) {
            throw new IllegalArgumentException("Alphabet size must be strictly positive.");
        }
        if (this.mInternalTransitionDensity < 0.0 || this.mInternalTransitionDensity > 1.0) {
            throw new IllegalArgumentException("Transition density must be between 0 and 1.");
        }
        if (this.mAcceptanceDensity < 0.0 || this.mAcceptanceDensity > 1.0) {
            throw new IllegalArgumentException("Acceptance density must be between 0 and 1.");
        }
    }

    private void addStates(int n, List<String> list, String string, NestedWordAutomaton<String, String> nestedWordAutomaton) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>(list);
        Collections.shuffle(arrayList, this.mRandom);
        int n2 = 0;
        while (n2 < n) {
            string2 = (String)arrayList.get(n2);
            if (string2.equals(string)) {
                nestedWordAutomaton.addState(true, true, string2);
            } else {
                nestedWordAutomaton.addState(false, true, string2);
            }
            ++n2;
        }
        n2 = n;
        while (n2 < this.mSize) {
            string2 = (String)arrayList.get(n2);
            if (string2.equals(string)) {
                nestedWordAutomaton.addState(true, false, string2);
            } else {
                nestedWordAutomaton.addState(false, false, string2);
            }
            ++n2;
        }
    }

    private void addInternalTransitions(int n, int n2, List<String> list, List<String> list2, NestedWordAutomaton<String, String> nestedWordAutomaton) {
        String string;
        int n3;
        int n4;
        int n5;
        int n6;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mSize);
        arrayList.add(0);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.mSize - 1);
        int n7 = 1;
        while (n7 < this.mSize) {
            arrayList2.add(n7);
            ++n7;
        }
        Collections.shuffle(arrayList2, this.mRandom);
        HashSet<Integer> hashSet = new HashSet<Integer>(this.mSize - 1);
        int n8 = 0;
        while (n8 < arrayList2.size()) {
            n6 = (Integer)arrayList.get(this.mRandom.nextInt(arrayList.size()));
            n5 = this.mRandom.nextInt(this.mAlphabetSize);
            n4 = (Integer)arrayList2.get(n8);
            arrayList.add(n4);
            n3 = n6 * this.mAlphabetSize * this.mSize + n5 * this.mSize + n4;
            hashSet.add(n3);
            String string2 = list.get(n6);
            String string3 = list2.get(n5);
            string = list.get(n4);
            nestedWordAutomaton.addInternalTransition(string2, string3, string);
            ++n8;
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n - this.mSize + 1);
        n6 = 0;
        while (n6 < n) {
            if (!hashSet.contains(n6)) {
                arrayList3.add(n6);
            }
            ++n6;
        }
        Collections.shuffle(arrayList3, this.mRandom);
        n6 = n2 - this.mSize + 1;
        n5 = 0;
        while (n5 < n6) {
            n4 = (Integer)arrayList3.get(n5);
            n3 = n4 / (this.mAlphabetSize * this.mSize);
            int n9 = n4 % (this.mAlphabetSize * this.mSize) / this.mSize;
            int n10 = n4 % this.mSize;
            string = list.get(n3);
            String string4 = list2.get(n9);
            String string5 = list.get(n10);
            nestedWordAutomaton.addInternalTransition(string, string4, string5);
            ++n5;
        }
    }

    private void addCallReturnTransitions(List<String> list, List<String> list2, NestedWordAutomaton<String, String> nestedWordAutomaton) {
        for (String string : list) {
            for (String string2 : list2) {
                for (String string3 : list) {
                    this.tryToAddCallTransition(nestedWordAutomaton, string, string2, string3);
                }
            }
        }
        for (String string : list) {
            for (String string2 : list) {
                for (String string3 : list2) {
                    this.tryToAddReturnTransition(list, nestedWordAutomaton, string, string2, string3);
                }
            }
        }
    }

    private void tryToAddCallTransition(NestedWordAutomaton<String, String> nestedWordAutomaton, String string, String string2, String string3) {
        if ((double)this.mRandom.nextFloat() < this.mCallTransitionDensity) {
            nestedWordAutomaton.addCallTransition(string, string2, string3);
        }
    }

    private void tryToAddReturnTransition(List<String> list, NestedWordAutomaton<String, String> nestedWordAutomaton, String string, String string2, String string3) {
        for (String string4 : list) {
            if (!((double)this.mRandom.nextFloat() < this.mReturnTransitionDensity)) continue;
            nestedWordAutomaton.addReturnTransition(string, string2, string3, string4);
        }
    }
}

