/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.DirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairDirectGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class FairDirectSimulation<LETTER, STATE>
extends FairSimulation<LETTER, STATE> {
    private boolean mIsCurrentlyDirectSimulation;
    private SimulationPerformance mPerformance;
    private boolean mHasFinished;

    public FairDirectSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, FairDirectGameGraph<LETTER, STATE> fairDirectGameGraph) throws AutomataOperationCanceledException {
        this(iProgressAwareTimer, iLogger, bl, iStateFactory, (Collection<Set<STATE>>)Collections.emptyList(), fairDirectGameGraph);
    }

    public FairDirectSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, Collection<Set<STATE>> collection, FairDirectGameGraph<LETTER, STATE> fairDirectGameGraph) throws AutomataOperationCanceledException {
        super(iProgressAwareTimer, iLogger, bl, iStateFactory, collection, fairDirectGameGraph);
    }

    @Override
    public SimulationPerformance getSimulationPerformance() {
        if (this.mHasFinished) {
            return this.mPerformance;
        }
        return super.getSimulationPerformance();
    }

    @Override
    protected FairGameGraphChanges<LETTER, STATE> attemptMerge(STATE STATE, STATE STATE2) throws AutomataOperationCanceledException {
        FairDirectGameGraph fairDirectGameGraph;
        if (this.getGameGraph() instanceof FairDirectGameGraph && (fairDirectGameGraph = (FairDirectGameGraph)this.getGameGraph()).isDirectSimulating(fairDirectGameGraph.getSpoilerVertex(STATE, STATE2, false)) && fairDirectGameGraph.isDirectSimulating(fairDirectGameGraph.getSpoilerVertex(STATE2, STATE, false))) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("\tAttempted merge for " + String.valueOf(STATE) + " and " + String.valueOf(STATE2) + " clearly is possible since they direct simulate each other."));
            }
            return null;
        }
        return super.attemptMerge(STATE, STATE2);
    }

    @Override
    protected FairGameGraphChanges<LETTER, STATE> attemptTransitionRemoval(STATE STATE, LETTER LETTER, STATE STATE2, STATE STATE3) throws AutomataOperationCanceledException {
        FairDirectGameGraph fairDirectGameGraph;
        if (this.getGameGraph() instanceof FairDirectGameGraph && (fairDirectGameGraph = (FairDirectGameGraph)this.getGameGraph()).isDirectSimulating(fairDirectGameGraph.getSpoilerVertex(STATE2, STATE3, false))) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("\tAttempted transition removal for " + String.valueOf(STATE) + " -" + String.valueOf(LETTER) + "-> " + String.valueOf(STATE2) + " clearly is possible since invoker " + String.valueOf(STATE3) + " direct simulates " + String.valueOf(STATE2) + "."));
            }
            return null;
        }
        return super.attemptTransitionRemoval(STATE, LETTER, STATE2, STATE3);
    }

    @Override
    protected int calculateInfinityOfSCC(StronglyConnectedComponent<Vertex<LETTER, STATE>> stronglyConnectedComponent) {
        if (this.mIsCurrentlyDirectSimulation) {
            return 1;
        }
        return super.calculateInfinityOfSCC(stronglyConnectedComponent);
    }

    @Override
    public void doSimulation() throws AutomataOperationCanceledException {
        Object object;
        this.mPerformance = new SimulationPerformance(SimulationOrMinimizationType.FAIRDIRECT, this.isUsingSCCs());
        this.mPerformance.startTimeMeasure(TimeMeasure.OVERALL);
        this.mPerformance.startTimeMeasure(TimeMeasure.SIMULATION_ONLY);
        int n = 0;
        long l = 0L;
        if (this.getGameGraph() instanceof FairDirectGameGraph) {
            object = (FairDirectGameGraph)this.getGameGraph();
            this.getLogger().debug((Object)"Starting direct simulation...");
            this.mIsCurrentlyDirectSimulation = true;
            ((FairDirectGameGraph)object).transformToDirectGameGraph();
            DirectSimulation directSimulation = new DirectSimulation(this.getProgressTimer(), this.getLogger(), this.isUsingSCCs(), this.getStateFactory(), object);
            directSimulation.doSimulation();
            ((FairDirectGameGraph)object).rememberAndClearDirectSimulationResults();
            n = directSimulation.getSimulationPerformance().getCountingMeasureResult(CountingMeasure.SIMULATION_STEPS);
            l = directSimulation.getSimulationPerformance().getTimeMeasureResult(TimeMeasure.BUILD_SCC, MultipleDataOption.ADDITIVE);
            ((FairDirectGameGraph)object).transformToFairGameGraph();
            this.getGameGraph().setSimulationPerformance(super.getSimulationPerformance());
            this.mIsCurrentlyDirectSimulation = false;
            this.getLogger().debug((Object)"Starting fair simulation...");
        }
        this.mPerformance.stopTimeMeasure(TimeMeasure.SIMULATION_ONLY);
        super.doSimulation();
        object = super.getSimulationPerformance();
        long l2 = ((SimulationPerformance)object).getTimeMeasureResult(TimeMeasure.SIMULATION_ONLY, MultipleDataOption.ADDITIVE);
        if (l2 != -1L) {
            this.mPerformance.addTimeMeasureValue(TimeMeasure.SIMULATION_ONLY, l2);
        }
        long l3 = this.mPerformance.stopTimeMeasure(TimeMeasure.OVERALL);
        long l4 = ((SimulationPerformance)object).getTimeMeasureResult(TimeMeasure.BUILD_GRAPH, MultipleDataOption.ADDITIVE);
        if (l4 != -1L) {
            this.mPerformance.addTimeMeasureValue(TimeMeasure.OVERALL, l3 += l4);
        }
        this.getLogger().info((Object)((this.isUsingSCCs() ? "SCC version" : "nonSCC version") + " of fairdirect simulation took " + l3 + " milliseconds"));
        if (n == -1) {
            n = 0;
        }
        if (l == -1L) {
            l = 0L;
        }
        this.mPerformance.addTimeMeasureValue(TimeMeasure.BUILD_SCC, ((SimulationPerformance)object).getTimeMeasureResult(TimeMeasure.BUILD_SCC, MultipleDataOption.ADDITIVE) + l);
        this.mPerformance.setCountingMeasure(CountingMeasure.SIMULATION_STEPS, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.SIMULATION_STEPS) + n);
        this.mPerformance.addTimeMeasureValue(TimeMeasure.BUILD_GRAPH, ((SimulationPerformance)object).getTimeMeasureResult(TimeMeasure.BUILD_GRAPH, MultipleDataOption.ADDITIVE));
        this.mPerformance.addTimeMeasureValue(TimeMeasure.BUILD_RESULT, ((SimulationPerformance)object).getTimeMeasureResult(TimeMeasure.BUILD_RESULT, MultipleDataOption.ADDITIVE));
        this.mPerformance.setCountingMeasure(CountingMeasure.REMOVED_STATES, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.REMOVED_STATES));
        this.mPerformance.setCountingMeasure(CountingMeasure.REMOVED_TRANSITIONS, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.REMOVED_TRANSITIONS));
        this.mPerformance.setCountingMeasure(CountingMeasure.FAILED_MERGE_ATTEMPTS, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.FAILED_MERGE_ATTEMPTS));
        this.mPerformance.setCountingMeasure(CountingMeasure.FAILED_TRANSREMOVE_ATTEMPTS, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.FAILED_TRANSREMOVE_ATTEMPTS));
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_STATES, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.BUCHI_STATES));
        this.mPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITIONS, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.BUCHI_TRANSITIONS));
        this.mPerformance.setCountingMeasure(CountingMeasure.GAMEGRAPH_VERTICES, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.GAMEGRAPH_VERTICES));
        this.mPerformance.setCountingMeasure(CountingMeasure.GAMEGRAPH_EDGES, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.GAMEGRAPH_EDGES));
        this.mPerformance.setCountingMeasure(CountingMeasure.SCCS, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.SCCS));
        this.mPerformance.setCountingMeasure(CountingMeasure.GLOBAL_INFINITY, ((SimulationPerformance)object).getCountingMeasureResult(CountingMeasure.GLOBAL_INFINITY));
        this.mHasFinished = true;
    }

    protected boolean isCurrentlyDirectGameGraph() {
        return this.mIsCurrentlyDirectSimulation;
    }
}

