/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Determinize;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.LoopDetector;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.NwaSimulationUtil;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.SearchElement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.TransitionType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.IWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerWinningSinkExtended;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SummarizeEdge;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameDoubleDeckerSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameSpecialSinkState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameSpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameLetter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.HashRelationBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Hep;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quin;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public final class NwaGameGraphGeneration<LETTER, STATE> {
    public static final int DUPLICATOR_PRIORITY = 2;
    private final HashMap<Hep<STATE, STATE, LETTER, Boolean, TransitionType, SummarizeEdge<LETTER, STATE>, IWinningSink<LETTER, STATE>>, DuplicatorVertex<LETTER, STATE>> mAutomatonStatesToGraphDuplicatorVertex;
    private final HashMap<Quin<STATE, STATE, Boolean, SummarizeEdge<LETTER, STATE>, IWinningSink<LETTER, STATE>>, SpoilerVertex<LETTER, STATE>> mAutomatonStatesToGraphSpoilerVertex;
    private final GameSpecialSinkState mAuxiliaryGameState;
    private final HashSet<SpoilerNwaVertex<LETTER, STATE>> mDuplicatorDirectlyLosesInSpoiler;
    private final HashSet<DuplicatorNwaVertex<LETTER, STATE>> mDuplicatorReturningVertices;
    private DuplicatorWinningSink<LETTER, STATE> mDuplicatorWinningSink;
    private final HashMap<Vertex<LETTER, STATE>, IWinningSink<LETTER, STATE>> mEntryToSink;
    private final AGameGraph<LETTER, STATE> mGameGraph;
    private final ILogger mLogger;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mNwa;
    private final Iterable<Set<STATE>> mPossibleEquivalenceClasses;
    private final HashSet<DuplicatorNwaVertex<LETTER, STATE>> mPossibleNonReturnDuplicatorDeadEnd;
    private final HashSet<SpoilerNwaVertex<LETTER, STATE>> mPossibleSpoilerDeadEnd;
    private final IProgressAwareTimer mProgressTimer;
    private final GameGraphChanges<LETTER, STATE> mRemovedReturnBridges;
    private final boolean mRestrictGraphToInitPart;
    private final AutomataLibraryServices mServices;
    private final SimulationPerformance mSimulationPerformance;
    private final SimulationOrMinimizationType mSimulationType;
    private SpoilerWinningSink<LETTER, STATE> mSpoilerWinningSink;
    private SpoilerWinningSinkExtended<LETTER, STATE> mSpoilerWinningSinkExtended;
    private final NestedMap2<SpoilerNwaVertex<LETTER, STATE>, Pair<STATE, Set<Pair<STATE, Boolean>>>, SummarizeEdge<LETTER, STATE>> mSrcDestToSummarizeEdges;
    private final boolean mUsePushOverEdges;

    public NwaGameGraphGeneration(AutomataLibraryServices automataLibraryServices, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, AGameGraph<LETTER, STATE> aGameGraph, SimulationOrMinimizationType simulationOrMinimizationType, Iterable<Set<STATE>> iterable, boolean bl) {
        this.mServices = automataLibraryServices;
        this.mNwa = iDoubleDeckerAutomaton;
        this.mAutomatonStatesToGraphDuplicatorVertex = new HashMap();
        this.mAutomatonStatesToGraphSpoilerVertex = new HashMap();
        this.mDuplicatorReturningVertices = new HashSet();
        this.mPossibleSpoilerDeadEnd = new HashSet();
        this.mPossibleNonReturnDuplicatorDeadEnd = new HashSet();
        this.mDuplicatorDirectlyLosesInSpoiler = new HashSet();
        this.mSrcDestToSummarizeEdges = new NestedMap2();
        this.mEntryToSink = new HashMap();
        this.mRemovedReturnBridges = new GameGraphChanges();
        this.mAuxiliaryGameState = new GameSpecialSinkState();
        this.mLogger = iLogger;
        this.mProgressTimer = iProgressAwareTimer;
        this.mGameGraph = aGameGraph;
        this.mSimulationType = simulationOrMinimizationType;
        this.mUsePushOverEdges = false;
        this.mSpoilerWinningSink = null;
        this.mSpoilerWinningSinkExtended = null;
        this.mDuplicatorWinningSink = null;
        this.mSimulationPerformance = new SimulationPerformance(simulationOrMinimizationType, false);
        this.mPossibleEquivalenceClasses = iterable;
        this.mRestrictGraphToInitPart = bl;
    }

    public void clear() {
        this.mAutomatonStatesToGraphDuplicatorVertex.clear();
        this.mAutomatonStatesToGraphSpoilerVertex.clear();
        this.mPossibleSpoilerDeadEnd.clear();
        this.mPossibleNonReturnDuplicatorDeadEnd.clear();
        this.mDuplicatorReturningVertices.clear();
        this.mEntryToSink.clear();
        this.mSrcDestToSummarizeEdges.clear();
        this.mDuplicatorDirectlyLosesInSpoiler.clear();
    }

    public void computeSummarizeEdgePriorities() throws AutomataOperationCanceledException {
        Object object;
        Object object2;
        Object object3;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Computing priorities of summarize edges.");
        }
        HashDeque hashDeque = new HashDeque();
        NestedMap3 nestedMap3 = new NestedMap3();
        LoopDetector<LETTER, STATE> loopDetector = new LoopDetector<LETTER, STATE>(this.mGameGraph, this.mLogger, this.mProgressTimer);
        for (Object object42 : this.mSrcDestToSummarizeEdges.entrySet()) {
            object3 = (SummarizeEdge)object42.getThird();
            if (this.mSimulationType == SimulationOrMinimizationType.DIRECT) {
                ((SummarizeEdge)object3).setAllPriorities(0);
                continue;
            }
            object2 = ((SummarizeEdge)object3).getSource();
            for (Pair pair : ((SummarizeEdge)object3).getDuplicatorChoices()) {
                for (SpoilerNwaVertex spoilerNwaVertex : ((SummarizeEdge)object3).getSpoilerInvokers(pair)) {
                    object = new SearchElement(spoilerNwaVertex, object2, null, object3, pair, spoilerNwaVertex);
                    hashDeque.add(object);
                }
            }
        }
        block3: while (!hashDeque.isEmpty()) {
            SpoilerVertex spoilerVertex;
            TransitionType transitionType;
            Iterator<Object> iterator;
            Object object4;
            Object object5;
            int n;
            int n2;
            Object object42;
            object42 = (SearchElement)hashDeque.poll();
            Vertex vertex2 = ((SearchElement)object42).getVertex();
            object3 = ((SearchElement)object42).getTarget();
            object2 = ((SearchElement)object42).getSummarizeEdge();
            Pair pair = ((SearchElement)object42).getDuplicatorChoice();
            Vertex vertex = ((SearchElement)object42).getOrigin();
            Vertex vertex3 = ((SearchElement)object42).getHistory();
            boolean bl = false;
            object = null;
            if (vertex2 instanceof DuplicatorNwaVertex) {
                object = (DuplicatorNwaVertex)vertex2;
                bl = true;
            }
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            boolean bl2 = vertex2.isSpoilerVertex();
            if (bl2) {
                n2 = 1;
                n = 0;
            } else {
                n2 = 0;
                n = 1;
            }
            Set<Vertex<LETTER, STATE>> set = this.mGameGraph.getSuccessors(vertex2);
            if (set != null) {
                for (Vertex<LETTER, STATE> vertex4 : set) {
                    int n6 = -1;
                    if (vertex4 == null) continue;
                    if (vertex4 instanceof DuplicatorNwaVertex) {
                        var23_32 = (DuplicatorNwaVertex)vertex4;
                        object5 = var23_32.getTransitionType();
                        if (object5 == TransitionType.RETURN || object5 == TransitionType.SINK || object5 == TransitionType.SUMMARIZE_EXIT) continue;
                        if (object5 == TransitionType.SUMMARIZE_ENTRY) {
                            Integer n7;
                            object4 = var23_32.getSummarizeEdge();
                            if (!((SummarizeEdge)object4).getDestinations().contains(vertex3)) continue;
                            iterator = vertex3.getQ1();
                            boolean bl3 = vertex3.isB();
                            transitionType = new Pair(iterator, (Object)bl3);
                            spoilerVertex = ((SummarizeEdge)object4).getDestination(transitionType);
                            int n8 = ((SummarizeEdge)object4).getPriority(transitionType);
                            if (n8 == -1) {
                                n8 = 2;
                            }
                            if ((n7 = (Integer)nestedMap3.get(spoilerVertex, object2, pair)) == null || n7 == -1) continue;
                            n6 = Math.min(n8, n7);
                            vertex4 = spoilerVertex;
                        } else {
                            object4 = (Integer)nestedMap3.get(vertex4, object2, pair);
                            if (object4 == null || (Integer)object4 == -1) continue;
                            n6 = (Integer)object4;
                        }
                    } else if (bl) {
                        var23_32 = ((DuplicatorNwaVertex)object).getTransitionType();
                        if (var23_32 == TransitionType.RETURN || var23_32 == TransitionType.SINK || var23_32 == TransitionType.SUMMARIZE_ENTRY || var23_32 == TransitionType.SUMMARIZE_EXIT) break;
                        object5 = (Integer)nestedMap3.get(vertex4, object2, pair);
                        if (object5 == null || (Integer)object5 == -1) continue;
                        n6 = (Integer)object5;
                    }
                    if (!loopDetector.isLoopVertex(vertex4, vertex, vertex2)) {
                        if (n4 != n2) {
                            if (n6 > n4) {
                                n4 = n6;
                            }
                            if (n6 == n2) {
                                n4 = n6;
                                break;
                            }
                        }
                    } else {
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug((Object)("\t\tSuccessor is loop vertex: " + String.valueOf(vertex4)));
                        }
                        if (n5 != n2) {
                            if (n6 > n5) {
                                n5 = n6;
                            }
                            if (n6 == n2) {
                                n5 = n6;
                            }
                        }
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in computeSummarizeEdgePriorties/successors");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                if (n4 == n) {
                    n3 = n;
                    this.mLogger.debug((Object)"\t\tWe do not use loop succesors for priority computation.");
                } else {
                    n3 = n4 == -1 ? n5 : (n5 == -1 ? n4 : (n5 == n ? n4 : (n4 == n2 || n5 == n2 ? n2 : 2)));
                }
            }
            int n9 = vertex2.getPriority();
            int n10 = n3 != -1 ? Math.min(n3, n9) : n9;
            Integer n11 = (Integer)nestedMap3.put((Object)vertex2, object2, pair, (Object)n10);
            boolean bl4 = false;
            if (n11 == null || n11 != n10) {
                bl4 = true;
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("\tSetting '" + n10 + "' for: " + String.valueOf(object42)));
                }
                if (bl && (object5 = ((DuplicatorNwaVertex)object).getTransitionType()) == TransitionType.CALL && (object4 = this.mGameGraph.getPredecessors(vertex2)) != null && object4.contains(object3)) {
                    ((SummarizeEdge)object2).setPriority(pair, n10);
                    bl4 = false;
                }
            }
            if (!bl4 || (object5 = this.mGameGraph.getPredecessors(vertex2)) == null) continue;
            iterator = object5.iterator();
            while (iterator.hasNext()) {
                object4 = (Vertex)iterator.next();
                if (object4 == null) continue;
                if (object4 instanceof DuplicatorNwaVertex) {
                    DuplicatorNwaVertex duplicatorNwaVertex = (DuplicatorNwaVertex)object4;
                    transitionType = duplicatorNwaVertex.getTransitionType();
                    if (transitionType == TransitionType.RETURN || transitionType == TransitionType.SINK || transitionType == TransitionType.SUMMARIZE_ENTRY) continue;
                    if (transitionType == TransitionType.SUMMARIZE_EXIT) {
                        spoilerVertex = duplicatorNwaVertex.getSummarizeEdge().getSource();
                        hashDeque.add(new SearchElement(spoilerVertex, object3, vertex2, object2, pair, vertex));
                    } else {
                        hashDeque.add(new SearchElement(object4, object3, vertex2, object2, pair, vertex));
                    }
                } else if (bl) {
                    TransitionType transitionType2 = ((DuplicatorNwaVertex)object).getTransitionType();
                    if (transitionType2 == TransitionType.RETURN || transitionType2 == TransitionType.SINK || transitionType2 == TransitionType.SUMMARIZE_ENTRY || transitionType2 == TransitionType.SUMMARIZE_EXIT) continue block3;
                    hashDeque.add(new SearchElement(object4, object3, vertex2, object2, pair, vertex));
                }
                if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                this.mLogger.debug((Object)"Stopped in computeSummarizeEdgePriorties/predecessors");
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
    }

    public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph(boolean bl) throws AutomataOperationCanceledException {
        Object object2;
        assert (NwaSimulationUtil.areNwaSimulationResultsCorrect(this.mGameGraph, this.mNwa, this.mSimulationType, new NwaSimulationUtil.BinaryRelationPredicateFromPartition<STATE>(this.mPossibleEquivalenceClasses), this.mLogger)) : "The computed simulation results are incorrect.";
        FairGameGraph<LETTER, STATE> fairGameGraph = this.castGraphToFairGameGraph();
        boolean bl2 = false;
        List<Triple<STATE, LETTER, STATE>> list = null;
        if (fairGameGraph != null) {
            list = fairGameGraph.getTransitionsToRemove();
            bl2 = list != null && !list.isEmpty();
        }
        IMinimizationStateFactory iMinimizationStateFactory = (IMinimizationStateFactory)this.mNwa.getStateFactory();
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = null;
        Object object3 = new UnionFind();
        for (Object object2 : this.mNwa.getStates()) {
            object3.makeEquivalenceClass(object2);
        }
        object2 = new HashRelation();
        for (SpoilerVertex spoilerVertex : this.mGameGraph.getSpoilerVertices()) {
            boolean bl3 = true;
            Object STATE = spoilerVertex.getQ0();
            Object STATE2 = spoilerVertex.getQ1();
            if (STATE == null || STATE2 == null) continue;
            if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                if (spoilerVertex.isB()) {
                    bl3 = this.mNwa.isFinal(STATE) && !this.mNwa.isFinal(STATE2);
                } else {
                    boolean bl4 = bl3 = !this.mNwa.isFinal(STATE) || this.mNwa.isFinal(STATE2);
                }
            }
            if (!bl3 || spoilerVertex.getPM(null, this.mGameGraph.getGlobalInfinity()) >= this.mGameGraph.getGlobalInfinity()) continue;
            object2.addPair(STATE, STATE2);
        }
        for (Object object4 : object2.getDomain()) {
            for (Object e : object2.getImage(object4)) {
                if (!object2.containsPair(e, object4)) continue;
                object3.union(object4, e);
            }
        }
        if (this.mProgressTimer != null && !this.mProgressTimer.continueProcessing()) {
            this.mLogger.debug((Object)"Stopped in generateBuchiAutomatonFromGraph/equivalenceClasses");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        Collection collection = object3.getAllEquivalenceClasses();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Offering the following merges for MaxSat: " + String.valueOf(collection)));
        }
        this.mSimulationPerformance.startTimeMeasure(TimeMeasure.SOLVE_MAX_SAT);
        BiPredicate biPredicate = bl ? new MinimizeNwaMaxSat2.TrueBiPredicate() : new MinimizeNwaMaxSat2.RelationBackedBiPredicate(new HashRelationBackedSetOfPairs());
        MinimizeNwaPmaxSatDirectBi<LETTER, STATE> minimizeNwaPmaxSatDirectBi = new MinimizeNwaPmaxSatDirectBi<LETTER, STATE>(this.mServices, iMinimizationStateFactory, this.mNwa, new PartitionBackedSetOfPairs(collection), new MinimizeNwaMaxSat2.Settings().setFinalNonfinalConstraintPredicate(biPredicate));
        this.mSimulationPerformance.stopTimeMeasure(TimeMeasure.SOLVE_MAX_SAT);
        iDoubleDeckerAutomaton = new RemoveUnreachable(this.mServices, minimizeNwaPmaxSatDirectBi.getResult()).getResult();
        if (this.mProgressTimer != null && !this.mProgressTimer.continueProcessing()) {
            this.mLogger.debug((Object)"Stopped in generateBuchiAutomatonFromGraph/states and transitions added");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (bl2) {
            object3 = new RemoveUnreachable(this.mServices, iDoubleDeckerAutomaton).getResult();
            return object3;
        }
        return iDoubleDeckerAutomaton;
    }

    public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
        this.mSimulationPerformance.startTimeMeasure(TimeMeasure.BUILD_GRAPH);
        this.generateGraphBase();
        this.patchGraph();
        this.mSimulationPerformance.startTimeMeasure(TimeMeasure.GENERATE_SUMMARIZE_EDGES);
        this.generateSummarizeEdges();
        this.mSimulationPerformance.stopTimeMeasure(TimeMeasure.GENERATE_SUMMARIZE_EDGES);
        this.mSimulationPerformance.startTimeMeasure(TimeMeasure.COMPUTE_SUMMARIZE_EDGE_PRIORITIES);
        this.computeSummarizeEdgePriorities();
        this.mSimulationPerformance.stopTimeMeasure(TimeMeasure.COMPUTE_SUMMARIZE_EDGE_PRIORITIES);
        this.clear();
        this.mSimulationPerformance.stopTimeMeasure(TimeMeasure.BUILD_GRAPH);
    }

    public void generateGraphBase() throws AutomataOperationCanceledException {
        SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex;
        this.mLogger.debug((Object)"Generating graph base.");
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Set<STATE> object3 : this.mPossibleEquivalenceClasses) {
            for (STATE STATE : object3) {
                for (STATE STATE2 : object3) {
                    int n = this.calculatePriority(STATE, STATE2);
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        spoilerNwaVertex = this.addSpoilerVertexHelper(0, false, STATE, STATE2);
                        if (spoilerNwaVertex != null) {
                            linkedList.add(spoilerNwaVertex);
                        }
                    } else {
                        spoilerNwaVertex = this.addSpoilerVertexHelper(n, false, STATE, STATE2);
                        if (spoilerNwaVertex != null) {
                            linkedList.add(spoilerNwaVertex);
                        }
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && n == 1 && (spoilerNwaVertex = this.addSpoilerVertexHelper(1, true, STATE, STATE2)) != null) {
                        linkedList.add(spoilerNwaVertex);
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating initial vertices");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
        }
        while (!linkedList.isEmpty()) {
            int n;
            SpoilerVertex spoilerVertex;
            DuplicatorVertex duplicatorVertex;
            DuplicatorVertex duplicatorVertex2;
            Iterator<STATE> iterator;
            DuplicatorVertex duplicatorVertex3;
            STATE STATE;
            Vertex vertex = (Vertex)linkedList.poll();
            if (this.mGameGraph.hasSuccessors(vertex)) continue;
            if (vertex instanceof SpoilerNwaVertex) {
                Object LETTER;
                duplicatorVertex3 = (SpoilerNwaVertex)vertex;
                STATE = duplicatorVertex3.getQ0();
                iterator = duplicatorVertex3.getQ1();
                for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE)) {
                    boolean bl = duplicatorVertex3.isB();
                    spoilerNwaVertex = outgoingInternalTransition.getSucc();
                    LETTER = outgoingInternalTransition.getLetter();
                    duplicatorVertex2 = duplicatorVertex3;
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(spoilerNwaVertex)) {
                        bl = true;
                    }
                    if ((duplicatorVertex = this.getDuplicatorVertex(spoilerNwaVertex, iterator, LETTER, bl, TransitionType.INTERNAL, null, null)) == null && (duplicatorVertex = this.addDuplicatorVertexHelper(2, bl, spoilerNwaVertex, iterator, LETTER, TransitionType.INTERNAL)) != null) {
                        linkedList.add(duplicatorVertex);
                    }
                    if (duplicatorVertex != null) {
                        this.addEdge(duplicatorVertex2, duplicatorVertex);
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating spoiler internal edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                for (OutgoingCallTransition outgoingCallTransition : this.mNwa.callSuccessors(STATE)) {
                    boolean bl = duplicatorVertex3.isB();
                    spoilerNwaVertex = outgoingCallTransition.getSucc();
                    LETTER = outgoingCallTransition.getLetter();
                    duplicatorVertex2 = duplicatorVertex3;
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(spoilerNwaVertex)) {
                        bl = true;
                    }
                    if ((duplicatorVertex = this.getDuplicatorVertex(spoilerNwaVertex, iterator, LETTER, bl, TransitionType.CALL, null, null)) == null && (duplicatorVertex = this.addDuplicatorVertexHelper(2, bl, spoilerNwaVertex, iterator, LETTER, TransitionType.CALL)) != null) {
                        linkedList.add(duplicatorVertex);
                    }
                    if (duplicatorVertex != null) {
                        this.addEdge(duplicatorVertex2, duplicatorVertex);
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating spoiler call edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                for (OutgoingReturnTransition outgoingReturnTransition : this.mNwa.returnSuccessors(STATE)) {
                    boolean bl = duplicatorVertex3.isB();
                    spoilerNwaVertex = outgoingReturnTransition.getSucc();
                    LETTER = outgoingReturnTransition.getLetter();
                    duplicatorVertex2 = duplicatorVertex3;
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(spoilerNwaVertex)) {
                        bl = true;
                    }
                    if ((duplicatorVertex = this.getDuplicatorVertex(spoilerNwaVertex, iterator, LETTER, bl, TransitionType.RETURN, null, null)) == null && (duplicatorVertex = this.addDuplicatorVertexHelper(2, bl, spoilerNwaVertex, iterator, LETTER, TransitionType.RETURN)) != null) {
                        linkedList.add(duplicatorVertex);
                    }
                    if (duplicatorVertex != null) {
                        this.addEdge(duplicatorVertex2, duplicatorVertex);
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating spoiler return edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                continue;
            }
            if (!(vertex instanceof DuplicatorNwaVertex)) continue;
            duplicatorVertex3 = (DuplicatorNwaVertex)vertex;
            STATE = duplicatorVertex3.getQ0();
            iterator = duplicatorVertex3.getQ1();
            Object LETTER = duplicatorVertex3.getLetter();
            Object object = ((DuplicatorNwaVertex)duplicatorVertex3).getTransitionType();
            if (object == TransitionType.INTERNAL) {
                for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(iterator, LETTER)) {
                    boolean bl = duplicatorVertex3.isB();
                    duplicatorVertex2 = outgoingInternalTransition.getSucc();
                    duplicatorVertex = duplicatorVertex3;
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(duplicatorVertex2)) {
                        bl = false;
                    }
                    if ((spoilerVertex = this.getSpoilerVertex(STATE, duplicatorVertex2, bl, null, null)) == null) {
                        if (this.mRestrictGraphToInitPart) {
                            this.addSpoilerWinningSink((DuplicatorNwaVertex<LETTER, STATE>)duplicatorVertex3);
                        } else {
                            n = this.calculatePriority(STATE, duplicatorVertex2);
                            spoilerVertex = this.addSpoilerVertexHelper(n, bl, STATE, duplicatorVertex2);
                            if (spoilerVertex != null) {
                                linkedList.add(spoilerVertex);
                            }
                        }
                    }
                    if (spoilerVertex != null) {
                        this.addEdge(duplicatorVertex, spoilerVertex);
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating duplicator internal edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
            if (object == TransitionType.CALL) {
                for (OutgoingCallTransition outgoingCallTransition : this.mNwa.callSuccessors(iterator, LETTER)) {
                    boolean bl = duplicatorVertex3.isB();
                    duplicatorVertex2 = outgoingCallTransition.getSucc();
                    duplicatorVertex = duplicatorVertex3;
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(duplicatorVertex2)) {
                        bl = false;
                    }
                    if ((spoilerVertex = this.getSpoilerVertex(STATE, duplicatorVertex2, bl, null, null)) == null) {
                        if (this.mRestrictGraphToInitPart) {
                            this.addSpoilerWinningSink((DuplicatorNwaVertex<LETTER, STATE>)duplicatorVertex3);
                        } else {
                            n = this.calculatePriority(STATE, duplicatorVertex2);
                            spoilerVertex = this.addSpoilerVertexHelper(n, bl, STATE, duplicatorVertex2);
                            if (spoilerVertex != null) {
                                linkedList.add(spoilerVertex);
                            }
                        }
                    }
                    if (spoilerVertex != null) {
                        this.addEdge(duplicatorVertex, spoilerVertex);
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating duplicator call edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
            if (object != TransitionType.RETURN) continue;
            for (OutgoingReturnTransition outgoingReturnTransition : this.mNwa.returnSuccessors(iterator, LETTER)) {
                boolean bl = duplicatorVertex3.isB();
                duplicatorVertex2 = outgoingReturnTransition.getSucc();
                duplicatorVertex = duplicatorVertex3;
                if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(duplicatorVertex2)) {
                    bl = false;
                }
                if ((spoilerVertex = this.getSpoilerVertex(STATE, duplicatorVertex2, bl, null, null)) == null) {
                    if (this.mRestrictGraphToInitPart) {
                        this.addSpoilerWinningSink((DuplicatorNwaVertex<LETTER, STATE>)duplicatorVertex3);
                    } else {
                        n = this.calculatePriority(STATE, duplicatorVertex2);
                        spoilerVertex = this.addSpoilerVertexHelper(n, bl, STATE, duplicatorVertex2);
                        if (spoilerVertex != null) {
                            linkedList.add(spoilerVertex);
                        }
                    }
                }
                if (spoilerVertex != null) {
                    this.addEdge(duplicatorVertex, spoilerVertex);
                }
                if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating duplicator return edges");
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
        this.mGameGraph.increaseGlobalInfinity();
    }

    @Deprecated
    public void generateRegularEdges() throws AutomataOperationCanceledException {
        this.mLogger.debug((Object)"Generating regular edges.");
        for (Object STATE : this.mNwa.getStates()) {
            DuplicatorVertex duplicatorVertex;
            SpoilerVertex spoilerVertex;
            SpoilerVertex spoilerVertex2;
            DuplicatorVertex duplicatorVertex2;
            for (IncomingInternalTransition incomingInternalTransition : this.mNwa.internalPredecessors(STATE)) {
                for (Object STATE2 : this.mNwa.getStates()) {
                    duplicatorVertex2 = this.getDuplicatorVertex(STATE2, incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), false, TransitionType.INTERNAL, null, null);
                    spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, false, null, null);
                    if (duplicatorVertex2 != null && spoilerVertex2 != null) {
                        this.addEdge(duplicatorVertex2, spoilerVertex2);
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        duplicatorVertex2 = this.getDuplicatorVertex(STATE2, incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), true, TransitionType.INTERNAL, null, null);
                        spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, true, null, null);
                        if (duplicatorVertex2 != null) {
                            if (this.mNwa.isFinal(STATE)) {
                                spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, false, null, null);
                            }
                            if (spoilerVertex2 != null) {
                                this.addEdge(duplicatorVertex2, spoilerVertex2);
                            }
                        }
                    }
                    spoilerVertex = this.getSpoilerVertex(incomingInternalTransition.getPred(), STATE2, false, null, null);
                    duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingInternalTransition.getLetter(), false, TransitionType.INTERNAL, null, null);
                    if (spoilerVertex != null) {
                        if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(STATE)) {
                            duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingInternalTransition.getLetter(), true, TransitionType.INTERNAL, null, null);
                        }
                        if (duplicatorVertex != null) {
                            this.addEdge(spoilerVertex, duplicatorVertex);
                        }
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        spoilerVertex = this.getSpoilerVertex(incomingInternalTransition.getPred(), STATE2, true, null, null);
                        duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingInternalTransition.getLetter(), true, TransitionType.INTERNAL, null, null);
                        if (spoilerVertex != null && duplicatorVertex != null) {
                            this.addEdge(spoilerVertex, duplicatorVertex);
                        }
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating internal edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                this.addAutomatonTransitionToInternalField(new Triple(incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), STATE));
            }
            for (IncomingCallTransition incomingCallTransition : this.mNwa.callPredecessors(STATE)) {
                for (Object STATE2 : this.mNwa.getStates()) {
                    duplicatorVertex2 = this.getDuplicatorVertex(STATE2, incomingCallTransition.getPred(), incomingCallTransition.getLetter(), false, TransitionType.CALL, null, null);
                    spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, false, null, null);
                    if (duplicatorVertex2 != null && spoilerVertex2 != null) {
                        this.addEdge(duplicatorVertex2, spoilerVertex2);
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        duplicatorVertex2 = this.getDuplicatorVertex(STATE2, incomingCallTransition.getPred(), incomingCallTransition.getLetter(), true, TransitionType.CALL, null, null);
                        spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, true, null, null);
                        if (duplicatorVertex2 != null) {
                            if (this.mNwa.isFinal(STATE)) {
                                spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, false, null, null);
                            }
                            if (spoilerVertex2 != null) {
                                this.addEdge(duplicatorVertex2, spoilerVertex2);
                            }
                        }
                    }
                    spoilerVertex = this.getSpoilerVertex(incomingCallTransition.getPred(), STATE2, false, null, null);
                    duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingCallTransition.getLetter(), false, TransitionType.CALL, null, null);
                    if (spoilerVertex != null) {
                        if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(STATE)) {
                            duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingCallTransition.getLetter(), true, TransitionType.CALL, null, null);
                        }
                        if (duplicatorVertex != null) {
                            this.addEdge(spoilerVertex, duplicatorVertex);
                        }
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        spoilerVertex = this.getSpoilerVertex(incomingCallTransition.getPred(), STATE2, true, null, null);
                        duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingCallTransition.getLetter(), true, TransitionType.CALL, null, null);
                        if (spoilerVertex != null && duplicatorVertex != null) {
                            this.addEdge(spoilerVertex, duplicatorVertex);
                        }
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating call edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
            for (IncomingReturnTransition incomingReturnTransition : this.mNwa.returnPredecessors(STATE)) {
                for (Object STATE2 : this.mNwa.getStates()) {
                    duplicatorVertex2 = this.getDuplicatorVertex(STATE2, incomingReturnTransition.getLinPred(), incomingReturnTransition.getLetter(), false, TransitionType.RETURN, null, null);
                    spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, false, null, null);
                    if (duplicatorVertex2 != null && spoilerVertex2 != null) {
                        this.addEdge(duplicatorVertex2, spoilerVertex2);
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        duplicatorVertex2 = this.getDuplicatorVertex(STATE2, incomingReturnTransition.getLinPred(), incomingReturnTransition.getLetter(), true, TransitionType.RETURN, null, null);
                        spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, true, null, null);
                        if (duplicatorVertex2 != null) {
                            if (this.mNwa.isFinal(STATE)) {
                                spoilerVertex2 = this.getSpoilerVertex(STATE2, STATE, false, null, null);
                            }
                            if (spoilerVertex2 != null) {
                                this.addEdge(duplicatorVertex2, spoilerVertex2);
                            }
                        }
                    }
                    spoilerVertex = this.getSpoilerVertex(incomingReturnTransition.getLinPred(), STATE2, false, null, null);
                    duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingReturnTransition.getLetter(), false, TransitionType.RETURN, null, null);
                    if (spoilerVertex != null) {
                        if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && this.mNwa.isFinal(STATE)) {
                            duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingReturnTransition.getLetter(), true, TransitionType.RETURN, null, null);
                        }
                        if (duplicatorVertex != null) {
                            this.addEdge(spoilerVertex, duplicatorVertex);
                        }
                    }
                    if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                        spoilerVertex = this.getSpoilerVertex(incomingReturnTransition.getLinPred(), STATE2, true, null, null);
                        duplicatorVertex = this.getDuplicatorVertex(STATE, STATE2, incomingReturnTransition.getLetter(), true, TransitionType.RETURN, null, null);
                        if (spoilerVertex != null && duplicatorVertex != null) {
                            this.addEdge(spoilerVertex, duplicatorVertex);
                        }
                    }
                    if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                    this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating return edges");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
        }
    }

    public void generateSummarizeEdges() throws AutomataOperationCanceledException {
        boolean bl;
        Iterable iterable;
        GameSpoilerNwaVertex gameSpoilerNwaVertex;
        Object object;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Generating summarize edges.");
        }
        INwaOutgoingLetterAndTransitionProvider<IGameLetter<LETTER, STATE>, IGameState> iNwaOutgoingLetterAndTransitionProvider = this.createGameAutomaton();
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = new RemoveUnreachable<IGameLetter<LETTER, STATE>, IGameState>(this.mServices, iNwaOutgoingLetterAndTransitionProvider).getResult();
        HashSet object32 = new HashSet();
        for (SpoilerVertex<LETTER, STATE> spoilerVertex : this.mGameGraph.getSpoilerVertices()) {
            if (!(spoilerVertex instanceof SpoilerNwaVertex)) continue;
            object = (SpoilerNwaVertex)spoilerVertex;
            gameSpoilerNwaVertex = new GameSpoilerNwaVertex(object);
            iterable = ((NestedWordAutomatonReachableStates)iDoubleDeckerAutomaton).summarySuccessors(gameSpoilerNwaVertex);
            if (iterable.iterator().hasNext()) {
                object32.add(gameSpoilerNwaVertex);
            }
            if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in generateSummarizeEdges/all summary sources");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        boolean bl2 = bl = !new IsDeterministic(this.mServices, iDoubleDeckerAutomaton).hasNondeterministicTransitions();
        if (bl) {
            this.mSimulationPerformance.setCountingMeasure(CountingMeasure.ALREADY_WAS_DETERMINISTIC, 1);
        }
        Set<Vertex<LETTER, STATE>> set = (IDeterminizeStateFactory)((NestedWordAutomatonReachableStates)iDoubleDeckerAutomaton).getStateFactory();
        object = new Determinize(this.mServices, set, iDoubleDeckerAutomaton, object32).getResult();
        this.mSimulationPerformance.setCountingMeasure(CountingMeasure.DETERMINIZED_GAME_AUTOMATON_STATES, object.size());
        gameSpoilerNwaVertex = new RemoveUnreachable(this.mServices, object).getResult();
        iterable = (IGameState)((NestedWordAutomatonReachableStates)((Object)gameSpoilerNwaVertex)).getEmptyStackState();
        for (IGameState iGameState : ((NestedWordAutomatonReachableStates)((Object)gameSpoilerNwaVertex)).getInitialStates()) {
            IGameState iGameState2;
            if (!(iGameState instanceof GameDoubleDeckerSet)) {
                throw new IllegalStateException("Expected cast to be possible, something seems to be wrong with the game graph.");
            }
            GameDoubleDeckerSet gameDoubleDeckerSet = (GameDoubleDeckerSet)iGameState;
            Set<IGameState> set2 = gameDoubleDeckerSet.getUpStates((IGameState)((Object)iterable));
            if (set2.size() > 1) {
                throw new IllegalStateException("Expected only one up state after determizing the game automaton at summary sources.");
            }
            IGameState iGameState3 = set2.iterator().next();
            if (!(iGameState3 instanceof GameSpoilerNwaVertex)) {
                throw new IllegalStateException("Expected cast to be possible, something seems to be wrong with the game graph.");
            }
            SpoilerNwaVertex spoilerNwaVertex = ((GameSpoilerNwaVertex)iGameState3).getSpoilerNwaVertex();
            HashMap hashMap = new HashMap();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            for (SummaryReturnTransition summaryReturnTransition : ((NestedWordAutomatonReachableStates)((Object)gameSpoilerNwaVertex)).summarySuccessors(iGameState)) {
                IGameState iGameState42;
                iGameState2 = summaryReturnTransition.getSucc();
                GameDoubleDeckerSet gameDoubleDeckerSet2 = (GameDoubleDeckerSet)iGameState2;
                Set<IGameState> set3 = gameDoubleDeckerSet2.getUpStates((IGameState)((Object)iterable));
                if (set3 == null) continue;
                if (set3.size() == 1 && (iGameState42 = set3.iterator().next()).equals(this.mAuxiliaryGameState)) {
                    bl5 = true;
                    continue;
                }
                for (IGameState iGameState42 : set3) {
                    if (iGameState42.equals(this.mAuxiliaryGameState)) continue;
                    SpoilerNwaVertex spoilerNwaVertex2 = ((GameSpoilerNwaVertex)iGameState42).getSpoilerNwaVertex();
                    IWinningSink iWinningSink = spoilerNwaVertex2.getSink();
                    if (iWinningSink == null) {
                        Object STATE = spoilerNwaVertex2.getQ0();
                        Object STATE2 = spoilerNwaVertex2.getQ1();
                        boolean bl6 = spoilerNwaVertex2.isB();
                        if (!hashMap.containsKey(STATE)) {
                            hashMap.put(STATE, new LinkedHashSet());
                        }
                        Set set4 = (Set)hashMap.get(STATE);
                        set4.add(new Pair(STATE2, (Object)bl6));
                        hashMap.put(STATE, set4);
                        continue;
                    }
                    if (iWinningSink.isWinningForSpoiler()) {
                        bl3 = true;
                        continue;
                    }
                    bl4 = true;
                }
                if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                this.mLogger.debug((Object)"Stopped in generateSummarizeEdges/each summary");
                throw new AutomataOperationCanceledException(this.getClass());
            }
            if (bl5) {
                this.addSpoilerWinningSinkExtended(spoilerNwaVertex);
            }
            if (bl3) {
                this.addSpoilerWinningSinkExtended(spoilerNwaVertex);
                continue;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                iGameState2 = entry.getKey();
                this.addSummarizeEdge(spoilerNwaVertex, iGameState2, (Set)entry.getValue());
            }
            if (!hashMap.isEmpty() || !bl4) continue;
            this.addDuplicatorWinningSink(spoilerNwaVertex);
        }
        for (DuplicatorNwaVertex<LETTER, STATE> duplicatorNwaVertex : this.mDuplicatorReturningVertices) {
            set = this.mGameGraph.getSuccessors(duplicatorNwaVertex);
            object = null;
            if (set != null) {
                object = new LinkedList<Vertex<LETTER, STATE>>(set);
                iterable = object.iterator();
                while (iterable.hasNext()) {
                    gameSpoilerNwaVertex = (Vertex)iterable.next();
                    this.mGameGraph.removeEdge(duplicatorNwaVertex, (Vertex<LETTER, STATE>)((Object)gameSpoilerNwaVertex));
                    this.mRemovedReturnBridges.removedEdge(duplicatorNwaVertex, (Vertex<LETTER, STATE>)((Object)gameSpoilerNwaVertex));
                }
            }
            gameSpoilerNwaVertex = this.mGameGraph.getPredecessors(duplicatorNwaVertex);
            iterable = null;
            if (gameSpoilerNwaVertex != null) {
                iterable = new LinkedList<Vertex<LETTER, STATE>>(gameSpoilerNwaVertex);
                for (Vertex vertex : iterable) {
                    this.mGameGraph.removeEdge(vertex, duplicatorNwaVertex);
                    this.mRemovedReturnBridges.removedEdge(vertex, duplicatorNwaVertex);
                    if (this.mGameGraph.hasSuccessors(vertex) || !(vertex instanceof SpoilerNwaVertex)) continue;
                    SpoilerNwaVertex spoilerNwaVertex = (SpoilerNwaVertex)vertex;
                    if (this.mSimulationType.equals((Object)SimulationOrMinimizationType.DELAYED) && spoilerNwaVertex.isB()) {
                        this.addDuplicatorWinningSink(spoilerNwaVertex);
                        continue;
                    }
                    this.addDuplicatorWinningSink(spoilerNwaVertex);
                }
            }
            this.removeDuplicatorVertex(duplicatorNwaVertex);
            this.mRemovedReturnBridges.removedVertex(duplicatorNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tRemoved duplicatorReturn: " + String.valueOf(duplicatorNwaVertex)));
            }
            if (this.mUsePushOverEdges && object != null && iterable != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Vertex vertex = (Vertex)iterator.next();
                    for (Vertex vertex2 : iterable) {
                        this.mGameGraph.addPushOverEdge(vertex2, vertex);
                        this.mRemovedReturnBridges.addedPushOverEdge(vertex2, vertex);
                        if (!this.mLogger.isDebugEnabled()) continue;
                        this.mLogger.debug((Object)("\tAdded pushOver: " + String.valueOf(vertex2) + " -> " + String.valueOf(vertex)));
                    }
                }
            }
            if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in generateSummarizeEdges/delete return vertices");
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    @Deprecated
    public void generateVertices() throws AutomataOperationCanceledException {
        this.mLogger.debug((Object)"Generating vertices.");
        for (Object STATE : this.mNwa.getStates()) {
            for (Object STATE2 : this.mNwa.getStates()) {
                int n = this.calculatePriority(STATE, STATE2);
                if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
                    this.addSpoilerVertexHelper(0, false, STATE, STATE2);
                } else {
                    this.addSpoilerVertexHelper(n, false, STATE, STATE2);
                }
                if (this.mSimulationType == SimulationOrMinimizationType.DELAYED && n == 1) {
                    this.addSpoilerVertexHelper(1, true, STATE, STATE2);
                }
                for (Object LETTER : this.mNwa.lettersInternalIncoming(STATE)) {
                    this.addDuplicatorVertexHelper(2, false, STATE, STATE2, LETTER, TransitionType.INTERNAL);
                    if (this.mSimulationType != SimulationOrMinimizationType.DELAYED) continue;
                    this.addDuplicatorVertexHelper(2, true, STATE, STATE2, LETTER, TransitionType.INTERNAL);
                }
                for (Object LETTER : this.mNwa.lettersCallIncoming(STATE)) {
                    this.addDuplicatorVertexHelper(2, false, STATE, STATE2, LETTER, TransitionType.CALL);
                    if (this.mSimulationType != SimulationOrMinimizationType.DELAYED) continue;
                    this.addDuplicatorVertexHelper(2, true, STATE, STATE2, LETTER, TransitionType.CALL);
                }
                for (IncomingReturnTransition incomingReturnTransition : this.mNwa.returnPredecessors(STATE)) {
                    if (!this.hasDownState(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred())) continue;
                    this.addDuplicatorVertexHelper(2, false, STATE, STATE2, incomingReturnTransition.getLetter(), TransitionType.RETURN);
                    if (this.mSimulationType != SimulationOrMinimizationType.DELAYED) continue;
                    this.addDuplicatorVertexHelper(2, true, STATE, STATE2, incomingReturnTransition.getLetter(), TransitionType.RETURN);
                }
                if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                this.mLogger.debug((Object)"Stopped in generateGameGraphFromAutomaton/generating vertices");
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
        this.mGameGraph.increaseGlobalInfinity();
    }

    public DuplicatorVertex<LETTER, STATE> getDuplicatorVertex(STATE STATE, STATE STATE2, LETTER LETTER, boolean bl, TransitionType transitionType, SummarizeEdge<LETTER, STATE> summarizeEdge, DuplicatorWinningSink<LETTER, STATE> duplicatorWinningSink) {
        return this.mAutomatonStatesToGraphDuplicatorVertex.get(new Hep(STATE, STATE2, LETTER, (Object)bl, (Object)transitionType, summarizeEdge, duplicatorWinningSink));
    }

    public GameGraphChanges<LETTER, STATE> getRemovedReturnBridgesChanges() {
        return this.mRemovedReturnBridges;
    }

    public SimulationPerformance getSimulationPerformance() {
        return this.mSimulationPerformance;
    }

    public SpoilerVertex<LETTER, STATE> getSpoilerVertex(STATE STATE, STATE STATE2, boolean bl, SummarizeEdge<LETTER, STATE> summarizeEdge, DuplicatorWinningSink<LETTER, STATE> duplicatorWinningSink) {
        return this.mAutomatonStatesToGraphSpoilerVertex.get(new Quin(STATE, STATE2, (Object)bl, summarizeEdge, duplicatorWinningSink));
    }

    public void patchGraph() throws AutomataOperationCanceledException {
        for (SpoilerNwaVertex<LETTER, STATE> vertex : this.mDuplicatorDirectlyLosesInSpoiler) {
            this.addSpoilerWinningSinkExtended(vertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tPatched directly losing: " + String.valueOf(vertex)));
            }
            if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in generateBuchiAutomatonFromGraph/patchDeadEnds");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        this.mDuplicatorDirectlyLosesInSpoiler.clear();
        for (SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex : this.mPossibleSpoilerDeadEnd) {
            if (this.mGameGraph.hasSuccessors(spoilerNwaVertex)) continue;
            this.addDuplicatorWinningSink(spoilerNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tPatched spoiler dead-end: " + String.valueOf(spoilerNwaVertex)));
            }
            if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in generateBuchiAutomatonFromGraph/patchDeadEnds");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        this.mPossibleSpoilerDeadEnd.clear();
        for (DuplicatorNwaVertex duplicatorNwaVertex : this.mPossibleNonReturnDuplicatorDeadEnd) {
            if (this.mGameGraph.hasSuccessors(duplicatorNwaVertex)) continue;
            this.addSpoilerWinningSink(duplicatorNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tPatched duplicator dead-end: " + String.valueOf(duplicatorNwaVertex)));
            }
            if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in generateBuchiAutomatonFromGraph/patchDeadEnds");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        this.mPossibleNonReturnDuplicatorDeadEnd.clear();
    }

    private void addAutomatonTransitionToInternalField(Triple<STATE, LETTER, STATE> triple) {
        FairGameGraph<LETTER, STATE> fairGameGraph = this.castGraphToFairGameGraph();
        if (fairGameGraph != null) {
            fairGameGraph.getBuechiTransitions().add(triple);
        }
    }

    private DuplicatorNwaVertex<LETTER, STATE> addDuplicatorVertexHelper(int n, boolean bl, STATE STATE, STATE STATE2, LETTER LETTER, TransitionType transitionType) {
        if (transitionType != TransitionType.RETURN || this.getDuplicatorVertex(STATE, STATE2, LETTER, bl, transitionType, null, null) == null) {
            DuplicatorNwaVertex<LETTER, STATE> duplicatorNwaVertex = new DuplicatorNwaVertex<LETTER, STATE>(n, bl, STATE, STATE2, LETTER, transitionType);
            this.addDuplicatorVertex(duplicatorNwaVertex);
            boolean bl2 = true;
            if (transitionType.equals((Object)TransitionType.INTERNAL)) {
                bl2 = this.mNwa.internalSuccessors(STATE2, LETTER).iterator().hasNext();
            } else if (transitionType.equals((Object)TransitionType.CALL)) {
                bl2 = this.mNwa.callSuccessors(STATE2, LETTER).iterator().hasNext();
            } else if (transitionType.equals((Object)TransitionType.RETURN)) {
                bl2 = this.mNwa.returnSuccessors(STATE2, LETTER).iterator().hasNext();
                this.mDuplicatorReturningVertices.add(duplicatorNwaVertex);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("\tAdded to duplicatorReturningVertices: " + String.valueOf(duplicatorNwaVertex)));
                }
            }
            if (!bl2 && !transitionType.equals((Object)TransitionType.RETURN)) {
                this.mPossibleNonReturnDuplicatorDeadEnd.add(duplicatorNwaVertex);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("\tAdded to possibleNonReturnDuplicatorDeadEnd: " + String.valueOf(duplicatorNwaVertex)));
                }
            }
            return duplicatorNwaVertex;
        }
        return null;
    }

    private void addDuplicatorWinningSink(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex) {
        if (this.mEntryToSink.get(spoilerNwaVertex) == null) {
            if (this.mDuplicatorWinningSink == null) {
                this.mDuplicatorWinningSink = new DuplicatorWinningSink<LETTER, STATE>(this.mGameGraph);
                this.mDuplicatorWinningSink.addToGraph();
            }
            this.mEntryToSink.put(spoilerNwaVertex, this.mDuplicatorWinningSink);
            this.mDuplicatorWinningSink.connectToEntry(spoilerNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAdded to duplicatorWinningSink: " + String.valueOf(spoilerNwaVertex)));
            }
        }
    }

    private void addEdgeToGameAutomaton(IGameState iGameState, IGameLetter<LETTER, STATE> iGameLetter, IGameState iGameState2, NestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState> nestedWordAutomaton) {
        TransitionType transitionType = iGameLetter.getTransitionType();
        if (transitionType.equals((Object)TransitionType.INTERNAL)) {
            if (!nestedWordAutomaton.containsInternalTransition(iGameState, iGameLetter, iGameState2)) {
                nestedWordAutomaton.addInternalTransition(iGameState, iGameLetter, iGameState2);
            }
        } else if (transitionType.equals((Object)TransitionType.CALL)) {
            if (!nestedWordAutomaton.containsCallTransition(iGameState, iGameLetter, iGameState2)) {
                nestedWordAutomaton.addCallTransition(iGameState, iGameLetter, iGameState2);
            }
        } else {
            throw new IllegalArgumentException("The transition type of the game letter is not supported by this operation.");
        }
    }

    private void addEdgeToGameAutomaton(IGameState iGameState, IGameState iGameState2, IGameLetter<LETTER, STATE> iGameLetter, IGameState iGameState3, NestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState> nestedWordAutomaton) {
        TransitionType transitionType = iGameLetter.getTransitionType();
        if (!transitionType.equals((Object)TransitionType.RETURN)) {
            throw new IllegalArgumentException("The transition type of the game letter is not supported by this operation.");
        }
        if (!nestedWordAutomaton.containsReturnTransition(iGameState, iGameState2, iGameLetter, iGameState3)) {
            nestedWordAutomaton.addReturnTransition(iGameState, iGameState2, iGameLetter, iGameState3);
        }
    }

    private void addGameStateToGameAutomaton(IGameState iGameState, NestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState> nestedWordAutomaton) {
        if (!nestedWordAutomaton.contains(iGameState)) {
            nestedWordAutomaton.addState(true, false, iGameState);
        }
    }

    private SpoilerNwaVertex<LETTER, STATE> addSpoilerVertexHelper(int n, boolean bl, STATE STATE, STATE STATE2) {
        boolean bl2;
        SpoilerNwaVertex spoilerNwaVertex = new SpoilerNwaVertex(n, bl, STATE, STATE2);
        this.addSpoilerVertex(spoilerNwaVertex);
        if (n == 1) {
            this.mGameGraph.increaseGlobalInfinity();
        }
        boolean bl3 = this.mNwa.internalSuccessors(STATE).iterator().hasNext();
        boolean bl4 = this.mNwa.callSuccessors(STATE).iterator().hasNext();
        if (!(bl3 || (bl2 = this.mNwa.returnSuccessors(STATE).iterator().hasNext()) || bl4)) {
            this.mPossibleSpoilerDeadEnd.add(spoilerNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAdded to possibleSpoilerDeadEnd: " + String.valueOf(spoilerNwaVertex)));
            }
        }
        if (this.mSimulationType.equals((Object)SimulationOrMinimizationType.DIRECT) && this.doesLoseInDirectSim(STATE, STATE2)) {
            this.mDuplicatorDirectlyLosesInSpoiler.add(spoilerNwaVertex);
        }
        if (this.mSimulationType.equals((Object)SimulationOrMinimizationType.DELAYED) && bl && this.mNwa.isFinal(STATE2)) {
            this.mPossibleSpoilerDeadEnd.add(spoilerNwaVertex);
        }
        return spoilerNwaVertex;
    }

    private void addSpoilerWinningSink(DuplicatorNwaVertex<LETTER, STATE> duplicatorNwaVertex) {
        if (this.mEntryToSink.get(duplicatorNwaVertex) == null) {
            if (this.mSpoilerWinningSink == null) {
                this.mSpoilerWinningSink = new SpoilerWinningSink<LETTER, STATE>(this.mGameGraph);
                this.mSpoilerWinningSink.addToGraph();
            }
            this.mEntryToSink.put(duplicatorNwaVertex, this.mSpoilerWinningSink);
            this.mSpoilerWinningSink.connectToEntry(duplicatorNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAdded to spoilerWinningSink: " + String.valueOf(duplicatorNwaVertex)));
            }
        }
    }

    private void addSpoilerWinningSinkExtended(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex) {
        if (this.mEntryToSink.get(spoilerNwaVertex) == null) {
            if (this.mSpoilerWinningSinkExtended == null) {
                this.mSpoilerWinningSinkExtended = new SpoilerWinningSinkExtended<LETTER, STATE>(this.mGameGraph);
                this.mSpoilerWinningSinkExtended.addToGraph();
            }
            this.mEntryToSink.put(spoilerNwaVertex, this.mSpoilerWinningSinkExtended);
            this.mSpoilerWinningSinkExtended.connectToEntry(spoilerNwaVertex);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAdded to spoilerWinningSinkExtended: " + String.valueOf(spoilerNwaVertex)));
            }
        }
    }

    private void addSummarizeEdge(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, STATE STATE, Set<Pair<STATE, Boolean>> set) {
        if (this.mSrcDestToSummarizeEdges.get(spoilerNwaVertex, (Object)new Pair(STATE, set)) == null) {
            SummarizeEdge<LETTER, STATE> summarizeEdge = new SummarizeEdge<LETTER, STATE>(spoilerNwaVertex, STATE, set, this);
            summarizeEdge.addToGameGraph();
            this.mSrcDestToSummarizeEdges.put(spoilerNwaVertex, (Object)new Pair(STATE, set), summarizeEdge);
            this.mSimulationPerformance.increaseCountingMeasure(CountingMeasure.SUMMARIZE_EDGES);
            int n = this.mSimulationPerformance.getCountingMeasureResult(CountingMeasure.SUB_SUMMARIZE_EDGES);
            if (n == -1) {
                n = 0;
            }
            this.mSimulationPerformance.setCountingMeasure(CountingMeasure.SUB_SUMMARIZE_EDGES, n + set.size());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAdded summarizeEdge: " + String.valueOf(spoilerNwaVertex) + " -" + String.valueOf(STATE) + "-> " + String.valueOf(set)));
            }
        }
    }

    private int calculatePriority(STATE STATE, STATE STATE2) {
        if (this.mSimulationType == SimulationOrMinimizationType.DIRECT) {
            return 0;
        }
        if (this.mSimulationType == SimulationOrMinimizationType.DELAYED) {
            if (!this.mNwa.isFinal(STATE2)) {
                return 1;
            }
            return 0;
        }
        if (this.mNwa.isFinal(STATE2)) {
            return 0;
        }
        if (this.mNwa.isFinal(STATE)) {
            return 1;
        }
        return 2;
    }

    private FairGameGraph<LETTER, STATE> castGraphToFairGameGraph() {
        FairGameGraph fairGameGraph = null;
        if (this.mGameGraph instanceof FairGameGraph) {
            fairGameGraph = (FairGameGraph)this.mGameGraph;
        }
        return fairGameGraph;
    }

    private Iterable<GameSpoilerNwaVertex<LETTER, STATE>> computeAllGameHierPreds(SpoilerVertex<LETTER, STATE> spoilerVertex, SpoilerVertex<LETTER, STATE> spoilerVertex2, LETTER LETTER) {
        return this.computeAllGameHierPreds(spoilerVertex.getQ0(), spoilerVertex.getQ1(), spoilerVertex2.getQ0(), spoilerVertex2.getQ1(), LETTER);
    }

    private Iterable<GameSpoilerNwaVertex<LETTER, STATE>> computeAllGameHierPreds(SpoilerVertex<LETTER, STATE> spoilerVertex, STATE STATE, LETTER LETTER) {
        return this.computeAllGameHierPreds(spoilerVertex.getQ0(), spoilerVertex.getQ1(), STATE, null, LETTER);
    }

    private Iterable<GameSpoilerNwaVertex<LETTER, STATE>> computeAllGameHierPreds(STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4, LETTER LETTER) {
        LinkedHashSet<GameSpoilerNwaVertex<LETTER, STATE>> linkedHashSet = new LinkedHashSet<GameSpoilerNwaVertex<LETTER, STATE>>();
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashSet<STATE> hashSet2 = new HashSet<STATE>();
        if (STATE3 != null) {
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mNwa.returnSuccessors(STATE, LETTER)) {
                if (!outgoingReturnTransition.getSucc().equals(STATE3)) continue;
                hashSet.add(outgoingReturnTransition.getHierPred());
            }
        } else {
            hashSet.addAll(this.mNwa.getDownStates(STATE));
            hashSet.remove(this.mNwa.getEmptyStackState());
        }
        if (STATE4 != null) {
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mNwa.returnSuccessors(STATE2, LETTER)) {
                if (!outgoingReturnTransition.getSucc().equals(STATE4)) continue;
                hashSet2.add(outgoingReturnTransition.getHierPred());
            }
        } else {
            hashSet2.addAll(this.mNwa.getDownStates(STATE2));
            hashSet2.remove(this.mNwa.getEmptyStackState());
        }
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : hashSet) {
            for (Object e : hashSet2) {
                SpoilerVertex<LETTER, Object> spoilerVertex = this.getSpoilerVertex(outgoingReturnTransition, e, false, null, null);
                if (spoilerVertex instanceof SpoilerNwaVertex) {
                    linkedHashSet.add(new GameSpoilerNwaVertex((SpoilerNwaVertex)spoilerVertex));
                }
                if (!this.mSimulationType.equals((Object)SimulationOrMinimizationType.DELAYED) || !((spoilerVertex = this.getSpoilerVertex(outgoingReturnTransition, e, true, null, null)) instanceof SpoilerNwaVertex)) continue;
                linkedHashSet.add(new GameSpoilerNwaVertex((SpoilerNwaVertex)spoilerVertex));
            }
        }
        return linkedHashSet;
    }

    private INwaOutgoingLetterAndTransitionProvider<IGameLetter<LETTER, STATE>, IGameState> createGameAutomaton() throws AutomataOperationCanceledException {
        Set<Vertex<LETTER, STATE>> set;
        Object object;
        SpoilerNwaVertex spoilerNwaVertex;
        HashSet<DuplicatorNwaVertex> hashSet = new HashSet<DuplicatorNwaVertex>();
        HashSet<DuplicatorNwaVertex> hashSet2 = new HashSet<DuplicatorNwaVertex>();
        HashSet<DuplicatorNwaVertex> hashSet3 = new HashSet<DuplicatorNwaVertex>();
        VpAlphabet vpAlphabet = new VpAlphabet(hashSet, hashSet2, hashSet3);
        NestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState> nestedWordAutomaton = new NestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState>(this.mServices, vpAlphabet, new GameFactory());
        LinkedList<Pair> linkedList = new LinkedList<Pair>();
        for (SpoilerVertex<LETTER, STATE> pair : this.mGameGraph.getSpoilerVertices()) {
            if (!(pair instanceof SpoilerNwaVertex)) continue;
            spoilerNwaVertex = (SpoilerNwaVertex)pair;
            object = null;
            set = this.mGameGraph.getSuccessors(spoilerNwaVertex);
            if (set == null) continue;
            for (Vertex<LETTER, STATE> vertex : set) {
                DuplicatorNwaVertex duplicatorNwaVertex;
                if (!(vertex instanceof DuplicatorNwaVertex)) continue;
                DuplicatorNwaVertex duplicatorNwaVertex2 = (DuplicatorNwaVertex)vertex;
                Set<Vertex<LETTER, STATE>> set2 = this.mGameGraph.getSuccessors(duplicatorNwaVertex2);
                if (set2 == null) {
                    if (!duplicatorNwaVertex2.getTransitionType().equals((Object)TransitionType.RETURN)) continue;
                    linkedList.add(new Pair((Object)spoilerNwaVertex, (Object)duplicatorNwaVertex2));
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug((Object)("\tRuns into Duplicator dead end: " + String.valueOf(spoilerNwaVertex) + " -> " + String.valueOf(duplicatorNwaVertex2)));
                    continue;
                }
                TransitionType transitionType = duplicatorNwaVertex2.getTransitionType();
                switch (transitionType) {
                    case CALL: {
                        duplicatorNwaVertex = duplicatorNwaVertex2;
                        hashSet2.add(duplicatorNwaVertex);
                        break;
                    }
                    case INTERNAL: {
                        duplicatorNwaVertex = duplicatorNwaVertex2;
                        hashSet.add(duplicatorNwaVertex);
                        break;
                    }
                    case RETURN: {
                        duplicatorNwaVertex = duplicatorNwaVertex2;
                        hashSet3.add(duplicatorNwaVertex);
                        break;
                    }
                    case SINK: 
                    case SUMMARIZE_ENTRY: 
                    case SUMMARIZE_EXIT: {
                        duplicatorNwaVertex = null;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"unknown ETransitionType");
                    }
                }
                object = new GameSpoilerNwaVertex(spoilerNwaVertex);
                this.addGameStateToGameAutomaton((IGameState)object, nestedWordAutomaton);
                for (Vertex vertex2 : set2) {
                    if (!(vertex2 instanceof SpoilerNwaVertex)) continue;
                    SpoilerNwaVertex spoilerNwaVertex2 = (SpoilerNwaVertex)vertex2;
                    GameSpoilerNwaVertex gameSpoilerNwaVertex = new GameSpoilerNwaVertex(spoilerNwaVertex2);
                    this.addGameStateToGameAutomaton(gameSpoilerNwaVertex, nestedWordAutomaton);
                    if (transitionType.equals((Object)TransitionType.INTERNAL)) {
                        this.addEdgeToGameAutomaton((IGameState)object, duplicatorNwaVertex, gameSpoilerNwaVertex, nestedWordAutomaton);
                        continue;
                    }
                    if (transitionType.equals((Object)TransitionType.CALL)) {
                        this.addEdgeToGameAutomaton((IGameState)object, duplicatorNwaVertex, gameSpoilerNwaVertex, nestedWordAutomaton);
                        continue;
                    }
                    if (!transitionType.equals((Object)TransitionType.RETURN)) continue;
                    Iterable iterable = this.computeAllGameHierPreds((SpoilerVertex<LETTER, STATE>)spoilerNwaVertex, (STATE)spoilerNwaVertex2, duplicatorNwaVertex2.getLetter());
                    for (GameSpoilerNwaVertex gameSpoilerNwaVertex2 : iterable) {
                        this.addGameStateToGameAutomaton(gameSpoilerNwaVertex2, nestedWordAutomaton);
                        this.addEdgeToGameAutomaton((IGameState)object, gameSpoilerNwaVertex2, duplicatorNwaVertex, gameSpoilerNwaVertex, nestedWordAutomaton);
                    }
                }
                if (this.mProgressTimer == null || this.mProgressTimer.continueProcessing()) continue;
                this.mLogger.debug((Object)"Stopped in generateSummarizeEdges/create game automaton");
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
        if (!linkedList.isEmpty()) {
            this.addGameStateToGameAutomaton(this.mAuxiliaryGameState, nestedWordAutomaton);
        }
        for (Pair pair : linkedList) {
            spoilerNwaVertex = (SpoilerNwaVertex)pair.getFirst();
            object = (DuplicatorNwaVertex)pair.getSecond();
            set = ((Vertex)object).getQ0();
            Object LETTER = ((DuplicatorVertex)object).getLetter();
            GameSpoilerNwaVertex gameSpoilerNwaVertex = new GameSpoilerNwaVertex(spoilerNwaVertex);
            this.addGameStateToGameAutomaton(gameSpoilerNwaVertex, nestedWordAutomaton);
            hashSet3.add((DuplicatorNwaVertex)object);
            for (GameSpoilerNwaVertex gameSpoilerNwaVertex3 : this.computeAllGameHierPreds(spoilerNwaVertex, set, LETTER)) {
                this.addGameStateToGameAutomaton(gameSpoilerNwaVertex3, nestedWordAutomaton);
                this.addEdgeToGameAutomaton(gameSpoilerNwaVertex, gameSpoilerNwaVertex3, (IGameLetter<LETTER, STATE>)object, this.mAuxiliaryGameState, nestedWordAutomaton);
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("\tAdded edge for gameHierPred: " + String.valueOf(gameSpoilerNwaVertex3)));
            }
        }
        return nestedWordAutomaton;
    }

    private boolean doesLoseInDirectSim(STATE STATE, STATE STATE2) {
        boolean bl;
        boolean bl2 = bl = this.mNwa.isFinal(STATE) && !this.mNwa.isFinal(STATE2);
        if (bl && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("\t\tDuplicator directly loses with Spoiler in: (" + String.valueOf(STATE) + ", " + String.valueOf(STATE2) + ")"));
        }
        return bl;
    }

    private boolean hasDownState(STATE STATE, STATE STATE2) {
        return this.mNwa.isDoubleDecker(STATE, STATE2);
    }

    protected void addDuplicatorVertex(DuplicatorVertex<LETTER, STATE> duplicatorVertex) {
        if (duplicatorVertex instanceof DuplicatorNwaVertex) {
            DuplicatorNwaVertex duplicatorNwaVertex = (DuplicatorNwaVertex)duplicatorVertex;
            this.mGameGraph.getInternalDuplicatorVerticesField().add(duplicatorNwaVertex);
            this.mAutomatonStatesToGraphDuplicatorVertex.put(new Hep(duplicatorNwaVertex.getQ0(), duplicatorNwaVertex.getQ1(), duplicatorNwaVertex.getLetter(), (Object)duplicatorNwaVertex.isB(), (Object)duplicatorNwaVertex.getTransitionType(), duplicatorNwaVertex.getSummarizeEdge(), duplicatorNwaVertex.getSink()), duplicatorNwaVertex);
        } else {
            this.mGameGraph.addDuplicatorVertex(duplicatorVertex);
        }
    }

    protected void addEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        this.mGameGraph.addEdge(vertex, vertex2);
    }

    protected void addSpoilerVertex(SpoilerVertex<LETTER, STATE> spoilerVertex) {
        if (spoilerVertex instanceof SpoilerNwaVertex) {
            SpoilerNwaVertex spoilerNwaVertex = (SpoilerNwaVertex)spoilerVertex;
            this.mGameGraph.getInternalSpoilerVerticesField().add(spoilerNwaVertex);
            this.mAutomatonStatesToGraphSpoilerVertex.put(new Quin(spoilerNwaVertex.getQ0(), spoilerNwaVertex.getQ1(), (Object)spoilerNwaVertex.isB(), spoilerNwaVertex.getSummarizeEdge(), spoilerNwaVertex.getSink()), spoilerNwaVertex);
        } else {
            this.mGameGraph.addSpoilerVertex(spoilerVertex);
        }
    }

    protected AGameGraph<LETTER, STATE> getGameGraph() {
        return this.mGameGraph;
    }

    protected void removeDuplicatorVertex(DuplicatorVertex<LETTER, STATE> duplicatorVertex) {
        if (duplicatorVertex instanceof DuplicatorNwaVertex) {
            DuplicatorNwaVertex duplicatorNwaVertex = (DuplicatorNwaVertex)duplicatorVertex;
            this.mGameGraph.getInternalDuplicatorVerticesField().remove(duplicatorNwaVertex);
            this.mAutomatonStatesToGraphDuplicatorVertex.put(new Hep(duplicatorNwaVertex.getQ0(), duplicatorNwaVertex.getQ1(), duplicatorNwaVertex.getLetter(), (Object)duplicatorNwaVertex.isB(), (Object)duplicatorNwaVertex.getTransitionType(), duplicatorNwaVertex.getSummarizeEdge(), duplicatorNwaVertex.getSink()), null);
        } else {
            this.mGameGraph.removeDuplicatorVertex(duplicatorVertex);
        }
    }

    protected void removeSpoilerVertex(SpoilerVertex<LETTER, STATE> spoilerVertex) {
        if (spoilerVertex instanceof SpoilerNwaVertex) {
            SpoilerNwaVertex spoilerNwaVertex = (SpoilerNwaVertex)spoilerVertex;
            this.mGameGraph.getInternalSpoilerVerticesField().remove(spoilerNwaVertex);
            this.mAutomatonStatesToGraphSpoilerVertex.put(new Quin(spoilerNwaVertex.getQ0(), spoilerNwaVertex.getQ1(), (Object)spoilerNwaVertex.isB(), spoilerNwaVertex.getSummarizeEdge(), spoilerNwaVertex.getSink()), null);
        } else {
            this.mGameGraph.removeSpoilerVertex(spoilerVertex);
        }
    }
}

