/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryArea;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class StdlibLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final TypeSizes mTypeSizes;
    private final TypeSizeAndOffsetComputer mTypeSizeComputer;
    private final ExpressionTranslation mExpressionTranslation;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final MemoryHandler mMemoryHandler;
    private final ProcedureManager mProcedureManager;
    private final INameHandler mNameHandler;
    private final CACSLPreferenceInitializer.CheckMode mOverflowCheckMode;

    public StdlibLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, TypeSizes typeSizes, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, ExpressionTranslation expressionTranslation, AuxVarInfoBuilder auxVarInfoBuilder, MemoryHandler memoryHandler, ProcedureManager procedureManager, INameHandler iNameHandler, CACSLPreferenceInitializer.CheckMode checkMode) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mTypeSizes = typeSizes;
        this.mTypeSizeComputer = typeSizeAndOffsetComputer;
        this.mExpressionTranslation = expressionTranslation;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mMemoryHandler = memoryHandler;
        this.mProcedureManager = procedureManager;
        this.mNameHandler = iNameHandler;
        this.mOverflowCheckMode = checkMode;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("calloc", this::handleCalloc));
        arrayList.add(new ILibraryModel.FunctionModel("free", this::handleFree));
        arrayList.add(new ILibraryModel.FunctionModel("malloc", this::handleMalloc));
        arrayList.add(new ILibraryModel.FunctionModel("realloc", this::handleRealloc));
        arrayList.add(new ILibraryModel.FunctionModel("atof", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("atoi", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("atol", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("atoll", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("abort", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> StdlibLibraryModel.handleAbort(iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("exit", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> StdlibLibraryModel.handleAbort(iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("getenv", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleGetenv(iDispatcher, iASTFunctionCallExpression, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("qsort", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, CPointer.voidPointer())));
        arrayList.add(new ILibraryModel.FunctionModel("rand", this::handleRand));
        arrayList.add(new ILibraryModel.FunctionModel("srand", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleVoidFunctionBySkipAndDispatch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1)));
        arrayList.add(new ILibraryModel.FunctionModel("strtof", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("strtod", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("strtold", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("strtol", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("strtoll", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("strtoul", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("strtoull", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("abs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAbs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("labs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAbs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("llabs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAbs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("imaxabs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAbs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        return arrayList;
    }

    @Override
    public Collection<String> getUnsupportedFunctions() {
        return List.of("aligned_alloc", "atexit", "at_quick_exit", "_Exit", "quick_exit", "system", "bsearch", "mblen", "mbtowc", "wctomb", "mbstowcs", "wcstombs", "div", "ldiv", "lldiv");
    }

    private Result handleGetenv(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation) {
        ExpressionResult expressionResult;
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        assert (iASTFunctionCallExpression.getArguments().length == 1) : "unexpected number of arguments to getenv";
        IASTInitializerClause iASTInitializerClause = iASTFunctionCallExpression.getArguments()[0];
        if (!this.mHelper.isStringLiteral(iASTInitializerClause)) {
            expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClause);
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
        }
        expressionResult = this.mHelper.getNondetStringOrNull(iLocation);
        expressionResultBuilder.addAllExceptLrValue(expressionResult).setLrValue(expressionResult.getLrValue());
        return expressionResultBuilder.build();
    }

    private static ExpressionResult handleAbort(ILocation iLocation) {
        return new ExpressionResult(Collections.singletonList(new AssumeStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false))), null);
    }

    private Result handleCalloc(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[0], this.mTypeSizeComputer.getSizeT());
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[1], this.mTypeSizeComputer.getSizeT());
        Expression expression = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 1, expressionResult.getLrValue().getValue(), this.mTypeSizeComputer.getSizeT(), expressionResult2.getLrValue().getValue(), this.mTypeSizeComputer.getSizeT());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
        CPointer cPointer = CPointer.voidPointer();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.MALLOC);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)this.mMemoryHandler.getUltimateMemAllocCall(expression, auxVarInfo.getLhs(), iLocation, MemoryArea.HEAP));
        expressionResultBuilder.addStatement((Statement)this.mMemoryHandler.constructUltimateMeminitCall(iLocation, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), expression, (Expression)auxVarInfo.getExp()));
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPointer));
        return expressionResultBuilder.build();
    }

    private Result handleFree(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(expressionResult.getLrValue());
        expressionResultBuilder.addStatements(this.mMemoryHandler.getChecksForFreeCall(iLocation, (RValue)expressionResult.getLrValue()));
        CallStatement callStatement = this.mMemoryHandler.getDeallocCall(expressionResult.getLrValue(), iLocation);
        expressionResultBuilder.addStatement((Statement)callStatement);
        return expressionResultBuilder.build();
    }

    private Result handleRealloc(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        MemoryModelDeclarations memoryModelDeclarations = MemoryModelDeclarations.C_REALLOC;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        CPointer cPointer = CPointer.voidPointer();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[0], cPointer);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[1], this.mTypeSizeComputer.getSizeT());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, expressionResult.getLrValue().getCType(), SFO.AUXVAR.REALLOCRES);
        CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{auxVarInfo.getLhs()}, (String)memoryModelDeclarations.getName(), (Expression[])new Expression[]{expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue()});
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)callStatement);
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), CPointer.voidPointer()));
        this.mMemoryHandler.requireMemoryModelFeature(memoryModelDeclarations);
        this.mProcedureManager.registerProcedure(memoryModelDeclarations.getName());
        return expressionResultBuilder.build();
    }

    private Result handleMalloc(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.performImplicitConversion(expressionResult, this.mTypeSizeComputer.getSizeT(), iLocation);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult2);
        CPointer cPointer = CPointer.voidPointer();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.MALLOC);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)this.mMemoryHandler.getUltimateMemAllocCall(expressionResult2.getLrValue().getValue(), auxVarInfo.getLhs(), iLocation, MemoryArea.HEAP));
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPointer));
        return expressionResultBuilder.build();
    }

    private Result handleRand(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        this.mHelper.checkArguments(iLocation, 0, string, iASTFunctionCallExpression.getArguments());
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), cPrimitive);
        expressionResultBuilder.setLrValue(rValue);
        Expression expression = ((LRValue)rValue).getValue();
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive));
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, expression2, cPrimitive, expression, cPrimitive);
        Expression expression5 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, expression, cPrimitive, expression3, cPrimitive);
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression4, (Expression)expression5));
        expressionResultBuilder.addStatement((Statement)assumeStatement);
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResultBuilder.getDeclarations(), expressionResultBuilder.getAuxVars()));
        return expressionResultBuilder.build();
    }

    private Result handleAbs(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        Expression expression;
        Expression expression2;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        Expression expression3 = expressionResult.getLrValue().getValue();
        if (this.mOverflowCheckMode != CACSLPreferenceInitializer.CheckMode.IGNORE && cPrimitive.isIntegerType() && !this.mTypeSizes.isUnsigned(cPrimitive)) {
            expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive));
            expression = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 9, expression3, cPrimitive, expression2, cPrimitive);
            this.mExpressionTranslation.addOverflowCheck(iLocation, expression, expressionResultBuilder);
        }
        expression2 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 9, expression3, cPrimitive, this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO), cPrimitive);
        expression = this.mExpressionTranslation.constructUnaryExpression(iLocation, 3, expression3, cPrimitive);
        Expression expression4 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression2, (Expression)expression3, (Expression)expression);
        return expressionResultBuilder.setLrValue(new RValue(expression4, cPrimitive)).build();
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("size_t", this.mTypeSizes.getSizeT()), new ILibraryModel.TypeModel("ssize_t", this.mTypeSizes.getSsizeT()), new ILibraryModel.TypeModel("wchar_t", new CPrimitive(CPrimitive.CPrimitives.USHORT)));
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        return List.of(new ILibraryModel.ConstantModel("NULL", iLocation -> new ExpressionResult(new RValue(this.mExpressionTranslation.constructZero(iLocation, CPointer.voidPointer()), CPointer.voidPointer()))));
    }
}

