/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Req2CauseTrackingCDD {
    private final Map<String, String> mTrackingVars = new HashMap<String, String>();
    private final ILogger mLogger;

    public Req2CauseTrackingCDD(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public CDD transformInvariantTracking(CDD cDD3, Set<String> set, Set<String> set2, boolean bl) {
        CDD[] cDDArray = cDD3.toDNF();
        if (cDDArray.length > 1 && bl) {
            Set<CDD> set3 = Req2CauseTrackingCDD.getEffectConjuncts(cDDArray, set2);
            if (this.hasDeterministicEffect(cDDArray, set2)) {
                CDD cDD4 = set3.stream().reduce(CDD.TRUE, (cDD, cDD2) -> cDD.and(cDD2));
                Set<CDD> set4 = Req2CauseTrackingCDD.getTriggerConjuncts(cDDArray, set2);
                CDD cDD5 = cDD4.and(set4.stream().reduce(CDD.TRUE, (cDD, cDD2) -> cDD.and(cDD2.negate())));
                return this.addTrackingGuards(cDD4.and(cDD5), set);
            }
            this.mLogger.error((Object)("Nondet. effect (will not build lower Automaton): " + String.valueOf(set3)));
            return CDD.FALSE;
        }
        return this.addTrackingGuards(cDD3, set);
    }

    private static Set<CDD> getEffectConjuncts(CDD[] cDDArray, Set<String> set) {
        HashSet<CDD> hashSet = new HashSet<CDD>();
        CDD[] cDDArray2 = cDDArray;
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD = cDDArray2[n2];
            Set<String> set2 = Req2CauseTrackingCDD.getCddVariables(cDD);
            set2.retainAll(set);
            if (set2.size() > 0) {
                hashSet.add(cDD);
            }
            ++n2;
        }
        return hashSet;
    }

    private static Set<CDD> getTriggerConjuncts(CDD[] cDDArray, Set<String> set) {
        HashSet<CDD> hashSet = new HashSet<CDD>();
        CDD[] cDDArray2 = cDDArray;
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD = cDDArray2[n2];
            Set<String> set2 = Req2CauseTrackingCDD.getCddVariables(cDD);
            if (!set2.removeAll(set)) {
                hashSet.add(cDD);
            }
            ++n2;
        }
        return hashSet;
    }

    private CDD addTrackingGuards(CDD cDD, Set<String> set) {
        CDD cDD2;
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return cDD;
        }
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        if (cDD.getChilds() != null) {
            CDD[] cDDArray = cDD.getChilds();
            int n = cDDArray.length;
            int n2 = 0;
            while (n2 < n) {
                cDD2 = cDDArray[n2];
                arrayList.add(this.addTrackingGuards(cDD2, set));
                ++n2;
            }
        }
        cDD2 = CDD.create((Decision)cDD.getDecision(), (CDD[])arrayList.toArray(new CDD[arrayList.size()]));
        CDD cDD3 = CDD.TRUE;
        for (String string : Req2CauseTrackingCDD.getVarsFromDecision(cDD.getDecision())) {
            if (!set.contains(string)) continue;
            String string2 = "u_" + string;
            if (!string.endsWith("'")) {
                this.mTrackingVars.put(string2, "bool");
            }
            cDD3 = cDD3.and(BooleanDecision.create((String)string2));
        }
        this.mLogger.info((Object)("Track guard for (" + String.valueOf(cDD) + ") is :" + String.valueOf(cDD3)));
        return cDD2.and(cDD3);
    }

    public CDD upperToLowerBoundCdd(CDD cDD, boolean bl) {
        CDD cDD2;
        RangeDecision rangeDecision;
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return cDD;
        }
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        if (cDD.getChilds() != null) {
            rangeDecision = cDD.getChilds();
            int n = ((CDD[])rangeDecision).length;
            int n2 = 0;
            while (n2 < n) {
                cDD2 = rangeDecision[n2];
                arrayList.add(this.upperToLowerBoundCdd(cDD2, bl));
                ++n2;
            }
        }
        cDD2 = arrayList.toArray(new CDD[arrayList.size()]);
        Decision decision = cDD.getDecision();
        if (decision instanceof RangeDecision) {
            CDD cDD3 = CDD.TRUE;
            rangeDecision = (RangeDecision)decision;
            int n = 0;
            while (n < ((CDD)cDD2).length) {
                if (cDD2[n] != CDD.FALSE) {
                    cDD3 = bl ? cDD3.and(Req2CauseTrackingCDD.upperToLowerBoundDecisionDropOther(rangeDecision, n)) : cDD3.and(Req2CauseTrackingCDD.upperToLowerBoundDecision(rangeDecision, n));
                }
                ++n;
            }
            return cDD3;
        }
        return CDD.create((Decision)cDD.getDecision(), (CDD[])cDD2);
    }

    private static CDD upperToLowerBoundDecision(RangeDecision rangeDecision, int n) {
        switch (rangeDecision.getOp(n)) {
            case -1: {
                return RangeDecision.create((String)rangeDecision.getVar(), (int)1, (int)rangeDecision.getVal(n));
            }
        }
        return RangeDecision.create((String)rangeDecision.getVar(), (int)rangeDecision.getOp(n), (int)rangeDecision.getVal(n));
    }

    private static CDD upperToLowerBoundDecisionDropOther(RangeDecision rangeDecision, int n) {
        switch (rangeDecision.getOp(n)) {
            case -1: {
                return RangeDecision.create((String)rangeDecision.getVar(), (int)1, (int)rangeDecision.getVal(n));
            }
        }
        return CDD.TRUE;
    }

    public CDD transformGurad(CDD cDD, Set<String> set, Set<String> set2, Set<String> set3, boolean bl) {
        Set<String> set4 = Req2CauseTrackingCDD.getCddVariables(cDD);
        set4.removeAll(set2);
        set4.removeAll(set3);
        if (bl) {
            set4.removeAll(set);
        }
        set4.removeAll(set.stream().map(string -> string + "'").collect(Collectors.toSet()));
        set4.removeAll(set2.stream().map(string -> string + "'").collect(Collectors.toSet()));
        CDD cDD2 = this.addTrackingGuards(cDD, set4);
        return cDD2;
    }

    public static Set<String> getAllVariables(PatternType<?> patternType) {
        List list = patternType.constructCounterTrace();
        HashSet<String> hashSet = new HashSet<String>();
        for (CounterTrace counterTrace : list) {
            CounterTrace.DCPhase[] dCPhaseArray;
            CounterTrace.DCPhase[] dCPhaseArray2 = dCPhaseArray = counterTrace.getPhases();
            int n = dCPhaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                CounterTrace.DCPhase dCPhase = dCPhaseArray2[n2];
                hashSet.addAll(Req2CauseTrackingCDD.getCddVariables(dCPhase.getInvariant()));
                ++n2;
            }
        }
        return hashSet;
    }

    public static CDD getEffectCDD(PatternType<?> patternType) {
        List list = patternType.getCdds();
        return (CDD)list.get(0);
    }

    public static Set<String> getEffectVariables(PatternType<?> patternType) {
        List list = patternType.constructCounterTrace();
        HashSet<String> hashSet = new HashSet<String>();
        for (CounterTrace counterTrace : list) {
            CounterTrace.DCPhase[] dCPhaseArray = counterTrace.getPhases();
            CDD cDD = dCPhaseArray[dCPhaseArray.length - 2].getInvariant();
            if (dCPhaseArray.length >= 3) {
                CDD cDD2 = dCPhaseArray[dCPhaseArray.length - 3].getInvariant();
                hashSet.addAll(Req2CauseTrackingCDD.getDifferences(cDD2, cDD));
                continue;
            }
            hashSet.addAll(Req2CauseTrackingCDD.getCddVariables(cDD));
        }
        return hashSet;
    }

    public static Set<String> getDifferences(CDD cDD, CDD cDD2) {
        Set<String> set = Req2CauseTrackingCDD.getCddVariables(cDD2);
        Set<CDD> set2 = Req2CauseTrackingCDD.getCDDAtoms(cDD);
        CDD[] cDDArray = cDD2.toDNF();
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD3 = cDDArray[n2];
            HashSet<String> hashSet = new HashSet<String>();
            Set<CDD> set3 = Req2CauseTrackingCDD.getCDDAtoms(cDD3);
            for (CDD cDD4 : set3) {
                for (CDD cDD5 : set2) {
                    if (cDD4.isEqual(cDD5)) break;
                }
                hashSet.addAll(Req2CauseTrackingCDD.getVarsFromDecision(cDD4.getDecision()));
            }
            set.retainAll(hashSet);
            ++n2;
        }
        return set;
    }

    private boolean hasDeterministicEffect(CDD[] cDDArray, Set<String> set) {
        Set<CDD> set2 = Req2CauseTrackingCDD.getEffectDecisions(cDDArray[0], set);
        this.mLogger.warn((Object)("reference Effect: " + String.valueOf(set2)));
        int n = 1;
        while (n < cDDArray.length) {
            Set<CDD> set3 = Req2CauseTrackingCDD.getEffectDecisions(cDDArray[n], set);
            if (!set3.isEmpty() && !set3.equals(set2)) {
                this.mLogger.warn((Object)("non-det with Effect: " + String.valueOf(Req2CauseTrackingCDD.getEffectDecisions(cDDArray[n], set))));
                return false;
            }
            ++n;
        }
        return true;
    }

    private static Set<CDD> getEffectDecisions(CDD cDD, Set<String> set) {
        Set<CDD> set2 = Req2CauseTrackingCDD.getCDDAtoms(cDD);
        HashSet<CDD> hashSet = new HashSet<CDD>();
        for (CDD cDD2 : set2) {
            Decision decision = cDD2.getDecision();
            if (!(decision instanceof BoogieBooleanExpressionDecision)) continue;
            for (String string : set) {
                if (!((BoogieBooleanExpressionDecision)decision).getVars().containsKey(string)) continue;
                hashSet.add(cDD2);
            }
        }
        return hashSet;
    }

    public static Set<CDD> getCDDAtoms(CDD cDD) {
        HashSet<CDD> hashSet = new HashSet<CDD>();
        Req2CauseTrackingCDD.extractAtomics(cDD, hashSet);
        return hashSet;
    }

    private static void extractAtomics(CDD cDD, Set<CDD> set) {
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return;
        }
        if (cDD.isAtomic()) {
            set.add(cDD);
            return;
        }
        if (cDD.getChilds() != null) {
            CDD[] cDDArray = cDD.getChilds();
            int n = cDDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDD cDD2 = cDDArray[n2];
                Req2CauseTrackingCDD.extractAtomics(cDD2, set);
                ++n2;
            }
        }
    }

    public static Set<String> getCddVariables(CDD cDD) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Decision<?> decision : Req2CauseTrackingCDD.getDecisions(cDD)) {
            hashSet.addAll(Req2CauseTrackingCDD.getVarsFromDecision(decision));
        }
        return hashSet;
    }

    public static Set<String> getCddVariables(Set<Decision<?>> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Decision<?> decision : set) {
            hashSet.addAll(Req2CauseTrackingCDD.getVarsFromDecision(decision));
        }
        return hashSet;
    }

    private static Set<String> getVarsFromDecision(Decision<?> decision) {
        HashSet<String> hashSet = new HashSet<String>();
        if (decision != null && !(decision instanceof EventDecision) && !(decision instanceof RangeDecision)) {
            if (decision instanceof BooleanDecision) {
                hashSet.add(((BooleanDecision)decision).getVar());
            } else if (decision instanceof BoogieBooleanExpressionDecision) {
                BoogieBooleanExpressionDecision boogieBooleanExpressionDecision = (BoogieBooleanExpressionDecision)decision;
                for (Map.Entry entry : boogieBooleanExpressionDecision.getVars().entrySet()) {
                    hashSet.add((String)entry.getKey());
                }
            } else {
                throw new UnsupportedOperationException("Unknown decision type: " + String.valueOf(decision.getClass()));
            }
        }
        return hashSet;
    }

    public Map<String, String> getTrackingVars() {
        return this.mTrackingVars;
    }

    public static Set<Decision<?>> getDecisions(CDD cDD) {
        HashSet hashSet = new HashSet();
        Req2CauseTrackingCDD.extractDecisions(cDD, hashSet);
        return hashSet;
    }

    private static void extractDecisions(CDD cDD, Set<Decision<?>> set) {
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return;
        }
        set.add(cDD.getDecision());
        if (cDD.getChilds() != null) {
            CDD[] cDDArray = cDD.getChilds();
            int n = cDDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDD cDD2 = cDDArray[n2];
                Req2CauseTrackingCDD.extractDecisions(cDD2, set);
                ++n2;
            }
        }
    }
}

