/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IcfgLoop<INLOC extends IcfgLocation> {
    private final Map<INLOC, IcfgLoop<INLOC>> mNestedLoops = new HashMap<INLOC, IcfgLoop<INLOC>>();
    private final Set<INLOC> mLoopbody;
    private final INLOC mHead;
    private final Set<INLOC> mNestedNodes;
    private final Set<ArrayList<IcfgEdge>> mPaths;
    private final IUltimateServiceProvider mServices;
    private final List<Pair<List<UnmodifiableTransFormula>, INLOC>> mLoopExits;

    public IcfgLoop(IUltimateServiceProvider iUltimateServiceProvider) {
        this(iUltimateServiceProvider, new HashSet(), null);
    }

    public IcfgLoop(IUltimateServiceProvider iUltimateServiceProvider, Set<INLOC> set, INLOC INLOC) {
        this.mLoopbody = new HashSet<INLOC>(set);
        this.mHead = INLOC;
        this.mNestedNodes = new HashSet<INLOC>();
        this.mPaths = new HashSet<ArrayList<IcfgEdge>>();
        this.mLoopExits = new ArrayList<Pair<List<UnmodifiableTransFormula>, INLOC>>();
        this.mServices = iUltimateServiceProvider;
    }

    public void addAll(Set<INLOC> set) {
        this.mLoopbody.addAll(set);
    }

    public void addNestedLoop(IcfgLoop<INLOC> icfgLoop) {
        if (icfgLoop.getLoopbody().equals(this.mLoopbody)) {
            return;
        }
        for (IcfgLoop<INLOC> icfgLoop2 : this.mNestedLoops.values()) {
            if (!icfgLoop2.contains(icfgLoop.getHead())) continue;
            icfgLoop2.addNestedLoop(icfgLoop);
            this.mNestedNodes.addAll(icfgLoop.getLoopbody());
            return;
        }
        this.mNestedLoops.put(icfgLoop.getHead(), icfgLoop);
        this.mNestedNodes.addAll(icfgLoop.getLoopbody());
        this.mNestedNodes.remove(icfgLoop.getHead());
    }

    public boolean hasNestedLoops() {
        return !this.mNestedLoops.isEmpty();
    }

    public IcfgLoop<INLOC> getNestedLoop(INLOC INLOC) {
        return this.mNestedLoops.get(INLOC);
    }

    public Set<INLOC> getNestedLoopHeads() {
        return this.mNestedLoops.keySet();
    }

    public Set<INLOC> getLoopbody() {
        return this.mLoopbody;
    }

    public INLOC getHead() {
        return this.mHead;
    }

    public List<Pair<List<UnmodifiableTransFormula>, INLOC>> getLoopExits() {
        return this.mLoopExits;
    }

    public boolean contains(INLOC INLOC) {
        return this.mLoopbody.contains(INLOC);
    }

    public Set<ArrayList<IcfgEdge>> getPaths() {
        if (this.mPaths.isEmpty()) {
            this.loopPaths();
        }
        return this.mPaths;
    }

    private void loopPaths() {
        IcfgEdge icfgEdge22;
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        ArrayList arrayList = new ArrayList();
        HashMap<INLOC, List<Pair<List<UnmodifiableTransFormula>, INLOC>>> hashMap = new HashMap<INLOC, List<Pair<List<UnmodifiableTransFormula>, INLOC>>>();
        for (IcfgLoop<INLOC> object : this.mNestedLoops.values()) {
            object.getPaths();
            hashMap.put(object.getHead(), object.getLoopExits());
        }
        for (IcfgEdge icfgEdge3 : this.mHead.getOutgoingEdges()) {
            if (!this.mLoopbody.contains(icfgEdge3.getTarget())) continue;
            icfgEdge22 = new ArrayList();
            icfgEdge22.add(icfgEdge3);
            arrayDeque.add(icfgEdge22);
        }
        while (!arrayDeque.isEmpty()) {
            ArrayList<IcfgEdge> arrayList2;
            ArrayList arrayList3 = (ArrayList)arrayDeque.removeFirst();
            Iterator<IcfgLoop<Object>> iterator = (IcfgLocation)((IcfgEdge)arrayList3.get(arrayList3.size() - 1)).getTarget();
            if (iterator.equals(this.mHead)) {
                this.mPaths.add(arrayList3);
                continue;
            }
            if (hashMap.containsKey(iterator)) {
                for (IcfgEdge icfgEdge22 : (List)hashMap.get(iterator)) {
                    if (this.mLoopbody.contains(icfgEdge22.getSecond())) {
                        arrayList2 = new ArrayList<IcfgEdge>(arrayList3);
                        arrayList2.addAll((Collection)icfgEdge22.getFirst());
                        arrayDeque.add(arrayList2);
                        continue;
                    }
                    arrayList2 = new ArrayList(arrayList3);
                    arrayList2.addAll((Collection)icfgEdge22.getFirst());
                    arrayList.add(arrayList2);
                }
            }
            for (IcfgEdge icfgEdge22 : iterator.getOutgoingEdges()) {
                if (!this.mNestedNodes.contains(icfgEdge22.getTarget()) && this.mLoopbody.contains(icfgEdge22.getTarget()) && !iterator.equals(icfgEdge22.getTarget())) {
                    arrayList2 = new ArrayList(arrayList3);
                    arrayList2.add(icfgEdge22);
                    arrayDeque.add(arrayList2);
                    continue;
                }
                if (this.mNestedNodes.contains(icfgEdge22.getTarget()) || iterator.equals(icfgEdge22.getTarget())) continue;
                arrayList2 = new ArrayList(arrayList3);
                arrayList2.add(icfgEdge22);
                arrayList.add(arrayList2);
            }
        }
        for (List list : arrayList) {
            icfgEdge22 = new ArrayList();
            list.forEach(icfgEdge -> {
                boolean bl = icfgEdge22.add(icfgEdge.getTransformula());
            });
            IcfgLocation icfgLocation = (IcfgLocation)((IcfgEdge)list.get(list.size() - 1)).getTarget();
            this.mLoopExits.add(new Pair((Object)icfgEdge22, (Object)icfgLocation));
        }
    }
}

