/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteTermVariables;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;

public class RewriteBooleans
extends RewriteTermVariables {
    public static final String DESCRIPTION = "Replace boolean variables by integer variables";
    private static final String TERM_VARIABLE_SUFFIX = "bool";
    private static final String REP_VAR_SORT_NAME = "Int";

    @Override
    protected String getTermVariableSuffix() {
        return TERM_VARIABLE_SUFFIX;
    }

    @Override
    protected String getRepVarSortName() {
        return REP_VAR_SORT_NAME;
    }

    public RewriteBooleans(ReplacementVarFactory replacementVarFactory, ManagedScript managedScript) {
        super(replacementVarFactory, managedScript);
    }

    @Override
    protected boolean hasToBeReplaced(Term term) {
        return RewriteBooleans.isBool(term);
    }

    private static final boolean isBool(Term term) {
        return SmtSortUtils.isBoolSort((Sort)term.getSort());
    }

    @Override
    protected Term constructReplacementTerm(TermVariable termVariable) {
        Term term = SmtUtils.constructIntValue((Script)this.mScript.getScript(), (BigInteger)BigInteger.ONE);
        Term term2 = this.mScript.getScript().term(">=", new Term[]{termVariable, term});
        return term2;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected Term constructNewDefinitionForRankVar(IProgramVar iProgramVar) {
        Term term = ReplacementVarUtils.getDefinition((IProgramVar)iProgramVar);
        assert (RewriteBooleans.isBool(term));
        Term term2 = SmtUtils.constructIntValue((Script)this.mScript.getScript(), (BigInteger)BigInteger.ONE);
        Term term3 = SmtUtils.constructIntValue((Script)this.mScript.getScript(), (BigInteger)BigInteger.ZERO);
        return this.mScript.getScript().term("ite", new Term[]{term, term2, term3});
    }
}

