/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.ModelContainer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.DuplicateKeyException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.InvalidKeyException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectTypeMismatchException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository.IRepository;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SerializationRepository
implements IRepository<String, ModelContainer> {
    private final File mFileSystemDirectory;
    private final ILogger mLogger;

    public SerializationRepository(File file, ILogger iLogger) {
        assert (iLogger != null);
        this.mFileSystemDirectory = file;
        this.mLogger = iLogger;
    }

    @Override
    public void dump() {
        this.removeAll(this.listKeys());
    }

    @Override
    public ModelContainer get(String string) throws PersistentObjectNotFoundException, PersistentObjectTypeMismatchException {
        if (this.listKeys().contains(string)) {
            try {
                this.mLogger.debug((Object)"deserializing model");
                Object object = this.deserialize(string);
                return (ModelContainer)object;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PersistentObjectNotFoundException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new PersistentObjectNotFoundException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PersistentObjectTypeMismatchException("A required class used in the stored object graph could not be found. Maybe it has been produced by a plug-in that didn't export this package", classNotFoundException);
            }
        }
        throw new PersistentObjectNotFoundException("No object found using the key: " + string);
    }

    private Object deserialize(String string) throws FileNotFoundException, IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.keyToFile(string)));){
            return objectInputStream.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public List<String> listKeys() {
        if (this.mFileSystemDirectory == null || !this.mFileSystemDirectory.exists() || !this.mFileSystemDirectory.isDirectory()) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = this.mFileSystemDirectory.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            File file = new File(string);
            if (file.getName().endsWith(".ser")) {
                linkedList.add(file.getName().substring(0, file.getName().length() - 4));
            }
            ++n2;
        }
        return linkedList;
    }

    @Override
    public boolean remove(String string) {
        File file = new File(String.valueOf(this.mFileSystemDirectory) + "/" + string + ".ser");
        boolean bl = file.delete();
        if (!bl && this.listKeys().contains(string)) {
            this.mLogger.warn((Object)("Could not delete " + file.getPath() + " from the file system!"));
            return false;
        }
        this.mLogger.debug((Object)"Now, the model is not in the repository (anymore)");
        return true;
    }

    @Override
    public void removeAll(List<String> list) {
        for (String string : list) {
            this.remove(string);
        }
    }

    @Override
    public void add(String string, ModelContainer modelContainer) throws DuplicateKeyException, StoreObjectException {
        if (this.listKeys().contains(string)) {
            throw new DuplicateKeyException("The key: " + string + " is already in use. If you want to replace the stored object, use method addOrReplace instead!");
        }
        this.addOrReplace(string, modelContainer);
    }

    @Override
    public void addOrReplace(String string, ModelContainer modelContainer) throws StoreObjectException {
        try {
            this.serializie(string, modelContainer);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InvalidKeyException("invalid key: " + string, fileNotFoundException);
        }
        catch (IOException iOException) {
            this.mLogger.fatal((Object)("Serialization of ModelContainer failed for key " + string + " to file " + String.valueOf(this.keyToFile(string))));
            throw new StoreObjectException(iOException);
        }
    }

    private void serializie(String string, ModelContainer modelContainer) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.keyToFile(string)));){
            objectOutputStream.writeObject(modelContainer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.mLogger.debug((Object)"serialized model");
    }

    private File keyToFile(String string) {
        return new File(String.valueOf(this.mFileSystemDirectory) + File.separator + SerializationRepository.sanitize(string) + ".ser");
    }

    private static String sanitize(String string) {
        return string.replaceAll("[\\/:\"*?<>|]+", "_");
    }

    @Override
    public boolean isEmpty() {
        return this.listKeys().isEmpty();
    }
}

