/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.Segmentation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SegmentationMap {
    private final UnionFind<IProgramVarOrConst> mArrayEqualities;
    private final Map<IProgramVarOrConst, Segmentation> mRepresentiveSegmentations;

    private SegmentationMap(UnionFind<IProgramVarOrConst> unionFind, Map<IProgramVarOrConst, Segmentation> map) {
        this.mArrayEqualities = unionFind;
        this.mRepresentiveSegmentations = map;
    }

    public SegmentationMap() {
        this((UnionFind<IProgramVarOrConst>)new UnionFind(), new HashMap<IProgramVarOrConst, Segmentation>());
    }

    public SegmentationMap(SegmentationMap segmentationMap) {
        this((UnionFind<IProgramVarOrConst>)segmentationMap.mArrayEqualities.clone(), new HashMap<IProgramVarOrConst, Segmentation>(segmentationMap.mRepresentiveSegmentations));
    }

    public Set<IProgramVarOrConst> getArrays() {
        return this.mArrayEqualities.getAllElements();
    }

    public Set<IProgramVar> getValueVars() {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (Segmentation segmentation : this.mRepresentiveSegmentations.values()) {
            hashSet.addAll(segmentation.getValues());
        }
        return hashSet;
    }

    public Set<IProgramVar> getBoundVars() {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (Segmentation segmentation : this.mRepresentiveSegmentations.values()) {
            hashSet.addAll(segmentation.getBounds());
        }
        return hashSet;
    }

    public Set<IProgramVar> getAuxVars() {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(this.getBoundVars());
        hashSet.addAll(this.getValueVars());
        return hashSet;
    }

    public void add(IProgramVarOrConst iProgramVarOrConst, Segmentation segmentation) {
        this.mArrayEqualities.makeEquivalenceClass((Object)iProgramVarOrConst);
        this.mRepresentiveSegmentations.put(iProgramVarOrConst, segmentation);
    }

    public void addEquivalenceClass(ImmutableSet<IProgramVarOrConst> immutableSet, Segmentation segmentation) {
        this.mArrayEqualities.addEquivalenceClass(immutableSet);
        IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)immutableSet.iterator().next();
        this.mRepresentiveSegmentations.put((IProgramVarOrConst)this.mArrayEqualities.find((Object)iProgramVarOrConst), segmentation);
    }

    public void putAll(SegmentationMap segmentationMap) {
        for (IProgramVarOrConst iProgramVarOrConst : segmentationMap.mArrayEqualities.getAllRepresentatives()) {
            ImmutableSet<IProgramVarOrConst> immutableSet = segmentationMap.getEquivalenceClass(iProgramVarOrConst);
            for (IProgramVarOrConst iProgramVarOrConst2 : immutableSet) {
                if (!this.getArrays().contains(iProgramVarOrConst2)) continue;
                this.remove(iProgramVarOrConst2);
            }
            this.mArrayEqualities.addEquivalenceClass(immutableSet, (Object)iProgramVarOrConst);
            this.mRepresentiveSegmentations.put(iProgramVarOrConst, segmentationMap.getSegmentation(iProgramVarOrConst));
        }
    }

    public void renameArray(IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2) {
        IProgramVarOrConst iProgramVarOrConst3 = (IProgramVarOrConst)this.mArrayEqualities.find((Object)iProgramVarOrConst);
        boolean bl = this.mArrayEqualities.getEquivalenceClassMembers((Object)iProgramVarOrConst).size() == 1;
        this.mArrayEqualities.remove((Object)iProgramVarOrConst);
        this.mArrayEqualities.makeEquivalenceClass((Object)iProgramVarOrConst2);
        Segmentation segmentation = this.mRepresentiveSegmentations.get(iProgramVarOrConst);
        if (segmentation == null) {
            this.mArrayEqualities.union((Object)iProgramVarOrConst2, (Object)iProgramVarOrConst3);
        } else {
            this.mRepresentiveSegmentations.remove(iProgramVarOrConst);
            if (!bl) {
                this.mArrayEqualities.union((Object)iProgramVarOrConst2, (Object)iProgramVarOrConst3);
            }
            this.mRepresentiveSegmentations.put((IProgramVarOrConst)this.mArrayEqualities.find((Object)iProgramVarOrConst2), segmentation);
        }
    }

    public void put(IProgramVarOrConst iProgramVarOrConst, Segmentation segmentation) {
        IProgramVarOrConst iProgramVarOrConst2 = (IProgramVarOrConst)this.mArrayEqualities.find((Object)iProgramVarOrConst);
        this.mRepresentiveSegmentations.put(iProgramVarOrConst2, segmentation);
    }

    public void remove(IProgramVarOrConst iProgramVarOrConst) {
        HashSet hashSet = new HashSet(this.mArrayEqualities.getContainingSet((Object)iProgramVarOrConst));
        hashSet.remove(iProgramVarOrConst);
        Iterator iterator = hashSet.iterator();
        this.mArrayEqualities.remove((Object)iProgramVarOrConst);
        Segmentation segmentation = this.mRepresentiveSegmentations.remove(iProgramVarOrConst);
        if (segmentation != null && iterator.hasNext()) {
            this.mRepresentiveSegmentations.put((IProgramVarOrConst)this.mArrayEqualities.find((Object)((IProgramVarOrConst)iterator.next())), segmentation);
        }
    }

    public void removeAll(Set<IProgramVarOrConst> set) {
        for (IProgramVarOrConst iProgramVarOrConst : set) {
            this.remove(iProgramVarOrConst);
        }
    }

    public void move(IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2) {
        if (this.mArrayEqualities.find((Object)iProgramVarOrConst) != null) {
            this.remove(iProgramVarOrConst);
        }
        this.mArrayEqualities.makeEquivalenceClass((Object)iProgramVarOrConst);
        this.mArrayEqualities.union((Object)iProgramVarOrConst, (Object)iProgramVarOrConst2);
    }

    public void union(IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2, Segmentation segmentation) {
        this.mRepresentiveSegmentations.remove(this.mArrayEqualities.find((Object)iProgramVarOrConst));
        this.mRepresentiveSegmentations.remove(this.mArrayEqualities.find((Object)iProgramVarOrConst2));
        this.mArrayEqualities.union((Object)iProgramVarOrConst, (Object)iProgramVarOrConst2);
        this.mRepresentiveSegmentations.put((IProgramVarOrConst)this.mArrayEqualities.find((Object)iProgramVarOrConst), segmentation);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (IProgramVarOrConst iProgramVarOrConst : SegmentationMap.sortProgramVars(this.getAllRepresentatives())) {
            stringBuilder.append(SegmentationMap.sortProgramVars((Collection<IProgramVarOrConst>)this.mArrayEqualities.getEquivalenceClassMembers((Object)iProgramVarOrConst)));
            stringBuilder.append(" -> ").append(this.mRepresentiveSegmentations.get(iProgramVarOrConst)).append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static List<IProgramVarOrConst> sortProgramVars(Collection<IProgramVarOrConst> collection) {
        return collection.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
    }

    public Segmentation getSegmentation(IProgramVarOrConst iProgramVarOrConst) {
        return this.mRepresentiveSegmentations.get(this.mArrayEqualities.find((Object)iProgramVarOrConst));
    }

    public ImmutableSet<IProgramVarOrConst> getEquivalenceClass(IProgramVarOrConst iProgramVarOrConst) {
        return this.mArrayEqualities.getEquivalenceClassMembers((Object)iProgramVarOrConst);
    }

    public Collection<IProgramVarOrConst> getAllRepresentatives() {
        return this.mArrayEqualities.getAllRepresentatives();
    }
}

