/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;

public final class IndependenceSettings {
    public static final IndependenceType DEFAULT_INDEPENDENCE_TYPE = IndependenceType.SEMANTIC;
    public static final AbstractionType DEFAULT_ABSTRACTION_TYPE = AbstractionType.NONE;
    public static final boolean DEFAULT_USE_CONDITIONAL = true;
    public static final boolean DEFAULT_USE_SEMICOMMUTATIVITY = true;
    public static final SolverBuilder.ExternalSolver DEFAULT_SOLVER = SolverBuilder.ExternalSolver.Z3;
    public static final long DEFAULT_SOLVER_TIMEOUT = 1000L;
    private final IndependenceType mIndependenceType;
    private final AbstractionType mAbstractionType;
    private final boolean mUseConditional;
    private final boolean mUseSemiCommutativity;
    private final SolverBuilder.ExternalSolver mSolver;
    private final long mSolverTimeout;

    public IndependenceSettings() {
        this(DEFAULT_INDEPENDENCE_TYPE, DEFAULT_ABSTRACTION_TYPE, true, true, DEFAULT_SOLVER, 1000L);
    }

    public IndependenceSettings(IndependenceType independenceType, AbstractionType abstractionType, boolean bl, boolean bl2, SolverBuilder.ExternalSolver externalSolver, long l) {
        this.mIndependenceType = independenceType;
        this.mAbstractionType = abstractionType;
        this.mUseConditional = bl;
        this.mUseSemiCommutativity = bl2;
        this.mSolver = externalSolver;
        this.mSolverTimeout = l;
    }

    public IndependenceType getIndependenceType() {
        return this.mIndependenceType;
    }

    public AbstractionType getAbstractionType() {
        return this.mAbstractionType;
    }

    public boolean useConditional() {
        return this.mUseConditional;
    }

    public boolean useSemiCommutativity() {
        return this.mUseSemiCommutativity;
    }

    public SolverBuilder.ExternalSolver getSolver() {
        return this.mSolver;
    }

    public long getSolverTimeout() {
        return this.mSolverTimeout;
    }

    public String toString() {
        if (this.mIndependenceType == IndependenceType.SYNTACTIC) {
            return "[IndependenceType=" + String.valueOf((Object)this.mIndependenceType) + ", AbstractionType=" + String.valueOf((Object)this.mAbstractionType) + ", UseConditional=<UNSUPPORTED>, UseSemiCommutativity=<UNSUPPORTED>, Solver=<NOT_USED>, SolverTimeout=<NOT_USED>]";
        }
        return "[IndependenceType=" + String.valueOf((Object)this.mIndependenceType) + ", AbstractionType=" + String.valueOf((Object)this.mAbstractionType) + ", UseConditional=" + this.mUseConditional + ", UseSemiCommutativity=" + this.mUseSemiCommutativity + ", Solver=" + String.valueOf(this.mSolver) + ", SolverTimeout=" + this.mSolverTimeout + "ms]";
    }

    public static enum AbstractionType {
        NONE,
        VARIABLES_GLOBAL,
        VARIABLES_LOCAL,
        LOOPER;

    }

    public static enum IndependenceType {
        SYNTACTIC,
        SEMANTIC;

    }
}

