/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.TraceCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public class IterativePredicateTransformer<L extends IAction> {
    private final ModifiableGlobalsTable mModifiedGlobals;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final ManagedScript mMgdScript;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredicateTransformer;
    private final BasicPredicateFactory mPredicateFactory;
    private final NestedWord<L> mTrace;
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    protected final SortedMap<Integer, IPredicate> mPendingContexts;
    private final IPredicate mTruePredicate;
    private final IIcfgSymbolTable mSymbolTable;
    private static final boolean INTERPROCEDURAL_POST = true;
    private static final boolean TRANSFORM_SUMMARY_TO_CNF = true;

    public IterativePredicateTransformer(BasicPredicateFactory basicPredicateFactory, ManagedScript managedScript, ModifiableGlobalsTable modifiableGlobalsTable, IUltimateServiceProvider iUltimateServiceProvider, NestedWord<L> nestedWord, IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, IPredicate iPredicate3, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(TraceCheckerUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mMgdScript = managedScript;
        this.mModifiedGlobals = modifiableGlobalsTable;
        this.mPredicateTransformer = new PredicateTransformer(managedScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mMgdScript));
        this.mPredicateFactory = basicPredicateFactory;
        this.mTrace = nestedWord;
        this.mPrecondition = iPredicate;
        this.mPostcondition = iPredicate2;
        this.mPendingContexts = sortedMap;
        this.mTruePredicate = iPredicate3;
        this.mSymbolTable = iIcfgSymbolTable;
    }

    public TracePredicates computeStrongestPostconditionSequence(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, List<IPredicatePostprocessor> list) {
        IPredicate[] iPredicateArray = new IPredicate[this.mTrace.length() - 1];
        TracePredicates tracePredicates = new TracePredicates(this.mPrecondition, this.mPostcondition, Arrays.asList(iPredicateArray));
        boolean bl = this.mPostcondition == null;
        int n = bl ? this.mTrace.length() : this.mTrace.length() - 1;
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            Term term;
            String string2;
            IIcfgCallTransition iIcfgCallTransition;
            IPredicate iPredicate = tracePredicates.getPredicate(n2);
            if (this.mTrace.getSymbol(n2) instanceof IIcfgCallTransition) {
                iIcfgCallTransition = (IIcfgCallTransition)this.mTrace.getSymbol(n2);
                string2 = iIcfgCallTransition.getSucceedingProcedure();
                var13_13 = this.mModifiedGlobals.getModifiedBoogieVars(string2);
                term = this.mTrace.isPendingCall(n2) ? (Term)this.mPredicateTransformer.strongestPostconditionCall((IAbstractPredicate)iPredicate, (ITransitionRelation)((TransFormula)nestedFormulas.getLocalVarAssignment(n2)), (ITransitionRelation)((TransFormula)nestedFormulas.getGlobalVarAssignment(n2)), (ITransitionRelation)((TransFormula)nestedFormulas.getOldVarAssignment(n2)), var13_13) : (Term)this.mPredicateTransformer.modularPostconditionCall((IAbstractPredicate)iPredicate, (ITransitionRelation)((TransFormula)nestedFormulas.getGlobalVarAssignment(n2)), var13_13);
            } else if (this.mTrace.getSymbol(n2) instanceof IIcfgReturnTransition) {
                if (this.mTrace.isPendingReturn(n2)) {
                    iIcfgCallTransition = (IPredicate)this.mPendingContexts.get(n2);
                    string2 = nestedFormulas.getOldVarAssignment(n2);
                    var13_13 = nestedFormulas.getLocalVarAssignment(n2);
                } else {
                    int n3 = this.mTrace.getCallPosition(n2);
                    assert (n3 >= 0 && n3 <= n2) : "Bad call position!";
                    iIcfgCallTransition = tracePredicates.getPredicate(n3);
                    string2 = nestedFormulas.getOldVarAssignment(n3);
                    var13_13 = nestedFormulas.getLocalVarAssignment(n3);
                }
                UnmodifiableTransFormula unmodifiableTransFormula = nestedFormulas.getFormulaFromNonCallPos(n2);
                String string3 = ((IAction)this.mTrace.getSymbol(n2)).getPrecedingProcedure();
                term = (Term)this.mPredicateTransformer.strongestPostconditionReturn((IAbstractPredicate)iPredicate, (IAbstractPredicate)iIcfgCallTransition, (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)var13_13, (ITransitionRelation)string2, this.mModifiedGlobals.getModifiedBoogieVars(string3));
            } else {
                term = (Term)this.mPredicateTransformer.strongestPostcondition((IAbstractPredicate)iPredicate, (ITransitionRelation)((TransFormula)nestedFormulas.getFormulaFromNonCallPos(n2)));
            }
            iIcfgCallTransition = this.constructPredicate(term);
            string2 = IterativePredicateTransformer.applyPostprocessors(list, n2 + 1, (IPredicate)iIcfgCallTransition);
            if (n2 == this.mTrace.length() - 1) {
                string = string2;
            } else {
                iPredicateArray[n2] = string2;
            }
            ++n2;
        }
        if (bl) {
            return new TracePredicates(this.mPrecondition, string, Arrays.asList(iPredicateArray));
        }
        return tracePredicates;
    }

    private IPredicate constructPredicate(Term term) {
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(term);
        return basicPredicate;
    }

    public TracePredicates computeWeakestPreconditionSequence(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, List<IPredicatePostprocessor> list, boolean bl, boolean bl2) throws TraceInterpolationException {
        return this.computeBackwardSequence(nestedFormulas, list, bl, bl2, BackwardSequence.WP);
    }

    public TracePredicates computePreSequence(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, List<IPredicatePostprocessor> list, boolean bl) throws TraceInterpolationException {
        return this.computeBackwardSequence(nestedFormulas, list, true, bl, BackwardSequence.PRE);
    }

    public TracePredicates computeBackwardSequence(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, List<IPredicatePostprocessor> list, boolean bl, boolean bl2, BackwardSequence backwardSequence) throws TraceInterpolationException {
        IPredicate[] iPredicateArray = new IPredicate[this.mTrace.length() - 1];
        TracePredicates tracePredicates = backwardSequence == BackwardSequence.WP ? new TracePredicates(this.mPrecondition, this.mPostcondition, Arrays.asList(iPredicateArray)) : new TracePredicates(this.mPrecondition, this.mPostcondition, Arrays.asList(iPredicateArray));
        HashMap<Integer, IPredicate> hashMap = new HashMap<Integer, IPredicate>();
        boolean bl3 = this.mPrecondition == null;
        int n = bl3 ? 0 : 1;
        IIcfgCallTransition iIcfgCallTransition = null;
        int n2 = this.mTrace.length() - 1;
        while (n2 >= n) {
            Term term;
            String string;
            IIcfgCallTransition iIcfgCallTransition2;
            IPredicate iPredicate = backwardSequence == BackwardSequence.WP ? tracePredicates.getPredicate(n2 + 1) : this.mPredicateFactory.not(tracePredicates.getPredicate(n2 + 1));
            if (this.mTrace.getSymbol(n2) instanceof IIcfgCallTransition) {
                if (this.mTrace.isPendingCall(n2)) {
                    iIcfgCallTransition2 = (IIcfgCallTransition)this.mTrace.getSymbol(n2);
                    string = iIcfgCallTransition2.getSucceedingProcedure();
                    var17_17 = this.mModifiedGlobals.getModifiedBoogieVars(string);
                    term = (Term)this.mPredicateTransformer.weakestPreconditionCall((IAbstractPredicate)iPredicate, (ITransitionRelation)((TransFormula)nestedFormulas.getLocalVarAssignment(n2)), (ITransitionRelation)((TransFormula)nestedFormulas.getGlobalVarAssignment(n2)), (ITransitionRelation)((TransFormula)nestedFormulas.getOldVarAssignment(n2)), var17_17);
                } else {
                    assert (hashMap.get(n2) != null) : "must have already been computed";
                    term = null;
                }
            } else if (this.mTrace.getSymbol(n2) instanceof IIcfgReturnTransition) {
                Object object;
                Object object2;
                UnmodifiableTransFormula unmodifiableTransFormula = nestedFormulas.getFormulaFromNonCallPos(n2);
                if (this.mTrace.isPendingReturn(n2)) {
                    iIcfgCallTransition2 = bl ? this.mTruePredicate : (IPredicate)this.mPendingContexts.get(n2);
                    var17_17 = nestedFormulas.getLocalVarAssignment(n2);
                    string = nestedFormulas.getOldVarAssignment(n2);
                } else {
                    Term term2;
                    int n3 = this.mTrace.getCallPosition(n2);
                    assert (n3 >= 0 && n3 <= n2) : "Bad call position!";
                    var17_17 = nestedFormulas.getLocalVarAssignment(n3);
                    string = nestedFormulas.getOldVarAssignment(n3);
                    object2 = nestedFormulas.getGlobalVarAssignment(n3);
                    object = this.computeProcedureSummary(this.mTrace, (UnmodifiableTransFormula)var17_17, unmodifiableTransFormula, (UnmodifiableTransFormula)string, (UnmodifiableTransFormula)object2, nestedFormulas, n3, n2);
                    Term term3 = backwardSequence == BackwardSequence.WP ? (Term)this.mPredicateTransformer.weakestPrecondition((IAbstractPredicate)iPredicate, (ITransitionRelation)((ProcedureSummary)object).getWithCallAndReturn()) : SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)((Term)this.mPredicateTransformer.weakestPrecondition((IAbstractPredicate)iPredicate, (ITransitionRelation)((ProcedureSummary)object).getWithCallAndReturn())));
                    IPredicate iPredicate2 = this.constructPredicate(term3);
                    IPredicate iPredicate3 = IterativePredicateTransformer.applyPostprocessors(list, n3, iPredicate2);
                    if (bl2 && (term2 = new PrenexNormalForm(this.mMgdScript).transform(iPredicate3.getFormula())) instanceof QuantifiedFormula) {
                        throw new TraceInterpolationException(TraceInterpolationException.Reason.ALTERNATING_QUANTIFIER_BAILOUT);
                    }
                    hashMap.put(n3, iPredicate3);
                    iIcfgCallTransition2 = bl ? this.mTruePredicate : iPredicate3;
                }
                IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)this.mTrace.getSymbol(n2);
                object2 = iIcfgReturnTransition.getCorrespondingCall().getSucceedingProcedure();
                object = this.mModifiedGlobals.getModifiedBoogieVars((String)object2);
                term = (Term)this.mPredicateTransformer.weakestPreconditionReturn((IAbstractPredicate)iPredicate, (IAbstractPredicate)iIcfgCallTransition2, (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)var17_17, (ITransitionRelation)string, (Set)object);
            } else {
                term = (Term)this.mPredicateTransformer.weakestPrecondition((IAbstractPredicate)iPredicate, (ITransitionRelation)((TransFormula)nestedFormulas.getFormulaFromNonCallPos(n2)));
            }
            if (this.mTrace.getSymbol(n2) instanceof IIcfgCallTransition && !this.mTrace.isPendingCall(n2)) {
                iIcfgCallTransition2 = (IPredicate)hashMap.get(n2);
            } else {
                string = backwardSequence == BackwardSequence.WP ? this.constructPredicate(term) : this.constructPredicate(SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)term));
                iIcfgCallTransition2 = IterativePredicateTransformer.applyPostprocessors(list, n2, (IPredicate)string);
            }
            if (n2 == 0) {
                iIcfgCallTransition = iIcfgCallTransition2;
            } else {
                iPredicateArray[n2 - 1] = iIcfgCallTransition2;
            }
            --n2;
        }
        if (bl3) {
            if (backwardSequence == BackwardSequence.WP) {
                return new TracePredicates(iIcfgCallTransition, this.mPostcondition, Arrays.asList(iPredicateArray));
            }
            return new TracePredicates(iIcfgCallTransition, this.mPostcondition, Arrays.asList(iPredicateArray));
        }
        return tracePredicates;
    }

    private static IPredicate applyPostprocessors(List<IPredicatePostprocessor> list, int n, IPredicate iPredicate) {
        IPredicate iPredicate2 = iPredicate;
        for (IPredicatePostprocessor iPredicatePostprocessor : list) {
            iPredicate2 = iPredicatePostprocessor.postprocess(iPredicate2, n);
        }
        return iPredicate2;
    }

    private ProcedureSummary computeProcedureSummary(NestedWord<L> nestedWord, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, UnmodifiableTransFormula unmodifiableTransFormula4, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, int n, int n2) {
        UnmodifiableTransFormula unmodifiableTransFormula5 = this.computeSummaryForInterproceduralTrace(nestedWord, nestedFormulas, n + 1, n2);
        String string = ((IAction)nestedWord.getSymbol(n)).getSucceedingProcedure();
        UnmodifiableTransFormula unmodifiableTransFormula6 = TransFormulaUtils.sequentialCompositionWithCallAndReturn((ManagedScript)this.mMgdScript, (boolean)true, (boolean)false, (boolean)true, (UnmodifiableTransFormula)unmodifiableTransFormula, (UnmodifiableTransFormula)unmodifiableTransFormula3, (UnmodifiableTransFormula)unmodifiableTransFormula4, (UnmodifiableTransFormula)unmodifiableTransFormula5, (UnmodifiableTransFormula)unmodifiableTransFormula2, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (IIcfgSymbolTable)this.mSymbolTable, (Set)this.mModifiedGlobals.getModifiedBoogieVars(string));
        return new ProcedureSummary(unmodifiableTransFormula6, unmodifiableTransFormula5);
    }

    private UnmodifiableTransFormula computeSummaryForInterproceduralTrace(NestedWord<L> nestedWord, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, int n, int n2) {
        LinkedList<UnmodifiableTransFormula> linkedList = new LinkedList<UnmodifiableTransFormula>();
        int n3 = n;
        while (n3 < n2) {
            if (nestedWord.getSymbol(n3) instanceof ICallAction) {
                Object object;
                Object object2;
                String string;
                UnmodifiableTransFormula unmodifiableTransFormula = nestedFormulas.getLocalVarAssignment(n3);
                UnmodifiableTransFormula unmodifiableTransFormula2 = nestedFormulas.getOldVarAssignment(n3);
                UnmodifiableTransFormula unmodifiableTransFormula3 = nestedFormulas.getGlobalVarAssignment(n3);
                if (nestedWord.isPendingCall(n3)) {
                    UnmodifiableTransFormula unmodifiableTransFormula4 = this.computeSummaryForInterproceduralTrace(nestedWord, nestedFormulas, n3 + 1, n2);
                    string = ((IAction)nestedWord.getSymbol(n2)).getSucceedingProcedure();
                    object2 = this.mModifiedGlobals.getModifiedBoogieVars(string);
                    return TransFormulaUtils.sequentialCompositionWithPendingCall((ManagedScript)this.mMgdScript, (boolean)true, (boolean)false, (boolean)true, linkedList, (UnmodifiableTransFormula)unmodifiableTransFormula, (UnmodifiableTransFormula)unmodifiableTransFormula2, null, (UnmodifiableTransFormula)unmodifiableTransFormula4, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (Set)object2, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (IIcfgSymbolTable)this.mSymbolTable, (String)((IAction)nestedWord.getSymbol(n)).getPrecedingProcedure(), (String)((IAction)nestedWord.getSymbol(n3)).getPrecedingProcedure(), (String)((IAction)nestedWord.getSymbol(n3)).getSucceedingProcedure(), (String)string, (ModifiableGlobalsTable)this.mModifiedGlobals);
                }
                int n4 = nestedWord.getReturnPosition(n3);
                if (n4 >= n2) {
                    string = this.computeSummaryForInterproceduralTrace(nestedWord, nestedFormulas, n3 + 1, n2);
                    object2 = ((IAction)nestedWord.getSymbol(n2)).getSucceedingProcedure();
                    object = this.mModifiedGlobals.getModifiedBoogieVars((String)object2);
                    return TransFormulaUtils.sequentialCompositionWithPendingCall((ManagedScript)this.mMgdScript, (boolean)true, (boolean)false, (boolean)true, linkedList, (UnmodifiableTransFormula)unmodifiableTransFormula, (UnmodifiableTransFormula)unmodifiableTransFormula2, (UnmodifiableTransFormula)unmodifiableTransFormula3, (UnmodifiableTransFormula)string, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (Set)object, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (IIcfgSymbolTable)this.mSymbolTable, (String)((IAction)nestedWord.getSymbol(n)).getPrecedingProcedure(), (String)((IAction)nestedWord.getSymbol(n3)).getPrecedingProcedure(), (String)((IAction)nestedWord.getSymbol(n3)).getSucceedingProcedure(), (String)object2, (ModifiableGlobalsTable)this.mModifiedGlobals);
                }
                string = this.computeSummaryForInterproceduralTrace(nestedWord, nestedFormulas, n3 + 1, n4);
                object2 = nestedFormulas.getFormulaFromNonCallPos(n4);
                object = ((IAction)nestedWord.getSymbol(n3)).getSucceedingProcedure();
                linkedList.addLast(TransFormulaUtils.sequentialCompositionWithCallAndReturn((ManagedScript)this.mMgdScript, (boolean)true, (boolean)false, (boolean)true, (UnmodifiableTransFormula)unmodifiableTransFormula, (UnmodifiableTransFormula)unmodifiableTransFormula2, (UnmodifiableTransFormula)unmodifiableTransFormula3, (UnmodifiableTransFormula)string, (UnmodifiableTransFormula)object2, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (IIcfgSymbolTable)this.mSymbolTable, (Set)this.mModifiedGlobals.getModifiedBoogieVars((String)object)));
                n3 = n4;
            } else if (!(nestedWord.getSymbol(n3) instanceof IReturnAction)) {
                linkedList.addLast(nestedFormulas.getFormulaFromNonCallPos(n3));
            }
            ++n3;
        }
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (boolean)true, (boolean)false, (boolean)true, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, linkedList);
    }

    private static enum BackwardSequence {
        PRE,
        WP;

    }

    @FunctionalInterface
    public static interface IPredicatePostprocessor {
        public IPredicate postprocess(IPredicate var1, int var2);
    }

    private static final class ProcedureSummary {
        private final UnmodifiableTransFormula mWithCallAndReturn;
        private final UnmodifiableTransFormula mWithoutCallAndReturn;

        public ProcedureSummary(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
            this.mWithCallAndReturn = unmodifiableTransFormula;
            this.mWithoutCallAndReturn = unmodifiableTransFormula2;
        }

        public UnmodifiableTransFormula getWithCallAndReturn() {
            return this.mWithCallAndReturn;
        }

        public UnmodifiableTransFormula getWithoutCallAndReturn() {
            return this.mWithoutCallAndReturn;
        }
    }

    public static class QuantifierEliminationPostprocessor
    implements IPredicatePostprocessor {
        private final IUltimateServiceProvider mServices;
        private final ManagedScript mMgdScript;
        private final BasicPredicateFactory mPredicateFactory;
        private final SmtUtils.SimplificationTechnique mSimplificationTechnique;

        public QuantifierEliminationPostprocessor(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, SmtUtils.SimplificationTechnique simplificationTechnique) {
            this.mServices = iUltimateServiceProvider;
            this.mMgdScript = managedScript;
            this.mPredicateFactory = basicPredicateFactory;
            this.mSimplificationTechnique = simplificationTechnique;
        }

        @Override
        public IPredicate postprocess(IPredicate iPredicate, int n) {
            Term term = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)iPredicate.getFormula(), (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
            return this.mPredicateFactory.newPredicate(term);
        }
    }

    public static class TraceInterpolationException
    extends Exception {
        private static final long serialVersionUID = -3626917726747958448L;
        private final Reason mReason;

        public TraceInterpolationException(Reason reason) {
            this.mReason = reason;
        }

        public Reason getReason() {
            return this.mReason;
        }

        public static enum Reason {
            ALTERNATING_QUANTIFIER_BAILOUT;

        }
    }
}

