/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqparser;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnsupportedSyntaxResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IFailedAnalysisResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.reqparser.Activator;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class ReqParserResultUtil {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private boolean mIsAborted;

    public ReqParserResultUtil(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mIsAborted = false;
    }

    @SafeVarargs
    public final <T extends PatternType<?>> void mergedRequirements(T ... TArray) {
        assert (TArray != null && TArray.length > 1);
        this.mergedRequirements((Collection<? extends PatternType<?>>)Arrays.asList(TArray));
    }

    public void mergedRequirements(Collection<? extends PatternType<?>> collection) {
        assert (collection != null && collection.size() > 1);
        String string = collection.stream().map(PatternType::getId).collect(Collectors.joining(", "));
        MergedRequirementsResult mergedRequirementsResult = new MergedRequirementsResult(string);
        this.mLogger.warn((Object)mergedRequirementsResult.getLongDescription());
        this.report((IResult)mergedRequirementsResult);
    }

    public void unsupportedSyntaxError(ILocation iLocation, String string) {
        this.errorAndAbort(String.valueOf(iLocation) + ": " + string, (IResult)new UnsupportedSyntaxResult(Activator.PLUGIN_ID, iLocation, string));
    }

    public void unexpectedParserFailure(String string, String string2) {
        this.errorAndAbort((IResult)new UnexpectedRequirementsParserFailureResult(string, string2));
    }

    public boolean isAlreadyAborted() {
        return this.mIsAborted;
    }

    private void errorAndAbort(IResult iResult) {
        this.errorAndAbort(iResult.getShortDescription(), iResult);
    }

    private void errorAndAbort(String string, IResult iResult) {
        this.mLogger.error((Object)string);
        this.report(iResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
        this.mIsAborted = true;
    }

    private void report(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }

    private static final class MergedRequirementsResult
    extends GenericResult {
        public MergedRequirementsResult(String string) {
            super(Activator.PLUGIN_ID, "Merged " + string, "The following requirements have been merged because they are equivalent: " + string, IResultWithSeverity.Severity.WARNING);
        }
    }

    private static final class UnexpectedRequirementsParserFailureResult
    extends AbstractResult
    implements IFailedAnalysisResult {
        private final String mMessage;
        private final String mLongMessage;

        public UnexpectedRequirementsParserFailureResult(String string, String string2) {
            super(Activator.PLUGIN_ID);
            this.mMessage = String.format("The parser failed on some requirements from %s", string);
            this.mLongMessage = string2;
        }

        public String getShortDescription() {
            return this.mMessage;
        }

        public String getLongDescription() {
            return this.mLongMessage;
        }
    }
}

