/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.AssertionOrderModulation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleBase;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;

public abstract class IpTcStrategyModuleTraceCheck<T extends IInterpolatingTraceCheck<LETTER>, LETTER extends IIcfgTransition<?>>
extends IpTcStrategyModuleBase<T, LETTER> {
    protected final TaskIdentifier mTaskIdentifier;
    protected final IUltimateServiceProvider mServices;
    protected final TaCheckAndRefinementPreferences<?> mPrefs;
    protected final AssertionOrderModulation<LETTER> mAssertionOrderModulation;
    protected final Counterexample<LETTER> mCounterexample;
    protected final IPredicateUnifier mPredicateUnifier;
    protected final IPredicate mPrecondition;
    protected final IPredicate mPostcondition;
    protected final PredicateFactory mPredicateFactory;

    public IpTcStrategyModuleTraceCheck(TaskIdentifier taskIdentifier, IUltimateServiceProvider iUltimateServiceProvider, TaCheckAndRefinementPreferences<LETTER> taCheckAndRefinementPreferences, Counterexample<LETTER> counterexample, IPredicate iPredicate, IPredicate iPredicate2, AssertionOrderModulation<LETTER> assertionOrderModulation, IPredicateUnifier iPredicateUnifier, PredicateFactory predicateFactory) {
        this.mServices = iUltimateServiceProvider;
        this.mPrefs = taCheckAndRefinementPreferences;
        this.mAssertionOrderModulation = assertionOrderModulation;
        this.mCounterexample = counterexample;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredicateFactory = predicateFactory;
        this.mPrecondition = iPredicate;
        this.mPostcondition = iPredicate2;
        this.mTaskIdentifier = taskIdentifier;
    }

    public void aggregateStatistics(RefinementEngineStatisticsGenerator refinementEngineStatisticsGenerator) {
        refinementEngineStatisticsGenerator.addStatistics(RefinementEngineStatisticsGenerator.RefinementEngineStatisticsDefinitions.TRACE_CHECK, this.getOrConstruct().getStatistics());
    }

    protected ManagedScript createExternalManagedScript(SolverBuilder.SolverSettings solverSettings) {
        return this.mPrefs.getIcfgContainer().getCfgSmtToolkit().createFreshManagedScript(this.mServices, solverSettings, this.getSolverName());
    }

    protected long computeTimeout(long l) {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("timeout must be non-negative or -1");
        }
        long l2 = this.mServices.getProgressMonitorService().remainingTime();
        if (l == -1L) {
            return l2;
        }
        if (l2 == -1L) {
            return l;
        }
        return Math.min(l2, l);
    }

    private String getSolverName() {
        return "TraceCheck_Iteration_" + this.mTaskIdentifier.toString();
    }
}

