/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter;

import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ProgramStatePrinter<TE, E> {
    private final IBacktranslationValueProvider<TE, E> mStringProvider;

    public ProgramStatePrinter(IBacktranslationValueProvider<TE, E> iBacktranslationValueProvider) {
        this.mStringProvider = iBacktranslationValueProvider;
    }

    private String singleEntryAsExpression(IProgramExecution.ProgramState<E> programState, E e, Predicate<String> predicate) {
        String string = this.mStringProvider.getStringFromExpression(e);
        if (!predicate.test(string)) {
            return null;
        }
        List list = programState.getValues(e).stream().map(arg_0 -> this.mStringProvider.getStringFromExpression(arg_0)).filter(this::checkValueString).map(string2 -> string + " == " + string2).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        String string3 = list.stream().collect(Collectors.joining(" || "));
        if (list.size() == 1) {
            return string3;
        }
        return "(" + string3 + ")";
    }

    public String stateAsExpression(IProgramExecution.ProgramState<E> programState, Predicate<String> predicate) {
        if (programState == null) {
            return null;
        }
        List list = programState.getVariables().stream().map(object -> this.singleEntryAsExpression(programState, object, predicate)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().collect(Collectors.joining(" && "));
    }

    public static boolean isValidCVariable(String string) {
        return !string.contains("\\") && !string.contains("&");
    }

    private boolean checkValueString(String string) {
        try {
            new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            return "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string);
        }
        return true;
    }
}

