/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.graphml;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.witnessprinter.Activator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessNode;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphMLWriter;
import java.util.function.Function;

public abstract class GraphMLBaseWitnessGenerator<TE, E> {
    private final IUltimateServiceProvider mServices;

    public GraphMLBaseWitnessGenerator(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    public abstract String makeGraphMLString();

    protected void addCanonicalWitnessGraphData(GraphMLWriter<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> graphMLWriter, String string, String string2) {
        this.addGraphData(graphMLWriter, "sourcecodelang", null, hypergraph -> "C");
        this.addGraphData(graphMLWriter, "witness-type", null, hypergraph -> string);
        this.addGraphData(graphMLWriter, "programfile", null, hypergraph -> string2);
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.writePassthroughWitnessGraphData(graphMLWriter, iPreferenceProvider, "producer", "Graph data producer");
        this.writePassthroughWitnessGraphData(graphMLWriter, iPreferenceProvider, "specification", "Graph data specification");
        this.writePassthroughWitnessGraphData(graphMLWriter, iPreferenceProvider, "programhash", "Graph data programhash");
        this.writePassthroughWitnessGraphData(graphMLWriter, iPreferenceProvider, "architecture", "Graph data architecture");
        String string3 = CoreUtil.getIsoUtcTimestamp();
        this.addGraphData(graphMLWriter, "creationtime", null, hypergraph -> string3);
    }

    private void writePassthroughWitnessGraphData(GraphMLWriter<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> graphMLWriter, IPreferenceProvider iPreferenceProvider, String string, String string2) {
        String string3 = iPreferenceProvider.getString(string2);
        if (string3 == null || "UNUSED".equals(string3)) {
            return;
        }
        this.addGraphData(graphMLWriter, string, null, hypergraph -> string3);
    }

    protected void addGraphData(GraphMLWriter<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> graphMLWriter, String string, String string2, Function<Hypergraph<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>>, String> function) {
        assert (function != null);
        graphMLWriter.addGraphData(string, null, string2, function::apply);
    }

    protected void addEdgeData(GraphMLWriter<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> graphMLWriter, String string, String string2, Function<GeneratedWitnessEdge<TE, E>, String> function) {
        assert (function != null);
        graphMLWriter.addEdgeData(string, null, string2, function::apply);
    }

    protected void addVertexData(GraphMLWriter<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> graphMLWriter, String string, String string2, Function<GeneratedWitnessNode, String> function) {
        assert (function != null);
        graphMLWriter.addVertexData(string, null, string2, function::apply);
    }
}

