/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class PredicateTransferrer {
    private final TransferrerWithVariableCache mTransferrer;
    private final SmtFreePredicateFactory mTargetFactory;
    private final SmtFreePredicateFactory mSourceFactory;
    private final BidirectionalMap<IPredicate, IPredicate> mPredicateCache = new BidirectionalMap();

    public PredicateTransferrer(TransferrerWithVariableCache transferrerWithVariableCache, SmtFreePredicateFactory smtFreePredicateFactory, SmtFreePredicateFactory smtFreePredicateFactory2) {
        this.mTransferrer = transferrerWithVariableCache;
        this.mSourceFactory = smtFreePredicateFactory;
        this.mTargetFactory = smtFreePredicateFactory2;
    }

    public IPredicate transferPredicate(IPredicate iPredicate) {
        return (IPredicate)this.mPredicateCache.computeIfAbsent((Object)iPredicate, this::transferPredicateHelper);
    }

    private BasicPredicate transferPredicateHelper(IPredicate iPredicate) {
        if (!iPredicate.getFuns().isEmpty()) {
            throw new UnsupportedOperationException("Implement support for transferring functions");
        }
        Set<IProgramVar> set = this.mTransferrer.transferVariables(iPredicate.getVars());
        Term term = this.mTransferrer.transferTerm(iPredicate.getFormula());
        Term term2 = this.mTransferrer.transferTerm(iPredicate.getClosedFormula());
        return this.mTargetFactory.construct(n -> new BasicPredicate(n, term, set, Collections.emptySet(), term2));
    }

    public IPredicate backTransferPredicate(IPredicate iPredicate) {
        return (IPredicate)this.mPredicateCache.inverse().computeIfAbsent((Object)iPredicate, this::backTransferPredicateHelper);
    }

    private BasicPredicate backTransferPredicateHelper(IPredicate iPredicate) {
        if (!iPredicate.getFuns().isEmpty()) {
            throw new UnsupportedOperationException("Implement support for transferring functions");
        }
        Set<IProgramVar> set = this.backTransferVariables(iPredicate.getVars());
        Term term = this.mTransferrer.backTransferTerm(iPredicate.getFormula());
        Term term2 = this.mTransferrer.backTransferTerm(iPredicate.getClosedFormula());
        return this.mSourceFactory.construct(n -> new BasicPredicate(n, term, set, Collections.emptySet(), term2));
    }

    private Set<IProgramVar> backTransferVariables(Set<IProgramVar> set) {
        return set.stream().map(this.mTransferrer::getOriginalProgramVar).collect(Collectors.toSet());
    }
}

