/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.CallReturnPyramideInstanceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PredicateTransformer<C, P extends IAbstractPredicate, R extends ITransitionRelation> {
    private final ManagedScript mMgdScript;
    private final IDomainSpecificOperationProvider<C, P, R> mOperationProvider;

    public PredicateTransformer(ManagedScript managedScript, IDomainSpecificOperationProvider<C, P, R> iDomainSpecificOperationProvider) {
        this.mMgdScript = managedScript;
        this.mOperationProvider = iDomainSpecificOperationProvider;
    }

    public C strongestPostcondition(P p, R r) {
        Object object;
        C c = this.mOperationProvider.getConstraint(p);
        if (this.mOperationProvider.isConstraintUnsatisfiable(c)) {
            return c;
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        ConstructionCache.IValueConstruction iValueConstruction = iProgramVar -> {
            TermVariable termVariable = PredicateTransformer.constructFreshTermVariable(this.mMgdScript, iProgramVar);
            hashSet.add(termVariable);
            return termVariable;
        };
        ConstructionCache constructionCache = new ConstructionCache(iValueConstruction);
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry2 : r.getInVars().entrySet()) {
            object = entry2.getKey();
            if (entry2.getValue() == r.getOutVars().get(object)) continue;
            TermVariable termVariable = (TermVariable)constructionCache.getOrConstruct(object);
            hashMap.put((Term)entry2.getValue(), (Term)termVariable);
            if (!p.getVars().contains(object)) continue;
            hashMap2.put((Term)object.getTermVariable(), (Term)termVariable);
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : r.getOutVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), (Term)entry.getKey().getTermVariable());
            if (r.getInVars().containsKey(entry.getKey()) || !p.getVars().contains(entry.getKey())) continue;
            object = (TermVariable)constructionCache.getOrConstruct((Object)entry.getKey());
            hashMap2.put((Term)entry.getKey().getTermVariable(), (Term)object);
        }
        C c2 = this.mOperationProvider.renameVariables(hashMap, this.mOperationProvider.getConstraintFromTransitionRelation(r));
        Iterator<Map.Entry<IProgramVar, Object>> iterator = this.mOperationProvider.renameVariables(hashMap2, c);
        object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c2, iterator));
        hashSet.addAll(r.getAuxVars());
        return (C)this.mOperationProvider.projectExistentially(hashSet, object);
    }

    public C strongestPostconditionCall(P p, R r, R r2, R r3, Set<IProgramNonOldVar> set) {
        if (!r2.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        if (!r3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), r.getAssignedVars(), set, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL);
        C c = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c3 = this.renameRelationToInstances(r3, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c4 = this.renameRelationToInstances(r2, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c2, c3, c4, c));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(r, callReturnPyramideInstanceProvider.getFreshTermVariables()), object);
    }

    public C modularPostconditionCall(P p, R r, Set<IProgramNonOldVar> set) {
        if (!r.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), Collections.emptySet(), set, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL);
        C c = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c2, c));
        return (C)this.mOperationProvider.projectExistentially(callReturnPyramideInstanceProvider.getFreshTermVariables(), object);
    }

    public C strongestPostconditionReturn(P p, P p2, R r, R r2, R r3, Set<IProgramNonOldVar> set) {
        if (!r.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"TransFormula of return must not contain auxVars");
        }
        if (!r3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, r.getAssignedVars(), r2.getAssignedVars(), set, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN);
        C c = this.renamePredicateToInstance(p2, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, callReturnPyramideInstanceProvider);
        C c3 = this.renameRelationToInstances(r2, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c4 = this.renameRelationToInstances(r3, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c5 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c3, c4, c5, c, c2));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(r2, callReturnPyramideInstanceProvider.getFreshTermVariables()), object);
    }

    public C weakestPrecondition(P p, R r) {
        C c = this.mOperationProvider.getConstraint(p);
        if (this.mOperationProvider.isConstraintValid(c)) {
            return c;
        }
        PreRenaming preRenaming = new PreRenaming(this, p, r);
        C c2 = this.mOperationProvider.renameVariables(preRenaming.getSubstitutionForRelation(), this.mOperationProvider.getConstraintFromTransitionRelation(r));
        C c3 = this.mOperationProvider.renameVariables(preRenaming.getSubstitutionForSuccessor(), c);
        Object object = this.mOperationProvider.constructDisjunction(PredicateTransformer.toList(this.mOperationProvider.constructNegation(c2), c3));
        return (C)this.mOperationProvider.projectUniversally(preRenaming.getVarsToProject(), object);
    }

    public C weakestPreconditionCall(P p, R r, R r2, R r3, Set<IProgramNonOldVar> set) {
        if (!r2.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        if (!r3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), r.getAssignedVars(), set, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL);
        C c = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c3 = this.renameRelationToInstances(r3, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c4 = this.renameRelationToInstances(r2, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructDisjunction(PredicateTransformer.toList(this.mOperationProvider.constructNegation(c2), this.mOperationProvider.constructNegation(c3), this.mOperationProvider.constructNegation(c4), c));
        return (C)this.mOperationProvider.projectUniversally(this.addAuxVarsOfCall(r, callReturnPyramideInstanceProvider.getFreshTermVariables()), object);
    }

    public C weakestPreconditionReturn(P p, P p2, R r, R r2, R r3, Set<IProgramNonOldVar> set) {
        if (!r.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"TransFormula of return must not contain auxVars");
        }
        if (!r3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, r.getAssignedVars(), r2.getAssignedVars(), set, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN);
        C c = this.renamePredicateToInstance(p2, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, callReturnPyramideInstanceProvider);
        C c3 = this.renameRelationToInstances(r2, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c4 = this.renameRelationToInstances(r3, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c5 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructDisjunction(PredicateTransformer.toList(this.mOperationProvider.constructNegation(c3), this.mOperationProvider.constructNegation(c4), this.mOperationProvider.constructNegation(c5), this.mOperationProvider.constructNegation(c), c2));
        return (C)this.mOperationProvider.projectUniversally(this.addAuxVarsOfCall(r2, callReturnPyramideInstanceProvider.getFreshTermVariables()), object);
    }

    public C pre(P p, R r) {
        C c = this.mOperationProvider.getConstraint(p);
        if (this.mOperationProvider.isConstraintUnsatisfiable(c)) {
            return c;
        }
        PreRenaming preRenaming = new PreRenaming(this, p, r);
        C c2 = this.mOperationProvider.renameVariables(preRenaming.getSubstitutionForRelation(), this.mOperationProvider.getConstraintFromTransitionRelation(r));
        C c3 = this.mOperationProvider.renameVariables(preRenaming.getSubstitutionForSuccessor(), c);
        Object object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c2, c3));
        return (C)this.mOperationProvider.projectExistentially(preRenaming.getVarsToProject(), object);
    }

    public C preCall(P p, R r, R r2, R r3, Set<IProgramNonOldVar> set) {
        if (!r2.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"globalVarsAssignments must not contain auxVars");
        }
        if (!r3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, Collections.emptySet(), r.getAssignedVars(), set, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL);
        C c = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c3 = this.renameRelationToInstances(r3, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c4 = this.renameRelationToInstances(r2, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c2, c3, c4, c));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(r, callReturnPyramideInstanceProvider.getFreshTermVariables()), object);
    }

    public C preReturn(P p, P p2, R r, R r2, R r3, Set<IProgramNonOldVar> set) {
        if (!r.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"TransFormula of return must not contain auxVars");
        }
        if (!r3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)"oldVarAssignments must not contain auxVars");
        }
        CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider = new CallReturnPyramideInstanceProvider(this.mMgdScript, r.getAssignedVars(), r2.getAssignedVars(), set, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN);
        C c = this.renamePredicateToInstance(p2, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, callReturnPyramideInstanceProvider);
        C c2 = this.renamePredicateToInstance(p, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, callReturnPyramideInstanceProvider);
        C c3 = this.renameRelationToInstances(r2, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c4 = this.renameRelationToInstances(r3, CallReturnPyramideInstanceProvider.Instance.BEFORE_CALL, CallReturnPyramideInstanceProvider.Instance.AFTER_CALL, callReturnPyramideInstanceProvider);
        C c5 = this.renameRelationToInstances(r, CallReturnPyramideInstanceProvider.Instance.BEFORE_RETURN, CallReturnPyramideInstanceProvider.Instance.AFTER_RETURN, callReturnPyramideInstanceProvider);
        Object object = this.mOperationProvider.constructConjunction(PredicateTransformer.toList(c3, c4, c5, c, c2));
        return (C)this.mOperationProvider.projectExistentially(this.addAuxVarsOfCall(r2, callReturnPyramideInstanceProvider.getFreshTermVariables()), object);
    }

    private C renamePredicateToInstance(P p, CallReturnPyramideInstanceProvider.Instance instance, CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider) {
        IProgramVar iProgramVar2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (IProgramVar iProgramVar2 : p.getVars()) {
            hashMap.put((Term)iProgramVar2.getTermVariable(), callReturnPyramideInstanceProvider.getInstance(iProgramVar2, instance));
        }
        iProgramVar2 = this.mOperationProvider.renameVariables(hashMap, this.mOperationProvider.getConstraint(p));
        return (C)iProgramVar2;
    }

    private C renameRelationToInstances(R r, CallReturnPyramideInstanceProvider.Instance instance, CallReturnPyramideInstanceProvider.Instance instance2, CallReturnPyramideInstanceProvider callReturnPyramideInstanceProvider) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry2 : r.getOutVars().entrySet()) {
            hashMap.put((Term)entry2.getValue(), callReturnPyramideInstanceProvider.getInstance(entry2.getKey(), instance2));
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : r.getInVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), callReturnPyramideInstanceProvider.getInstance(entry.getKey(), instance));
        }
        C c = this.mOperationProvider.renameVariables(hashMap, this.mOperationProvider.getConstraintFromTransitionRelation(r));
        return c;
    }

    private Set<TermVariable> addAuxVarsOfCall(R r, Set<TermVariable> set) {
        Set<TermVariable> set2;
        if (r.getAuxVars().isEmpty()) {
            set2 = set;
        } else {
            set2 = new HashSet<TermVariable>(set);
            set2.addAll(r.getAuxVars());
        }
        return set2;
    }

    @SafeVarargs
    private static <E> List<E> toList(E ... EArray) {
        return Arrays.asList(EArray);
    }

    private static TermVariable constructFreshTermVariable(ManagedScript managedScript, IProgramVar iProgramVar) {
        return managedScript.constructFreshTermVariable(iProgramVar.getGloballyUniqueId(), iProgramVar.getTermVariable().getSort());
    }

    private static final class PreRenaming {
        private final Set<TermVariable> mVarsToProject = new HashSet<TermVariable>();
        private final Map<Term, Term> mSubstitutionForRelation;
        private final Map<Term, Term> mSubstitutionForSuccessor;
        final /* synthetic */ PredicateTransformer this$0;

        private PreRenaming(P p, R r) {
            IProgramVar iProgramVar2;
            this.this$0 = var1_1;
            ConstructionCache.IValueConstruction iValueConstruction = iProgramVar -> {
                TermVariable termVariable = PredicateTransformer.constructFreshTermVariable(this.this$0.mMgdScript, iProgramVar);
                this.mVarsToProject.add(termVariable);
                return termVariable;
            };
            ConstructionCache constructionCache = new ConstructionCache(iValueConstruction);
            this.mSubstitutionForRelation = new HashMap<Term, Term>();
            this.mSubstitutionForSuccessor = new HashMap<Term, Term>();
            for (Map.Entry<IProgramVar, TermVariable> entry : r.getOutVars().entrySet()) {
                iProgramVar2 = entry.getKey();
                if (entry.getValue() == r.getInVars().get(iProgramVar2)) continue;
                TermVariable termVariable = (TermVariable)constructionCache.getOrConstruct((Object)iProgramVar2);
                this.mSubstitutionForRelation.put((Term)entry.getValue(), (Term)termVariable);
                if (!p.getVars().contains(iProgramVar2)) continue;
                this.mSubstitutionForSuccessor.put((Term)iProgramVar2.getTermVariable(), (Term)termVariable);
            }
            for (Map.Entry<IProgramVar, TermVariable> entry : r.getInVars().entrySet()) {
                this.mSubstitutionForRelation.put((Term)entry.getValue(), (Term)entry.getKey().getTermVariable());
                if (r.getOutVars().containsKey(entry.getKey()) || !p.getVars().contains(entry.getKey())) continue;
                iProgramVar2 = (TermVariable)constructionCache.getOrConstruct((Object)entry.getKey());
                this.mSubstitutionForSuccessor.put((Term)entry.getKey().getTermVariable(), (Term)iProgramVar2);
            }
            this.mVarsToProject.addAll(r.getAuxVars());
        }

        public Set<TermVariable> getVarsToProject() {
            return this.mVarsToProject;
        }

        public Map<Term, Term> getSubstitutionForRelation() {
            return this.mSubstitutionForRelation;
        }

        public Map<Term, Term> getSubstitutionForSuccessor() {
            return this.mSubstitutionForSuccessor;
        }
    }
}

