/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    String text;
    Image image;
    Image[] images = new Image[0];
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    long accelGroup;
    long vboxHandle;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        } else if ((style & 0x800000) != 0) {
            style |= 0x20;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void _setImages(Image[] images) {
        if (images != null && images.length > 1) {
            Image[] bestImages = new Image[images.length];
            System.arraycopy(images, 0, bestImages, 0, images.length);
            this.sort(bestImages);
            images = bestImages;
        }
        long icon_list = 0L;
        if (images != null) {
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                long pixbuf = ImageList.createPixbuf(image);
                if (GTK.GTK4) {
                    long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
                    OS.g_object_unref(pixbuf);
                    icon_list = OS.g_list_append(icon_list, texture);
                } else {
                    icon_list = OS.g_list_append(icon_list, pixbuf);
                }
                ++n2;
            }
        }
        if (GTK.GTK4) {
            long surface = GTK4.gtk_native_get_surface(this.topHandle());
            GTK4.gdk_toplevel_set_icon_list(surface, icon_list);
        } else {
            GTK3.gtk_window_set_icon_list(this.topHandle(), icon_list);
        }
        long temp = icon_list;
        while (temp != 0L) {
            OS.g_object_unref(OS.g_list_data(temp));
            temp = OS.g_list_next(temp);
        }
        if (icon_list != 0L) {
            OS.g_list_free(icon_list);
        }
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    int compare(ImageData data1, ImageData data2) {
        if (data1.width == data2.width && data1.height == data2.height) {
            int transparent1 = data1.getTransparencyType();
            int transparent2 = data2.getTransparencyType();
            if (transparent1 == 1) {
                return -1;
            }
            if (transparent2 == 1) {
                return 1;
            }
            if (transparent1 == 2) {
                return -1;
            }
            if (transparent2 == 2) {
                return 1;
            }
            if (transparent1 == 4) {
                return -1;
            }
            if (transparent2 == 4) {
                return 1;
            }
            return 0;
        }
        return data1.width > data2.width || data1.height > data2.height ? -1 : 1;
    }

    @Override
    Widget computeTabGroup() {
        return this;
    }

    @Override
    Control computeTabRoot() {
        return this;
    }

    void createAccelGroup() {
        if (this.accelGroup != 0L) {
            return;
        }
        this.accelGroup = GTK.gtk_accel_group_new();
        if (this.accelGroup == 0L) {
            this.error(2);
        }
        long shellHandle = this.topHandle();
        GTK3.gtk_window_add_accel_group(shellHandle, this.accelGroup);
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void destroyAccelGroup() {
        if (this.accelGroup == 0L) {
            return;
        }
        if (this.menuBar != null) {
            this.menuBar.removeAccelerators(this.accelGroup);
        }
        long shellHandle = this.topHandle();
        GTK3.gtk_window_remove_accel_group(shellHandle, this.accelGroup);
        OS.g_object_unref(this.accelGroup);
        this.accelGroup = 0L;
    }

    void fixAccelGroup() {
        if (this.menuBar == null) {
            return;
        }
        this.destroyAccelGroup();
        this.createAccelGroup();
        this.menuBar.addAccelerators(this.accelGroup);
    }

    void fixDecorations(Decorations newDecorations, Control control, Menu[] menus) {
        if (this == newDecorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menus == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int index = 0;
            while (index < menus.length) {
                if (menus[index] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++index;
            }
            menu.fixMenus(newDecorations);
        }
    }

    public Button getDefaultButton() {
        Button button;
        this.checkWidget();
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button != null && button.isDisposed()) {
            return null;
        }
        return button;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] result = new Image[this.images.length];
        System.arraycopy(this.images, 0, result, 0, this.images.length);
        return result;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    boolean isTabItem() {
        return false;
    }

    @Override
    Decorations menuShell() {
        return this;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(destroy);
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
            this.menus = null;
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.vboxHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menuBar != null) {
            this.menuBar.reskin(flags);
        }
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null) {
                    menu.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean restored = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return restored;
    }

    public void setDefaultButton(Button button) {
        long saveButtonHandle;
        this.checkWidget();
        long buttonHandle = 0L;
        if (this.saveDefault != null && !this.saveDefault.isDisposed() && (saveButtonHandle = this.saveDefault.handle) != 0L) {
            long context = GTK.gtk_widget_get_style_context(saveButtonHandle);
            GTK.gtk_style_context_remove_class(context, GTK.GTK_STYLE_CLASS_SUGGESTED_ACTION);
        }
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
            buttonHandle = button.handle;
        }
        this.saveDefault = this.defaultButton = button;
        if (buttonHandle != 0L) {
            long context = GTK.gtk_widget_get_style_context(buttonHandle);
            GTK.gtk_style_context_add_class(context, GTK.GTK_STYLE_CLASS_SUGGESTED_ACTION);
        }
        if (GTK.GTK4) {
            GTK4.gtk_window_set_default_widget(this.topHandle(), buttonHandle);
        } else {
            GTK3.gtk_window_set_default(this.topHandle(), buttonHandle);
        }
    }

    public void setImage(Image image) {
        Image[] imageArray;
        this.checkWidget();
        this.image = image;
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null) {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        } else {
            imageArray = null;
        }
        this._setImages(imageArray);
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null || images[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        this.images = images;
        this._setImages(images);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        this.minimized = minimized;
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (!create && this.menuBar != null) {
            this.menuBar._setOrientation(this.style & 0x6000000);
        }
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    void sort(Image[] images) {
        int length = images.length;
        if (length <= 1) {
            return;
        }
        ImageData[] datas = new ImageData[length];
        int i = 0;
        while (i < length) {
            datas[i] = images[i].getImageData();
            ++i;
        }
        int gap = length / 2;
        while (gap > 0) {
            int i2 = gap;
            while (i2 < length) {
                int j = i2 - gap;
                while (j >= 0) {
                    if (this.compare(datas[j], datas[j + gap]) >= 0) {
                        Image swap = images[j];
                        images[j] = images[j + gap];
                        images[j + gap] = swap;
                        ImageData swapData = datas[j];
                        datas[j] = datas[j + gap];
                        datas[j + gap] = swapData;
                    }
                    j -= gap;
                }
                ++i2;
            }
            gap /= 2;
        }
    }

    @Override
    boolean traverseItem(boolean next) {
        return false;
    }

    @Override
    boolean traverseReturn() {
        Button button;
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button == null || button.isDisposed()) {
            return false;
        }
        if (!button.isVisible() || !button.isEnabled()) {
            return true;
        }
        long shellHandle = this._getShell().topHandle();
        if (GTK.GTK4) {
            long defaultWidget = GTK.gtk_window_get_default_widget(shellHandle);
            return GTK.gtk_widget_activate(defaultWidget);
        }
        return GTK3.gtk_window_activate_default(shellHandle);
    }
}

