/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayDeque;

public class PrintTerm {
    protected final ArrayDeque<Object> mTodo = new ArrayDeque();

    public void append(Appendable appendable, Term term) {
        try {
            this.mTodo.add(term);
            this.run(appendable);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Appender throws IOException", iOException);
        }
    }

    public void append(Appendable appendable, Sort sort) {
        try {
            this.mTodo.add(sort);
            this.run(appendable);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Appender throws IOException", iOException);
        }
    }

    public void append(Appendable appendable, Object[] objectArray) {
        try {
            this.mTodo.add(objectArray);
            this.run(appendable);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Appender throws IOException", iOException);
        }
    }

    public static String quoteIdentifier(String string) {
        assert (string.indexOf(124) < 0 && string.indexOf(92) < 0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' && n > 0 || "~!@$%^&*_+-=<>.?/".indexOf(c) >= 0)) {
                return "|" + string + "|";
            }
            ++n;
        }
        return string;
    }

    public static Object quoteObjectIfString(Object object) {
        if (object instanceof String) {
            String string = String.valueOf(object);
            if (string.charAt(0) == '|' && string.charAt(string.length() - 1) == '|') {
                return object;
            }
            return PrintTerm.quoteIdentifier(string);
        }
        return object;
    }

    protected void walkTerm(Term term) {
        term.toStringHelper(this.mTodo);
    }

    protected void walkSort(Sort sort) {
        sort.toStringHelper(this.mTodo);
    }

    private void run(Appendable appendable) throws IOException {
        while (!this.mTodo.isEmpty()) {
            Object object = this.mTodo.removeLast();
            if (object instanceof Term) {
                this.walkTerm((Term)object);
                continue;
            }
            if (object instanceof Sort) {
                this.walkSort((Sort)object);
                continue;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                this.mTodo.addLast(")");
                int n = objectArray.length - 1;
                while (n >= 0) {
                    this.mTodo.addLast(objectArray[n]);
                    if (n > 0) {
                        this.mTodo.addLast(" ");
                    }
                    --n;
                }
                appendable.append('(');
                continue;
            }
            appendable.append(object.toString());
        }
    }

    public String toString() {
        return "[PrintTerm: " + String.valueOf(this.mTodo) + "]";
    }
}

