/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayOccurrenceAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArraySelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayIndexEqualityUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayIndexReplacementConstructor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Elim1Store {
    private static final Comparator<Term> FEWER_VARIABLE_FIRST = (term, term2) -> term2.getFreeVars().length - term.getFreeVars().length;
    private static final Comparator<ArrayIndex> INDEX_WITH_FEWER_VARIABLE_FIRST = (arrayIndex, arrayIndex2) -> arrayIndex2.getFreeVars().size() - arrayIndex.getFreeVars().size();
    private static final String AUX_VAR_NEW_ARRAY = "arrayElimArr";
    private static final String AUX_VAR_INDEX = "arrayElimIndex";
    private static final String AUX_VAR_ARRAYCELL = "arrayElimCell";
    private final Script mScript;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private static final boolean DEBUG_EXTENDED_RESULT_CHECK = false;
    private static final boolean APPLY_DOUBLE_CASE_SIMPLIFICATION = true;
    private static final boolean APPLY_RESULT_SIMPLIFICATION = false;
    private static final boolean DEBUG_CRASH_ON_LARGE_SIMPLIFICATION_POTENTIAL = false;
    private static final boolean SELECT_OVER_STORE_PREPROCESSING = true;
    private static final boolean DEBUG_DUMP_TEST_FOR_BUG = false;

    public Elim1Store(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, int n) {
        this.mScript = managedScript.getScript();
        this.mMgdScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
    }

    public EliminationTask elim1(EliminationTask eliminationTask) throws ElimStorePlain.ElimStorePlainException {
        Object object;
        Pair<List<Term>, List<Term>> pair;
        Pair<List<Term>, List<Term>> pair2;
        Object object2;
        assert (UltimateNormalFormUtils.respectsUltimateNormalForm(eliminationTask.getTerm())) : "invalid input";
        if (eliminationTask.getEliminatees().size() != 1) {
            throw new IllegalArgumentException("Can only eliminate one variable");
        }
        int n = eliminationTask.getQuantifier();
        TermVariable termVariable = eliminationTask.getEliminatees().iterator().next();
        Term term = QuantifierUtils.negateIfUniversal(this.mServices, this.mMgdScript, n, eliminationTask.getContext().getCriticalConstraint());
        ArrayOccurrenceAnalysis arrayOccurrenceAnalysis = new ArrayOccurrenceAnalysis(this.mMgdScript.getScript(), eliminationTask.getTerm(), (Term)termVariable).downgradeDimensionsIfNecessary(this.mMgdScript.getScript());
        assert (arrayOccurrenceAnalysis.computeSelectAndStoreDimensions().size() <= 1) : "incompatible";
        List<MultiDimensionalSelect> list = arrayOccurrenceAnalysis.getArraySelects();
        List<MultiDimensionalNestedStore> list2 = arrayOccurrenceAnalysis.getNestedArrayStores();
        ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation = ArrayIndexEqualityUtils.collectComplimentaryEqualityInformation(this.mMgdScript.getScript(), n, term, list, list2);
        if (threeValuedEquivalenceRelation == null) {
            Term term2 = QuantifierUtils.getNeutralElement(this.mScript, n);
            this.mLogger.warn((Object)("Array PQE input equivalent to " + String.valueOf(term2)));
            return new EliminationTask(n, Collections.emptySet(), term2, eliminationTask.getContext());
        }
        HashSet<ArrayIndex> hashSet = new HashSet<ArrayIndex>();
        for (MultiDimensionalSelect object52 : list) {
            hashSet.add(object52.getIndex());
        }
        ArrayIndexEqualityManager arrayIndexEqualityManager = new ArrayIndexEqualityManager(threeValuedEquivalenceRelation, term, n, this.mLogger, this.mMgdScript);
        if (arrayIndexEqualityManager.contextIsAbsorbingElement()) {
            arrayIndexEqualityManager.unlockSolver();
            Term term3 = QuantifierUtils.getNeutralElement(this.mScript, n);
            this.mLogger.warn((Object)("Array PQE input equivalent to " + String.valueOf(term3)));
            return new EliminationTask(n, Collections.emptySet(), term3, eliminationTask.getContext());
        }
        long l = System.nanoTime();
        ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation2 = Elim1Store.analyzeIndexEqualities(n, hashSet, list2, term, threeValuedEquivalenceRelation, termVariable, this.mMgdScript, arrayIndexEqualityManager);
        long l2 = (System.nanoTime() - l) / 1000000L;
        if (l2 > 100L) {
            this.mLogger.info((Object)("Index analysis took " + l2 + " ms"));
        }
        assert (threeValuedEquivalenceRelation2 != null);
        Elim1Store.inferCellEqualitiesViaCongruence(this.mMgdScript, termVariable, threeValuedEquivalenceRelation2, threeValuedEquivalenceRelation);
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>();
        for (ArrayIndex arrayIndex : hashSet) {
            object2 = (ArrayIndex)threeValuedEquivalenceRelation2.getRepresentative((Object)arrayIndex);
            arrayList.add((ArrayIndex)object2);
        }
        AuxVarConstructor auxVarConstructor = new AuxVarConstructor();
        IndexMappingProvider indexMappingProvider = new IndexMappingProvider(this.mMgdScript, termVariable, threeValuedEquivalenceRelation2);
        object2 = indexMappingProvider.getIndexReplacementMapping();
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>(indexMappingProvider.getConstructedAuxVars());
        Term term2 = indexMappingProvider.constructAuxVarDefinitions(this.mScript, n);
        Map<MultiDimensionalNestedStore, Term> map = this.computeStoreTermEquivalenceMapping(this.mScript, auxVarConstructor, n, termVariable, eliminationTask.getTerm(), list2);
        Map<ArrayIndex, Term> map2 = Elim1Store.constructOldCellValueMapping(arrayList, map, threeValuedEquivalenceRelation, (Map<ArrayIndex, ArrayIndex>)object2, auxVarConstructor, termVariable, n, threeValuedEquivalenceRelation2, this.mScript);
        linkedHashSet.addAll(auxVarConstructor.getConstructedAuxVars());
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry<MultiDimensionalNestedStore, Term> entry : map.entrySet()) {
            assert (entry.getKey().toTerm(this.mScript).getSort() == entry.getValue().getSort()) : "incompatible sorts";
            hashMap.put(entry.getKey().toTerm(this.mScript), entry.getValue());
        }
        for (ArrayIndex arrayIndex : hashSet) {
            pair2 = Elim1Store.constructOldSelectTerm(this.mMgdScript, termVariable, arrayIndex);
            pair = (Pair<List<Term>, List<Term>>)threeValuedEquivalenceRelation2.getRepresentative((Object)arrayIndex);
            if (map2.containsKey(pair)) {
                assert (pair2.getSort() == map2.get(pair).getSort()) : "incompatible sorts";
                hashMap.put((Term)pair2, map2.get(pair));
                continue;
            }
            throw new AssertionError((Object)"should be dead code by now");
        }
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        ArrayList arrayList3 = new ArrayList();
        pair2 = Elim1Store.constructWriteConstraints2(arrayList, threeValuedEquivalenceRelation2, this.mMgdScript, (Map<ArrayIndex, ArrayIndex>)object2, map2, termVariable, n, map, hashMap, threeValuedEquivalenceRelation, arrayIndexEqualityManager);
        arrayList2.addAll((Collection)pair2.getFirst());
        arrayList3.addAll((Collection)pair2.getSecond());
        pair = Elim1Store.constructIndexValueConnection(arrayList, threeValuedEquivalenceRelation2, this.mMgdScript, (Map<ArrayIndex, ArrayIndex>)object2, map2, termVariable, n, threeValuedEquivalenceRelation, arrayIndexEqualityManager);
        arrayList2.addAll((Collection)pair.getFirst());
        arrayList3.addAll((Collection)pair.getSecond());
        arrayIndexEqualityManager.unlockSolver();
        Term term3 = Elim1Store.indexEquivalencesToTerm(this.mScript, threeValuedEquivalenceRelation2, n, arrayIndexEqualityManager);
        assert (term3 == QuantifierUtils.getAbsorbingElement(this.mScript, n)) : "strange equivalences";
        Term term4 = this.computeHiddenWeakArrayEqualities(this.mScript, n, map);
        Term term5 = QuantifierUtils.applyDualFiniteConnective(this.mScript, n, term2, eliminationTask.getTerm(), term4);
        Term term6 = Substitution.apply(this.mMgdScript, hashMap, term5);
        if (Arrays.asList(term6.getFreeVars()).contains(termVariable)) {
            String string = "var is still there: " + String.valueOf(termVariable);
            throw new AssertionError((Object)string);
        }
        Term term7 = QuantifierUtils.applyDualFiniteConnective(this.mScript, n, arrayList2);
        if (Arrays.asList(term6.getFreeVars()).contains(termVariable)) {
            if (QuantifierUtils.isQuantifierFree(eliminationTask.getTerm())) {
                throw new AssertionError((Object)"Unexpected substitution problem.");
            }
            throw new ElimStorePlain.ElimStorePlainException("Subterm of an index is captued by an inner quantifier");
        }
        Term term8 = QuantifierUtils.applyDualFiniteConnective(this.mScript, n, term6, term7);
        if (!arrayList3.isEmpty()) {
            object = QuantifierUtils.applyDualFiniteConnective(this.mScript, n, arrayList3);
            Term term9 = SmtUtils.and(this.mScript, QuantifierUtils.negateIfUniversal(this.mServices, this.mMgdScript, n, term8), eliminationTask.getContext().getCriticalConstraint());
            SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics(this.mMgdScript, (Term)object, term9, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            this.mLogger.info((Object)extendedSimplificationResult.buildSizeReductionMessage());
            Term term10 = extendedSimplificationResult.getSimplifiedTerm();
            term8 = QuantifierUtils.applyDualFiniteConnective(this.mScript, n, term8, term10);
        }
        if (Arrays.asList(term8.getFreeVars()).contains(termVariable)) {
            throw new AssertionError((Object)("var is still there: " + String.valueOf(termVariable) + " input size " + String.valueOf(new DagSizePrinter(term8)) + " context size " + String.valueOf(new DagSizePrinter(term8)) + " output size " + String.valueOf(new DagSizePrinter(term8))));
        }
        assert (!Arrays.asList(term8.getFreeVars()).contains(termVariable)) : "var is still there: " + String.valueOf(termVariable) + " term size " + String.valueOf(new DagSizePrinter(term8));
        object = new StringBuilder();
        ((StringBuilder)object).append("Elim1");
        int n2 = new MultiDimensionalSort(termVariable.getSort()).getDimension();
        ((StringBuilder)object).append(" eliminated variable of array dimension " + n2);
        ((StringBuilder)object).append(", " + list2.size() + " stores");
        ((StringBuilder)object).append(", " + hashSet.size() + " select indices");
        ((StringBuilder)object).append(", " + arrayList.size() + " select index equivalence classes");
        int n3 = (arrayList.size() * arrayList.size() - arrayList.size()) / 2;
        ((StringBuilder)object).append(String.format(", %d disjoint index pairs (out of %d index pairs)", threeValuedEquivalenceRelation.getDisequalities().size(), n3));
        ((StringBuilder)object).append(String.format(", introduced %d new quantified variables", linkedHashSet.size()));
        ((StringBuilder)object).append(String.format(", introduced %d case distinctions", arrayList3.size()));
        ((StringBuilder)object).append(String.format(", treesize of input %d treesize of output %d", new DAGSize().treesize(eliminationTask.getTerm()), new DAGSize().treesize(term8)));
        this.mLogger.info((Object)((StringBuilder)object).toString());
        object = new EliminationTask(n, linkedHashSet, term8, eliminationTask.getContext());
        assert (!this.mMgdScript.isLocked()) : "Solver still locked";
        return object;
    }

    private Map<MultiDimensionalNestedStore, Term> computeStoreTermEquivalenceMapping(Script script, AuxVarConstructor auxVarConstructor, int n, TermVariable termVariable, Term term, List<MultiDimensionalNestedStore> list) {
        HashMap<MultiDimensionalNestedStore, Term> hashMap = new HashMap<MultiDimensionalNestedStore, Term>();
        Iterator<MultiDimensionalNestedStore> iterator = list.iterator();
        while (iterator.hasNext()) {
            EqProvider eqProvider = new EqProvider(term, termVariable, n);
            MultiDimensionalNestedStore multiDimensionalNestedStore = iterator.next();
            Term term2 = eqProvider.getEqTerm(multiDimensionalNestedStore.toTerm(script));
            Object object = term2 != null ? term2 : auxVarConstructor.constructAuxVar(AUX_VAR_NEW_ARRAY, termVariable.getSort());
            hashMap.put(multiDimensionalNestedStore, (Term)object);
        }
        return hashMap;
    }

    private Term computeHiddenWeakArrayEqualities(Script script, int n, Map<MultiDimensionalNestedStore, Term> map) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Map.Entry<MultiDimensionalNestedStore, Term>> arrayList2 = new ArrayList<Map.Entry<MultiDimensionalNestedStore, Term>>(map.entrySet());
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            int n3 = n2 + 1;
            while (n3 < arrayList2.size()) {
                Term term = this.computeHiddenWeakArrayEquality(script, n, arrayList2.get(n2).getKey(), arrayList2.get(n2).getValue(), arrayList2.get(n3).getKey(), arrayList2.get(n3).getValue());
                arrayList.add(term);
                ++n3;
            }
            ++n2;
        }
        return QuantifierUtils.applyDualFiniteConnective(script, n, arrayList);
    }

    private Term computeHiddenWeakArrayEquality(Script script, int n, MultiDimensionalNestedStore multiDimensionalNestedStore, Term term, MultiDimensionalNestedStore multiDimensionalNestedStore2, Term term2) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (ArrayIndex arrayIndex : multiDimensionalNestedStore.getIndices()) {
            arrayList.add(arrayIndex.get(0));
        }
        for (ArrayIndex arrayIndex : multiDimensionalNestedStore2.getIndices()) {
            arrayList.add(arrayIndex.get(0));
        }
        return Elim1Store.constructWeakArrayEquality(script, n, arrayList, term, term2);
    }

    private static Term constructWeakArrayEquality(Script script, int n, List<Term> list, Term term, Term term2) {
        Term term3 = term;
        for (Term term4 : list) {
            Term term5 = SmtUtils.select(script, term2, term4);
            term3 = SmtUtils.store(script, term3, term4, term5);
        }
        return QuantifierUtils.applyDerOperator(script, n, term3, term2);
    }

    private static void inferCellEqualitiesViaCongruence(ManagedScript managedScript, TermVariable termVariable, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation2) {
        for (Map.Entry entry : threeValuedEquivalenceRelation.getSupportingEqualities().entrySet()) {
            ArrayIndex arrayIndex = (ArrayIndex)entry.getKey();
            ArrayIndex arrayIndex2 = (ArrayIndex)entry.getValue();
            Term term = Elim1Store.constructOldSelectTerm(managedScript, termVariable, arrayIndex);
            Term term2 = Elim1Store.constructOldSelectTerm(managedScript, termVariable, arrayIndex2);
            threeValuedEquivalenceRelation2.addElement((Object)term);
            threeValuedEquivalenceRelation2.addElement((Object)term2);
            threeValuedEquivalenceRelation2.reportEquality((Object)term, (Object)term2);
        }
    }

    private static Term indexEquivalencesToTerm(Script script, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation, int n, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        List list = threeValuedEquivalenceRelation.getSupportingEqualities().entrySet().stream().map(entry -> arrayIndexEqualityManager.constructDerRelation(script, n, (ArrayIndex)entry.getKey(), (ArrayIndex)entry.getValue())).collect(Collectors.toList());
        List list2 = threeValuedEquivalenceRelation.getDisequalities().getSetOfPairs().stream().map(entry -> arrayIndexEqualityManager.constructAntiDerRelation(script, n, (ArrayIndex)entry.getKey(), (ArrayIndex)entry.getValue())).collect(Collectors.toList());
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return QuantifierUtils.applyDualFiniteConnective(script, n, arrayList);
    }

    private static Map<ArrayIndex, Term> constructOldCellValueMapping(List<ArrayIndex> list, Map<MultiDimensionalNestedStore, Term> map, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation, Map<ArrayIndex, ArrayIndex> map2, AuxVarConstructor auxVarConstructor, TermVariable termVariable, int n, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation2, Script script) {
        ConstructionCache.IValueConstruction iValueConstruction = multiDimensionalSelect -> {
            TermVariable termVariable = auxVarConstructor.constructAuxVar(AUX_VAR_ARRAYCELL, multiDimensionalSelect.toTerm(script).getSort());
            return termVariable;
        };
        ConstructionCache constructionCache = new ConstructionCache(iValueConstruction);
        HashMap<ArrayIndex, Term> hashMap = new HashMap<ArrayIndex, Term>();
        for (ArrayIndex arrayIndex : list) {
            Term term = Elim1Store.getOldValueInNewArray(map, threeValuedEquivalenceRelation2, map2, arrayIndex, script);
            Term term2 = term != null ? term : Elim1Store.constructOldCellValue(threeValuedEquivalenceRelation, termVariable, (ConstructionCache<MultiDimensionalSelect, TermVariable>)constructionCache, arrayIndex, script);
            hashMap.put(arrayIndex, term2);
        }
        return hashMap;
    }

    private static Term getOldValueInNewArray(Map<MultiDimensionalNestedStore, Term> map, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation, Map<ArrayIndex, ArrayIndex> map2, ArrayIndex arrayIndex, Script script) {
        return null;
    }

    private static Term constructOldCellValue(ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation, TermVariable termVariable, ConstructionCache<MultiDimensionalSelect, TermVariable> constructionCache, ArrayIndex arrayIndex, Script script) {
        Term term;
        MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect((Term)termVariable, arrayIndex);
        Term term2 = (Term)threeValuedEquivalenceRelation.getRepresentative((Object)multiDimensionalSelect.toTerm(script));
        Term term3 = Elim1Store.findNiceReplacementForRepresentative(term2, termVariable, threeValuedEquivalenceRelation);
        if (term3 != null) {
            term = term3;
        } else {
            TermVariable termVariable2 = (TermVariable)constructionCache.getOrConstruct((Object)multiDimensionalSelect);
            term = termVariable2;
        }
        return term;
    }

    /*
     * WARNING - void declaration
     */
    private static ThreeValuedEquivalenceRelation<ArrayIndex> analyzeIndexEqualities(int n, Set<ArrayIndex> set, List<MultiDimensionalNestedStore> list, Term term, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation, TermVariable termVariable, ManagedScript managedScript, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        void var13_20;
        ArrayIndex arrayIndex;
        ArrayIndex arrayIndex2;
        void var13_18;
        managedScript.getScript().echo(new QuotedObject("starting to analyze index equalities"));
        if (arrayIndexEqualityManager.contextIsAbsorbingElement()) {
            arrayIndexEqualityManager.unlockSolver();
            return null;
        }
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>(set);
        for (MultiDimensionalNestedStore object22 : list) {
            arrayList.addAll(object22.getIndices());
        }
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        HashMap hashMap = new HashMap();
        HashMap<ArrayIndex, Object> hashMap2 = new HashMap<ArrayIndex, Object>();
        for (ArrayIndex arrayIndex3 : set) {
            Term term2 = Elim1Store.constructOldSelectTerm(managedScript, termVariable, arrayIndex3);
            arrayList2.add(term2);
            hashMap.put(term2, arrayIndex3);
            hashMap2.put(arrayIndex3, term2);
        }
        for (MultiDimensionalNestedStore multiDimensionalNestedStore : list) {
            arrayList2.addAll(multiDimensionalNestedStore.getValues());
        }
        ThreeValuedEquivalenceRelation threeValuedEquivalenceRelation2 = new ThreeValuedEquivalenceRelation();
        for (ArrayIndex arrayIndex4 : arrayList) {
            threeValuedEquivalenceRelation2.addElement((Object)arrayIndex4);
        }
        boolean bl = false;
        while (var13_18 < arrayList.size()) {
            void var14_26 = var13_18 + true;
            while (var14_26 < arrayList.size()) {
                arrayIndex2 = arrayList.get((int)var13_18);
                arrayIndex = arrayList.get((int)var14_26);
                EqualityStatus equalityStatus = arrayIndexEqualityManager.checkIndexEquality(arrayIndex2, arrayIndex);
                switch (equalityStatus) {
                    case EQUAL: {
                        threeValuedEquivalenceRelation2.reportEquality((Object)arrayIndex2, (Object)arrayIndex);
                        break;
                    }
                    case NOT_EQUAL: {
                        threeValuedEquivalenceRelation2.reportDisequality((Object)arrayIndex2, (Object)arrayIndex);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("illegal EqualityStatus " + String.valueOf(equalityStatus)));
                    }
                }
                ++var14_26;
            }
            ++var13_18;
        }
        boolean bl2 = false;
        while (var13_20 < arrayList2.size()) {
            void var14_27 = var13_20 + true;
            while (var14_27 < arrayList2.size()) {
                arrayIndex2 = (Term)arrayList2.get((int)var13_20);
                if (threeValuedEquivalenceRelation.getEqualityStatus((Object)arrayIndex2, (Object)(arrayIndex = (Term)arrayList2.get((int)var14_27))) == EqualityStatus.UNKNOWN) {
                    arrayIndexEqualityManager.checkEqualityStatus((Term)arrayIndex2, (Term)arrayIndex);
                }
                ++var14_27;
            }
            ++var13_20;
        }
        managedScript.getScript().echo(new QuotedObject("finished analysis of index equalities"));
        return threeValuedEquivalenceRelation2;
    }

    private Term constructStoredValueInformation(int n, TermVariable termVariable, Map<MultiDimensionalStore, Term> map, Map<ArrayIndex, ArrayIndex> map2, Map<Term, Term> map3, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry<MultiDimensionalStore, Term> entry : map.entrySet()) {
            ArrayIndex arrayIndex = (ArrayIndex)threeValuedEquivalenceRelation.getRepresentative((Object)entry.getKey().getIndex());
            ArrayIndex arrayIndex2 = map2.get(arrayIndex);
            arrayList.add(QuantifierUtils.applyDerOperator(this.mMgdScript.getScript(), n, new MultiDimensionalSelect(entry.getValue(), arrayIndex2).toTerm(this.mScript), Substitution.apply(this.mMgdScript, map3, entry.getKey().getValue())));
        }
        return QuantifierUtils.applyDualFiniteConnective(this.mScript, n, arrayList);
    }

    private static boolean occursIn(TermVariable termVariable, ArrayIndex arrayIndex) {
        return arrayIndex.stream().anyMatch(term -> Elim1Store.occursIn(termVariable, term));
    }

    private static boolean occursIn(TermVariable termVariable, Term term) {
        return Arrays.asList(term.getFreeVars()).contains(termVariable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<List<Term>, List<Term>> constructIndexValueConnection(List<ArrayIndex> list, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation, ManagedScript managedScript, Map<ArrayIndex, ArrayIndex> map, Map<ArrayIndex, Term> map2, TermVariable termVariable, int n, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation2, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = n2 + 1;
            while (n3 < list.size()) {
                block19: {
                    Term term;
                    ArrayIndex arrayIndex;
                    Term term2;
                    if (!threeValuedEquivalenceRelation.isRepresentative((Object)list.get(n3))) {
                        throw new AssertionError((Object)"representatives only");
                    }
                    ArrayIndex arrayIndex2 = list.get(n2);
                    ArrayIndex arrayIndex3 = list.get(n3);
                    EqualityStatus equalityStatus = threeValuedEquivalenceRelation.getEqualityStatus((Object)arrayIndex2, (Object)arrayIndex3);
                    switch (equalityStatus) {
                        case EQUAL: {
                            term2 = null;
                            break;
                        }
                        case NOT_EQUAL: {
                            break block19;
                        }
                        case UNKNOWN: {
                            arrayIndex = map.get(arrayIndex2);
                            assert (!Elim1Store.occursIn(termVariable, arrayIndex)) : "var is still there";
                            ArrayIndex arrayIndex4 = map.get(arrayIndex3);
                            assert (!Elim1Store.occursIn(termVariable, arrayIndex4)) : "var is still there";
                            term2 = arrayIndexEqualityManager.constructDerRelation(managedScript.getScript(), n, arrayIndex, arrayIndex4);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    Term term3 = Elim1Store.constructOldSelectTerm(managedScript, termVariable, arrayIndex2);
                    Term term4 = Elim1Store.constructOldSelectTerm(managedScript, termVariable, arrayIndex3);
                    EqualityStatus equalityStatus2 = threeValuedEquivalenceRelation2.getEqualityStatus((Object)term3, (Object)term4);
                    switch (equalityStatus2) {
                        case EQUAL: {
                            break block19;
                        }
                        case NOT_EQUAL: {
                            if (term2 == null) throw new AssertionError((Object)"input was inconsistent");
                            arrayList.add(Elim1Store.notWith1StepPush(managedScript.getScript(), term2));
                            break block19;
                        }
                        case UNKNOWN: {
                            term = map2.get(arrayIndex2);
                            assert (!Elim1Store.occursIn(termVariable, term)) : "var is still there";
                            Term term5 = map2.get(arrayIndex3);
                            assert (!Elim1Store.occursIn(termVariable, term5)) : "var is still there";
                            arrayIndex = QuantifierUtils.applyDerOperator(managedScript.getScript(), n, term, term5);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (n == 0) {
                        term = SmtUtils.or(managedScript.getScript(), new Term[]{Elim1Store.notWith1StepPush(managedScript.getScript(), term2), arrayIndex});
                    } else {
                        if (n != 1) throw new AssertionError((Object)"unknown quantifier");
                        term = SmtUtils.and(managedScript.getScript(), new Term[]{Elim1Store.notWith1StepPush(managedScript.getScript(), term2), arrayIndex});
                    }
                    arrayList2.add(term);
                }
                ++n3;
            }
            ++n2;
        }
        return new Pair(arrayList, arrayList2);
    }

    public static Term notWith1StepPush(Script script, Term term) {
        Term term2 = NnfTransformer.pushNot1StepInside(script, term, NnfTransformer.QuantifierHandling.CRASH);
        if (term2 == null) {
            return SmtUtils.not(script, term);
        }
        return term2;
    }

    private static boolean selectTermsWithsimilarArray(Term term, Term term2) {
        ArraySelect arraySelect = ArraySelect.of(term);
        if (arraySelect == null) {
            return false;
        }
        ArraySelect arraySelect2 = ArraySelect.of(term2);
        if (arraySelect2 == null) {
            return false;
        }
        return arraySelect.getArray() == arraySelect2.getArray();
    }

    private static Pair<List<Term>, List<Term>> constructWriteConstraints(List<ArrayIndex> list, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation, ManagedScript managedScript, Map<ArrayIndex, ArrayIndex> map, Map<ArrayIndex, Term> map2, TermVariable termVariable, int n, Map<MultiDimensionalStore, Term> map3, Map<Term, Term> map4, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation2, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Map.Entry<MultiDimensionalStore, Term> entry : map3.entrySet()) {
            ArrayIndex arrayIndex = entry.getKey().getIndex();
            ArrayIndex arrayIndex2 = (ArrayIndex)threeValuedEquivalenceRelation.getRepresentative((Object)arrayIndex);
            arrayIndex = entry.getKey().getValue();
            Term term = entry.getValue();
            for (ArrayIndex arrayIndex3 : list) {
                assert (threeValuedEquivalenceRelation.isRepresentative((Object)arrayIndex3)) : "no representative: " + String.valueOf(arrayIndex3);
                ArrayIndex arrayIndex4 = map.get(arrayIndex2);
                assert (!Elim1Store.occursIn(termVariable, arrayIndex4)) : "var is still there";
                ArrayIndex arrayIndex5 = map.get(arrayIndex3);
                assert (!Elim1Store.occursIn(termVariable, arrayIndex5)) : "var is still there";
                Term term2 = arrayIndexEqualityManager.constructDerRelation(managedScript.getScript(), n, arrayIndex4, arrayIndex5);
                MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(term, arrayIndex5);
                Term term3 = Substitution.apply(managedScript, map4, (Term)arrayIndex);
                Term term4 = QuantifierUtils.applyDerOperator(managedScript.getScript(), n, multiDimensionalSelect.toTerm(managedScript.getScript()), term3);
                EqualityStatus equalityStatus = threeValuedEquivalenceRelation.getEqualityStatus((Object)arrayIndex2, (Object)arrayIndex3);
                switch (equalityStatus) {
                    case EQUAL: {
                        arrayList.add(term4);
                        break;
                    }
                    case NOT_EQUAL: {
                        break;
                    }
                    case UNKNOWN: {
                        Term term5 = Elim1Store.constructOldSelectTerm(managedScript, termVariable, arrayIndex3);
                        if (threeValuedEquivalenceRelation2.getEqualityStatus((Object)term5, (Object)arrayIndex) == EqualityStatus.EQUAL) {
                            arrayList.add(term4);
                            break;
                        }
                        Term term6 = term4;
                        Term term7 = Elim1Store.notWith1StepPush(managedScript.getScript(), term2);
                        Term term8 = QuantifierUtils.applyCorrespondingFiniteConnective(managedScript.getScript(), n, term7, term6);
                        arrayList2.add(term8);
                        term5 = map2.get(arrayIndex3);
                        term6 = QuantifierUtils.applyDerOperator(managedScript.getScript(), n, multiDimensionalSelect.toTerm(managedScript.getScript()), term5);
                        term7 = term2;
                        term8 = QuantifierUtils.applyCorrespondingFiniteConnective(managedScript.getScript(), n, term7, term6);
                        arrayList2.add(term8);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        return new Pair(arrayList, arrayList2);
    }

    private static Pair<List<Term>, List<Term>> constructWriteConstraints2(List<ArrayIndex> list, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation, ManagedScript managedScript, Map<ArrayIndex, ArrayIndex> map, Map<ArrayIndex, Term> map2, TermVariable termVariable, int n, Map<MultiDimensionalNestedStore, Term> map3, Map<Term, Term> map4, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation2, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Map.Entry<MultiDimensionalNestedStore, Term> entry : map3.entrySet()) {
            Term term;
            Object object;
            Iterator iterator;
            ArrayList<ArrayIndex> arrayList3 = new ArrayList<ArrayIndex>();
            ArrayList<Term> arrayList4 = new ArrayList<Term>();
            Term term2 = entry.getValue();
            int n2 = 0;
            while (n2 < entry.getKey().getIndices().size()) {
                iterator = entry.getKey().getIndices().get(n2);
                ArrayIndex arrayIndex = (ArrayIndex)threeValuedEquivalenceRelation.getRepresentative((Object)iterator);
                iterator = map.get(arrayIndex);
                assert (!Elim1Store.occursIn(termVariable, (ArrayIndex)((Object)iterator))) : "var is still there";
                object = entry.getKey().getValues().get(n2);
                term = Substitution.apply(managedScript, map4, object);
                arrayList3.add((ArrayIndex)((Object)iterator));
                arrayList4.add(term);
                ++n2;
            }
            for (ArrayIndex arrayIndex : list) {
                assert (threeValuedEquivalenceRelation.isRepresentative((Object)arrayIndex)) : "no representative: " + String.valueOf(arrayIndex);
                iterator = map.get(arrayIndex);
                assert (!Elim1Store.occursIn(termVariable, (ArrayIndex)((Object)iterator))) : "var is still there";
                object = map2.get(arrayIndex);
                term = arrayIndexEqualityManager.constructNestedStoreUpdateConstraint(managedScript.getScript(), n, term2, (ArrayIndex)((Object)iterator), (List<ArrayIndex>)arrayList3, (List<Term>)arrayList4, (Term)object);
                if (SmtUtils.isAtomicFormula(term)) {
                    arrayList.add(term);
                    continue;
                }
                arrayList2.add(term);
            }
            HashSet<ArrayIndex> hashSet = new HashSet<ArrayIndex>();
            for (ArrayIndex arrayIndex : entry.getKey().getIndices()) {
                hashSet.add((ArrayIndex)threeValuedEquivalenceRelation.getRepresentative((Object)arrayIndex));
            }
            for (ArrayIndex arrayIndex : hashSet) {
                assert (threeValuedEquivalenceRelation.isRepresentative((Object)arrayIndex)) : "no representative: " + String.valueOf(arrayIndex);
                object = map.get(arrayIndex);
                assert (!Elim1Store.occursIn(termVariable, (ArrayIndex)object)) : "var is still there";
                term = null;
                Term term3 = arrayIndexEqualityManager.constructNestedStoreUpdateConstraint(managedScript.getScript(), n, term2, (ArrayIndex)object, arrayList3, arrayList4, term);
                if (SmtUtils.isAtomicFormula(term3)) {
                    arrayList.add(term3);
                    continue;
                }
                arrayList2.add(term3);
            }
        }
        return new Pair(arrayList, arrayList2);
    }

    private static Term findNiceReplacementForRepresentative(Term term2, TermVariable termVariable, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation) {
        assert (threeValuedEquivalenceRelation.isRepresentative((Object)term2)) : "Not representative " + String.valueOf(term2);
        Set set = threeValuedEquivalenceRelation.getEquivalenceClass((Object)term2);
        List list = set.stream().filter(term -> !Elim1Store.occursIn(termVariable, term)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, FEWER_VARIABLE_FIRST);
        return (Term)list.get(0);
    }

    private static ArrayIndex findNiceReplacementForRepresentative(ArrayIndex arrayIndex2, TermVariable termVariable, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation) {
        assert (threeValuedEquivalenceRelation.isRepresentative((Object)arrayIndex2)) : "Not representative " + String.valueOf(arrayIndex2);
        Set set = threeValuedEquivalenceRelation.getEquivalenceClass((Object)arrayIndex2);
        List list = set.stream().filter(arrayIndex -> !Elim1Store.occursIn(termVariable, arrayIndex)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, INDEX_WITH_FEWER_VARIABLE_FIRST);
        return (ArrayIndex)list.get(0);
    }

    private static Term constructOldSelectTerm(ManagedScript managedScript, TermVariable termVariable, ArrayIndex arrayIndex) {
        return new MultiDimensionalSelect((Term)termVariable, arrayIndex).toTerm(managedScript.getScript());
    }

    private class AuxVarConstructor {
        private final Set<TermVariable> mConstructedAuxVars = new HashSet<TermVariable>();

        private AuxVarConstructor() {
        }

        public TermVariable constructAuxVar(String string, Sort sort) {
            TermVariable termVariable = Elim1Store.this.mMgdScript.constructFreshTermVariable(string, sort);
            this.mConstructedAuxVars.add(termVariable);
            return termVariable;
        }

        public Set<TermVariable> getConstructedAuxVars() {
            return this.mConstructedAuxVars;
        }
    }

    private class EqProvider {
        private final Term[] mContext;
        private final TermVariable mEliminatee;
        private final int mQuantifier;

        public EqProvider(Term term, TermVariable termVariable, int n) {
            this.mContext = QuantifierUtils.getDualFiniteJuncts(n, term);
            this.mEliminatee = termVariable;
            this.mQuantifier = n;
        }

        public Term getEqTerm(Term term) {
            EqualityInformation equalityInformation = EqualityInformation.getEqinfo(Elim1Store.this.mScript, term, this.mContext, (Term)this.mEliminatee, this.mQuantifier);
            if (equalityInformation == null) {
                return null;
            }
            return equalityInformation.getRelatedTerm();
        }
    }

    private static class IndexMappingProvider {
        private final ArrayIndexReplacementConstructor mReplacementConstructor;
        private final Map<ArrayIndex, ArrayIndex> mIndexReplacementMapping = new HashMap<ArrayIndex, ArrayIndex>();

        public IndexMappingProvider(ManagedScript managedScript, TermVariable termVariable, ThreeValuedEquivalenceRelation<ArrayIndex> threeValuedEquivalenceRelation) {
            this.mReplacementConstructor = new ArrayIndexReplacementConstructor(managedScript, Elim1Store.AUX_VAR_INDEX, termVariable);
            for (ArrayIndex arrayIndex : threeValuedEquivalenceRelation.getAllRepresentatives()) {
                ArrayIndex arrayIndex2 = Elim1Store.findNiceReplacementForRepresentative(arrayIndex, termVariable, threeValuedEquivalenceRelation);
                if (arrayIndex2 != null) {
                    this.mIndexReplacementMapping.put(arrayIndex, arrayIndex2);
                    continue;
                }
                ArrayIndex arrayIndex3 = (ArrayIndex)threeValuedEquivalenceRelation.getRepresentative((Object)arrayIndex);
                ArrayIndex arrayIndex4 = this.mReplacementConstructor.constructIndexReplacementIfNeeded(arrayIndex3);
                this.mIndexReplacementMapping.put(arrayIndex, arrayIndex4);
            }
        }

        public Map<ArrayIndex, ArrayIndex> getIndexReplacementMapping() {
            return this.mIndexReplacementMapping;
        }

        public Term constructAuxVarDefinitions(Script script, int n) {
            return this.mReplacementConstructor.constructDefinitions(script, n);
        }

        public Set<TermVariable> getConstructedAuxVars() {
            return this.mReplacementConstructor.getConstructedAuxVars();
        }
    }

    public static class ValueEqualityChecker {
        final TermVariable mEliminatee;
        final Term mStoreIndex;
        final Term mStoreValue;
        final ThreeValuedEquivalenceRelation<Term> mIndices;
        final ManagedScript mMgdScript;
        final IncrementalPlicationChecker mIncrementalPlicationChecker;
        final Map<Term, Term> mOldCellMapping;
        final List<Term> mValueEqualities = new ArrayList<Term>();

        public ValueEqualityChecker(TermVariable termVariable, Term term, Term term2, ThreeValuedEquivalenceRelation<Term> threeValuedEquivalenceRelation, ManagedScript managedScript, IncrementalPlicationChecker incrementalPlicationChecker, Map<Term, Term> map) {
            this.mEliminatee = termVariable;
            this.mStoreIndex = term;
            this.mStoreValue = term2;
            this.mIndices = threeValuedEquivalenceRelation;
            this.mMgdScript = managedScript;
            this.mIncrementalPlicationChecker = incrementalPlicationChecker;
            this.mOldCellMapping = map;
        }

        public boolean isDistinguishworthyIndexPair(Term term, Term term2) {
            Term term3 = SmtUtils.select(this.mMgdScript.getScript(), (Term)this.mEliminatee, term);
            Term term4 = SmtUtils.select(this.mMgdScript.getScript(), (Term)this.mEliminatee, term2);
            Term term5 = SmtUtils.binaryEquality(this.mMgdScript.getScript(), term3, term4);
            IncrementalPlicationChecker.Validity validity = this.mIncrementalPlicationChecker.checkPlication(term5);
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                boolean bl = this.processStoreIndex(term, term2, term4);
                boolean bl2 = this.processStoreIndex(term2, term, term3);
                if (bl && bl2) {
                    return true;
                }
                Term term6 = SmtUtils.binaryEquality(this.mMgdScript.getScript(), this.mOldCellMapping.get(term), this.mOldCellMapping.get(term2));
                this.mValueEqualities.add(term6);
                return false;
            }
            return true;
        }

        private boolean processStoreIndex(Term term, Term term2, Term term3) {
            if (this.isStoreIndex(term)) {
                Term term4 = SmtUtils.binaryEquality(this.mMgdScript.getScript(), this.mStoreValue, term3);
                IncrementalPlicationChecker.Validity validity = this.mIncrementalPlicationChecker.checkPlication(term4);
                if (validity == IncrementalPlicationChecker.Validity.VALID) {
                    Term term5 = SmtUtils.binaryEquality(this.mMgdScript.getScript(), this.mStoreValue, this.mOldCellMapping.get(term2));
                    this.mValueEqualities.add(term5);
                    return false;
                }
                return true;
            }
            return false;
        }

        boolean isStoreIndex(Term term) {
            if (this.mStoreIndex == null) {
                return false;
            }
            return ((Term)this.mIndices.getRepresentative((Object)term)).equals(this.mIndices.getRepresentative((Object)this.mStoreIndex));
        }

        public List<Term> getValueEqualities() {
            return this.mValueEqualities;
        }
    }
}

