/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.TransitionType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.IWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SummarizeEdge;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameLetter;

public final class DuplicatorNwaVertex<LETTER, STATE>
extends DuplicatorVertex<LETTER, STATE>
implements IGameLetter<LETTER, STATE> {
    private final IWinningSink<LETTER, STATE> mSink;
    private final SummarizeEdge<LETTER, STATE> mSummarizeEdge;
    private final TransitionType mTransitionType;

    public DuplicatorNwaVertex(int n, boolean bl, STATE STATE, STATE STATE2, LETTER LETTER, TransitionType transitionType) {
        this(n, bl, STATE, STATE2, LETTER, transitionType, null, null);
    }

    public DuplicatorNwaVertex(int n, boolean bl, STATE STATE, STATE STATE2, LETTER LETTER, TransitionType transitionType, IWinningSink<LETTER, STATE> iWinningSink) {
        this(n, bl, STATE, STATE2, LETTER, transitionType, null, iWinningSink);
    }

    public DuplicatorNwaVertex(int n, boolean bl, STATE STATE, STATE STATE2, LETTER LETTER, TransitionType transitionType, SummarizeEdge<LETTER, STATE> summarizeEdge) {
        this(n, bl, STATE, STATE2, LETTER, transitionType, summarizeEdge, null);
    }

    private DuplicatorNwaVertex(int n, boolean bl, STATE STATE, STATE STATE2, LETTER LETTER, TransitionType transitionType, SummarizeEdge<LETTER, STATE> summarizeEdge, IWinningSink<LETTER, STATE> iWinningSink) {
        super(n, bl, STATE, STATE2, LETTER);
        this.mTransitionType = transitionType;
        this.mSummarizeEdge = summarizeEdge;
        this.mSink = iWinningSink;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof DuplicatorNwaVertex)) {
            return false;
        }
        DuplicatorNwaVertex duplicatorNwaVertex = (DuplicatorNwaVertex)object;
        if (this.mSink == null ? duplicatorNwaVertex.mSink != null : !this.mSink.equals(duplicatorNwaVertex.mSink)) {
            return false;
        }
        if (this.mSummarizeEdge == null ? duplicatorNwaVertex.mSummarizeEdge != null : !this.mSummarizeEdge.equals(duplicatorNwaVertex.mSummarizeEdge)) {
            return false;
        }
        return this.mTransitionType == duplicatorNwaVertex.mTransitionType;
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isB() + "," + String.valueOf(this.getQ0()) + "," + String.valueOf(this.getQ1()) + ",");
        if (this.mTransitionType.equals((Object)TransitionType.SUMMARIZE_ENTRY)) {
            stringBuilder.append("SEntry/").append(this.mSummarizeEdge.hashCode());
        } else if (this.mTransitionType.equals((Object)TransitionType.SUMMARIZE_EXIT)) {
            stringBuilder.append("SExit/").append(this.mSummarizeEdge.hashCode());
        } else if (this.mTransitionType.equals((Object)TransitionType.SINK)) {
            stringBuilder.append("Sink/").append(this.mSink.hashCode());
        } else {
            stringBuilder.append(this.getLetter());
        }
        stringBuilder.append("<" + this.getPriority() + ">");
        return stringBuilder.toString();
    }

    public IWinningSink<LETTER, STATE> getSink() {
        return this.mSink;
    }

    public SummarizeEdge<LETTER, STATE> getSummarizeEdge() {
        return this.mSummarizeEdge;
    }

    @Override
    public TransitionType getTransitionType() {
        return this.mTransitionType;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mSink == null ? 0 : this.mSink.hashCode());
        n = 31 * n + (this.mSummarizeEdge == null ? 0 : this.mSummarizeEdge.hashCode());
        n = 31 * n + (this.mTransitionType == null ? 0 : this.mTransitionType.hashCode());
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.isB()).append(",(").append(this.getQ0()).append(",");
        stringBuilder.append(this.getQ1()).append(",");
        if (this.mTransitionType.equals((Object)TransitionType.SUMMARIZE_ENTRY)) {
            stringBuilder.append("SEntry/").append(this.mSummarizeEdge.hashCode());
        } else if (this.mTransitionType.equals((Object)TransitionType.SUMMARIZE_EXIT)) {
            stringBuilder.append("SExit/").append(this.mSummarizeEdge.hashCode());
        } else if (this.mTransitionType.equals((Object)TransitionType.SINK)) {
            stringBuilder.append("Sink/").append(this.mSink.hashCode());
        } else {
            stringBuilder.append(this.getLetter());
        }
        stringBuilder.append("),p:").append(this.getPriority()).append(",pm:").append(this.mPm);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

