/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.PriorityComparator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameEmptyState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameLetter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.GameAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.GameCallReturnSummary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.SummaryComputationGraphNode;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.WeightedSummaryTargets;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.LexicographicCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PosetUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SummaryComputation<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final IDoubleDeckerAutomaton<IGameLetter<LETTER, STATE>, IGameState> mGameAutomaton;
    private final ArrayDeque<SummaryComputationGraphNode<LETTER, STATE>> mWorklist = new ArrayDeque();
    private final Set<SummaryComputationGraphNode<LETTER, STATE>> mNodes = new HashSet<SummaryComputationGraphNode<LETTER, STATE>>();
    private final WeightedSummaryTargets.WeightedSummaryTargetsComparator mWeightedSummaryTargetsComparator = new WeightedSummaryTargets.WeightedSummaryTargetsComparator();
    private final HashRelation<Set<IGameState>, NestedMap2<IGameState, IGameState, Integer>> mTrigger2Summaries = new HashRelation();
    private final HashRelation<Set<IGameState>, SummaryComputationGraphNode<LETTER, STATE>> mSummaryTrigger2Node = new HashRelation();
    private final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    private final Set<IGameState> mNeedSpoilerWinningSink;
    private final LinkedHashSet<GameCallReturnSummary<STATE>> mGameSummaries;

    public SummaryComputation(AutomataLibraryServices automataLibraryServices, IDoubleDeckerAutomaton<IGameLetter<LETTER, STATE>, IGameState> iDoubleDeckerAutomaton, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton2) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mGameAutomaton = iDoubleDeckerAutomaton;
        this.mOperand = iDoubleDeckerAutomaton2;
        this.mNeedSpoilerWinningSink = this.computeSpoilerWinningSink();
        this.initialize();
        while (!this.mWorklist.isEmpty()) {
            Object object;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                object = "processing worklist (game automaton has " + this.mGameAutomaton.size() + " states, worklist contains " + this.mWorklist.size() + " elements)";
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), (String)object);
                throw new AutomataOperationCanceledException(runningTaskInfo);
            }
            object = this.mWorklist.remove();
            this.process((SummaryComputationGraphNode<LETTER, STATE>)object);
        }
        this.mLogger.info((Object)("Found " + this.mTrigger2Summaries.size() + " summaries"));
        this.mGameSummaries = new LinkedHashSet();
        for (Object object : this.mTrigger2Summaries.getSetOfPairs()) {
            NestedMap2 nestedMap2 = (NestedMap2)object.getValue();
            NestedMap2 nestedMap22 = new NestedMap2();
            for (Object object2 : nestedMap2.entrySet()) {
                nestedMap22.put((Object)((IGameState)object2.getSecond()), (Object)((IGameState)object2.getFirst()), (Object)((Integer)object2.getThird()));
            }
            for (Object object2 : nestedMap22.keySet()) {
                Object object3;
                SpoilerNwaVertex spoilerNwaVertex;
                Map map = nestedMap22.get(object2);
                NestedMap2 nestedMap23 = new NestedMap2();
                for (Map.Entry entry : map.entrySet()) {
                    spoilerNwaVertex = GameAutomaton.unwrapSpoilerNwaVertex((IGameState)entry.getKey());
                    if (spoilerNwaVertex.getSink() != null) continue;
                    object3 = spoilerNwaVertex.getQ0();
                    assert (object3 != null);
                    nestedMap23.put(object3, (Object)((IGameState)entry.getKey()), (Object)((Integer)entry.getValue()));
                }
                for (Map.Entry entry : nestedMap23.keySet()) {
                    spoilerNwaVertex = nestedMap23.get((Object)entry);
                    object3 = new GameCallReturnSummary<Object>((IGameState)object2, entry, (Map<IGameState, Integer>)((Object)spoilerNwaVertex));
                    this.mGameSummaries.add((GameCallReturnSummary<STATE>)object3);
                }
            }
        }
        new ArrayList<GameCallReturnSummary<STATE>>(this.mGameSummaries);
        this.mLogger.info((Object)("Found " + this.mGameSummaries.size() + " summaries"));
    }

    private Set<IGameState> computeSpoilerWinningSink() {
        HashSet<IGameState> hashSet = new HashSet<IGameState>();
        for (IGameState iGameState : this.mGameAutomaton.getStates()) {
            if (!this.needWinningSink(iGameState)) continue;
            hashSet.add(iGameState);
        }
        return hashSet;
    }

    private Integer duplicatorNodePriorityProvider(IGameLetter<LETTER, STATE> iGameLetter, IGameState iGameState) {
        return 2;
    }

    private Integer spoilerNodePriorityProvider(IGameState iGameState, IGameLetter<LETTER, STATE> iGameLetter) {
        return GameAutomaton.unwrapSpoilerNwaVertex(iGameState).getPriority();
    }

    private Integer callWorkaroundPriorityProvider(IGameState iGameState, IGameLetter<LETTER, STATE> iGameLetter) {
        return 2;
    }

    private boolean needWinningSink(IGameState iGameState) {
        SpoilerNwaVertex spoilerNwaVertex = GameAutomaton.unwrapSpoilerNwaVertex(iGameState);
        if (this.isSpoilerWinningSink(spoilerNwaVertex)) {
            return false;
        }
        for (IGameState iGameState2 : this.mGameAutomaton.getDownStates(iGameState)) {
            if (iGameState2 instanceof GameEmptyState) continue;
            SpoilerNwaVertex spoilerNwaVertex2 = GameAutomaton.unwrapSpoilerNwaVertex(iGameState2);
            HashSet hashSet = new HashSet();
            for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(spoilerNwaVertex.getQ0(), spoilerNwaVertex2.getQ0())) {
                hashSet.add(outgoingReturnTransition.getLetter());
            }
            for (Object object : hashSet) {
                boolean bl = NestedWordAutomataUtils.hasOutgoingReturnTransition(this.mOperand, spoilerNwaVertex.getQ1(), spoilerNwaVertex2.getQ1(), object);
                if (bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpoilerWinningSink(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex) {
        return spoilerNwaVertex.getSink() instanceof SpoilerWinningSink;
    }

    private void initialize() throws AutomataOperationCanceledException {
        for (IGameState iGameState : this.mGameAutomaton.getStates()) {
            Object object;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                object = "initializing worklist (game automaton has " + this.mGameAutomaton.size() + " states, worklist contains " + this.mWorklist.size() + " elements, input had " + this.mOperand.size() + " states)";
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), (String)object);
                throw new AutomataOperationCanceledException(runningTaskInfo);
            }
            object = new HashRelation();
            for (SummaryReturnTransition summaryReturnTransition : this.mGameAutomaton.summarySuccessors(iGameState)) {
                object.addPair(((IGameLetter)summaryReturnTransition.getLetter()).getLetter(), (Object)summaryReturnTransition.getSucc());
            }
            for (Object object2 : object.getDomain()) {
                NestedMap2 nestedMap2 = new NestedMap2();
                for (IGameState iGameState2 : object.getImage(object2)) {
                    nestedMap2.put((Object)((IGameState)this.mGameAutomaton.getEmptyStackState()), (Object)iGameState2, (Object)new WeightedSummaryTargets(iGameState2, 2));
                }
                this.processReturnPredecessors(object2, (NestedMap2<IGameState, IGameState, WeightedSummaryTargets>)nestedMap2, object.getImage(object2));
            }
        }
    }

    private void process(SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode) {
        Set<Object> set2;
        HashRelation3<LETTER, IGameState, IGameState> hashRelation3 = this.collectIncomingReturnLetters(summaryComputationGraphNode);
        for (Set<Object> set2 : hashRelation3.projectToFst()) {
            Iterator<Object> iterator = hashRelation3.projectToSnd(set2);
            this.mSummaryTrigger2Node.addPair((Object)iterator, summaryComputationGraphNode);
            for (NestedMap2 nestedMap2 : this.mTrigger2Summaries.getImage(iterator)) {
                this.processSummary(summaryComputationGraphNode, (NestedMap2<IGameState, IGameState, Integer>)nestedMap2);
            }
            this.processReturnPredecessors((LETTER)set2, summaryComputationGraphNode.getSource2Current2Targets(), (Set<IGameState>)((Object)iterator));
        }
        set2 = this.collectIncomingCallLetters(summaryComputationGraphNode);
        for (Object object : set2) {
            this.processCallPredecessors(object, summaryComputationGraphNode);
        }
        set2 = this.collectIncomingInternalLetters(summaryComputationGraphNode);
        for (Object object : set2) {
            this.processInternalPredecessors(object, summaryComputationGraphNode);
        }
    }

    private void processReturnPredecessors(LETTER LETTER, NestedMap2<IGameState, IGameState, WeightedSummaryTargets> nestedMap2, Set<IGameState> set) {
        Object object;
        IGameLetter iGameLetter;
        Object object22;
        this.mLogger.info((Object)("computing predecessors under " + String.valueOf(LETTER)));
        HashRelation hashRelation = new HashRelation();
        HashMap<IGameState, HashRelation<IGameLetter<LETTER, STATE>, IGameState>> hashMap = new HashMap<IGameState, HashRelation<IGameLetter<LETTER, STATE>, IGameState>>();
        HashRelation hashRelation2 = new HashRelation();
        for (Object object22 : nestedMap2.keys2()) {
            for (IncomingReturnTransition incomingReturnTransition : this.mGameAutomaton.returnPredecessors((IGameState)object22.getSecond())) {
                iGameLetter = (IGameLetter)incomingReturnTransition.getLetter();
                if (!iGameLetter.getLetter().equals(LETTER)) continue;
                hashRelation.addPair((Object)((IGameLetter)incomingReturnTransition.getLetter()), (Object)((IGameState)object22.getSecond()));
                object = incomingReturnTransition.getHierPred();
                HashRelation hashRelation3 = (HashRelation)hashMap.get(object);
                if (hashRelation3 == null) {
                    hashRelation3 = new HashRelation();
                    hashMap.put((IGameState)object, hashRelation3);
                }
                hashRelation3.addPair((Object)((IGameLetter)incomingReturnTransition.getLetter()), (Object)((IGameState)object22.getSecond()));
                hashRelation2.addPair((Object)incomingReturnTransition.getLinPred(), (Object)((IGameLetter)incomingReturnTransition.getLetter()));
            }
        }
        if (hashRelation.size() == 0) {
            return;
        }
        object22 = Collections.singleton(this.computeDuplicatorPredecessorUnderReturn(nestedMap2, hashMap));
        Set<NestedMap2<IGameState, IGameState, WeightedSummaryTargets>> set2 = this.computePredecessorsUnderPly((Set)object22, (HashRelation)hashRelation2, (PriorityProvider)this::spoilerNodePriorityProvider, this::spoilerAggregration);
        object = set2.iterator();
        while (object.hasNext()) {
            iGameLetter = (NestedMap2)object.next();
            this.constructNode((NestedMap2<IGameState, IGameState, WeightedSummaryTargets>)iGameLetter, set);
        }
    }

    private NestedMap2<IGameState, IGameLetter<LETTER, STATE>, WeightedSummaryTargets> computeDuplicatorPredecessorUnderReturn(NestedMap2<IGameState, IGameState, WeightedSummaryTargets> nestedMap2, Map<IGameState, HashRelation<IGameLetter<LETTER, STATE>, IGameState>> map) {
        NestedMap2 nestedMap22 = new NestedMap2();
        for (Map.Entry<IGameState, HashRelation<IGameLetter<LETTER, STATE>, IGameState>> entry : map.entrySet()) {
            IGameState iGameState = entry.getKey();
            for (IGameLetter iGameLetter : entry.getValue().getDomain()) {
                Object object2;
                HashMap<IGameState, Integer> hashMap = new HashMap<IGameState, Integer>();
                for (Object object2 : entry.getValue().getImage((Object)iGameLetter)) {
                    hashMap.put((IGameState)object2, 2);
                }
                object2 = new WeightedSummaryTargets(hashMap);
                nestedMap22.put((Object)iGameState, (Object)iGameLetter, object2);
            }
        }
        return nestedMap22;
    }

    private void processInternalPredecessors(LETTER LETTER, SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode) {
        Object object;
        this.mLogger.info((Object)("computing predecessors under " + String.valueOf(LETTER)));
        HashRelation hashRelation = new HashRelation();
        HashRelation hashRelation2 = new HashRelation();
        for (IGameState object22 : summaryComputationGraphNode.getSources()) {
            for (IGameState iGameState : summaryComputationGraphNode.getCurrent(object22)) {
                for (IncomingInternalTransition incomingInternalTransition : this.mGameAutomaton.internalPredecessors(iGameState)) {
                    object = (IGameLetter)incomingInternalTransition.getLetter();
                    if (!object.getLetter().equals(LETTER)) continue;
                    hashRelation.addPair((Object)((IGameLetter)incomingInternalTransition.getLetter()), (Object)iGameState);
                    hashRelation2.addPair((Object)incomingInternalTransition.getPred(), (Object)((IGameLetter)incomingInternalTransition.getLetter()));
                }
            }
        }
        Set set = this.computePredecessorsUnderPly(Collections.singleton(summaryComputationGraphNode.getSource2Current2Targets()), hashRelation, this::duplicatorNodePriorityProvider, this::duplicatorAggregration);
        Set<NestedMap2<IGameState, IGameState, WeightedSummaryTargets>> set2 = this.computePredecessorsUnderPly(set, hashRelation2, this::spoilerNodePriorityProvider, this::spoilerAggregration);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (NestedMap2)iterator.next();
            this.constructNode((NestedMap2<IGameState, IGameState, WeightedSummaryTargets>)object, summaryComputationGraphNode.getSummaryComputationTriggers());
        }
    }

    private void constructNode(NestedMap2<IGameState, IGameState, WeightedSummaryTargets> nestedMap2, Set<IGameState> set) {
        SummaryComputationGraphNode summaryComputationGraphNode = new SummaryComputationGraphNode(nestedMap2, set);
        this.mLogger.info((Object)("constructed node " + String.valueOf(summaryComputationGraphNode)));
        if (!this.mNodes.contains(summaryComputationGraphNode)) {
            this.mLogger.info((Object)"added to worklist");
            this.mWorklist.add(summaryComputationGraphNode);
            this.mNodes.add(summaryComputationGraphNode);
        } else {
            this.mLogger.info((Object)"already constructed");
        }
    }

    private void processCallPredecessors(LETTER LETTER, SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode) {
        Object object;
        this.mLogger.info((Object)("computing predecessors under " + String.valueOf(LETTER)));
        HashRelation hashRelation = new HashRelation();
        HashRelation hashRelation2 = new HashRelation();
        for (IGameState object22 : summaryComputationGraphNode.getSources()) {
            for (IGameState iGameState : summaryComputationGraphNode.getCurrent(object22)) {
                for (IncomingCallTransition incomingCallTransition : this.mGameAutomaton.callPredecessors(iGameState)) {
                    object = (IGameLetter)incomingCallTransition.getLetter();
                    if (!object.getLetter().equals(LETTER)) continue;
                    hashRelation.addPair((Object)((IGameLetter)incomingCallTransition.getLetter()), (Object)iGameState);
                    hashRelation2.addPair((Object)incomingCallTransition.getPred(), (Object)((IGameLetter)incomingCallTransition.getLetter()));
                }
            }
        }
        Set set = this.computePredecessorsUnderPly(Collections.singleton(summaryComputationGraphNode.getSource2Current2Targets()), hashRelation, this::duplicatorNodePriorityProvider, this::duplicatorAggregration);
        Set<NestedMap2<IGameState, IGameState, WeightedSummaryTargets>> set2 = this.computePredecessorsUnderPly(set, hashRelation2, this::callWorkaroundPriorityProvider, this::spoilerAggregration);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (NestedMap2)iterator.next();
            this.constructSummary((NestedMap2<IGameState, IGameState, WeightedSummaryTargets>)object, summaryComputationGraphNode.getSummaryComputationTriggers());
        }
    }

    private void constructSummary(NestedMap2<IGameState, IGameState, WeightedSummaryTargets> nestedMap2, Set<IGameState> set) {
        NestedMap2 nestedMap22 = new NestedMap2();
        for (Object object : nestedMap2.keySet()) {
            WeightedSummaryTargets weightedSummaryTargets = (WeightedSummaryTargets)nestedMap2.get(object, object);
            if (weightedSummaryTargets == null) continue;
            for (Map.Entry<IGameState, Integer> entry : weightedSummaryTargets.entrySet()) {
                nestedMap22.put((Object)entry.getKey(), object, (Object)entry.getValue());
            }
        }
        this.mTrigger2Summaries.addPair(set, (Object)nestedMap22);
        for (Object object : this.mSummaryTrigger2Node.getImage(set)) {
            this.processSummary((SummaryComputationGraphNode<LETTER, STATE>)object, (NestedMap2<IGameState, IGameState, Integer>)nestedMap22);
        }
    }

    private void processSummary(SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode, NestedMap2<IGameState, IGameState, Integer> nestedMap2) {
        Object object2;
        HashRelation hashRelation = new HashRelation();
        for (Object object2 : nestedMap2.keys2()) {
            hashRelation.addPair((Object)((IGameState)object2.getFirst()), (Object)((IGameState)object2.getSecond()));
        }
        object2 = this.computePredecessorsUnderPly(Collections.singleton(summaryComputationGraphNode.getSource2Current2Targets()), hashRelation, (arg_0, arg_1) -> nestedMap2.get(arg_0, arg_1), this::duplicatorAggregration);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            NestedMap2 nestedMap22 = (NestedMap2)iterator.next();
            this.constructNode((NestedMap2<IGameState, IGameState, WeightedSummaryTargets>)nestedMap22, summaryComputationGraphNode.getSummaryComputationTriggers());
        }
    }

    private Set<LETTER> collectIncomingInternalLetters(SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode) {
        HashSet hashSet = new HashSet();
        for (IGameState iGameState : summaryComputationGraphNode.getSources()) {
            for (IGameState iGameState2 : summaryComputationGraphNode.getCurrent(iGameState)) {
                for (IncomingInternalTransition incomingInternalTransition : this.mGameAutomaton.internalPredecessors(iGameState2)) {
                    IGameLetter iGameLetter = (IGameLetter)incomingInternalTransition.getLetter();
                    hashSet.add(iGameLetter.getLetter());
                }
            }
        }
        return hashSet;
    }

    private Set<LETTER> collectIncomingCallLetters(SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode) {
        HashSet hashSet = new HashSet();
        for (IGameState iGameState : summaryComputationGraphNode.getSources()) {
            for (IGameState iGameState2 : summaryComputationGraphNode.getCurrent(iGameState)) {
                for (IncomingCallTransition incomingCallTransition : this.mGameAutomaton.callPredecessors(iGameState2)) {
                    IGameLetter iGameLetter = (IGameLetter)incomingCallTransition.getLetter();
                    hashSet.add(iGameLetter.getLetter());
                }
            }
        }
        return hashSet;
    }

    private HashRelation3<LETTER, IGameState, IGameState> collectIncomingReturnLetters(SummaryComputationGraphNode<LETTER, STATE> summaryComputationGraphNode) {
        HashRelation3 hashRelation3 = new HashRelation3();
        for (IGameState iGameState : summaryComputationGraphNode.getSources()) {
            for (IGameState iGameState2 : summaryComputationGraphNode.getCurrent(iGameState)) {
                for (IncomingReturnTransition incomingReturnTransition : this.mGameAutomaton.returnPredecessors(iGameState2)) {
                    IGameLetter iGameLetter = (IGameLetter)incomingReturnTransition.getLetter();
                    hashRelation3.addTriple(iGameLetter.getLetter(), (Object)iGameState2, (Object)incomingReturnTransition.getHierPred());
                }
            }
        }
        return hashRelation3;
    }

    private <PRED, SUCC> Set<NestedMap2<IGameState, PRED, WeightedSummaryTargets>> computePredecessorsUnderPly(Set<NestedMap2<IGameState, SUCC, WeightedSummaryTargets>> set, HashRelation<PRED, SUCC> hashRelation, PriorityProvider<PRED, SUCC> priorityProvider, Aggregation aggregation) {
        HashSet<NestedMap2<IGameState, PRED, WeightedSummaryTargets>> hashSet = new HashSet<NestedMap2<IGameState, PRED, WeightedSummaryTargets>>();
        for (NestedMap2<IGameState, SUCC, WeightedSummaryTargets> nestedMap2 : set) {
            Map map;
            Object object;
            ArrayList<Pair<IGameState, PRED>> arrayList = new ArrayList<Pair<IGameState, PRED>>();
            ArrayList<List<WeightedSummaryTargets>> arrayList2 = new ArrayList<List<WeightedSummaryTargets>>();
            LexicographicCounter lexicographicCounter = nestedMap2.keySet().iterator();
            while (lexicographicCounter.hasNext()) {
                object = (IGameState)lexicographicCounter.next();
                map = nestedMap2.get(object);
                SummaryComputation.addPredecessorsToLists(hashRelation, priorityProvider, map, arrayList, arrayList2, (IGameState)object, aggregation);
            }
            object = new int[arrayList2.size()];
            int n = 0;
            while (n < arrayList2.size()) {
                object[n] = ((List)arrayList2.get(n)).size();
                ++n;
            }
            lexicographicCounter = new LexicographicCounter(object);
            do {
                map = new NestedMap2();
                int[] nArray = lexicographicCounter.getCurrentValue();
                int n2 = 0;
                while (n2 < nArray.length) {
                    map.put((IGameState)((Pair)arrayList.get(n2)).getFirst(), ((Pair)arrayList.get(n2)).getSecond(), (WeightedSummaryTargets)((List)arrayList2.get(n2)).get(nArray[n2]));
                    ++n2;
                }
                hashSet.add((NestedMap2<IGameState, PRED, WeightedSummaryTargets>)map);
                lexicographicCounter.increment();
            } while (!lexicographicCounter.isZero());
            assert (lexicographicCounter.getNumberOfValuesProduct() == hashSet.size()) : "inconsistent";
        }
        this.mLogger.info((Object)(hashSet.size() + " predecessors under ply"));
        return hashSet;
    }

    private static <SUCC, PRED> void addPredecessorsToLists(HashRelation<PRED, SUCC> hashRelation, PriorityProvider<PRED, SUCC> priorityProvider, Map<SUCC, WeightedSummaryTargets> map, List<Pair<IGameState, PRED>> list, List<List<WeightedSummaryTargets>> list2, IGameState iGameState, Aggregation aggregation) {
        for (Object e : hashRelation.getDomain()) {
            Object object2;
            HashSet<WeightedSummaryTargets> hashSet = new HashSet<WeightedSummaryTargets>();
            Set set = hashRelation.getImage(e);
            for (Object object2 : set) {
                WeightedSummaryTargets weightedSummaryTargets = map.get(object2);
                if (weightedSummaryTargets == null) continue;
                int n = priorityProvider.getPriority(e, object2);
                hashSet.add(weightedSummaryTargets.computeUpdate(n));
            }
            if (hashSet.isEmpty()) continue;
            object2 = aggregation.aggregate(hashSet);
            list.add(new Pair((Object)iGameState, e));
            list2.add((List<WeightedSummaryTargets>)object2);
        }
    }

    private List<WeightedSummaryTargets> spoilerAggregration(Set<WeightedSummaryTargets> set) {
        return PosetUtils.filterMinimalElements(set, (IPartialComparator)this.mWeightedSummaryTargetsComparator).collect(Collectors.toList());
    }

    private List<WeightedSummaryTargets> duplicatorAggregration(Set<WeightedSummaryTargets> set) {
        HashMap<IGameState, Integer> hashMap = new HashMap<IGameState, Integer>();
        for (WeightedSummaryTargets weightedSummaryTargets : set) {
            for (Map.Entry<IGameState, Integer> entry : weightedSummaryTargets.entrySet()) {
                Integer n = (Integer)hashMap.get(entry.getKey());
                Integer n2 = n == null ? entry.getValue() : (new PriorityComparator().compare(n, entry.getValue()) >= 0 ? n : entry.getValue());
                hashMap.put(entry.getKey(), n2);
            }
        }
        return Collections.singletonList(new WeightedSummaryTargets(hashMap));
    }

    public Set<IGameState> getNeedSpoilerWinningSink() {
        return this.mNeedSpoilerWinningSink;
    }

    public LinkedHashSet<GameCallReturnSummary<STATE>> getGameSummaries() {
        return this.mGameSummaries;
    }

    @FunctionalInterface
    static interface Aggregation {
        public List<WeightedSummaryTargets> aggregate(Set<WeightedSummaryTargets> var1);
    }

    @FunctionalInterface
    static interface PriorityProvider<P, S> {
        public Integer getPriority(P var1, S var2);
    }
}

