/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.CoveringOptimizationVisitor;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import java.util.Objects;
import java.util.function.Function;

public class Petri2AutomatonCoveringRelation<L, S, P>
implements CoveringOptimizationVisitor.ICoveringRelation<S> {
    private final IPetriNet<L, P> mPetriNet;
    private final Function<S, Marking<P>> mGetMarking;

    public Petri2AutomatonCoveringRelation(IPetriNet<L, P> iPetriNet, Function<S, Marking<P>> function) {
        this.mPetriNet = iPetriNet;
        this.mGetMarking = Objects.requireNonNull(function);
    }

    @Override
    public boolean covers(S s, S s2) {
        Marking<P> marking = this.mGetMarking.apply(s);
        Marking<P> marking2 = this.mGetMarking.apply(s2);
        return marking2.stream().allMatch(object -> marking.contains(object) || !this.canLeave(object) && !this.mPetriNet.isAccepting(object));
    }

    private boolean canLeave(P p) {
        return !this.mPetriNet.getSuccessors(p).isEmpty();
    }
}

