/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.AutomatonWithImplicitSelfloops;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DifferenceDD;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PetriNetUtils {
    private PetriNetUtils() {
    }

    public static <LETTER, PLACE> boolean similarPredecessorPlaces(Collection<Transition<LETTER, PLACE>> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        ImmutableSet immutableSet = collection.iterator().next().getPredecessors();
        return collection.stream().allMatch(transition -> immutableSet.equals(transition.getPredecessors()));
    }

    public static <LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE> & INwaInclusionStateFactory<PLACE>> boolean isEquivalent(AutomataLibraryServices automataLibraryServices, CRSF CRSF, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider2) throws AutomataLibraryException {
        return new IsEquivalent<LETTER, PLACE>(automataLibraryServices, CRSF, PetriNetUtils.netToNwa(automataLibraryServices, CRSF, iPetriNetTransitionProvider), PetriNetUtils.netToNwa(automataLibraryServices, CRSF, iPetriNetTransitionProvider2)).getResult();
    }

    private static <LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE>> INwaOutgoingLetterAndTransitionProvider<LETTER, PLACE> netToNwa(AutomataLibraryServices automataLibraryServices, CRSF CRSF, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider) throws PetriNetNot1SafeException, AutomataOperationCanceledException {
        return new PetriNet2FiniteAutomaton<LETTER, PLACE>(automataLibraryServices, CRSF, iPetriNetTransitionProvider).getResult();
    }

    public static <LETTER, PLACE> String printHashCodesOfInternalDataStructures(IPetriNet<LETTER, PLACE> iPetriNet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HashCodes of PetriNet data structures ");
        stringBuilder.append(System.lineSeparator());
        int n = 0;
        for (Object PLACE : iPetriNet.getInitialPlaces()) {
            stringBuilder.append("Place " + n + ": " + PLACE.hashCode());
            stringBuilder.append(System.lineSeparator());
            ++n;
        }
        int n2 = 0;
        for (Transition<LETTER, PLACE> transition : iPetriNet.getTransitions()) {
            stringBuilder.append(transition.hashCode());
            stringBuilder.append("Place " + n2 + ": " + transition.hashCode());
            stringBuilder.append(System.lineSeparator());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static <LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE> & INwaInclusionStateFactory<PLACE>> boolean doDifferenceLanguageCheck(AutomataLibraryServices automataLibraryServices, CRSF CRSF, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider2) throws PetriNetNot1SafeException, AutomataOperationCanceledException, AutomataLibraryException {
        Object object;
        Object object2;
        AutomatonWithImplicitSelfloops<LETTER, Object> automatonWithImplicitSelfloops = new AutomatonWithImplicitSelfloops<LETTER, Object>(automataLibraryServices, iNestedWordAutomaton, iNestedWordAutomaton.getAlphabet(), iNestedWordAutomaton::isFinal);
        Object object3 = new PetriNet2FiniteAutomaton<LETTER, PLACE>(automataLibraryServices, CRSF, iPetriNetTransitionProvider).getResult();
        Object object4 = new DifferenceDD<LETTER, Object>(automataLibraryServices, CRSF, object3, automatonWithImplicitSelfloops).getResult();
        Object object5 = new PetriNet2FiniteAutomaton<LETTER, PLACE>(automataLibraryServices, CRSF, iPetriNetTransitionProvider2).getResult();
        IsIncluded isIncluded = new IsIncluded(automataLibraryServices, CRSF, object5, object4);
        if (!isIncluded.getResult().booleanValue()) {
            object2 = isIncluded.getCounterexample().getWord();
            object = automataLibraryServices.getLoggingService().getLogger(PetriNetUtils.class);
            object.error((Object)("Accepted by resulting net but not in difference of languages : " + String.valueOf(object2)));
        }
        if (!((IsIncluded)(object2 = new IsIncluded(automataLibraryServices, CRSF, object4, object5))).getResult().booleanValue()) {
            object = ((IsIncluded)object2).getCounterexample().getWord();
            ILogger iLogger = automataLibraryServices.getLoggingService().getLogger(PetriNetUtils.class);
            iLogger.error((Object)("In difference of languages but not accepted by resulting net : " + String.valueOf(object)));
        }
        return isIncluded.getResult() != false && ((IsIncluded)object2).getResult() != false;
    }

    public static <PLACE> String generateStatesAndPlacesDisjointErrorMessage(PLACE PLACE) {
        return "Currently, we require that states of the automaton are disjoint from places of Petri net. Please rename: " + String.valueOf(PLACE);
    }

    public static <PLACE> Map<PLACE, PLACE> mergePlaces(Set<PLACE> set, UnionFind<PLACE> unionFind) {
        HashMap<PLACE, Object> hashMap = new HashMap<PLACE, Object>();
        for (PLACE PLACE : set) {
            Object object = unionFind.find(PLACE);
            if (object == null) {
                hashMap.put(PLACE, PLACE);
                continue;
            }
            hashMap.put(PLACE, object);
        }
        return hashMap;
    }

    public static <LETTER, PLACE> Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> mergePlaces(IPetriNet<LETTER, PLACE> iPetriNet, Map<PLACE, PLACE> map) {
        HashMap<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> hashMap = new HashMap<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>>();
        for (Transition<LETTER, PLACE> transition : iPetriNet.getTransitions()) {
            ImmutableSet immutableSet = (ImmutableSet)transition.getPredecessors().stream().map(map::get).collect(ImmutableSet.collector());
            ImmutableSet immutableSet2 = (ImmutableSet)transition.getSuccessors().stream().map(map::get).collect(ImmutableSet.collector());
            Transition transition2 = new Transition(transition.getSymbol(), immutableSet, immutableSet2, 0);
            hashMap.put(transition, transition2);
        }
        return hashMap;
    }

    public static <LETTER, PLACE> IPetriNet<LETTER, PLACE> mergePlaces(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, Map<PLACE, PLACE> map) {
        Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> map2 = PetriNetUtils.mergePlaces(iPetriNet, map);
        BoundedPetriNet boundedPetriNet = new BoundedPetriNet(automataLibraryServices, iPetriNet.getAlphabet(), false);
        HashMap<PLACE, Pair> hashMap = new HashMap<PLACE, Pair>();
        for (PLACE object : iPetriNet.getPlaces()) {
            boolean bl;
            boolean bl2;
            boolean bl3 = iPetriNet.getInitialPlaces().contains(object);
            boolean bl4 = iPetriNet.isAccepting(object);
            PLACE PLACE = map.get(object);
            Pair pair = (Pair)hashMap.get(PLACE);
            if (pair == null) {
                bl2 = false;
                bl = false;
            } else {
                bl2 = (Boolean)pair.getFirst();
                bl = (Boolean)pair.getSecond();
            }
            hashMap.put(PLACE, new Pair((Object)(bl2 || bl3 ? 1 : 0), (Object)(bl || bl4 ? 1 : 0)));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            boundedPetriNet.addPlace(entry.getKey(), (Boolean)((Pair)entry.getValue()).getFirst(), (Boolean)((Pair)entry.getValue()).getSecond());
        }
        for (Map.Entry entry : map2.entrySet()) {
            boundedPetriNet.addTransition(((Transition)entry.getValue()).getSymbol(), ((Transition)entry.getValue()).getPredecessors(), ((Transition)entry.getValue()).getSuccessors());
        }
        return boundedPetriNet;
    }
}

