/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.BranchingProcessInitialNode;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.ConditionNode;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.EventNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableDirectedGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class BranchingProcessToUltimateModel<LETTER, PLACE> {
    public IElement transformToUltimateModel(BranchingProcess<LETTER, PLACE> branchingProcess) {
        BranchingProcessInitialNode<LETTER, PLACE> branchingProcessInitialNode = new BranchingProcessInitialNode<LETTER, PLACE>(branchingProcess);
        Collection<Condition<LETTER, PLACE>> collection = branchingProcess.initialConditions();
        HashMap<Condition<LETTER, PLACE>, ConditionNode<LETTER, PLACE>> hashMap = new HashMap<Condition<LETTER, PLACE>, ConditionNode<LETTER, PLACE>>();
        HashMap<Event<LETTER, PLACE>, EventNode<LETTER, PLACE>> hashMap2 = new HashMap<Event<LETTER, PLACE>, EventNode<LETTER, PLACE>>();
        LinkedList<Object> linkedList = new LinkedList<Object>(collection);
        for (Condition<LETTER, PLACE> condition : collection) {
            ConditionNode<LETTER, PLACE> conditionNode = new ConditionNode<LETTER, PLACE>(condition, branchingProcess);
            hashMap.put(condition, conditionNode);
            branchingProcessInitialNode.connectOutgoing((IModifiableDirectedGraph)conditionNode);
        }
        while (!linkedList.isEmpty()) {
            Condition<LETTER, PLACE> condition;
            condition = linkedList.remove();
            if (condition instanceof Condition) {
                this.conditionHandling(hashMap, hashMap2, linkedList, condition);
                continue;
            }
            if (!(condition instanceof Event)) continue;
            this.eventHandling(branchingProcess, hashMap, hashMap2, linkedList, (Event)((Object)condition));
        }
        return branchingProcessInitialNode;
    }

    private void conditionHandling(Map<Condition<LETTER, PLACE>, ConditionNode<LETTER, PLACE>> map, Map<Event<LETTER, PLACE>, EventNode<LETTER, PLACE>> map2, Queue<Object> queue, Condition<LETTER, PLACE> condition) {
        ConditionNode<LETTER, PLACE> conditionNode = map.get(condition);
        for (Event<LETTER, PLACE> event : condition.getSuccessorEvents()) {
            EventNode<LETTER, PLACE> eventNode = map2.get(event);
            if (eventNode == null) {
                eventNode = new EventNode<LETTER, PLACE>(event);
                map2.put(event, eventNode);
                queue.add(event);
            }
            conditionNode.connectOutgoing((IModifiableDirectedGraph)eventNode);
        }
    }

    private void eventHandling(BranchingProcess<LETTER, PLACE> branchingProcess, Map<Condition<LETTER, PLACE>, ConditionNode<LETTER, PLACE>> map, Map<Event<LETTER, PLACE>, EventNode<LETTER, PLACE>> map2, Queue<Object> queue, Event<LETTER, PLACE> event) {
        EventNode<LETTER, PLACE> eventNode = map2.get(event);
        for (Condition<LETTER, PLACE> condition : event.getSuccessorConditions()) {
            ConditionNode<LETTER, PLACE> conditionNode = map.get(condition);
            if (conditionNode == null) {
                conditionNode = new ConditionNode<LETTER, PLACE>(condition, branchingProcess);
                map.put(condition, conditionNode);
                queue.add(condition);
            }
            eventNode.connectOutgoing((IModifiableDirectedGraph)conditionNode);
        }
    }
}

