/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.util.z;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.RelationDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.TermNotSupportedException;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.TermToCDDVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZTerm;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZWrapper;
import java.io.StringWriter;
import java.io.Writer;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.oz.util.Factory;
import net.sourceforge.czt.print.oz.PrintUtils;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ExistsExpr;
import net.sourceforge.czt.z.ast.ExistsPred;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ForallExpr;
import net.sourceforge.czt.z.ast.ForallPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ExistsExprVisitor;
import net.sourceforge.czt.z.visitor.ExistsPredVisitor;
import net.sourceforge.czt.z.visitor.ForallExprVisitor;
import net.sourceforge.czt.z.visitor.ForallPredVisitor;

public class TermToRelationCDDVisitor
extends TermToCDDVisitor
implements ForallExprVisitor<CDD>,
ForallPredVisitor<CDD>,
ExistsExprVisitor<CDD>,
ExistsPredVisitor<CDD> {
    private static final String Z_EQUALS_OPERATOR = ZString.ARG_TOK + ZString.EQUALS + ZString.ARG_TOK;
    private static final String Z_NEQ_OPERATOR = ZString.ARG_TOK + ZString.NEQ + ZString.ARG_TOK;
    private static final String Z_LESS_OPERATOR = ZString.ARG_TOK + ZString.LESS + ZString.ARG_TOK;
    private static final String Z_LEQ_OPERATOR = ZString.ARG_TOK + ZString.LEQ + ZString.ARG_TOK;
    private static final String Z_GREATER_OPERATOR = ZString.ARG_TOK + ZString.GREATER + ZString.ARG_TOK;
    private static final String Z_GEQ_OPERATOR = ZString.ARG_TOK + ZString.GEQ + ZString.ARG_TOK;
    Factory factory = new Factory();

    public TermToRelationCDDVisitor(ZTerm zTerm) {
        super(zTerm);
    }

    @Override
    public CDD visitMemPred(MemPred memPred) {
        RefExpr refExpr;
        ZName zName;
        if (memPred.getRightExpr() instanceof RefExpr && (zName = (refExpr = (RefExpr)memPred.getRightExpr()).getZName()).getOperatorName().getWord().equals(Z_NEQ_OPERATOR)) {
            ZName zName2 = this.factory.createZName(Z_EQUALS_OPERATOR, zName.getStrokeList());
            RefExpr refExpr2 = this.factory.createRefExpr((Name)zName2, refExpr.getZExprList(), refExpr.getMixfix());
            MemPred memPred2 = this.factory.createMemPred(memPred.getLeftExpr(), (Expr)refExpr2, memPred.getMixfix());
            return ((CDD)memPred2.accept((Visitor)this)).negate();
        }
        return this.visitTerm((Term)memPred);
    }

    @Override
    public CDD visitTerm(Term term) {
        StringWriter stringWriter = new StringWriter();
        PrintUtils.print((Term)term, (Writer)stringWriter, (SectionManager)((SectionManager)this.sectionInfo), (String)ZWrapper.getSectionName(), (Markup)Markup.UNICODE);
        String string = stringWriter.toString();
        string = string.replace(ZString.PRIME, RelationDecision.Operator.PRIME.toString());
        string = string.replace(ZString.MINUS, RelationDecision.Operator.MINUS.toString());
        string = string.replace(ZString.MULT, RelationDecision.Operator.MULT.toString());
        string = string.replace(" div ", RelationDecision.Operator.DIV.toString());
        string = string.replace(" ", "");
        try {
            if (string.contains(ZString.GEQ)) {
                return this.getRelationDecFor(string.split(ZString.GEQ), RelationDecision.Operator.GEQ);
            }
            if (string.contains(ZString.LEQ)) {
                return this.getRelationDecFor(string.split(ZString.LEQ), RelationDecision.Operator.LEQ);
            }
            if (string.contains(ZString.LESS)) {
                return this.getRelationDecFor(string.split(ZString.LESS), RelationDecision.Operator.LESS);
            }
            if (string.contains(ZString.GREATER)) {
                return this.getRelationDecFor(string.split(ZString.GREATER), RelationDecision.Operator.GREATER);
            }
            if (string.contains(ZString.NEQ)) {
                return this.getRelationDecFor(string.split(ZString.NEQ), RelationDecision.Operator.NEQ);
            }
            if (string.contains(ZString.EQUALS)) {
                return this.getRelationDecFor(string.split(ZString.EQUALS), RelationDecision.Operator.EQUALS);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Found wrong number of operands in " + string);
        }
        throw new RuntimeException("Term cannot be transformed into RelationDecision: " + string);
    }

    private CDD getRelationDecFor(String[] stringArray, RelationDecision.Operator operator) {
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        return RelationDecision.create(stringArray[0], operator, stringArray[1]);
    }

    public CDD visitForallExpr(ForallExpr forallExpr) {
        throw new TermNotSupportedException((Term)forallExpr, this.sectionInfo);
    }

    public CDD visitForallPred(ForallPred forallPred) {
        throw new TermNotSupportedException((Term)forallPred, this.sectionInfo);
    }

    public CDD visitExistsExpr(ExistsExpr existsExpr) {
        throw new TermNotSupportedException((Term)existsExpr, this.sectionInfo);
    }

    public CDD visitExistsPred(ExistsPred existsPred) {
        throw new TermNotSupportedException((Term)existsPred, this.sectionInfo);
    }
}

