/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.BoogieGlobalLhsFinder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.BoogieProcedureInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UndeclaredFunctionException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.TransitiveClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.LinkedHashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProcedureManager {
    private final Set<BoogieProcedureInfo> mMethodsCalledBeforeDeclared;
    private final Map<String, BoogieProcedureInfo> mProcedureNameToProcedureInfo;
    private final LinkedHashRelation<BoogieProcedureInfo, BoogieProcedureInfo> mInverseCallGraph;
    private BoogieProcedureInfo mCurrentProcedureInfo;
    private BoogieProcedureInfo mPreviousProcedureInfo;
    private final ILogger mLogger;
    private final TranslationSettings mSettings;

    public ProcedureManager(ILogger iLogger, TranslationSettings translationSettings) {
        this.mLogger = iLogger;
        this.mSettings = translationSettings;
        this.mMethodsCalledBeforeDeclared = new LinkedHashSet<BoogieProcedureInfo>();
        this.mProcedureNameToProcedureInfo = new LinkedHashMap<String, BoogieProcedureInfo>();
        this.mInverseCallGraph = new LinkedHashRelation();
    }

    void beginProcedureScope(CHandler cHandler, BoogieProcedureInfo boogieProcedureInfo) {
        assert (boogieProcedureInfo != null);
        this.mPreviousProcedureInfo = this.mCurrentProcedureInfo;
        this.mCurrentProcedureInfo = boogieProcedureInfo;
        cHandler.beginScope();
    }

    void endProcedureScope(CHandler cHandler) {
        this.mCurrentProcedureInfo = this.mPreviousProcedureInfo;
        this.mPreviousProcedureInfo = null;
        cHandler.endScope();
    }

    public void registerProcedure(String string) {
        this.getOrConstructProcedureInfo(string);
    }

    public void registerProcedureDeclaration(String string, Procedure procedure) {
        BoogieProcedureInfo boogieProcedureInfo = this.getOrConstructProcedureInfo(string);
        if (boogieProcedureInfo.hasDeclaration()) {
            throw new IllegalStateException("procedure already has a declaration, this is unexpected");
        }
        boogieProcedureInfo.setDeclaration(procedure);
    }

    BoogieProcedureInfo getOrConstructProcedureInfo(String string) {
        return this.mProcedureNameToProcedureInfo.computeIfAbsent(string, BoogieProcedureInfo::new);
    }

    BoogieProcedureInfo getProcedureInfo(String string) {
        BoogieProcedureInfo boogieProcedureInfo = this.mProcedureNameToProcedureInfo.get(string);
        if (boogieProcedureInfo == null) {
            throw new IllegalArgumentException("a procedure of the given name is not yet known " + string);
        }
        return boogieProcedureInfo;
    }

    public List<Declaration> computeFinalProcedureDeclarations(MemoryHandler memoryHandler) {
        for (BoogieProcedureInfo object2 : this.mMethodsCalledBeforeDeclared) {
            if (object2.hasDeclaration()) continue;
            throw new UndeclaredFunctionException(null, "a function that is called in the program is not declared in the program: " + object2.getProcedureName());
        }
        SccComputation.ISuccessorProvider iSuccessorProvider = boogieProcedureInfo -> this.mInverseCallGraph.getImage(boogieProcedureInfo).iterator();
        HashSet<BoogieProcedureInfo> hashSet = new HashSet<BoogieProcedureInfo>(this.mProcedureNameToProcedureInfo.values());
        Function<BoogieProcedureInfo, Set> function = boogieProcedureInfo -> boogieProcedureInfo.getModifiedGlobals();
        Map map = TransitiveClosure.computeClosure((ILogger)this.mLogger, (Set)hashSet, function, (SccComputation.ISuccessorProvider)iSuccessorProvider);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (BoogieProcedureInfo boogieProcedureInfo2 : this.mProcedureNameToProcedureInfo.values()) {
            Specification[] specificationArray;
            Procedure procedure = boogieProcedureInfo2.getDeclaration();
            String string = boogieProcedureInfo2.getProcedureName();
            Specification[] specificationArray2 = procedure.getSpecification();
            CACSLLocation cACSLLocation = (CACSLLocation)procedure.getLocation();
            Specification[] specificationArray3 = ProcedureManager.addModifies(memoryHandler, (Set)map.get(boogieProcedureInfo2), boogieProcedureInfo2, string, specificationArray2, cACSLLocation);
            if (memoryHandler.getRequiredMemoryStructureFeatures().isMemoryStructureInfrastructureRequired() && this.mSettings.getFunctionsCheckedForMemoryNeutrality().contains(string)) {
                Expression expression = memoryHandler.getValidArray(cACSLLocation);
                int n = specificationArray3.length;
                Check check = new Check(Spec.MEMORY_NEUTRAL);
                CACSLLocation cACSLLocation2 = LocationFactory.createLocation(cACSLLocation);
                specificationArray = Arrays.copyOf(specificationArray3, n + 1);
                specificationArray[n] = new EnsuresSpecification((ILocation)cACSLLocation2, false, ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)cACSLLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression)));
                check.annotate((IElement)specificationArray[n]);
                if (this.mSettings.isSvcompMemtrackCompatibilityMode()) {
                    new Overapprox(Collections.singletonMap("memtrack", cACSLLocation2)).annotate((IElement)specificationArray[n]);
                }
            } else {
                specificationArray = specificationArray3;
            }
            arrayList.add((Declaration)new Procedure((ILocation)cACSLLocation, procedure.getAttributes(), string, procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), specificationArray, null));
        }
        return arrayList;
    }

    private static Specification[] addModifies(MemoryHandler memoryHandler, Set<VariableLHS> set, BoogieProcedureInfo boogieProcedureInfo, String string, Specification[] specificationArray, CACSLLocation cACSLLocation) {
        if (boogieProcedureInfo.isModifiedGlobalsIsUsedDefined()) {
            return specificationArray;
        }
        assert (set != null) : "No modifies clause proc " + string;
        boogieProcedureInfo.addModifiedGlobals(set);
        Specification[] specificationArray2 = Arrays.copyOf(specificationArray, specificationArray.length + 1);
        Collection<HeapDataArray> collection = memoryHandler.getDataHeapArrays(memoryHandler.getRequiredMemoryStructureFeatures());
        if (ProcedureManager.containsOneHeapDataArray(set, collection)) {
            for (HeapDataArray object2 : collection) {
                boogieProcedureInfo.addModifiedGlobal(object2.getVariableLHS());
            }
        }
        VariableLHS[] variableLHSArray = (VariableLHS[])set.stream().toArray(VariableLHS[]::new);
        specificationArray2[specificationArray.length] = ProcedureManager.constructModifiesSpecification(cACSLLocation, false, variableLHSArray);
        return specificationArray2;
    }

    private static Set<VariableLHS> filterDuplicateVariableLHSs(Set<VariableLHS> set) {
        LinkedHashSet<VariableLHS> linkedHashSet = new LinkedHashSet<VariableLHS>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (VariableLHS variableLHS : set) {
            if (linkedHashSet2.contains(variableLHS.getIdentifier())) continue;
            linkedHashSet.add(variableLHS);
            linkedHashSet2.add(variableLHS.getIdentifier());
        }
        return linkedHashSet;
    }

    private static boolean containsOneHeapDataArray(Set<VariableLHS> set, Collection<HeapDataArray> collection) {
        return collection.stream().anyMatch(heapDataArray -> set.contains(heapDataArray.getVariableLHS()));
    }

    void registerCall(BoogieProcedureInfo boogieProcedureInfo, BoogieProcedureInfo boogieProcedureInfo2) {
        if (!boogieProcedureInfo2.hasDeclaration()) {
            this.mMethodsCalledBeforeDeclared.add(boogieProcedureInfo2);
        }
        this.mInverseCallGraph.addPair((Object)boogieProcedureInfo2, (Object)boogieProcedureInfo);
    }

    public void beginCustomProcedure(CHandler cHandler, ILocation iLocation, String string, Procedure procedure) {
        BoogieProcedureInfo boogieProcedureInfo = this.getOrConstructProcedureInfo(string);
        boogieProcedureInfo.setDeclaration(procedure);
        this.beginProcedureScope(cHandler, boogieProcedureInfo);
    }

    public void endCustomProcedure(CHandler cHandler, String string) {
        assert (this.mCurrentProcedureInfo.getProcedureName().equals(string));
        this.endProcedureScope(cHandler);
    }

    public Procedure getProcedureDeclaration(String string) {
        BoogieProcedureInfo boogieProcedureInfo = this.getProcedureInfo(string);
        if (!boogieProcedureInfo.hasDeclaration()) {
            throw new IllegalArgumentException("a procedure of the requested name is not yet known: " + string);
        }
        return boogieProcedureInfo.getDeclaration();
    }

    public boolean isGlobalScope() {
        return this.mCurrentProcedureInfo == null;
    }

    public String getCurrentProcedureID() {
        if (this.mCurrentProcedureInfo == null) {
            throw new IllegalStateException("Check for isGlobalScope first");
        }
        return this.mCurrentProcedureInfo.getProcedureName();
    }

    public ICType getReturnTypeOfCurrentProcedure() {
        if (this.mCurrentProcedureInfo == null) {
            throw new IllegalStateException("Check for isGlobalScope first");
        }
        return this.mCurrentProcedureInfo.getCType().getResultType();
    }

    public CFunction getCFunctionType(String string) {
        BoogieProcedureInfo boogieProcedureInfo = this.getProcedureInfo(string);
        return boogieProcedureInfo.getCType();
    }

    public boolean hasProcedure(String string) {
        return this.mProcedureNameToProcedureInfo.containsKey(string);
    }

    private static Specification constructModifiesSpecification(CACSLLocation cACSLLocation, boolean bl, VariableLHS[] variableLHSArray) {
        LinkedHashSet<VariableLHS> linkedHashSet = new LinkedHashSet<VariableLHS>(Arrays.asList(variableLHSArray));
        Set<VariableLHS> set = ProcedureManager.filterDuplicateVariableLHSs(linkedHashSet);
        return new ModifiesSpecification((ILocation)cACSLLocation, bl, set.toArray(new VariableLHS[set.size()]));
    }

    public Body constructBody(ILocation iLocation, VariableDeclaration[] variableDeclarationArray, Statement[] statementArray, String string) {
        BoogieProcedureInfo boogieProcedureInfo = this.getProcedureInfo(string);
        Collection<Statement> collection = new CallAndAssignmentStatementFinder().getCallsAndAssignments(statementArray);
        for (Statement statement : collection) {
            if (statement instanceof CallStatement) {
                this.registerCallStatement((CallStatement)statement, boogieProcedureInfo);
            }
            if (!(statement instanceof AssignmentStatement)) continue;
            ProcedureManager.registerAssignmentStatement((AssignmentStatement)statement, boogieProcedureInfo);
        }
        return new Body(iLocation, variableDeclarationArray, statementArray);
    }

    private static void registerAssignmentStatement(AssignmentStatement assignmentStatement, BoogieProcedureInfo boogieProcedureInfo) {
        LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
        int n = leftHandSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            LeftHandSide leftHandSide = leftHandSideArray[n2];
            VariableLHS variableLHS = new BoogieGlobalLhsFinder().getGlobalId(leftHandSide);
            if (variableLHS != null) {
                boogieProcedureInfo.addModifiedGlobal(variableLHS);
            }
            ++n2;
        }
    }

    private void registerCallStatement(CallStatement callStatement, BoogieProcedureInfo boogieProcedureInfo) {
        Object object;
        VariableLHS[] variableLHSArray = callStatement.getLhs();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = variableLHSArray[n2];
            VariableLHS variableLHS = new BoogieGlobalLhsFinder().getGlobalId((LeftHandSide)object);
            if (variableLHS != null) {
                boogieProcedureInfo.addModifiedGlobal(variableLHS);
            }
            ++n2;
        }
        object = this.getOrConstructProcedureInfo(callStatement.getMethodName());
        this.registerCall(boogieProcedureInfo, (BoogieProcedureInfo)object);
    }

    public void registerForkStatement(ForkStatement forkStatement) {
        String string = this.getCurrentProcedureID();
        BoogieProcedureInfo boogieProcedureInfo = this.getProcedureInfo(string);
        BoogieProcedureInfo boogieProcedureInfo2 = this.getProcedureInfo(forkStatement.getProcedureName());
        this.registerCall(boogieProcedureInfo, boogieProcedureInfo2);
    }

    public EnsuresSpecification constructEnsuresSpecification(ILocation iLocation, boolean bl, Expression expression, Set<VariableLHS> set) {
        BoogieProcedureInfo boogieProcedureInfo = this.mCurrentProcedureInfo;
        boogieProcedureInfo.addModifiedGlobals(set);
        return new EnsuresSpecification(iLocation, bl, expression);
    }

    public void addSpecificationsToCurrentProcedure(List<Specification> list) {
        assert (!this.isGlobalScope());
        BoogieProcedureInfo boogieProcedureInfo = this.mCurrentProcedureInfo;
        Procedure procedure = boogieProcedureInfo.getDeclaration();
        ArrayList<Specification> arrayList = new ArrayList<Specification>(Arrays.asList(procedure.getSpecification()));
        arrayList.addAll(list);
        Procedure procedure2 = new Procedure(procedure.getLoc(), procedure.getAttributes(), procedure.getIdentifier(), procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), arrayList.toArray(new Specification[arrayList.size()]), null);
        boogieProcedureInfo.resetDeclaration(procedure2);
    }

    BoogieProcedureInfo getCurrentProcedureInfo() {
        return this.mCurrentProcedureInfo;
    }

    public boolean isCalledBeforeDeclared(BoogieProcedureInfo boogieProcedureInfo) {
        return this.mMethodsCalledBeforeDeclared.contains(boogieProcedureInfo);
    }

    public void registerCalledBeforeDeclaredFunction(BoogieProcedureInfo boogieProcedureInfo) {
        this.mMethodsCalledBeforeDeclared.add(boogieProcedureInfo);
    }

    public Set<CFunction> getAllFunctionSignatures() {
        return this.mProcedureNameToProcedureInfo.entrySet().stream().map(Map.Entry::getValue).filter(boogieProcedureInfo -> boogieProcedureInfo.hasCType()).map(boogieProcedureInfo -> boogieProcedureInfo.getCType()).collect(Collectors.toSet());
    }

    private static class CallAndAssignmentStatementFinder
    extends BoogieVisitor {
        Collection<Statement> mResult = new ArrayList<Statement>();

        private CallAndAssignmentStatementFinder() {
        }

        protected void visit(CallStatement callStatement) {
            this.mResult.add((Statement)callStatement);
            super.visit(callStatement);
        }

        protected void visit(AssignmentStatement assignmentStatement) {
            this.mResult.add((Statement)assignmentStatement);
            super.visit(assignmentStatement);
        }

        Collection<Statement> getCallsAndAssignments(Statement[] statementArray) {
            this.processStatements(statementArray);
            return this.mResult;
        }
    }
}

