/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util;

import java.util.BitSet;

public class UtilBitSet {
    private UtilBitSet() {
    }

    public static boolean subsetOf(BitSet bitSet, BitSet bitSet2) {
        if (bitSet.cardinality() > bitSet2.cardinality()) {
            return false;
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.andNot(bitSet2);
        return bitSet3.isEmpty();
    }

    public static boolean contentEq(BitSet bitSet, BitSet bitSet2) {
        if (bitSet.cardinality() != bitSet2.cardinality()) {
            return false;
        }
        int n = bitSet.nextSetBit(0);
        int n2 = bitSet2.nextSetBit(0);
        while (n >= 0 || n2 >= 0) {
            if (n != n2) {
                return false;
            }
            n = bitSet.nextSetBit(n + 1);
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
        return true;
    }

    public static BitSet subtract(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.andNot(bitSet2);
        return bitSet3;
    }

    public static BitSet union(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.or(bitSet2);
        return bitSet3;
    }

    public static BitSet intersect(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.and(bitSet2);
        return bitSet3;
    }

    public static void main(String[] stringArray) {
        BitSet bitSet = new BitSet(17);
        BitSet bitSet2 = new BitSet(19);
        BitSet bitSet3 = new BitSet(15);
        int n = 1;
        while (n < 14) {
            bitSet.set(n);
            bitSet2.set(n);
            bitSet3.set(n);
            n += 2;
        }
        System.out.println("A: " + String.valueOf(bitSet));
        System.out.println("B: " + String.valueOf(bitSet2));
        System.out.println("C: " + String.valueOf(bitSet3));
        System.out.println(UtilBitSet.contentEq(bitSet, bitSet2));
        System.out.println(UtilBitSet.contentEq(bitSet3, bitSet));
        bitSet2.set(15);
        System.out.println(UtilBitSet.subsetOf(bitSet, bitSet2));
        System.out.println(UtilBitSet.subsetOf(bitSet2, bitSet));
        System.out.println(UtilBitSet.subsetOf(bitSet2, bitSet3));
        System.out.println(UtilBitSet.subsetOf(bitSet3, bitSet2));
        System.out.println(UtilBitSet.subtract(bitSet2, bitSet3));
        System.out.println(UtilBitSet.subtract(bitSet3, bitSet2));
        System.out.println(UtilBitSet.intersect(bitSet3, bitSet2));
    }
}

