/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChangeType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.VertexValueContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorSubSummaryChoiceVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerSubSummaryPriorityVertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap4;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AGameGraph<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mBuechi;
    private final NestedMap4<STATE, STATE, LETTER, Boolean, DuplicatorVertex<LETTER, STATE>> mBuechiStatesToGraphDuplicatorVertex;
    private final NestedMap3<STATE, STATE, Boolean, SpoilerVertex<LETTER, STATE>> mBuechiStatesToGraphSpoilerVertex;
    private final HashSet<DuplicatorVertex<LETTER, STATE>> mDuplicatorVertices;
    private int mGlobalInfinity;
    private final ILogger mLogger;
    private SimulationPerformance mPerformance;
    private final HashMap<Vertex<LETTER, STATE>, HashSet<Vertex<LETTER, STATE>>> mPredecessors;
    private final IProgressAwareTimer mProgressTimer;
    private final HashMap<Vertex<LETTER, STATE>, HashSet<Vertex<LETTER, STATE>>> mPushOverPredecessors;
    private final HashMap<Vertex<LETTER, STATE>, HashSet<Vertex<LETTER, STATE>>> mPushOverSuccessors;
    private final AutomataLibraryServices mServices;
    private final HashSet<SpoilerVertex<LETTER, STATE>> mSpoilerVertices;
    private final IMergeStateFactory<STATE> mStateFactory;
    private final HashMap<Vertex<LETTER, STATE>, HashSet<Vertex<LETTER, STATE>>> mSuccessors;

    public AGameGraph(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this.mBuechi = iNestedWordAutomaton;
        this.mServices = automataLibraryServices;
        this.mProgressTimer = iProgressAwareTimer;
        this.mLogger = iLogger;
        this.mStateFactory = iMergeStateFactory;
        this.mDuplicatorVertices = new HashSet();
        this.mSpoilerVertices = new HashSet();
        this.mSuccessors = new HashMap();
        this.mPushOverSuccessors = new HashMap();
        this.mPredecessors = new HashMap();
        this.mPushOverPredecessors = new HashMap();
        this.mBuechiStatesToGraphSpoilerVertex = new NestedMap3();
        this.mBuechiStatesToGraphDuplicatorVertex = new NestedMap4();
        this.mGlobalInfinity = 0;
        this.mPerformance = null;
    }

    public void addDuplicatorVertex(DuplicatorVertex<LETTER, STATE> duplicatorVertex) {
        this.mDuplicatorVertices.add(duplicatorVertex);
        this.mBuechiStatesToGraphDuplicatorVertex.put(duplicatorVertex.getQ0(), duplicatorVertex.getQ1(), duplicatorVertex.getLetter(), (Object)duplicatorVertex.isB(), duplicatorVertex);
    }

    public void addEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        if (!this.mSuccessors.containsKey(vertex)) {
            this.mSuccessors.put(vertex, new HashSet());
        }
        this.mSuccessors.get(vertex).add(vertex2);
        if (!this.mPredecessors.containsKey(vertex2)) {
            this.mPredecessors.put(vertex2, new HashSet());
        }
        this.mPredecessors.get(vertex2).add(vertex);
    }

    public void addPushOverEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        if (!this.mPushOverSuccessors.containsKey(vertex)) {
            this.mPushOverSuccessors.put(vertex, new HashSet());
        }
        this.mPushOverSuccessors.get(vertex).add(vertex2);
        if (!this.mPushOverPredecessors.containsKey(vertex2)) {
            this.mPushOverPredecessors.put(vertex2, new HashSet());
        }
        this.mPushOverPredecessors.get(vertex2).add(vertex);
    }

    public void addSpoilerVertex(SpoilerVertex<LETTER, STATE> spoilerVertex) {
        this.mSpoilerVertices.add(spoilerVertex);
        this.mBuechiStatesToGraphSpoilerVertex.put(spoilerVertex.getQ0(), spoilerVertex.getQ1(), (Object)spoilerVertex.isB(), spoilerVertex);
    }

    public abstract INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException;

    public abstract void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException;

    public int getAmountOfEdges() {
        int n = 0;
        for (HashSet<Vertex<LETTER, STATE>> hashSet : this.mSuccessors.values()) {
            n += hashSet.size();
        }
        return n;
    }

    public INestedWordAutomaton<LETTER, STATE> getAutomaton() {
        return this.mBuechi;
    }

    public int getAutomatonSize() {
        return this.mBuechi.size();
    }

    public DuplicatorVertex<LETTER, STATE> getDuplicatorVertex(STATE STATE, STATE STATE2, LETTER LETTER, boolean bl) {
        return (DuplicatorVertex)this.mBuechiStatesToGraphDuplicatorVertex.get(STATE, STATE2, LETTER, (Object)bl);
    }

    public Set<DuplicatorVertex<LETTER, STATE>> getDuplicatorVertices() {
        return Collections.unmodifiableSet(this.mDuplicatorVertices);
    }

    public int getGlobalInfinity() {
        return this.mGlobalInfinity;
    }

    public HashSet<DuplicatorVertex<LETTER, STATE>> getInternalDuplicatorVerticesField() {
        return this.mDuplicatorVertices;
    }

    public HashSet<SpoilerVertex<LETTER, STATE>> getInternalSpoilerVerticesField() {
        return this.mSpoilerVertices;
    }

    public Set<Vertex<LETTER, STATE>> getNonDeadEndVertices() {
        return Collections.unmodifiableSet(this.mSuccessors.keySet());
    }

    public Set<Vertex<LETTER, STATE>> getPredecessors(Vertex<LETTER, STATE> vertex) {
        if (this.hasPredecessors(vertex)) {
            return Collections.unmodifiableSet((Set)this.mPredecessors.get(vertex));
        }
        return null;
    }

    public int getPriority(Vertex<LETTER, STATE> vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("The given vertex must not be null.");
        }
        return vertex.getPriority();
    }

    public Set<Vertex<LETTER, STATE>> getPushOverPredecessors(Vertex<LETTER, STATE> vertex) {
        if (this.hasPushOverPredecessors(vertex)) {
            return Collections.unmodifiableSet((Set)this.mPushOverPredecessors.get(vertex));
        }
        return null;
    }

    public Set<Vertex<LETTER, STATE>> getPushOverSuccessors(Vertex<LETTER, STATE> vertex) {
        if (this.hasPushOverSuccessors(vertex)) {
            return Collections.unmodifiableSet((Set)this.mPushOverSuccessors.get(vertex));
        }
        return null;
    }

    public AutomataLibraryServices getServices() {
        return this.mServices;
    }

    public int getSize() {
        return this.mSpoilerVertices.size() + this.mDuplicatorVertices.size();
    }

    public SpoilerVertex<LETTER, STATE> getSpoilerVertex(STATE STATE, STATE STATE2, boolean bl) {
        return (SpoilerVertex)this.mBuechiStatesToGraphSpoilerVertex.get(STATE, STATE2, (Object)bl);
    }

    public Set<SpoilerVertex<LETTER, STATE>> getSpoilerVertices() {
        return Collections.unmodifiableSet(this.mSpoilerVertices);
    }

    public Set<Vertex<LETTER, STATE>> getSuccessors(Vertex<LETTER, STATE> vertex) {
        if (this.hasSuccessors(vertex)) {
            return Collections.unmodifiableSet((Set)this.mSuccessors.get(vertex));
        }
        return null;
    }

    public Set<Vertex<LETTER, STATE>> getVertices() {
        HashSet<Vertex<LETTER, STATE>> hashSet = new HashSet<Vertex<LETTER, STATE>>(this.mSpoilerVertices);
        hashSet.addAll(this.mDuplicatorVertices);
        return hashSet;
    }

    public boolean hasPredecessors(Vertex<LETTER, STATE> vertex) {
        return this.mPredecessors.containsKey(vertex);
    }

    public boolean hasPushOverPredecessors(Vertex<LETTER, STATE> vertex) {
        return this.mPushOverPredecessors.containsKey(vertex);
    }

    public boolean hasPushOverSuccessors(Vertex<LETTER, STATE> vertex) {
        return this.mPushOverSuccessors.containsKey(vertex);
    }

    public boolean hasSuccessors(Vertex<LETTER, STATE> vertex) {
        return this.mSuccessors.containsKey(vertex);
    }

    public void increaseGlobalInfinity() {
        ++this.mGlobalInfinity;
    }

    public void removeDuplicatorVertex(DuplicatorVertex<LETTER, STATE> duplicatorVertex) {
        this.mDuplicatorVertices.remove(duplicatorVertex);
        this.mBuechiStatesToGraphDuplicatorVertex.put(duplicatorVertex.getQ0(), duplicatorVertex.getQ1(), duplicatorVertex.getLetter(), (Object)duplicatorVertex.isB(), null);
    }

    public void removeEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        if (this.mSuccessors.get(vertex) != null) {
            this.mSuccessors.get(vertex).remove(vertex2);
            if (this.mSuccessors.get(vertex).size() == 0) {
                this.mSuccessors.remove(vertex);
            }
        }
        if (this.mPredecessors.get(vertex2) != null) {
            this.mPredecessors.get(vertex2).remove(vertex);
            if (this.mPredecessors.get(vertex2).size() == 0) {
                this.mPredecessors.remove(vertex2);
            }
        }
    }

    public void removePushOverEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        if (this.mPushOverSuccessors.get(vertex) != null) {
            this.mPushOverSuccessors.get(vertex).remove(vertex2);
            if (this.mPushOverSuccessors.get(vertex).size() == 0) {
                this.mPushOverSuccessors.remove(vertex);
            }
        }
        if (this.mPushOverPredecessors.get(vertex2) != null) {
            this.mPushOverPredecessors.get(vertex2).remove(vertex);
            if (this.mPushOverPredecessors.get(vertex2).size() == 0) {
                this.mPushOverPredecessors.remove(vertex2);
            }
        }
    }

    public void removeSpoilerVertex(SpoilerVertex<LETTER, STATE> spoilerVertex) {
        this.mSpoilerVertices.remove(spoilerVertex);
        this.mBuechiStatesToGraphSpoilerVertex.put(spoilerVertex.getQ0(), spoilerVertex.getQ1(), (Object)spoilerVertex.isB(), null);
    }

    public void setSimulationPerformance(SimulationPerformance simulationPerformance) {
        this.mPerformance = simulationPerformance;
    }

    public String toAtsFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        stringBuilder.append("NestedWordAutomaton nwa = (");
        stringBuilder.append(string + "\tcallAlphabet = { },");
        stringBuilder.append(string + "\tinternalAlphabet = {a},");
        stringBuilder.append(string + "\treturnAlphabet = { },");
        stringBuilder.append(string + "\tstates = {");
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl = true;
        for (Vertex<LETTER, STATE> vertex : this.getVertices()) {
            if (!bl) {
                stringBuilder2.append(" ");
            }
            stringBuilder2.append("\"").append(vertex.getName()).append("\"");
            bl = false;
        }
        stringBuilder.append(stringBuilder2.toString()).append("},");
        stringBuilder.append(string + "\tinitialStates = {" + stringBuilder2.toString() + "},");
        stringBuilder.append(string + "\tfinalStates = { },");
        stringBuilder.append(string + "\tcallTransitions = { },");
        stringBuilder.append(string + "\tinternalTransitions = {");
        for (Vertex<LETTER, STATE> vertex : this.getVertices()) {
            if (!this.hasSuccessors(vertex)) continue;
            for (Vertex<LETTER, STATE> vertex2 : this.getSuccessors(vertex)) {
                stringBuilder.append(string).append("\t\t(\"").append(vertex.getName()).append("\" \"a\" \"").append(vertex2.getName()).append("\")");
            }
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\treturnTransitions = {}");
        stringBuilder.append(string + ");");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        stringBuilder.append("GameGraph gg = (");
        stringBuilder.append(string + "\tSpoilerVertices = {");
        for (SpoilerVertex<LETTER, STATE> vertex : this.getSpoilerVertices()) {
            stringBuilder.append(string + "\t\t<(" + vertex.isB() + ", " + String.valueOf(vertex.getQ0()) + ", " + String.valueOf(vertex.getQ1()) + "), p:" + this.getPriority(vertex) + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tDuplicatorVertices = {");
        for (DuplicatorVertex duplicatorVertex : this.getDuplicatorVertices()) {
            stringBuilder.append(string + "\t\t<(" + duplicatorVertex.isB() + ", " + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), p:" + this.getPriority(duplicatorVertex) + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tedges = {");
        for (Vertex vertex : this.getNonDeadEndVertices()) {
            for (Vertex<LETTER, STATE> vertex2 : this.getSuccessors(vertex)) {
                DuplicatorVertex duplicatorVertex;
                stringBuilder.append(string + "\t\t(" + vertex.isB() + ", " + String.valueOf(vertex.getQ0()) + ", " + String.valueOf(vertex.getQ1()));
                if (vertex instanceof DuplicatorVertex) {
                    duplicatorVertex = (DuplicatorVertex)vertex;
                    stringBuilder.append(", " + String.valueOf(duplicatorVertex.getLetter()));
                }
                stringBuilder.append(")");
                if (vertex instanceof SpoilerSubSummaryPriorityVertex || vertex instanceof DuplicatorSubSummaryChoiceVertex) {
                    stringBuilder.append(vertex.getClass().getSimpleName());
                }
                stringBuilder.append("\t--> (" + vertex2.isB() + ", " + String.valueOf(vertex2.getQ0()) + ", " + String.valueOf(vertex2.getQ1()));
                if (vertex2 instanceof DuplicatorVertex) {
                    duplicatorVertex = (DuplicatorVertex)vertex2;
                    stringBuilder.append(", " + String.valueOf(duplicatorVertex.getLetter()));
                }
                stringBuilder.append(")");
                if (!(vertex2 instanceof SpoilerSubSummaryPriorityVertex) && !(vertex2 instanceof DuplicatorSubSummaryChoiceVertex)) continue;
                stringBuilder.append(vertex2.getClass().getSimpleName());
            }
        }
        stringBuilder.append(string + "\t}");
        stringBuilder.append(string + ");");
        return stringBuilder.toString();
    }

    public void undoChanges(GameGraphChanges<LETTER, STATE> gameGraphChanges) {
        Object object;
        Object object222;
        Object object2;
        Triple triple22;
        if (gameGraphChanges == null) {
            return;
        }
        NestedMap2<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>, GameGraphChangeType> nestedMap2 = gameGraphChanges.getChangedEdges();
        for (Triple triple22 : nestedMap2.entrySet()) {
            Vertex object52 = (Vertex)triple22.getFirst();
            Vertex vertex = (Vertex)triple22.getSecond();
            object2 = (GameGraphChangeType)((Object)triple22.getThird());
            if (object2.equals((Object)GameGraphChangeType.ADDITION)) {
                this.removeEdge(object52, vertex);
                continue;
            }
            if (!object2.equals((Object)GameGraphChangeType.REMOVAL)) continue;
            this.addEdge(object52, vertex);
        }
        triple22 = gameGraphChanges.getChangedPushOverEdges();
        for (Object object222 : triple22.entrySet()) {
            Vertex vertex = (Vertex)object222.getFirst();
            object2 = (Vertex)object222.getSecond();
            object = (GameGraphChangeType)((Object)object222.getThird());
            if (object.equals((Object)GameGraphChangeType.ADDITION)) {
                this.removePushOverEdge(vertex, (Vertex<LETTER, STATE>)object2);
                continue;
            }
            if (!object.equals((Object)GameGraphChangeType.REMOVAL)) continue;
            this.addPushOverEdge(vertex, (Vertex<LETTER, STATE>)object2);
        }
        object222 = gameGraphChanges.getChangedVertices();
        for (Map.Entry entry : ((HashMap)object222).entrySet()) {
            object2 = (Vertex)entry.getKey();
            object = (GameGraphChangeType)((Object)entry.getValue());
            if (object.equals((Object)GameGraphChangeType.ADDITION)) {
                if (((Vertex)object2).isDuplicatorVertex()) {
                    this.removeDuplicatorVertex((DuplicatorVertex)object2);
                    continue;
                }
                if (!((Vertex)object2).isSpoilerVertex()) continue;
                this.removeSpoilerVertex((SpoilerVertex)object2);
                continue;
            }
            if (!object.equals((Object)GameGraphChangeType.REMOVAL)) continue;
            if (((Vertex)object2).isDuplicatorVertex()) {
                this.addDuplicatorVertex((DuplicatorVertex)object2);
                continue;
            }
            if (!((Vertex)object2).isSpoilerVertex()) continue;
            this.addSpoilerVertex((SpoilerVertex)object2);
        }
        HashMap<Vertex<LETTER, STATE>, VertexValueContainer> hashMap = gameGraphChanges.getRememberedVertexValues();
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (Vertex)entry.getKey();
            VertexValueContainer vertexValueContainer = (VertexValueContainer)entry.getValue();
            if (VertexValueContainer.isValueValid(vertexValueContainer.getProgressMeasure())) {
                ((Vertex)object).setPM(vertexValueContainer.getProgressMeasure());
            }
            if (VertexValueContainer.isValueValid(vertexValueContainer.getBestNeighborMeasure())) {
                ((Vertex)object).setBEff(vertexValueContainer.getBestNeighborMeasure());
            }
            if (!VertexValueContainer.isValueValid(vertexValueContainer.getNeighborCounter())) continue;
            ((Vertex)object).setC(vertexValueContainer.getNeighborCounter());
        }
    }

    public void verifyAutomatonValidity(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        if (!NestedWordAutomataUtils.isFiniteAutomaton(iNestedWordAutomaton)) {
            throw new IllegalArgumentException("The inputed automaton is no Buechi-automaton. It must have an empty call and return alphabet.");
        }
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    protected IProgressAwareTimer getProgressTimer() {
        return this.mProgressTimer;
    }

    protected SimulationPerformance getSimulationPerformance() {
        return this.mPerformance;
    }

    protected IMergeStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    protected void setGlobalInfinity(int n) {
        this.mGlobalInfinity = n;
    }
}

