/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.ASimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import java.util.Set;

public class DirectSimulation<LETTER, STATE>
extends ASimulation<LETTER, STATE> {
    private final AGameGraph<LETTER, STATE> mGame;

    public DirectSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, AGameGraph<LETTER, STATE> aGameGraph) throws AutomataOperationCanceledException {
        super(iProgressAwareTimer, iLogger, bl, iStateFactory, SimulationOrMinimizationType.DIRECT);
        aGameGraph.setSimulationPerformance(this.getSimulationPerformance());
        this.mGame = aGameGraph;
    }

    @Override
    protected int calcBestNghbMeasure(Vertex<LETTER, STATE> vertex, int n, Set<Vertex<LETTER, STATE>> set) {
        if (vertex.isSpoilerVertex() && !this.getGameGraph().hasSuccessors(vertex)) {
            return this.getGameGraph().getGlobalInfinity();
        }
        return super.calcBestNghbMeasure(vertex, n, set);
    }

    @Override
    protected AGameGraph<LETTER, STATE> getGameGraph() {
        return this.mGame;
    }
}

