/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.GetRandomDfa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReduceBuchiFairSimulation<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final INestedWordAutomaton<LETTER, STATE> mResult;
    private final FairSimulation<LETTER, STATE> mSimulation;
    private final SimulationPerformance mStatistics;
    private final boolean mUseSCCs;

    public ReduceBuchiFairSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, false, Collections.emptyList(), false);
    }

    public ReduceBuchiFairSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, bl, Collections.emptyList(), false);
    }

    public ReduceBuchiFairSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl, Collection<Set<STATE>> collection) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, bl, collection, false);
    }

    public ReduceBuchiFairSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl, Collection<Set<STATE>> collection, boolean bl2) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, bl, bl2, new FairSimulation<LETTER, STATE>(automataLibraryServices.getProgressAwareTimer(), automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID), bl, iMinimizationStateFactory, collection, new FairGameGraph<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, automataLibraryServices.getProgressAwareTimer(), automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID), iNestedWordAutomaton)));
    }

    protected ReduceBuchiFairSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl, boolean bl2, FairSimulation<LETTER, STATE> fairSimulation) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.mUseSCCs = bl;
        this.mLogger.info((Object)this.startMessage());
        this.mLogger.debug((Object)"Starting generation of Fair Game Graph...");
        fairSimulation.getGameGraph().generateGameGraphFromAutomaton();
        this.mSimulation = fairSimulation;
        fairSimulation.doSimulation();
        this.mResult = this.mSimulation.getResult();
        super.directResultConstruction(this.mResult);
        this.mStatistics = fairSimulation.getSimulationPerformance();
        if (bl2) {
            this.mLogger.info((Object)"Start testing correctness of operation deeply...");
            boolean bl3 = ReduceBuchiFairSimulation.checkOperationDeep(this, false, true);
            if (bl3) {
                this.mLogger.info((Object)"End testing correctness of operation deeply, it is not correct.");
            } else {
                this.mLogger.info((Object)"End testing correctness of operation deeply, it is correct.");
            }
        }
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkBuchiEquivalence(iMinimizationCheckResultStateFactory);
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = super.getAutomataOperationStatistics();
        this.mStatistics.exportToExistingAutomataOperationStatistics(automataOperationStatistics);
        return automataOperationStatistics;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    protected AutomataLibraryServices getServices() {
        return this.mServices;
    }

    private static <LETTER, STATE> boolean checkOperationDeep(ReduceBuchiFairSimulation<LETTER, STATE> reduceBuchiFairSimulation, boolean bl, boolean bl2) throws AutomataOperationCanceledException {
        FairSimulation<LETTER, STATE> fairSimulation;
        ReduceBuchiFairSimulation<LETTER, STATE> reduceBuchiFairSimulation2;
        FairSimulation<LETTER, STATE> fairSimulation2;
        ReduceBuchiFairSimulation<LETTER, STATE> reduceBuchiFairSimulation3;
        ILogger iLogger = null;
        if (bl2) {
            iLogger = reduceBuchiFairSimulation.mLogger;
        }
        if (reduceBuchiFairSimulation.mUseSCCs) {
            reduceBuchiFairSimulation3 = reduceBuchiFairSimulation;
            fairSimulation2 = reduceBuchiFairSimulation3.mSimulation;
            if (bl) {
                ReduceBuchiFairSimulation.logMessage("Start Cross-Simulation without SCC...", iLogger);
            }
            reduceBuchiFairSimulation2 = new ReduceBuchiFairSimulation<LETTER, STATE>(reduceBuchiFairSimulation.mServices, reduceBuchiFairSimulation.mStateFactory, reduceBuchiFairSimulation.mOperand, false);
            fairSimulation = reduceBuchiFairSimulation2.mSimulation;
            if (bl) {
                ReduceBuchiFairSimulation.logMessage("", iLogger);
            }
        } else {
            if (bl) {
                ReduceBuchiFairSimulation.logMessage("Start Cross-Simulation with SCC...", iLogger);
            }
            reduceBuchiFairSimulation3 = new ReduceBuchiFairSimulation<LETTER, STATE>(reduceBuchiFairSimulation.mServices, reduceBuchiFairSimulation.mStateFactory, reduceBuchiFairSimulation.mOperand, true);
            fairSimulation2 = reduceBuchiFairSimulation3.mSimulation;
            if (bl) {
                ReduceBuchiFairSimulation.logMessage("", iLogger);
            }
            reduceBuchiFairSimulation2 = reduceBuchiFairSimulation;
            fairSimulation = reduceBuchiFairSimulation2.mSimulation;
        }
        if (bl) {
            ReduceBuchiFairSimulation.logMessage("Start comparing results...", iLogger);
        }
        boolean bl3 = false;
        FairGameGraph fairGameGraph = (FairGameGraph)fairSimulation.getGameGraph();
        Set<Vertex<LETTER, STATE>> set = fairSimulation2.getGameGraph().getVertices();
        Set<Vertex<LETTER, STATE>> set2 = fairSimulation.getGameGraph().getVertices();
        int n = fairGameGraph.getGlobalInfinity();
        if (set.size() != set2.size()) {
            ReduceBuchiFairSimulation.logMessage("SimSCC and SimNoSCC have different size: " + set.size() + " & " + set2.size(), iLogger);
            bl3 = true;
        }
        if (n != fairSimulation2.getGameGraph().getGlobalInfinity()) {
            ReduceBuchiFairSimulation.logMessage("SimSCC and SimNoSCC have different infinities: " + fairSimulation2.getGameGraph().getGlobalInfinity() + " & " + n, iLogger);
            bl3 = true;
        }
        for (Vertex<LETTER, STATE> vertex : set) {
            int n2;
            int n3;
            Vertex vertex2;
            Vertex vertex3;
            if (vertex.isSpoilerVertex()) {
                vertex3 = (SpoilerVertex)vertex;
                vertex2 = fairGameGraph.getSpoilerVertex(vertex3.getQ0(), vertex3.getQ1(), false);
                if (vertex2 == null) {
                    ReduceBuchiFairSimulation.logMessage("SCCVertex unknown for nonSCC version: " + String.valueOf(vertex3), iLogger);
                    bl3 = true;
                    continue;
                }
                n3 = vertex3.getPM(null, n);
                n2 = vertex2.getPM(null, n);
                if (n3 < n && n2 >= n) {
                    ReduceBuchiFairSimulation.logMessage("SCCVertex is not infinity but nonSCC is (" + String.valueOf(vertex3) + "): " + n3 + " & " + n2, iLogger);
                    bl3 = true;
                    continue;
                }
                if (n3 < n || n2 >= n) continue;
                ReduceBuchiFairSimulation.logMessage("SCCVertex is infinity but nonSCC is not (" + String.valueOf(vertex3) + "): " + n3 + " & " + n2, iLogger);
                bl3 = true;
                continue;
            }
            vertex3 = (DuplicatorVertex)vertex;
            vertex2 = fairGameGraph.getDuplicatorVertex(vertex3.getQ0(), vertex3.getQ1(), ((DuplicatorVertex)vertex3).getLetter(), false);
            if (vertex2 == null) {
                ReduceBuchiFairSimulation.logMessage("SCCVertex unknown for nonSCC version: " + String.valueOf(vertex3), iLogger);
                bl3 = true;
                continue;
            }
            n3 = vertex3.getPM(null, n);
            n2 = vertex2.getPM(null, n);
            if (n3 < n && n2 >= n) {
                ReduceBuchiFairSimulation.logMessage("SCCVertex is not infinity but nonSCC is (" + String.valueOf(vertex3) + "): " + n3 + " & " + n2, iLogger);
                bl3 = true;
                continue;
            }
            if (n3 < n || n2 >= n) continue;
            ReduceBuchiFairSimulation.logMessage("SCCVertex is infinity but nonSCC is not (" + String.valueOf(vertex3) + "): " + n3 + " & " + n2, iLogger);
            bl3 = true;
        }
        try {
            if (!((Boolean)reduceBuchiFairSimulation3.checkResultHelper((IMinimizationCheckResultStateFactory)((Object)reduceBuchiFairSimulation.mStateFactory)).getFirst()).booleanValue()) {
                ReduceBuchiFairSimulation.logMessage("OperationSCC is not correct.", iLogger);
                bl3 = true;
            }
            if (!((Boolean)reduceBuchiFairSimulation2.checkResultHelper((IMinimizationCheckResultStateFactory)((Object)reduceBuchiFairSimulation.mStateFactory)).getFirst()).booleanValue()) {
                ReduceBuchiFairSimulation.logMessage("OperationNoSCC is not correct.", iLogger);
                bl3 = true;
            }
        }
        catch (AutomataLibraryException automataLibraryException) {
            automataLibraryException.printStackTrace();
        }
        if (bl3) {
            ReduceBuchiFairSimulation.logMessage("End comparing results, a problem occurred. Logging buechi...", iLogger);
            ReduceBuchiFairSimulation.logMessage(reduceBuchiFairSimulation.mOperand.toString(), iLogger);
        } else if (bl) {
            ReduceBuchiFairSimulation.logMessage("End comparing results, no problem occurred.", iLogger);
        }
        return bl3;
    }

    private static void logMessage(String string, ILogger iLogger) {
        if (iLogger != null) {
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)string);
            }
        } else {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) throws AutomataOperationCanceledException {
        ToolchainStorage toolchainStorage = new ToolchainStorage();
        StringFactory stringFactory = new StringFactory();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("a");
        hashSet.add("b");
        System.out.println("Start comparing test 'SCC vs. nonSCC' with 100 random automata (n=50, k=20, f=10, totPerc=5)...");
        int n = 1;
        while (n <= 100) {
            if (n % 10 == 0) {
                System.out.println("\tWorked " + n + " automata");
            }
            Object object = new GetRandomDfa(new AutomataLibraryServices((IUltimateServiceProvider)toolchainStorage), 50, 20, 10, 5, 0L, true, false, false, false).getResult();
            ReduceBuchiFairSimulation reduceBuchiFairSimulation = new ReduceBuchiFairSimulation(new AutomataLibraryServices((IUltimateServiceProvider)toolchainStorage), stringFactory, object);
            boolean bl = false;
            bl = ReduceBuchiFairSimulation.checkOperationDeep(reduceBuchiFairSimulation, false, false);
            if (bl) break;
            ++n;
        }
        System.out.println("Program terminated.");
    }
}

