/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.language.settings.providers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ICListenerAgent;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.language.settings.providers.CompileCommand;
import org.eclipse.cdt.managedbuilder.internal.language.settings.providers.Messages;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CompilationDatabaseParser
extends LanguageSettingsSerializableProvider
implements ICListenerAgent,
ILanguageSettingsEditableProvider {
    public static final String JOB_FAMILY_COMPILATION_DATABASE_PARSER = "org.eclipse.cdt.managedbuilder.internal.language.settings.providers.CompilationDatabaseParser";
    private static final String ATTR_CDB_PATH = "cdb-path";
    private static final String ATTR_BUILD_PARSER_ID = "build-parser-id";
    private static final String ATTR_CDB_MODIFIED_TIME = "cdb-modified-time";
    private static final String ATTR_EXCLUDE_FILES = "exclude-files";

    public String getCompilationDataBasePathProperty() {
        return this.getProperty(ATTR_CDB_PATH);
    }

    public String resolveCompilationDataBasePath(ICConfigurationDescription cfgDescription) throws CoreException {
        ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
        String compilationDataBasePath = varManager.resolveValue(this.getCompilationDataBasePathProperty(), "", null, cfgDescription);
        if (Files.isDirectory(Paths.get(compilationDataBasePath, new String[0]), new LinkOption[0]) || !Files.isReadable(Paths.get(compilationDataBasePath, new String[0]))) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", MessageFormat.format(Messages.CompilationDatabaseParser_CDBNotFound, this.getCompilationDataBasePathProperty())));
        }
        return compilationDataBasePath;
    }

    public void setCompilationDataBasePathProperty(String compilationDataBasePathProperty) {
        this.setProperty(ATTR_CDB_PATH, compilationDataBasePathProperty);
    }

    public void setExcludeFiles(boolean selection) {
        this.setPropertyBool(ATTR_EXCLUDE_FILES, selection);
    }

    public boolean getExcludeFiles() {
        return this.getPropertyBool(ATTR_EXCLUDE_FILES);
    }

    public void setBuildParserId(String parserId) {
        this.setProperty(ATTR_BUILD_PARSER_ID, parserId);
    }

    public String getBuildParserId() {
        return this.getProperty(ATTR_BUILD_PARSER_ID);
    }

    public Long getCDBModifiedTime(String cdbPath) throws IOException {
        FileTime lastModifiedTime = Files.getLastModifiedTime(Paths.get(cdbPath, new String[0]), new LinkOption[0]);
        return lastModifiedTime.toMillis();
    }

    public void registerListener(ICConfigurationDescription cfgDescription) {
        this.unregisterListener();
        try {
            this.processCompileCommandsFile(null, cfgDescription);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    public void unregisterListener() {
    }

    public boolean processCompileCommandsFile(IProgressMonitor monitor, ICConfigurationDescription cfgDescription) throws CoreException {
        AbstractBuildCommandParser outputParser;
        Long cdbModifiedTime;
        if (cfgDescription.isReadOnly()) {
            this.scheduleOnWritableCfgDescription(cfgDescription);
            return false;
        }
        if (!cfgDescription.equals(cfgDescription.getProjectDescription().getDefaultSettingConfiguration())) {
            return false;
        }
        if (this.getCompilationDataBasePathProperty().isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.CompilationDatabaseParser_CDBNotConfigured));
        }
        String cdbPath = this.resolveCompilationDataBasePath(cfgDescription);
        try {
            if (!this.getProperty(ATTR_CDB_MODIFIED_TIME).isEmpty() && this.getProperty(ATTR_CDB_MODIFIED_TIME).equals(this.getCDBModifiedTime(cdbPath).toString())) {
                return false;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.CompilationDatabaseParser_ErrorProcessingCompilationDatabase, (Throwable)e));
        }
        if (this.getBuildParserId().isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", MessageFormat.format(Messages.CompilationDatabaseParser_BuildCommandParserNotConfigured, cdbPath)));
        }
        if (!this.isEmpty()) {
            this.clear();
        }
        try {
            cdbModifiedTime = this.getCDBModifiedTime(cdbPath);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.CompilationDatabaseParser_ErrorProcessingCompilationDatabase, (Throwable)e));
        }
        int totalTicks = this.getExcludeFiles() ? 100 : 60;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalTicks);
        subMonitor.subTask(Messages.CompilationDatabaseParser_ProgressParsingJSONFile);
        subMonitor.split(5);
        CompileCommand[] compileCommands = null;
        try {
            Throwable throwable = null;
            Object var9_13 = null;
            try (FileReader reader = new FileReader(cdbPath);){
                Gson gson = new Gson();
                compileCommands = (CompileCommand[])gson.fromJson((Reader)reader, CompileCommand[].class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.CompilationDatabaseParser_ErrorProcessingCompilationDatabase, (Throwable)e));
        }
        if (compileCommands == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.CompilationDatabaseParser_ErrorProcessingCompilationDatabase, (Throwable)new NullPointerException(Messages.CompilationDatabaseParser_StillNull)));
        }
        try {
            outputParser = this.getBuildCommandParser(cfgDescription, this.getBuildParserId());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", Messages.CompilationDatabaseParser_ErrorProcessingCompilationDatabase, (Throwable)e));
        }
        CDBWorkingDirectoryTracker workingDirectoryTracker = new CDBWorkingDirectoryTracker();
        SubMonitor parseCmdsMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.split(50), (int)compileCommands.length);
        outputParser.startup(cfgDescription, workingDirectoryTracker);
        int i = 0;
        while (i < compileCommands.length) {
            String command;
            File file;
            CompileCommand c = compileCommands[i];
            if (i % 100 == 0) {
                parseCmdsMonitor.subTask(String.format(Messages.CompilationDatabaseParser_ProgressParsingBuildCommands, i, compileCommands.length));
            }
            String dir = c.getDirectory();
            workingDirectoryTracker.setCurrentDirectory(null);
            if (dir != null && (file = new File(dir)).exists()) {
                workingDirectoryTracker.setCurrentDirectory(file.toURI());
            }
            if ((command = c.getCommand()) != null) {
                outputParser.processLine(command);
            } else if (c.getArguments() != null) {
                outputParser.processLine(String.join((CharSequence)" ", c.getArguments()));
            }
            parseCmdsMonitor.worked(1);
            ++i;
        }
        LanguageSettingsStorage storage = outputParser.copyStorage();
        SubMonitor entriesMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.split(5), (int)storage.getLanguages().size());
        entriesMonitor.subTask(Messages.CompilationDatabaseParser_ProgressApplyingEntries);
        for (String language : storage.getLanguages()) {
            SubMonitor langMonitor = entriesMonitor.split(1);
            Set resourcePaths = storage.getResourcePaths(language);
            SubMonitor langEntriesMonitor = SubMonitor.convert((IProgressMonitor)langMonitor, (int)resourcePaths.size());
            for (String resourcePath : resourcePaths) {
                IFile file = cfgDescription.getProjectDescription().getProject().getFile((IPath)new Path(resourcePath));
                if (file.exists()) {
                    List settingEntries = storage.getSettingEntries(resourcePath, language);
                    this.setSettingEntries(cfgDescription, (IResource)file, language, settingEntries);
                }
                langEntriesMonitor.worked(1);
            }
        }
        if (this.getExcludeFiles()) {
            this.excludeFiles(cfgDescription, subMonitor);
        }
        this.setProperty(ATTR_CDB_MODIFIED_TIME, cdbModifiedTime.toString());
        this.touchProjectDes(cfgDescription.getProjectDescription());
        return true;
    }

    private void scheduleOnWritableCfgDescription(final ICConfigurationDescription cfgDescription) {
        WorkspaceJob job = new WorkspaceJob(Messages.CompilationDatabaseParser_Job){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IProject project = cfgDescription.getProjectDescription().getProject();
                if (!project.isAccessible()) {
                    return Status.CANCEL_STATUS;
                }
                ICProjectDescription projectDescription = CCorePlugin.getDefault().getCoreModel().getProjectDescription(project.getProject(), true);
                ICConfigurationDescription writableCfg = projectDescription.getConfigurationById(cfgDescription.getId());
                if (!(writableCfg instanceof ILanguageSettingsProvidersKeeper)) {
                    return Status.CANCEL_STATUS;
                }
                CompilationDatabaseParser parser = null;
                List settingProviders = ((ILanguageSettingsProvidersKeeper)writableCfg).getLanguageSettingProviders();
                for (ILanguageSettingsProvider languageSettingsProvider : settingProviders) {
                    if (!languageSettingsProvider.getId().equals(CompilationDatabaseParser.this.getId()) || !(languageSettingsProvider instanceof CompilationDatabaseParser)) continue;
                    parser = (CompilationDatabaseParser)languageSettingsProvider;
                    break;
                }
                if (parser == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    if (parser.processCompileCommandsFile(monitor, writableCfg)) {
                        CoreModel.getDefault().setProjectDescription(project.getProject(), projectDescription);
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == CompilationDatabaseParser.JOB_FAMILY_COMPILATION_DATABASE_PARSER;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private void excludeFiles(ICConfigurationDescription cfgDescription, SubMonitor subMonitor) throws CoreException {
        final ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(cfgDescription.getProjectDescription().getProject());
        final int[] sourceFilesCount = new int[1];
        cProject.getProject().accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (CoreModel.isValidSourceUnitName((IProject)cProject.getProject(), (String)proxy.getName())) {
                    sourceFilesCount[0] = sourceFilesCount[0] + 1;
                }
                return true;
            }
        }, 2, 0);
        SubMonitor sourceMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.split(35), (int)sourceFilesCount[0]);
        ExcludeSourceFilesVisitor sourceFileVisitor = new ExcludeSourceFilesVisitor((IProgressMonitor)sourceMonitor, sourceFilesCount[0], cfgDescription);
        cProject.accept((ICElementVisitor)sourceFileVisitor);
        ICSourceEntry[] sourceEntries = sourceFileVisitor.getSourceEntries();
        subMonitor.split(5);
        if (sourceEntries != null) {
            cfgDescription.setSourceEntries(sourceEntries);
        }
    }

    private void touchProjectDes(ICProjectDescription desc) {
        QualifiedName TOUCH_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "touch-project");
        desc.setSessionProperty(TOUCH_PROPERTY, (Object)"");
        desc.setSessionProperty(TOUCH_PROPERTY, null);
    }

    private AbstractBuildCommandParser getBuildCommandParser(ICConfigurationDescription cfgDesc, String id) throws CloneNotSupportedException {
        ICConfigurationDescription configurationDescription = cfgDesc;
        if (configurationDescription instanceof ILanguageSettingsProvidersKeeper) {
            List settingProviders = ((ILanguageSettingsProvidersKeeper)configurationDescription).getLanguageSettingProviders();
            for (ILanguageSettingsProvider languageSettingsProvider : settingProviders) {
                AbstractBuildCommandParser buildParser;
                if (!(languageSettingsProvider instanceof AbstractBuildCommandParser) || !(languageSettingsProvider instanceof ILanguageSettingsEditableProvider) || !(buildParser = (AbstractBuildCommandParser)languageSettingsProvider).getId().equals(id)) continue;
                return (AbstractBuildCommandParser)((ILanguageSettingsEditableProvider)buildParser).clone();
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.CompilationDatabaseParser_BuildCommandParserNotFound, id, cfgDesc.getName()));
    }

    public boolean isEmpty() {
        return this.getProperty(ATTR_CDB_MODIFIED_TIME).isEmpty() && super.isEmpty();
    }

    public void clear() {
        super.clear();
        this.setProperty(ATTR_CDB_MODIFIED_TIME, null);
    }

    public CompilationDatabaseParser cloneShallow() throws CloneNotSupportedException {
        CompilationDatabaseParser clone = (CompilationDatabaseParser)super.cloneShallow();
        clone.setProperty(ATTR_CDB_MODIFIED_TIME, null);
        return clone;
    }

    public CompilationDatabaseParser clone() throws CloneNotSupportedException {
        return (CompilationDatabaseParser)super.clone();
    }

    private static class CDBWorkingDirectoryTracker
    implements IWorkingDirectoryTracker {
        URI currentDirectory = null;

        private CDBWorkingDirectoryTracker() {
        }

        public URI getWorkingDirectoryURI() {
            return this.currentDirectory;
        }

        public void setCurrentDirectory(URI currentDirectory) {
            this.currentDirectory = currentDirectory;
        }
    }

    private final class ExcludeSourceFilesVisitor
    implements ICElementVisitor {
        private final ICConfigurationDescription cfgDescription;
        ICSourceEntry[] entries = null;
        private final IProgressMonitor monitor;
        private final int sourceFilesCount;
        private int nbChecked = 0;
        private Stack<FolderExclusionInfo> folderExclusionInfos = new Stack();

        private ExcludeSourceFilesVisitor(IProgressMonitor monitor, int sourceFilesCount, ICConfigurationDescription cfgDescription) {
            this.monitor = monitor;
            this.sourceFilesCount = sourceFilesCount;
            this.cfgDescription = cfgDescription;
            this.entries = cfgDescription.getSourceEntries();
        }

        public ICSourceEntry[] getSourceEntries() {
            return this.entries;
        }

        public boolean visit(ICElement element) throws CoreException {
            int elementType = element.getElementType();
            if (elementType != 60) {
                boolean isSourceContainer;
                boolean bl = isSourceContainer = elementType == 12 || elementType == 11;
                if (isSourceContainer) {
                    this.folderExclusionInfos.push(new FolderExclusionInfo());
                }
                return isSourceContainer;
            }
            ITranslationUnit tu = (ITranslationUnit)element;
            if (tu.isSourceUnit()) {
                this.handleTranslationUnit(tu);
            }
            return false;
        }

        private void handleTranslationUnit(ITranslationUnit tu) throws CoreException {
            FolderExclusionInfo folderInfo = this.folderExclusionInfos.peek();
            List list = CompilationDatabaseParser.this.getSettingEntries(this.cfgDescription, tu.getResource(), tu.getLanguage().getId());
            if (list == null) {
                folderInfo.excludedSourceFiles.add(tu.getResource().getFullPath());
            } else {
                folderInfo.allFilesExcluded = false;
            }
            this.monitor.worked(1);
            if (this.nbChecked % 100 == 0) {
                this.monitor.subTask(String.format(Messages.CompilationDatabaseParser_ProgressExcludingFiles, this.nbChecked, this.sourceFilesCount));
            }
            ++this.nbChecked;
        }

        public void leave(ICElement element) throws CoreException {
            int elementType = element.getElementType();
            if (elementType == 12 || elementType == 11) {
                FolderExclusionInfo folderInfo = this.folderExclusionInfos.pop();
                if (folderInfo.allFilesExcluded && !this.folderExclusionInfos.isEmpty()) {
                    this.folderExclusionInfos.peek().childrenFoldersWithAllFilesExcluded.add(element.getPath());
                } else {
                    if (!this.folderExclusionInfos.isEmpty()) {
                        this.folderExclusionInfos.peek().allFilesExcluded = false;
                    }
                    for (IPath excludedFolder : folderInfo.childrenFoldersWithAllFilesExcluded) {
                        this.entries = CDataUtil.setExcluded((IPath)excludedFolder, (boolean)true, (boolean)true, (ICSourceEntry[])this.entries);
                    }
                    for (IPath excludedFile : folderInfo.excludedSourceFiles) {
                        this.entries = CDataUtil.setExcluded((IPath)excludedFile, (boolean)false, (boolean)true, (ICSourceEntry[])this.entries);
                    }
                }
            }
        }

        private class FolderExclusionInfo {
            private ArrayList<IPath> childrenFoldersWithAllFilesExcluded = new ArrayList();
            private ArrayList<IPath> excludedSourceFiles = new ArrayList();
            private boolean allFilesExcluded = true;

            private FolderExclusionInfo() {
            }
        }
    }
}

