/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.mcr.IInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.McrTraceCheckResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.AutomatonFreeRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpTcStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IIpAbStrategyModule;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.Mcr;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TraceAbstractionRefinementEngine;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StrategyModuleMcr<L extends IIcfgTransition<?>>
implements IIpTcStrategyModule<Mcr<L>, L>,
IIpAbStrategyModule<L>,
Mcr.IMcrResultProvider<L> {
    private final ILogger mLogger;
    private final TaCheckAndRefinementPreferences<?> mPrefs;
    private final StrategyFactory<L> mStrategyFactory;
    private final IPredicateUnifier mPredicateUnifier;
    private Mcr<L> mMcr;
    private final IEmptyStackStateFactory<IPredicate> mEmptyStackFactory;
    private IIpAbStrategyModule.IpAbStrategyModuleResult<L> mAutomatonResult;
    private final List<L> mCounterexample;
    private final IAutomaton<L, IPredicate> mAbstraction;
    private final TaskIdentifier mTaskIdentifier;
    private final IInterpolantProvider<L> mInterpolantProvider;
    private final List<QualifiedTracePredicates> mUsedPredicates;
    private final IUltimateServiceProvider mServices;
    private IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> mAfeResult;

    public StrategyModuleMcr(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, IPredicateUnifier iPredicateUnifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, StrategyFactory<L> strategyFactory, Word<L> word, IAutomaton<L, IPredicate> iAutomaton, TaskIdentifier taskIdentifier, IInterpolantProvider<L> iInterpolantProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mPrefs = taCheckAndRefinementPreferences;
        this.mStrategyFactory = strategyFactory;
        this.mLogger = iLogger;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mEmptyStackFactory = iEmptyStackStateFactory;
        this.mCounterexample = word.asList();
        this.mAbstraction = iAutomaton;
        this.mTaskIdentifier = taskIdentifier;
        this.mInterpolantProvider = iInterpolantProvider;
        this.mUsedPredicates = new ArrayList<QualifiedTracePredicates>();
    }

    public Script.LBool isCorrect() {
        return this.getOrConstruct().isCorrect();
    }

    public boolean providesRcfgProgramExecution() {
        return this.getOrConstruct().providesRcfgProgramExecution();
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        return this.getOrConstruct().getRcfgProgramExecution();
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return this.getOrConstruct().getTraceCheckReasonUnknown();
    }

    public IHoareTripleChecker getHoareTripleChecker() {
        this.getOrConstruct();
        return this.mAfeResult.getHoareTripleChecker();
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public void aggregateStatistics(RefinementEngineStatisticsGenerator refinementEngineStatisticsGenerator) {
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.getOrConstruct().getInterpolantComputationStatus();
    }

    public Collection<QualifiedTracePredicates> getPerfectInterpolantSequences() {
        Mcr<L> mcr = this.getOrConstruct();
        if (mcr.isPerfectSequence()) {
            return Collections.singleton(new QualifiedTracePredicates(mcr.getIpp(), mcr.getClass(), true));
        }
        return Collections.emptyList();
    }

    public Collection<QualifiedTracePredicates> getImperfectInterpolantSequences() {
        Mcr<L> mcr = this.getOrConstruct();
        if (!mcr.isPerfectSequence()) {
            return Collections.singleton(new QualifiedTracePredicates(mcr.getIpp(), mcr.getClass(), false));
        }
        return Collections.emptyList();
    }

    public Mcr<L> getOrConstruct() {
        if (this.mMcr == null) {
            try {
                this.mMcr = new Mcr<L>(this.mServices, this.mLogger, this.mPrefs, this.mPredicateUnifier, this.mEmptyStackFactory, this.mCounterexample, this.mAbstraction.getAlphabet(), this, this.mInterpolantProvider);
            }
            catch (AutomataLibraryException automataLibraryException) {
                throw new RuntimeException(automataLibraryException);
            }
        }
        return this.mMcr;
    }

    @Override
    public IIpAbStrategyModule.IpAbStrategyModuleResult<L> buildInterpolantAutomaton(List<QualifiedTracePredicates> list, List<QualifiedTracePredicates> list2) throws AutomataOperationCanceledException {
        if (this.mAutomatonResult == null) {
            this.mAutomatonResult = new IIpAbStrategyModule.IpAbStrategyModuleResult<L>(this.mMcr.getAutomaton(), this.mUsedPredicates);
        }
        return this.mAutomatonResult;
    }

    @Override
    public McrTraceCheckResult<L> getResult(Word<L> word) {
        TraceAbstractionPreferenceInitializer.RefinementStrategy refinementStrategy = this.mPrefs.getMcrRefinementStrategy();
        if (refinementStrategy == TraceAbstractionPreferenceInitializer.RefinementStrategy.MCR) {
            throw new IllegalStateException("MCR cannot used with MCR as internal strategy.");
        }
        TraceAbstractionRefinementEngine.ITARefinementStrategy<L> iTARefinementStrategy = this.mStrategyFactory.constructStrategy(this.mServices, new Counterexample(word), this.mAbstraction, this.mTaskIdentifier, this.mEmptyStackFactory, this.mPredicateUnifier, this.mPredicateUnifier.getTruePredicate(), this.mPredicateUnifier.getFalsePredicate(), refinementStrategy);
        AutomatonFreeRefinementEngine automatonFreeRefinementEngine = new AutomatonFreeRefinementEngine(this.mServices, this.mLogger, iTARefinementStrategy);
        List list = word.asList();
        RefinementEngineStatisticsGenerator refinementEngineStatisticsGenerator = automatonFreeRefinementEngine.getRefinementEngineStatistics();
        this.mAfeResult = automatonFreeRefinementEngine.getResult();
        Script.LBool lBool = this.mAfeResult.getCounterexampleFeasibility();
        if (lBool != Script.LBool.UNSAT) {
            return McrTraceCheckResult.constructFeasibleResult((List)list, (Script.LBool)lBool, (IStatisticsDataProvider)refinementEngineStatisticsGenerator, (IProgramExecution)this.mAfeResult.getIcfgProgramExecution());
        }
        Collection collection = (Collection)this.mAfeResult.getInfeasibilityProof();
        this.mUsedPredicates.addAll(collection);
        return McrTraceCheckResult.constructInfeasibleResult((List)list, (Collection)collection, (IStatisticsDataProvider)refinementEngineStatisticsGenerator);
    }
}

