/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import java.util.ArrayDeque;
import java.util.Deque;

public class ExpressionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>> {
    private final Deque<Evaluator<VALUE, STATE>> mEvaluators = new ArrayDeque<Evaluator<VALUE, STATE>>();
    private Evaluator<VALUE, STATE> mRootEvaluator = null;

    public void addEvaluator(Evaluator<VALUE, STATE> evaluator) {
        if (this.mEvaluators.isEmpty()) {
            if (this.mRootEvaluator != null) {
                throw new UnsupportedOperationException("The root evaluator is not empty.");
            }
            this.mEvaluators.push(evaluator);
            this.mRootEvaluator = evaluator;
        } else if (this.mEvaluators.peek().hasFreeOperands()) {
            this.mEvaluators.peek().addSubEvaluator(evaluator);
            if (evaluator.hasFreeOperands()) {
                this.mEvaluators.push(evaluator);
            }
        }
        while (!this.mEvaluators.isEmpty()) {
            if (this.mEvaluators.peek().hasFreeOperands()) break;
            this.mEvaluators.pop();
        }
    }

    public Evaluator<VALUE, STATE> getRootEvaluator() {
        return this.mRootEvaluator;
    }

    public boolean isEmpty() {
        return this.mEvaluators.isEmpty();
    }

    public boolean isFinished() {
        return this.isEmpty() && this.mRootEvaluator != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mRootEvaluator);
        if (!this.mEvaluators.isEmpty()) {
            stringBuilder.append(", Stack: ").append(this.mEvaluators);
        }
        return stringBuilder.toString();
    }
}

