/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import java.util.Collection;
import java.util.Collections;

public class SingletonBooleanExpressionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>>
extends Evaluator<VALUE, STATE> {
    private final BooleanValue mBooleanValue;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;

    public SingletonBooleanExpressionEvaluator(BooleanValue booleanValue, int n, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, EvaluatorLogger evaluatorLogger) {
        super(n, iNonrelationalValueFactory, evaluatorLogger);
        this.mBooleanValue = booleanValue;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
    }

    @Override
    public Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mNonrelationalValueFactory.createTopValue(), this.mBooleanValue));
    }

    @Override
    public Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        return Collections.singletonList(STATE);
    }

    @Override
    public boolean hasFreeOperands() {
        return false;
    }

    @Override
    public boolean containsBool() {
        return true;
    }

    public String toString() {
        return this.mBooleanValue.toString();
    }

    @Override
    public EvaluatorUtils.EvaluatorType getType() {
        return EvaluatorUtils.EvaluatorType.BOOL;
    }
}

