/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;

public class AffineExpression {
    private final Map<IProgramVarOrConst, BigDecimal> mCoefficients;
    private BigDecimal mConstant;

    public AffineExpression(Map<IProgramVarOrConst, BigDecimal> map, BigDecimal bigDecimal) {
        assert (map != null && bigDecimal != null);
        this.mCoefficients = map;
        this.mConstant = bigDecimal;
        this.removeZeroSummands();
    }

    public AffineExpression(BigDecimal bigDecimal) {
        this(new HashMap<IProgramVarOrConst, BigDecimal>(), bigDecimal);
    }

    private AffineExpression() {
        this(BigDecimal.ZERO);
    }

    private void removeZeroSummands() {
        Iterator<BigDecimal> iterator = this.mCoefficients.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().signum() != 0) continue;
            iterator.remove();
        }
    }

    public Map<IProgramVarOrConst, BigDecimal> getCoefficients() {
        return Collections.unmodifiableMap(this.mCoefficients);
    }

    public BigDecimal getCoefficient(IProgramVarOrConst iProgramVarOrConst) {
        BigDecimal bigDecimal = this.mCoefficients.get(iProgramVarOrConst);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public BigDecimal getConstant() {
        return this.mConstant;
    }

    public boolean isConstant() {
        return this.mCoefficients.isEmpty();
    }

    public AffineExpression withoutConstant() {
        return new AffineExpression(this.mCoefficients, BigDecimal.ZERO);
    }

    public AffineExpression unitCoefficientForm() {
        if (this.mCoefficients.size() == 0) {
            return this;
        }
        if (this.absCoefficientsAreEqual()) {
            BigDecimal bigDecimal2;
            BigDecimal bigDecimal3 = this.mCoefficients.values().iterator().next().abs();
            try {
                bigDecimal2 = this.mConstant.divide(bigDecimal3);
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
            HashMap<IProgramVarOrConst, BigDecimal> hashMap = new HashMap<IProgramVarOrConst, BigDecimal>();
            this.mCoefficients.forEach((iProgramVarOrConst, bigDecimal) -> {
                BigDecimal bigDecimal2 = hashMap.put((IProgramVarOrConst)iProgramVarOrConst, bigDecimal.signum() > 0 ? BigDecimal.ONE : AbsIntUtil.MINUS_ONE);
            });
            return new AffineExpression(hashMap, bigDecimal2);
        }
        return null;
    }

    private boolean absCoefficientsAreEqual() {
        BigDecimal bigDecimal = null;
        for (BigDecimal bigDecimal2 : this.mCoefficients.values()) {
            bigDecimal2 = bigDecimal2.abs();
            if (bigDecimal != null && bigDecimal2.compareTo(bigDecimal) != 0) {
                return false;
            }
            bigDecimal = bigDecimal2;
        }
        return true;
    }

    public OneVarForm getOneVarForm() {
        if (this.mCoefficients.size() != 1) {
            return null;
        }
        Map.Entry<IProgramVarOrConst, BigDecimal> entry = this.mCoefficients.entrySet().iterator().next();
        if (entry.getValue().abs().compareTo(BigDecimal.ONE) != 0) {
            return null;
        }
        OneVarForm oneVarForm = new OneVarForm();
        oneVarForm.var = entry.getKey();
        oneVarForm.negVar = entry.getValue().signum() < 0;
        oneVarForm.constant = new OctValue(this.mConstant);
        return oneVarForm;
    }

    public TwoVarForm getTwoVarForm() {
        Object object2;
        int n = this.mCoefficients.size();
        if (n < 1 || n > 2) {
            return null;
        }
        ArrayList arrayList = new ArrayList(n);
        ArrayList arrayList2 = new ArrayList(n);
        this.mCoefficients.entrySet().forEach(entry -> {
            arrayList.add((IProgramVarOrConst)entry.getKey());
            arrayList2.add((BigDecimal)entry.getValue());
        });
        if (n == 2) {
            for (Object object2 : arrayList2) {
                if (((BigDecimal)object2).abs().compareTo(BigDecimal.ONE) == 0) continue;
                return null;
            }
        } else if (((BigDecimal)arrayList2.get(0)).abs().compareTo(AbsIntUtil.TWO) != 0) {
            return null;
        }
        object2 = new TwoVarForm();
        ((TwoVarForm)object2).var1 = (IProgramVarOrConst)arrayList.get(0);
        boolean bl = ((TwoVarForm)object2).negVar1 = ((BigDecimal)arrayList2.get(0)).signum() < 0;
        if (n == 1) {
            ((TwoVarForm)object2).var2 = ((TwoVarForm)object2).var1;
            ((TwoVarForm)object2).negVar2 = ((TwoVarForm)object2).negVar1;
        } else {
            ((TwoVarForm)object2).var2 = (IProgramVarOrConst)arrayList.get(1);
            ((TwoVarForm)object2).negVar2 = ((BigDecimal)arrayList2.get(1)).signum() < 0;
        }
        ((TwoVarForm)object2).constant = new OctValue(this.mConstant);
        return object2;
    }

    public AffineExpression add(AffineExpression affineExpression) {
        AffineExpression affineExpression2 = new AffineExpression();
        affineExpression2.mConstant = this.mConstant.add(affineExpression.mConstant);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.mCoefficients.keySet());
        hashSet.addAll(affineExpression.mCoefficients.keySet());
        for (IProgramVarOrConst iProgramVarOrConst : hashSet) {
            BigDecimal bigDecimal = this.getCoefficient(iProgramVarOrConst).add(affineExpression.getCoefficient(iProgramVarOrConst));
            affineExpression2.mCoefficients.put(iProgramVarOrConst, bigDecimal);
        }
        affineExpression2.removeZeroSummands();
        return affineExpression2;
    }

    public AffineExpression subtract(AffineExpression affineExpression) {
        return this.add(affineExpression.negate());
    }

    public AffineExpression negate() {
        AffineExpression affineExpression = new AffineExpression();
        affineExpression.mConstant = this.mConstant.negate();
        for (Map.Entry<IProgramVarOrConst, BigDecimal> entry : this.mCoefficients.entrySet()) {
            affineExpression.mCoefficients.put(entry.getKey(), entry.getValue().negate());
        }
        return affineExpression;
    }

    public AffineExpression multiply(AffineExpression affineExpression) {
        AffineExpression affineExpression2;
        AffineExpression affineExpression3;
        if (this.isConstant()) {
            affineExpression3 = affineExpression;
            affineExpression2 = this;
        } else if (affineExpression.isConstant()) {
            affineExpression3 = this;
            affineExpression2 = affineExpression;
        } else {
            return null;
        }
        if (affineExpression2.mConstant.signum() == 0) {
            return new AffineExpression();
        }
        AffineExpression affineExpression4 = new AffineExpression();
        affineExpression4.mConstant = affineExpression3.mConstant.multiply(affineExpression2.mConstant);
        for (Map.Entry<IProgramVarOrConst, BigDecimal> entry : affineExpression3.mCoefficients.entrySet()) {
            BigDecimal bigDecimal = entry.getValue().multiply(affineExpression2.mConstant);
            affineExpression4.mCoefficients.put(entry.getKey(), bigDecimal);
        }
        return affineExpression4;
    }

    public AffineExpression divide(AffineExpression affineExpression, boolean bl) {
        if (affineExpression.isConstant()) {
            try {
                return this.divideByConstant(affineExpression.mConstant, bl);
            }
            catch (ArithmeticException arithmeticException) {}
        }
        return null;
    }

    private AffineExpression divideByConstant(BigDecimal bigDecimal, boolean bl) {
        if (this.isConstant()) {
            BigDecimal bigDecimal2 = bl ? AbsIntUtil.euclideanDivision(this.mConstant, bigDecimal) : this.mConstant.divide(bigDecimal);
            return new AffineExpression(bigDecimal2);
        }
        BiFunction<BigDecimal, BigDecimal, BigDecimal> biFunction = bl ? AbsIntUtil::exactDivison : BigDecimal::divide;
        AffineExpression affineExpression = new AffineExpression();
        affineExpression.mConstant = biFunction.apply(this.mConstant, bigDecimal);
        for (Map.Entry<IProgramVarOrConst, BigDecimal> entry : this.mCoefficients.entrySet()) {
            BigDecimal bigDecimal3 = biFunction.apply(entry.getValue(), bigDecimal);
            affineExpression.mCoefficients.put(entry.getKey(), bigDecimal3);
        }
        return affineExpression;
    }

    public AffineExpression modulo(AffineExpression affineExpression) {
        if (this.isConstant() && affineExpression.isConstant() && affineExpression.mConstant.signum() != 0) {
            return new AffineExpression(AbsIntUtil.euclideanModulo(this.mConstant, affineExpression.mConstant));
        }
        return null;
    }

    public int hashCode() {
        return 31 * this.mCoefficients.hashCode() + this.mConstant.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AffineExpression affineExpression = (AffineExpression)object;
        if (this.mConstant.compareTo(affineExpression.mConstant) != 0) {
            return false;
        }
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.mCoefficients.keySet());
        hashSet.addAll(affineExpression.mCoefficients.keySet());
        for (IProgramVarOrConst iProgramVarOrConst : hashSet) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = this.getCoefficient(iProgramVarOrConst);
            if (bigDecimal2.compareTo(bigDecimal = affineExpression.getCoefficient(iProgramVarOrConst)) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<IProgramVarOrConst, BigDecimal> entry : this.mCoefficients.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append('\u22c5');
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" + ");
        }
        stringBuilder.append(this.mConstant);
        return stringBuilder.toString();
    }

    public static class OneVarForm {
        public IProgramVarOrConst var;
        public boolean negVar;
        public OctValue constant;
    }

    public static class TwoVarForm {
        public IProgramVarOrConst var1;
        public IProgramVarOrConst var2;
        public boolean negVar2;
        public boolean negVar1;
        public OctValue constant;
    }
}

