/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class Axiom
extends Declaration {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Axiom.class);
    Expression formula;

    public Axiom(ILocation iLocation, Attribute[] attributeArray, Expression expression) {
        super(iLocation, attributeArray);
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Axiom: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Axiom").append('[');
        stringBuffer.append((Object)this.formula);
        return stringBuffer.append(']').toString();
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Declaration)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.formula != null) {
                this.formula.accept(generatedBoogieAstVisitor);
            }
            if (this.attributes != null) {
                Attribute[] attributeArray = this.attributes;
                int n = this.attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    Attribute attribute = attributeArray[n2];
                    attribute.accept(generatedBoogieAstVisitor);
                    ++n2;
                }
            }
        }
    }

    @Override
    public Declaration accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Declaration declaration = generatedBoogieAstTransformer.transform(this);
        if (declaration != this) {
            return declaration;
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(generatedBoogieAstTransformer);
        }
        boolean bl = false;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (this.attributes != null) {
            Attribute[] attributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                Attribute attribute2 = attribute.accept(generatedBoogieAstTransformer);
                bl = bl || attribute2 != attribute;
                arrayList.add(attribute2);
                ++n2;
            }
        }
        if (bl || this.formula != expression) {
            return new Axiom(this.loc, arrayList.toArray(new Attribute[0]), expression);
        }
        return this;
    }
}

