/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class CDD {
    public static final CDD TRUE = new CDD(null, null);
    public static final CDD FALSE = new CDD(null, null);
    public static final CDD[] TRUE_CHILDS = new CDD[]{TRUE, FALSE};
    public static final CDD[] FALSE_CHILDS = new CDD[]{FALSE, TRUE};
    private static final UnifyHash<CDD> UNIFY_HASH = new UnifyHash();
    private static final Comparator<Decision<?>> DECISION_COMPARATOR = Decision.getComparator();
    private final Decision<?> mDecision;
    private final int mDepth;
    private final CDD[] mChilds;
    private final boolean mTimed;
    private CDD mPrimeCache;

    private CDD(Decision<?> decision, CDD[] cDDArray) {
        this.mDecision = decision;
        this.mChilds = cDDArray;
        boolean bl = decision instanceof RangeDecision;
        int n = 0;
        if (cDDArray != null) {
            CDD[] cDDArray2 = cDDArray;
            int n2 = cDDArray.length;
            int n3 = 0;
            while (n3 < n2) {
                CDD cDD = cDDArray2[n3];
                n = CDD.max(n, cDD.mDepth + 1);
                bl = bl || cDD.isTimed();
                ++n3;
            }
        }
        this.mDepth = n;
        this.mTimed = bl;
    }

    private static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public int getDepth() {
        return this.mDepth;
    }

    public boolean isTimed() {
        return this.mTimed;
    }

    public static CDD create(Decision<?> decision, CDD[] cDDArray) {
        CDD cDD = new CDD(decision, cDDArray);
        int n = decision.hashCode();
        int n2 = 0;
        while (n2 < cDDArray.length) {
            n = n * (11 + n2) ^ cDDArray[n2].hashCode();
            ++n2;
        }
        for (CDD cDD2 : UNIFY_HASH.iterateHashCode(n)) {
            if (!cDD2.isEqual(cDD)) continue;
            return cDD2;
        }
        UNIFY_HASH.put(n, (Object)cDD);
        return cDD;
    }

    public boolean isEqual(CDD cDD) {
        if (this.mDecision.equals(cDD.mDecision)) {
            return Arrays.equals(this.mChilds, cDD.mChilds);
        }
        return false;
    }

    public boolean implies(CDD cDD) {
        if (this == FALSE || cDD == TRUE) {
            return true;
        }
        if (this == TRUE || cDD == FALSE) {
            return false;
        }
        int n = DECISION_COMPARATOR.compare(this.mDecision, cDD.mDecision);
        if (n < 0) {
            CDD[] cDDArray = this.mChilds;
            int n2 = this.mChilds.length;
            int n3 = 0;
            while (n3 < n2) {
                CDD cDD2 = cDDArray[n3];
                if (!cDD2.implies(cDD)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        if (n <= 0) {
            return this.mDecision.implies(cDD.mDecision, this.mChilds, cDD.mChilds);
        }
        CDD[] cDDArray = cDD.mChilds;
        int n4 = cDD.mChilds.length;
        int n5 = 0;
        while (n5 < n4) {
            CDD cDD3 = cDDArray[n5];
            if (!this.implies(cDD3)) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public CDD negate() {
        if (this.mChilds == null) {
            if (this == TRUE) {
                return FALSE;
            }
            return TRUE;
        }
        CDD[] cDDArray = new CDD[this.mChilds.length];
        int n = 0;
        while (n < this.mChilds.length) {
            cDDArray[n] = this.mChilds[n].negate();
            ++n;
        }
        return CDD.create(this.mDecision, cDDArray);
    }

    public CDD and(CDD cDD) {
        if (cDD == FALSE || this == TRUE) {
            return cDD;
        }
        if (cDD == TRUE || this == FALSE) {
            return this;
        }
        return this.and(cDD, new HashMap<CDD, Map<CDD, CDD>>());
    }

    public CDD and(CDD cDD, Map<CDD, Map<CDD, CDD>> map) {
        CDD cDD2;
        if (cDD == FALSE || this == TRUE) {
            return cDD;
        }
        if (cDD == TRUE || this == FALSE) {
            return this;
        }
        Map<CDD, CDD> map2 = map.get(this);
        if (map2 == null) {
            map2 = new HashMap<CDD, CDD>();
            map.put(this, map2);
        }
        if ((cDD2 = map2.get(cDD)) != null) {
            return cDD2;
        }
        int n = DECISION_COMPARATOR.compare(this.mDecision, cDD.mDecision);
        if (n == 0) {
            cDD2 = this.mDecision.and(cDD.mDecision, this.mChilds, cDD.mChilds, map);
        } else if (n < 0) {
            CDD[] cDDArray = new CDD[this.mChilds.length];
            int n2 = 0;
            while (n2 < this.mChilds.length) {
                cDDArray[n2] = this.mChilds[n2].and(cDD, map);
                ++n2;
            }
            cDD2 = this.mDecision.simplify(cDDArray);
        } else {
            CDD[] cDDArray = new CDD[cDD.mChilds.length];
            int n3 = 0;
            while (n3 < cDD.mChilds.length) {
                cDDArray[n3] = this.and(cDD.mChilds[n3], map);
                ++n3;
            }
            cDD2 = cDD.mDecision.simplify(cDDArray);
        }
        map2.put(cDD, cDD2);
        return cDD2;
    }

    public CDD or(CDD cDD) {
        if (cDD == FALSE || this == TRUE) {
            return this;
        }
        if (cDD == TRUE || this == FALSE) {
            return cDD;
        }
        HashMap<CDD, Map<CDD, CDD>> hashMap = new HashMap<CDD, Map<CDD, CDD>>();
        return this.or(cDD, hashMap);
    }

    public CDD or(CDD cDD, Map<CDD, Map<CDD, CDD>> map) {
        CDD cDD2;
        CDD cDD3;
        if (cDD == FALSE || this == TRUE) {
            return this;
        }
        if (cDD == TRUE || this == FALSE) {
            return cDD;
        }
        Map<CDD, CDD> map2 = map.get(this);
        if (map2 == null) {
            map2 = new HashMap<CDD, CDD>();
            map.put(this, map2);
        }
        if ((cDD3 = map2.get(cDD)) != null) {
            return cDD3;
        }
        int n = DECISION_COMPARATOR.compare(this.mDecision, cDD.mDecision);
        if (n == 0) {
            cDD2 = this.mDecision.or(cDD.mDecision, this.mChilds, cDD.mChilds, map);
        } else if (n < 0) {
            CDD[] cDDArray = new CDD[this.mChilds.length];
            var8_9 = 0;
            while (var8_9 < this.mChilds.length) {
                cDDArray[var8_9] = this.mChilds[var8_9].or(cDD, map);
                ++var8_9;
            }
            cDD2 = this.mDecision.simplify(cDDArray);
        } else {
            CDD[] cDDArray = new CDD[cDD.mChilds.length];
            var8_9 = 0;
            while (var8_9 < cDD.mChilds.length) {
                cDDArray[var8_9] = this.or(cDD.mChilds[var8_9], map);
                ++var8_9;
            }
            cDD2 = cDD.mDecision.simplify(cDDArray);
        }
        CDD cDD4 = map2.put(cDD, cDD2);
        assert (cDD4 == null);
        return cDD2;
    }

    public CDD assume(CDD cDD) {
        int n;
        CDD[] cDDArray;
        int n2;
        while (true) {
            if (this == TRUE || cDD == FALSE) {
                return TRUE;
            }
            if (this == FALSE || cDD == TRUE) {
                return this;
            }
            n2 = DECISION_COMPARATOR.compare(cDD.mDecision, this.mDecision);
            if (n2 >= 0) break;
            cDDArray = cDD.mChilds[0];
            n = 1;
            while (n < cDD.mChilds.length) {
                cDDArray = cDDArray.or(cDD.mChilds[n]);
                ++n;
            }
            cDD = cDDArray;
        }
        if (n2 == 0) {
            return this.mDecision.assume(cDD.mDecision, this.mChilds, cDD.mChilds);
        }
        cDDArray = null;
        n = 0;
        while (n < this.mChilds.length) {
            CDD cDD2 = this.mChilds[n].assume(cDD);
            if (cDDArray == null && cDD2 != this.mChilds[n]) {
                cDDArray = new CDD[this.mChilds.length];
                System.arraycopy(this.mChilds, 0, cDDArray, 0, n);
            }
            if (cDDArray != null) {
                cDDArray[n] = cDD2;
            }
            ++n;
        }
        if (cDDArray == null) {
            return this;
        }
        return this.mDecision.simplify(cDDArray);
    }

    public CDD[] toDNF() {
        if (this == TRUE) {
            return new CDD[]{this};
        }
        if (this == FALSE) {
            return new CDD[0];
        }
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        int n = 0;
        while (n < this.mChilds.length) {
            CDD[] cDDArray = this.mChilds[n].toDNF();
            if (this.childDominates(n)) {
                var7_7 = cDDArray;
                var6_6 = cDDArray.length;
                var5_5 = 0;
                while (var5_5 < var6_6) {
                    var4_4 = var7_7[var5_5];
                    if (!arrayList.contains(var4_4)) {
                        arrayList.add(var4_4);
                    }
                    ++var5_5;
                }
            } else {
                var7_7 = cDDArray;
                var6_6 = cDDArray.length;
                var5_5 = 0;
                while (var5_5 < var6_6) {
                    var4_4 = var7_7[var5_5];
                    if (this.cddDominates(n, var4_4)) {
                        if (!arrayList.contains(var4_4)) {
                            arrayList.add(var4_4);
                        }
                    } else {
                        Object[] objectArray = new CDD[this.mChilds.length];
                        Arrays.fill(objectArray, FALSE);
                        objectArray[n] = var4_4;
                        CDD cDD = CDD.create(this.mDecision, (CDD[])objectArray);
                        if (!arrayList.contains(cDD)) {
                            arrayList.add(cDD);
                        }
                    }
                    ++var5_5;
                }
            }
            ++n;
        }
        return arrayList.toArray(new CDD[arrayList.size()]);
    }

    public CDD toDNF_CDD() {
        CDD[] cDDArray = this.toDNF();
        CDD cDD = FALSE;
        CDD[] cDDArray2 = cDDArray;
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD2 = cDDArray2[n2];
            cDD = cDD.or(cDD2);
            ++n2;
        }
        return cDD;
    }

    public CDD[] toCNF() {
        if (this == TRUE) {
            return new CDD[0];
        }
        if (this == FALSE) {
            return new CDD[]{this};
        }
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        int n = 0;
        while (n < this.mChilds.length) {
            CDD[] cDDArray = this.mChilds[n].toCNF();
            if (this.childIsDominated(n)) {
                var7_7 = cDDArray;
                var6_6 = cDDArray.length;
                var5_5 = 0;
                while (var5_5 < var6_6) {
                    var4_4 = var7_7[var5_5];
                    if (!arrayList.contains(var4_4)) {
                        arrayList.add(var4_4);
                    }
                    ++var5_5;
                }
            } else {
                var7_7 = cDDArray;
                var6_6 = cDDArray.length;
                var5_5 = 0;
                while (var5_5 < var6_6) {
                    var4_4 = var7_7[var5_5];
                    if (this.cddIsDominated(n, var4_4)) {
                        if (!arrayList.contains(var4_4)) {
                            arrayList.add(var4_4);
                        }
                    } else {
                        Object[] objectArray = new CDD[this.mChilds.length];
                        Arrays.fill(objectArray, TRUE);
                        objectArray[n] = var4_4;
                        CDD cDD = CDD.create(this.mDecision, (CDD[])objectArray);
                        if (!arrayList.contains(cDD)) {
                            arrayList.add(cDD);
                        }
                    }
                    ++var5_5;
                }
            }
            ++n;
        }
        return arrayList.toArray(new CDD[arrayList.size()]);
    }

    public CDD toCNF_CDD() {
        CDD[] cDDArray = this.toCNF();
        CDD cDD = TRUE;
        CDD[] cDDArray2 = cDDArray;
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD2 = cDDArray2[n2];
            cDD = cDD.and(cDD2);
            ++n2;
        }
        return cDD;
    }

    public boolean childDominates(int n) {
        return this.cddDominates(n, this.mChilds[n]);
    }

    private boolean cddDominates(int n, CDD cDD) {
        int n2 = 0;
        while (n2 < this.mChilds.length) {
            if (n2 != n && !cDD.implies(this.mChilds[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean childIsDominated(int n) {
        return this.cddIsDominated(n, this.mChilds[n]);
    }

    private boolean cddIsDominated(int n, CDD cDD) {
        int n2 = 0;
        while (n2 < this.mChilds.length) {
            if (n2 != n && !this.mChilds[n2].implies(cDD)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public CDD[] getChilds() {
        return this.mChilds;
    }

    public Decision<?> getDecision() {
        return this.mDecision;
    }

    public CDD prime(Set<String> set) {
        if (this == TRUE || this == FALSE) {
            return this;
        }
        if (this.mPrimeCache != null) {
            return this.mPrimeCache;
        }
        Decision<?> decision = this.mDecision;
        CDD[] cDDArray = this.mChilds;
        CDD[] cDDArray2 = new CDD[cDDArray.length];
        int n = 0;
        while (n < cDDArray.length) {
            cDDArray2[n] = cDDArray[n].prime(set);
            ++n;
        }
        Object obj = decision.prime(set);
        this.mPrimeCache = CDD.create(obj, cDDArray2);
        return this.mPrimeCache;
    }

    public boolean isAtomic() {
        return !(this.getChilds()[0] != TRUE && this.getChilds()[0] != FALSE || this.getChilds()[1] != TRUE && this.getChilds()[1] != FALSE);
    }

    public CDD unprime(Set<String> set) {
        if (this == TRUE || this == FALSE) {
            return this;
        }
        Decision<?> decision = this.mDecision;
        CDD[] cDDArray = this.mChilds;
        CDD[] cDDArray2 = new CDD[cDDArray.length];
        int n = 0;
        while (n < cDDArray.length) {
            cDDArray2[n] = cDDArray[n].unprime(set);
            ++n;
        }
        Object obj = decision.unprime(set);
        return CDD.create(obj, cDDArray2);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        return this.toString("boogie", bl);
    }

    public String toTexString() {
        return this.toString("tex", false);
    }

    public String toSmtString() {
        return this.toString("smt", true);
    }

    public String toBoogieString() {
        return this.toString("boogie", true);
    }

    public String toUppaalString() {
        return this.toString("uppaal", true);
    }

    public String toGeneralString() {
        return this.toString("general", true);
    }

    public String toString(String string, boolean bl) {
        boolean bl2;
        String string2;
        String string3;
        Function<Integer, String> function;
        Function<CDD, String> function2;
        if (this == TRUE) {
            return "true";
        }
        if (this == FALSE) {
            return "false";
        }
        if ("tex".equalsIgnoreCase(string)) {
            function2 = cDD -> cDD.toString("tex", bl);
            function = n -> this.mDecision.toTexString((int)n);
            string3 = " \\vee ";
            string2 = " \\wedge ";
            bl2 = true;
        } else if ("uppaal".equalsIgnoreCase(string)) {
            function2 = cDD -> cDD.toString("uppaal", bl);
            function = n -> this.mDecision.toUppaalString((int)n);
            string3 = " || ";
            string2 = " &amp;&amp; ";
            bl2 = true;
        } else if ("boogie".equalsIgnoreCase(string)) {
            function2 = cDD -> cDD.toString("boogie", bl);
            function = n -> this.mDecision.toBoogieString((int)n);
            string3 = " || ";
            string2 = " && ";
            bl2 = true;
        } else if ("general".equalsIgnoreCase(string)) {
            function2 = cDD -> cDD.toString("general", bl);
            function = n -> this.mDecision.toString((int)n);
            string3 = " \u2228 ";
            string2 = " \u2227 ";
            bl2 = true;
        } else if ("smt".equalsIgnoreCase(string)) {
            function2 = cDD -> cDD.toString("smt", bl);
            function = n -> this.mDecision.toSmtString((int)n);
            string3 = "(or ";
            string2 = "(and ";
            bl2 = false;
        } else {
            throw new UnsupportedOperationException("Unknown format: " + string);
        }
        if (bl2) {
            return this.toStringInfix(function2, function, string3, string2);
        }
        return this.toStringPrefix(function2, function, string3, string2);
    }

    private String toStringPrefix(Function<CDD, String> function, Function<Integer, String> function2, String string, String string2) {
        long l = Arrays.stream(this.mChilds).filter(cDD -> cDD != FALSE).count();
        StringBuilder stringBuilder = new StringBuilder();
        if (l > 1L) {
            stringBuilder.append(string);
        }
        int n = 0;
        while (n < this.mChilds.length) {
            if (this.mChilds[n] != FALSE) {
                if (this.childDominates(n)) {
                    stringBuilder.append(function.apply(this.mChilds[n]));
                } else {
                    if (this.mChilds[n].getChilds() != null) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(function2.apply(n));
                    if (this.mChilds[n] != TRUE) {
                        stringBuilder.append(function.apply(this.mChilds[n]));
                    }
                    if (this.mChilds[n].getChilds() != null) {
                        stringBuilder.append(") ");
                    }
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private String toStringInfix(Function<CDD, String> function, Function<Integer, String> function2, String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.mChilds.length) {
            if (this.mChilds[n] != FALSE) {
                if (this.childDominates(n)) {
                    arrayList.add(function.apply(this.mChilds[n]));
                } else if (this.mChilds[n] != TRUE) {
                    arrayList.add("(" + function2.apply(n) + string2 + function.apply(this.mChilds[n]) + ")");
                } else {
                    arrayList.add(function2.apply(n));
                }
            }
            ++n;
        }
        if (arrayList.size() == 1) {
            return (String)arrayList.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = arrayList.iterator();
        stringBuilder.append("(");
        stringBuilder.append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append((String)iterator.next());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List<Pair<Decision<?>, int[]>> getDecisionsConjunction() {
        ArrayList arrayList = new ArrayList();
        CDD cDD = this;
        while (cDD.getChilds() != null) {
            Pair pair;
            int[] nArray;
            CDD[] cDDArray = cDD.getChilds();
            CDD cDD2 = cDDArray[0];
            CDD cDD3 = cDDArray[1];
            Decision<?> decision = cDD.getDecision();
            if (cDD2 == FALSE) {
                nArray = new int[]{1};
                pair = new Pair(decision, (Object)nArray);
                arrayList.add(pair);
                cDD = cDD3;
                continue;
            }
            if (cDDArray.length == 3) {
                int[] nArray2 = new int[2];
                nArray2[1] = 2;
                nArray = nArray2;
                pair = new Pair(decision, (Object)nArray);
                arrayList.add(pair);
            } else {
                nArray = new int[1];
                pair = new Pair(decision, (Object)nArray);
                arrayList.add(pair);
            }
            cDD = cDD2;
        }
        return arrayList;
    }

    public List<List<Pair<Decision<?>, int[]>>> getDecisionsDNF() {
        CDD[] cDDArray = this.toDNF();
        ArrayList arrayList = new ArrayList();
        CDD[] cDDArray2 = cDDArray;
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD = cDDArray2[n2];
            arrayList.add(cDD.getDecisionsConjunction());
            ++n2;
        }
        return arrayList;
    }
}

