/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.StaticObjectsHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.StringLiteralResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class CExpressionTranslator {
    private final MemoryHandler mMemoryHandler;
    private final StaticObjectsHandler mStaticObjectsHandler;
    private final ExpressionTranslation mExpressionTranslation;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final TypeSizes mTypeSizes;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final IMemoryPointer mMemoryPointer;
    private final CACSLPreferenceInitializer.CheckMode mPointerSubtractionAndComparisonValidityCheckMode;
    private final CACSLPreferenceInitializer.CheckMode mDivisionByZeroOfIntegerTypes;
    private final CACSLPreferenceInitializer.CheckMode mDivisionByZeroOfFloatingTypes;
    private final CACSLPreferenceInitializer.CheckMode mCheckSignedIntegerBounds;
    private final boolean mEnforceIfForConditional;

    public CExpressionTranslator(TranslationSettings translationSettings, MemoryHandler memoryHandler, ExpressionTranslation expressionTranslation, ExpressionResultTransformer expressionResultTransformer, AuxVarInfoBuilder auxVarInfoBuilder, TypeSizes typeSizes, StaticObjectsHandler staticObjectsHandler, IMemoryPointer iMemoryPointer) {
        this(memoryHandler, expressionTranslation, expressionResultTransformer, auxVarInfoBuilder, typeSizes, staticObjectsHandler, translationSettings.getPointerSubtractionAndComparisonValidityCheckMode(), translationSettings.getDivisionByZeroOfIntegerTypes(), translationSettings.getDivisionByZeroOfFloatingTypes(), translationSettings.checkSignedIntegerBounds(), translationSettings.enforceIfForConditional(), iMemoryPointer);
    }

    private CExpressionTranslator(MemoryHandler memoryHandler, ExpressionTranslation expressionTranslation, ExpressionResultTransformer expressionResultTransformer, AuxVarInfoBuilder auxVarInfoBuilder, TypeSizes typeSizes, StaticObjectsHandler staticObjectsHandler, CACSLPreferenceInitializer.CheckMode checkMode, CACSLPreferenceInitializer.CheckMode checkMode2, CACSLPreferenceInitializer.CheckMode checkMode3, CACSLPreferenceInitializer.CheckMode checkMode4, boolean bl, IMemoryPointer iMemoryPointer) {
        this.mMemoryHandler = memoryHandler;
        this.mStaticObjectsHandler = staticObjectsHandler;
        this.mExpressionTranslation = expressionTranslation;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mTypeSizes = typeSizes;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mMemoryPointer = iMemoryPointer;
        this.mPointerSubtractionAndComparisonValidityCheckMode = checkMode;
        this.mDivisionByZeroOfIntegerTypes = checkMode2;
        this.mDivisionByZeroOfFloatingTypes = checkMode3;
        this.mCheckSignedIntegerBounds = checkMode4;
        this.mEnforceIfForConditional = bl;
    }

    public ExpressionResult handleRelationalOperators(ILocation iLocation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        Expression expression;
        Object object;
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        assert (expressionResult2.getLrValue() instanceof RValue) : "no RValue";
        expressionResult = this.mExprResultTransformer.rexBoolToInt(expressionResult, iLocation);
        expressionResult2 = this.mExprResultTransformer.rexBoolToInt(expressionResult2, iLocation);
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        ICType iCType2 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        if (iCType instanceof CPrimitive && iCType2 instanceof CPointer && this.isNullPointerEquivalent((RValue)expressionResult.getLrValue())) {
            expressionResult = this.mExprResultTransformer.performImplicitConversion(expressionResult, CPointer.voidPointer(), iLocation);
            iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        } else if (iCType instanceof CPointer && iCType2 instanceof CPrimitive && this.isNullPointerEquivalent((RValue)expressionResult2.getLrValue())) {
            expressionResult2 = this.mExprResultTransformer.performImplicitConversion(expressionResult2, CPointer.voidPointer(), iLocation);
            iCType2 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
        if (iCType instanceof CPrimitive && iCType2 instanceof CPrimitive) {
            assert (iCType.isRealType() && iCType2.isRealType()) : "no real type";
            object = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
            expressionResult = (ExpressionResult)object.getFirst();
            expressionResult2 = (ExpressionResult)object.getSecond();
            expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
            expression = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, n, expressionResult.getLrValue().getValue(), (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType(), expressionResult2.getLrValue().getValue(), (CPrimitive)expressionResult2.getLrValue().getCType().getUnderlyingType());
        } else if (iCType instanceof CPointer && iCType2 instanceof CPointer) {
            object = this.mMemoryPointer.constructPointerComponentRelation(iLocation, 28, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), "base", this.mExpressionTranslation);
            expression = this.mMemoryPointer.constructPointerRelationExpression(iLocation, (Expression)object, this.mPointerSubtractionAndComparisonValidityCheckMode, this.mExpressionTranslation, n, expressionResult, expressionResult2);
            expressionResultBuilder = this.addBaseEqualityCheck(iLocation, (Expression)object, expressionResultBuilder);
        } else {
            throw new UnsupportedOperationException("unsupported " + String.valueOf(iCType) + ", " + String.valueOf(iCType2));
        }
        object = new CPrimitive(CPrimitive.CPrimitives.INT);
        RValue rValue = new RValue(expression, (ICType)object, true, false);
        return expressionResultBuilder.setLrValue(rValue).build();
    }

    public ExpressionResult handleAdditiveOperation(ILocation iLocation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        Expression expression;
        ICType iCType;
        Object object;
        Object object2;
        if (!List.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(21), Integer.valueOf(22)).contains(n)) {
            throw new AssertionError((Object)("no additive operation " + n));
        }
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        assert (expressionResult2.getLrValue() instanceof RValue) : "no RValue";
        ICType iCType2 = expressionResult.getLrValue().getCType().getUnderlyingType();
        ICType iCType3 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        if (iCType2 instanceof CArray && iCType3.isArithmeticType()) {
            object2 = ((CArray)iCType2).getValueType().getUnderlyingType();
            expressionResult = this.mExprResultTransformer.performImplicitConversion(expressionResult, new CPointer((ICType)object2), iLocation);
            iCType2 = expressionResult.getLrValue().getCType().getUnderlyingType();
        }
        if (iCType2.isArithmeticType() && iCType3.isArithmeticType()) {
            object = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
            expressionResult = (ExpressionResult)object.getFirst();
            expressionResult2 = (ExpressionResult)object.getSecond();
            object2 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
            iCType = expressionResult.getLrValue().getCType();
            assert (iCType.equals(expressionResult2.getLrValue().getCType()));
            CPrimitive cPrimitive = (CPrimitive)iCType.getUnderlyingType();
            this.addIntegerBoundsCheck(iLocation, (ExpressionResultBuilder)object2, cPrimitive, n, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue());
            expression = this.mExpressionTranslation.constructArithmeticExpression(iLocation, n, expressionResult.getLrValue().getValue(), cPrimitive, expressionResult2.getLrValue().getValue(), cPrimitive);
        } else if (iCType2 instanceof CPointer && iCType3.isArithmeticType()) {
            iCType = expressionResult.getLrValue().getCType();
            object = ((CPointer)iCType).getPointsToType();
            ExpressionResult expressionResult3 = this.mMemoryHandler.doPointerArithmeticWithConversion(n, iLocation, expressionResult.getLrValue().getValue(), (RValue)expressionResult2.getLrValue(), (ICType)object);
            object2 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
            ((ExpressionResultBuilder)object2).addAllExceptLrValue(expressionResult3);
            expression = expressionResult3.getLrValue().getValue();
            this.addOffsetInBoundsCheck(iLocation, expression, (ExpressionResultBuilder)object2);
        } else if (iCType2.isArithmeticType() && iCType3 instanceof CPointer) {
            if (n != 4 && n != 21) {
                throw new AssertionError((Object)"lType arithmetic, rType CPointer only legal if op is plus");
            }
            iCType = expressionResult2.getLrValue().getCType();
            object = ((CPointer)iCType).getPointsToType();
            ExpressionResult expressionResult4 = this.mMemoryHandler.doPointerArithmeticWithConversion(n, iLocation, expressionResult2.getLrValue().getValue(), (RValue)expressionResult.getLrValue(), (ICType)object);
            object2 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
            ((ExpressionResultBuilder)object2).addAllExceptLrValue(expressionResult4);
            expression = expressionResult4.getLrValue().getValue();
            this.addOffsetInBoundsCheck(iLocation, expression, (ExpressionResultBuilder)object2);
        } else if (iCType2 instanceof CPointer && iCType3 instanceof CPointer) {
            ICType iCType4;
            if (n != 5 && n != 22) {
                throw new AssertionError((Object)"lType arithmetic, rType CPointer only legal if op is minus");
            }
            iCType = this.mExpressionTranslation.getCTypeOfPointerComponents();
            ICType iCType5 = ((CPointer)iCType2).getPointsToType().getUnderlyingType();
            if (!iCType5.equals(iCType4 = ((CPointer)iCType3).getPointsToType().getUnderlyingType())) {
                throw new UnsupportedOperationException("incompatible pointers: pointsto " + String.valueOf(iCType5) + " " + String.valueOf(iCType4));
            }
            object = iCType5;
            object2 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
            iCType5 = this.mMemoryPointer.constructPointerComponentRelation(iLocation, 28, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), "base", this.mExpressionTranslation);
            this.addBaseEqualityCheck(iLocation, (Expression)iCType5, (ExpressionResultBuilder)object2);
            expression = this.mMemoryHandler.doPointerSubtraction(iLocation, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), (ICType)object);
        } else {
            throw new UnsupportedOperationException("non-standard case of pointer arithmetic");
        }
        object = new RValue(expression, iCType, false, false);
        ((ExpressionResultBuilder)object2).setLrValue((LRValue)object);
        if (expressionResult instanceof StringLiteralResult) {
            ((ExpressionResultBuilder)object2).getDeclarations().forEach(declaration -> this.mStaticObjectsHandler.addGlobalVarDeclarationWithoutCDeclaration((VariableDeclaration)declaration));
            this.mStaticObjectsHandler.addStatementsForUltimateInit(((ExpressionResultBuilder)object2).getStatements());
            return new StringLiteralResult(((ExpressionResultBuilder)object2).getLrValue(), ((ExpressionResultBuilder)object2).getOverappr(), ((StringLiteralResult)expressionResult).getLiteralString());
        }
        return ((ExpressionResultBuilder)object2).build();
    }

    public ExpressionResult handleUnaryArithmeticOperators(ILocation iLocation, int n, ExpressionResult expressionResult) {
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        switch (n) {
            case 7: {
                CPrimitive cPrimitive;
                Object object;
                Expression expression;
                if (!iCType.isScalarType()) {
                    throw new IllegalArgumentException("scalar type required");
                }
                if (expressionResult.getLrValue().isBoogieBool()) {
                    expression = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expressionResult.getLrValue().getValue());
                } else {
                    if (iCType instanceof CPointer) {
                        object = this.mMemoryPointer.constructNullPointer(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents());
                    } else if (iCType instanceof CEnum) {
                        cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
                        object = this.mExpressionTranslation.constructZero(iLocation, cPrimitive);
                    } else if (iCType instanceof CPrimitive) {
                        object = this.mExpressionTranslation.constructZero(iLocation, iCType);
                    } else {
                        throw new AssertionError((Object)"illegal case");
                    }
                    expression = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 28, expressionResult.getLrValue().getValue(), iCType, (Expression)object, iCType);
                }
                object = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
                cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
                RValue rValue = new RValue(expression, cPrimitive, true);
                return ((ExpressionResultBuilder)object).setLrValue(rValue).build();
            }
            case 2: {
                if (!iCType.isArithmeticType()) {
                    throw new UnsupportedOperationException("arithmetic type required");
                }
                if (iCType.isArithmeticType()) {
                    expressionResult = this.mExprResultTransformer.rexBoolToInt(expressionResult, iLocation);
                    expressionResult = this.mExprResultTransformer.promoteToIntegerIfNecessary(iLocation, expressionResult);
                }
                return expressionResult;
            }
            case 3: 
            case 6: {
                if (!iCType.isArithmeticType()) {
                    throw new UnsupportedOperationException("arithmetic type required");
                }
                expressionResult = this.mExprResultTransformer.rexBoolToInt(expressionResult, iLocation);
                expressionResult = this.mExprResultTransformer.promoteToIntegerIfNecessary(iLocation, expressionResult);
                CPrimitive cPrimitive = (CPrimitive)expressionResult.getLrValue().getCType();
                ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
                if (n == 3 && cPrimitive.isIntegerType()) {
                    this.addIntegerBoundsCheck(iLocation, expressionResultBuilder, cPrimitive, n, expressionResult.getLrValue().getValue());
                }
                Expression expression = this.mExpressionTranslation.constructUnaryExpression(iLocation, n, expressionResult.getLrValue().getValue(), cPrimitive);
                RValue rValue = new RValue(expression, cPrimitive, false);
                return expressionResultBuilder.setLrValue(rValue).build();
            }
        }
        throw new IllegalArgumentException("not a unary arithmetic operator " + n);
    }

    public ExpressionResult handleBitshiftOperation(ILocation iLocation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        if (!List.of(Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(23), Integer.valueOf(24)).contains(n)) {
            throw new AssertionError((Object)("no bitshift " + n));
        }
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        assert (expressionResult2.getLrValue() instanceof RValue) : "no RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        ICType iCType2 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        if (!iCType2.isIntegerType() || !iCType.isIntegerType()) {
            throw new UnsupportedOperationException("operands have to have integer types");
        }
        ExpressionResult expressionResult3 = this.mExprResultTransformer.promoteToIntegerIfNecessary(iLocation, expressionResult);
        CPrimitive cPrimitive = (CPrimitive)expressionResult3.getLrValue().getCType().getUnderlyingType();
        ExpressionResult expressionResult4 = this.mExprResultTransformer.promoteToIntegerIfNecessary(iLocation, expressionResult2);
        CPrimitive cPrimitive2 = (CPrimitive)expressionResult4.getLrValue().getCType().getUnderlyingType();
        ExpressionResult expressionResult5 = this.mExpressionTranslation.handleBitshiftExpression(iLocation, n, expressionResult3.getLrValue().getValue(), cPrimitive, expressionResult4.getLrValue().getValue(), cPrimitive2, this.mAuxVarInfoBuilder);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult3, expressionResult4);
        return expressionResultBuilder.addAllIncludingLrValue(expressionResult5).build();
    }

    public ExpressionResult handleMultiplicativeOperation(ILocation iLocation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        assert (expressionResult2.getLrValue() instanceof RValue) : "no RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        ICType iCType2 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        if (!iCType2.isArithmeticType() || !iCType.isArithmeticType()) {
            throw new UnsupportedOperationException("operands have to have integer types");
        }
        if (n == 2 || n == 3) {
            expressionResult2 = this.addDivisionByZeroCheck(iLocation, expressionResult2);
        }
        Pair<ExpressionResult, ExpressionResult> pair = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
        expressionResult = (ExpressionResult)pair.getFirst();
        expressionResult2 = (ExpressionResult)pair.getSecond();
        CPrimitive cPrimitive = (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType();
        assert (cPrimitive.equals(expressionResult2.getLrValue().getCType().getUnderlyingType()));
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2);
        switch (n) {
            case 1: 
            case 2: 
            case 18: 
            case 19: {
                this.addIntegerBoundsCheck(iLocation, expressionResultBuilder, cPrimitive, n, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue());
                break;
            }
            case 3: 
            case 20: {
                break;
            }
            default: {
                throw new AssertionError((Object)("no multiplicative " + n));
            }
        }
        Expression expression = this.mExpressionTranslation.constructArithmeticExpression(iLocation, n, expressionResult.getLrValue().getValue(), cPrimitive, expressionResult2.getLrValue().getValue(), cPrimitive);
        RValue rValue = new RValue(expression, cPrimitive, false, false);
        return expressionResultBuilder.setLrValue(rValue).build();
    }

    public ExpressionResult handleEqualityOperators(ILocation iLocation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        Object object;
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        assert (expressionResult2.getLrValue() instanceof RValue) : "no RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        ICType iCType2 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        if (iCType instanceof CPointer || iCType2 instanceof CPointer) {
            if (!(iCType instanceof CPointer)) {
                expressionResult = this.mExprResultTransformer.performImplicitConversion(expressionResult, CPointer.voidPointer(), iLocation);
            }
            if (!(iCType2 instanceof CPointer)) {
                expressionResult2 = this.mExprResultTransformer.performImplicitConversion(expressionResult2, CPointer.voidPointer(), iLocation);
            }
        } else if (iCType.isArithmeticType() && iCType2.isArithmeticType()) {
            object = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
            expressionResult = (ExpressionResult)object.getFirst();
            expressionResult2 = (ExpressionResult)object.getSecond();
        } else {
            throw new UnsupportedOperationException("unsupported " + String.valueOf(iCType2) + ", " + String.valueOf(iCType));
        }
        iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
        iCType2 = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, n, expressionResult.getLrValue().getValue(), expressionResult.getLrValue().getCType(), expressionResult2.getLrValue().getValue(), expressionResult2.getLrValue().getCType());
        object = new RValue((Expression)iCType2, iCType, true, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2).setLrValue((LRValue)object).build();
    }

    public ExpressionResult handleBitwiseArithmeticOperation(ILocation iLocation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        if (!List.of(Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(25), Integer.valueOf(26), Integer.valueOf(27)).contains(n)) {
            throw new AssertionError((Object)("no bitwise arithmetic operation " + n));
        }
        assert (expressionResult.getLrValue() instanceof RValue) : "no RValue";
        assert (expressionResult2.getLrValue() instanceof RValue) : "no RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        ICType iCType2 = expressionResult2.getLrValue().getCType().getUnderlyingType();
        if (!iCType2.isIntegerType() || !iCType.isIntegerType()) {
            throw new UnsupportedOperationException("operands have to have integer types");
        }
        Pair<ExpressionResult, ExpressionResult> pair = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
        expressionResult = (ExpressionResult)pair.getFirst();
        expressionResult2 = (ExpressionResult)pair.getSecond();
        CPrimitive cPrimitive = (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType();
        assert (cPrimitive.equals(expressionResult.getLrValue().getCType().getUnderlyingType()));
        ExpressionResult expressionResult3 = this.mExpressionTranslation.handleBinaryBitwiseExpression(iLocation, n, expressionResult.getLrValue().getValue(), cPrimitive, expressionResult2.getLrValue().getValue(), cPrimitive, this.mAuxVarInfoBuilder);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2).addAllIncludingLrValue(expressionResult3).build();
    }

    public Result handlePostfixIncrementAndDecrement(ILocation iLocation, int n, ExpressionResult expressionResult, IASTNode iASTNode, Function<ExpressionResult, ExpressionResult> function) {
        int n2;
        assert (!expressionResult.getLrValue().isBoogieBool());
        expressionResult = this.mExprResultTransformer.switchToRValue(expressionResult, iLocation, iASTNode);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllIncludingLrValue(expressionResult);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, expressionResult.getLrValue().getCType(), SFO.AUXVAR.POST_MOD);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{auxVarInfo.getLhs()};
        Expression[] expressionArray = new Expression[]{expressionResult.getLrValue().getValue()};
        expressionResultBuilder.addStatement((Statement)StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])leftHandSideArray, (Expression[])expressionArray));
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), iCType);
        if (n == 9) {
            n2 = 4;
        } else if (n == 10) {
            n2 = 5;
        } else {
            throw new AssertionError((Object)"no postfix");
        }
        Expression expression = this.constructXcrementedValue(iLocation, expressionResultBuilder, iCType, n2, rValue.getValue());
        expressionResultBuilder.setOrResetLrValue(new RValue(expression, iCType, false, false));
        ExpressionResult expressionResult2 = function.apply(expressionResultBuilder.build());
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult2).setLrValue(rValue).build();
    }

    public Result handlePrefixIncrementAndDecrement(int n, ILocation iLocation, ExpressionResult expressionResult, IASTNode iASTNode, Function<ExpressionResult, ExpressionResult> function) {
        int n2;
        assert (!expressionResult.getLrValue().isBoogieBool());
        expressionResult = this.mExprResultTransformer.switchToRValue(expressionResult, iLocation, iASTNode);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, expressionResult.getLrValue().getCType(), SFO.AUXVAR.PRE_MOD);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        if (n == 0) {
            n2 = 4;
        } else if (n == 1) {
            n2 = 5;
        } else {
            throw new AssertionError((Object)"no prefix");
        }
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        Expression expression = this.constructXcrementedValue(iLocation, expressionResultBuilder, iCType, n2, expressionResult.getLrValue().getValue());
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{auxVarInfo.getLhs()};
        Expression[] expressionArray = new Expression[]{expression};
        expressionResultBuilder.addStatement((Statement)StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])leftHandSideArray, (Expression[])expressionArray));
        expressionResultBuilder.setLrValue(new RValue(expression, iCType, false, false));
        ExpressionResult expressionResult2 = function.apply(expressionResultBuilder.build());
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), iCType);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult2).setLrValue(rValue).build();
    }

    public ExpressionResult handleConditionalOperator(ILocation iLocation, ExpressionResult expressionResult, ExpressionResult expressionResult2, ExpressionResult expressionResult3, IASTNode iASTNode) {
        Object object;
        ExpressionResult expressionResult4 = this.mExprResultTransformer.rexIntToBool(expressionResult, iLocation);
        ExpressionResult expressionResult5 = this.mExprResultTransformer.rexBoolToInt(expressionResult2, iLocation);
        ExpressionResult expressionResult6 = this.mExprResultTransformer.rexBoolToInt(expressionResult3, iLocation);
        if (!expressionResult4.getLrValue().getCType().isScalarType()) {
            throw new IncorrectSyntaxException(iLocation, "first operand of a conditional operator must have scalar type");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (!expressionResult5.hasLRValue() || !expressionResult6.hasLRValue()) {
            object = new RValue((Expression)ExpressionFactory.createVoidDummyExpression((ILocation)iLocation), new CPrimitive(CPrimitive.CPrimitives.VOID));
            if (!expressionResult5.hasLRValue()) {
                expressionResult5 = new ExpressionResultBuilder(expressionResult5).setLrValue((LRValue)object).build();
                bl = true;
            }
            if (!expressionResult6.hasLRValue()) {
                expressionResult6 = new ExpressionResultBuilder(expressionResult6).setLrValue((LRValue)object).build();
                bl2 = true;
            }
        }
        if (expressionResult5.getLrValue().getCType().isArithmeticType() && expressionResult6.getLrValue().getCType().isArithmeticType()) {
            Pair<ExpressionResult, ExpressionResult> pair = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult5, expressionResult6);
            expressionResult5 = (ExpressionResult)pair.getFirst();
            expressionResult6 = (ExpressionResult)pair.getSecond();
            object = expressionResult5.getLrValue().getCType();
        } else if (bl && bl2) {
            object = new CPrimitive(CPrimitive.CPrimitives.VOID);
        } else if (expressionResult5.getLrValue().isNullPointerConstant(this.mMemoryPointer) || expressionResult5.getLrValue().getCType().getUnderlyingType().isIntegerType()) {
            if (expressionResult6.getLrValue().getCType().getUnderlyingType() instanceof CPointer) {
                expressionResult5 = this.mExprResultTransformer.convertNullPointerConstantToPointer(expressionResult5, expressionResult6.getLrValue().getCType().getUnderlyingType(), iLocation);
                object = expressionResult6.getLrValue().getCType();
            } else if (expressionResult6.getLrValue().getCType().getUnderlyingType() instanceof CArray) {
                expressionResult6 = this.mExprResultTransformer.decayArrayToPointer(expressionResult6, iLocation, iASTNode);
                expressionResult5 = this.mExprResultTransformer.convertNullPointerConstantToPointer(expressionResult5, expressionResult6.getLrValue().getCType().getUnderlyingType(), iLocation);
                object = expressionResult6.getLrValue().getCType();
            } else {
                object = expressionResult6.getLrValue().getCType();
            }
        } else if (expressionResult6.getLrValue().isNullPointerConstant(this.mMemoryPointer) || expressionResult6.getLrValue().getCType().getUnderlyingType().isIntegerType()) {
            if (expressionResult5.getLrValue().getCType().getUnderlyingType() instanceof CPointer) {
                expressionResult6 = this.mExprResultTransformer.convertNullPointerConstantToPointer(expressionResult6, expressionResult5.getLrValue().getCType().getUnderlyingType(), iLocation);
                object = expressionResult5.getLrValue().getCType();
            } else if (expressionResult5.getLrValue().getCType().getUnderlyingType() instanceof CArray) {
                expressionResult5 = this.mExprResultTransformer.decayArrayToPointer(expressionResult5, iLocation, iASTNode);
                expressionResult6 = this.mExprResultTransformer.convertNullPointerConstantToPointer(expressionResult6, expressionResult5.getLrValue().getCType().getUnderlyingType(), iLocation);
                object = expressionResult5.getLrValue().getCType();
            } else {
                object = expressionResult5.getLrValue().getCType();
            }
        } else if (expressionResult5.getLrValue().getCType().getUnderlyingType() instanceof CArray && expressionResult6.getLrValue().getCType().getUnderlyingType() instanceof CArray) {
            object = new CPointer(((CArray)expressionResult5.getLrValue().getCType()).getValueType());
            expressionResult5 = this.mExprResultTransformer.decayArrayToPointer(expressionResult5, iLocation, iASTNode);
            expressionResult6 = this.mExprResultTransformer.decayArrayToPointer(expressionResult6, iLocation, iASTNode);
        } else {
            object = expressionResult5.getLrValue().getCType();
        }
        return this.constructResultForConditionalOperator(iLocation, expressionResult4, expressionResult5, expressionResult6, (ICType)object, bl, bl2);
    }

    private ExpressionResult constructResultForConditionalOperator(ILocation iLocation, ExpressionResult expressionResult, ExpressionResult expressionResult2, ExpressionResult expressionResult3, ICType iCType, boolean bl, boolean bl2) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        if (!this.mEnforceIfForConditional && expressionResult2.getStatements().isEmpty() && expressionResult3.getStatements().isEmpty()) {
            expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
            if (!iCType.isVoidType()) {
                Expression expression = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expressionResult.getLrValue().getValue(), (Expression)expressionResult2.getLrValue().getValue(), (Expression)expressionResult3.getLrValue().getValue());
                expressionResultBuilder.setLrValue(new RValue(expression, iCType));
            }
        } else {
            AuxVarInfo auxVarInfo;
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
            if (iCType.isVoidType()) {
                auxVarInfo = null;
            } else {
                auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.ITE);
                expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo).setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType));
            }
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
            CExpressionTranslator.assignAuxVar(iLocation, expressionResult2, expressionResultBuilder, auxVarInfo, arrayList, bl);
            CExpressionTranslator.assignAuxVar(iLocation, expressionResult3, expressionResultBuilder, auxVarInfo, arrayList2, bl2);
            IfStatement ifStatement = new IfStatement(iLocation, expressionResult.getLrValue().getValue(), arrayList.toArray(new Statement[arrayList.size()]), arrayList2.toArray(new Statement[arrayList2.size()]));
            for (Overapprox overapprox : expressionResultBuilder.getOverappr()) {
                overapprox.annotate((IElement)ifStatement);
            }
            expressionResultBuilder.addStatement((Statement)ifStatement);
        }
        return expressionResultBuilder.build();
    }

    private Expression constructXcrementedValue(ILocation iLocation, ExpressionResultBuilder expressionResultBuilder, ICType iCType, int n, Expression expression) {
        Expression expression2;
        assert (n == 4 || n == 5) : "has to be either minus or plus";
        if (iCType instanceof CPointer) {
            CPointer cPointer = (CPointer)iCType;
            Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ONE);
            CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
            RValue rValue = new RValue(expression3, cPrimitive);
            expression2 = this.mMemoryHandler.doPointerArithmetic(n, iLocation, expression, rValue, cPointer.getPointsToType(), cPrimitive);
            this.addOffsetInBoundsCheck(iLocation, expression2, expressionResultBuilder);
        } else if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            Expression expression4 = iCType.isFloatingType() ? this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE) : this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ONE);
            this.addIntegerBoundsCheck(iLocation, expressionResultBuilder, cPrimitive, n, expression, expression4);
            expression2 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, n, expression, cPrimitive, expression4, cPrimitive);
        } else {
            throw new IllegalArgumentException("input has to be CPointer or CPrimitive");
        }
        return expression2;
    }

    private ExpressionResult addDivisionByZeroCheck(ILocation iLocation, ExpressionResult expressionResult) {
        Expression expression;
        Expression expression2;
        CACSLPreferenceInitializer.CheckMode checkMode;
        Expression expression3 = expressionResult.getLrValue().getValue();
        CPrimitive cPrimitive = (CPrimitive)expressionResult.getLrValue().getCType();
        if (cPrimitive.isIntegerType()) {
            checkMode = this.mDivisionByZeroOfIntegerTypes;
        } else if (cPrimitive.isFloatingType()) {
            checkMode = this.mDivisionByZeroOfFloatingTypes;
        } else {
            throw new UnsupportedOperationException("cannot check division by zero for type " + String.valueOf(cPrimitive));
        }
        if (checkMode == CACSLPreferenceInitializer.CheckMode.IGNORE) {
            return expressionResult;
        }
        if (cPrimitive.isIntegerType()) {
            expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
            expression = this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 29, expression3, cPrimitive, expression2, cPrimitive);
        } else if (cPrimitive.isFloatingType()) {
            expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ZERO);
            expression = this.mExpressionTranslation.constructBinaryComparisonFloatingPointExpression(iLocation, 29, expression3, cPrimitive, expression2, cPrimitive);
        } else {
            throw new UnsupportedOperationException("cannot check division by zero for type " + String.valueOf(cPrimitive));
        }
        if (ExpressionFactory.isTrueLiteral((Expression)expression)) {
            return expressionResult;
        }
        if (checkMode == CACSLPreferenceInitializer.CheckMode.ASSUME) {
            expression2 = new AssumeStatement(iLocation, expression);
        } else if (checkMode == CACSLPreferenceInitializer.CheckMode.CHECK) {
            expression2 = new AssertStatement(iLocation, expression);
            Check check = new Check(Spec.DIVISION_BY_ZERO);
            check.annotate((IElement)expression2);
        } else {
            throw new AssertionError((Object)"illegal");
        }
        return new ExpressionResultBuilder(expressionResult).addStatement((Statement)expression2).build();
    }

    private void addIntegerBoundsCheck(ILocation iLocation, ExpressionResultBuilder expressionResultBuilder, CPrimitive cPrimitive, int n, Expression ... expressionArray) {
        Pair<Expression, Expression> pair;
        if (this.mCheckSignedIntegerBounds == CACSLPreferenceInitializer.CheckMode.IGNORE || !cPrimitive.isIntegerType() || this.mTypeSizes.isUnsigned(cPrimitive)) {
            return;
        }
        if (expressionArray.length == 1) {
            assert (n == 3);
            pair = this.mExpressionTranslation.constructOverflowCheckForUnaryExpression(iLocation, n, cPrimitive, expressionArray[0]);
        } else if (expressionArray.length == 2) {
            pair = this.mExpressionTranslation.constructOverflowCheckForArithmeticExpression(iLocation, n, cPrimitive, expressionArray[0], expressionArray[1]);
        } else {
            throw new AssertionError((Object)"no such operation");
        }
        this.mExpressionTranslation.addOverflowCheck(iLocation, (Expression)pair.getFirst(), expressionResultBuilder);
        this.mExpressionTranslation.addOverflowCheck(iLocation, (Expression)pair.getSecond(), expressionResultBuilder);
    }

    private ExpressionResultBuilder addBaseEqualityCheck(ILocation iLocation, Expression expression, ExpressionResultBuilder expressionResultBuilder) {
        switch (this.mPointerSubtractionAndComparisonValidityCheckMode) {
            case CHECK: {
                AssertStatement assertStatement = new AssertStatement(iLocation, expression);
                Check check = new Check(Spec.ILLEGAL_POINTER_ARITHMETIC);
                check.annotate((IElement)assertStatement);
                expressionResultBuilder.addStatement((Statement)assertStatement);
                return expressionResultBuilder;
            }
            case ASSUME: {
                AssumeStatement assumeStatement = new AssumeStatement(iLocation, expression);
                expressionResultBuilder.addStatement((Statement)assumeStatement);
                return expressionResultBuilder;
            }
            case IGNORE: {
                return expressionResultBuilder;
            }
        }
        throw new AssertionError((Object)"unknown value");
    }

    private boolean isNullPointerEquivalent(RValue rValue) {
        return BigInteger.ZERO.equals(this.mTypeSizes.extractIntegerValue(rValue));
    }

    private void addOffsetInBoundsCheck(ILocation iLocation, Expression expression, ExpressionResultBuilder expressionResultBuilder) {
    }

    private static void assignAuxVar(ILocation iLocation, ExpressionResult expressionResult, ExpressionResultBuilder expressionResultBuilder, AuxVarInfo auxVarInfo, List<Statement> list, boolean bl) {
        list.addAll(expressionResult.getStatements());
        if (auxVarInfo != null && !bl) {
            LeftHandSide[] leftHandSideArray = new LeftHandSide[]{auxVarInfo.getLhs()};
            Expression expression = expressionResult.getLrValue().getValue();
            AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])leftHandSideArray, (Expression[])new Expression[]{expression});
            for (Overapprox overapprox : expressionResultBuilder.getOverappr()) {
                overapprox.annotate((IElement)assignmentStatement);
            }
            list.add((Statement)assignmentStatement);
        }
        expressionResultBuilder.addAllExceptLrValueAndStatements(expressionResult);
    }

    public CExpressionTranslator disableChecksForUndefinedBehavior() {
        return new CExpressionTranslator(this.mMemoryHandler, this.mExpressionTranslation, this.mExprResultTransformer, this.mAuxVarInfoBuilder, this.mTypeSizes, this.mStaticObjectsHandler, CACSLPreferenceInitializer.CheckMode.IGNORE, CACSLPreferenceInitializer.CheckMode.IGNORE, CACSLPreferenceInitializer.CheckMode.IGNORE, CACSLPreferenceInitializer.CheckMode.IGNORE, this.mEnforceIfForConditional, this.mMemoryPointer);
    }
}

