/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureBase;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MemoryStructureSingleBitprecise
extends MemoryStructureBase {
    private final HeapDataArray mDataArray;
    private final int mResolution;

    public MemoryStructureSingleBitprecise(int n, TypeSizes typeSizes, ITypeHandler iTypeHandler) {
        super(typeSizes, iTypeHandler);
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ASTType aSTType = iTypeHandler.byteSize2AstType(cACSLLocation, CPrimitive.CPrimitiveCategory.INTTYPE, n);
        BoogieType boogieType = this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType);
        this.mResolution = n;
        this.mDataArray = new HeapDataArray("int", aSTType, boogieType, this.mTypeHandler.getBoogiePointerType(), n);
    }

    @Override
    public String getProcedureSuffix(CPrimitive.CPrimitives cPrimitives) {
        return this.mDataArray.getName() + String.valueOf((Object)cPrimitives.getPrimitiveCategory()) + String.valueOf(this.mTypeSizes.getSize(cPrimitives));
    }

    @Override
    public HeapDataArray getDataHeapArray(CPrimitive.CPrimitives cPrimitives) {
        return this.mDataArray;
    }

    @Override
    public List<MemoryStructureBase.ReadWriteDefinition> getReadWriteDefinitionForNonPointerHeapDataArray(HeapDataArray heapDataArray, RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        HashRelation3 hashRelation3 = new HashRelation3();
        for (CPrimitive.CPrimitives arrayList2 : requiredMemoryModelFeatures.getDataOnHeapRequired()) {
            int n = this.mTypeSizes.getSize(arrayList2);
            if (this.getDataHeapArray(arrayList2) != heapDataArray) continue;
            hashRelation3.addTriple((Object)arrayList2.getPrimitiveCategory(), (Object)n, (Object)arrayList2);
        }
        ArrayList<MemoryStructureBase.ReadWriteDefinition> arrayList = new ArrayList<MemoryStructureBase.ReadWriteDefinition>();
        for (Object object : hashRelation3.projectToFst()) {
            for (Integer n : hashRelation3.projectToSnd(object)) {
                Set set = hashRelation3.projectToTrd(object, (Object)n);
                CPrimitive.CPrimitives cPrimitives = (CPrimitive.CPrimitives)((Object)set.iterator().next());
                String string = this.getProcedureSuffix(cPrimitives);
                ASTType aSTType = this.mTypeHandler.cType2AstType(LocationFactory.createIgnoreCLocation(), new CPrimitive(cPrimitives));
                boolean bl = DataStructureUtils.haveNonEmptyIntersection(requiredMemoryModelFeatures.getUncheckedWriteRequired(), (Set)set);
                boolean bl2 = DataStructureUtils.haveNonEmptyIntersection(requiredMemoryModelFeatures.getInitWriteRequired(), (Set)set);
                arrayList.add(new MemoryStructureBase.ReadWriteDefinition(string, n, aSTType, new CPrimitive(cPrimitives), bl, bl2));
            }
        }
        return arrayList;
    }

    @Override
    protected int bytesizeOfStoredPointerComponents() {
        return this.mTypeSizes.getSizeOfPointer();
    }

    public int getResolution() {
        return this.mResolution;
    }
}

