/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;

public class AuxVarInfoBuilder {
    private final INameHandler mNameHandler;
    private final ITypeHandler mTypeHandler;
    private final ProcedureManager mProcedureManager;

    public AuxVarInfoBuilder(INameHandler iNameHandler, ITypeHandler iTypeHandler, ProcedureManager procedureManager) {
        this.mNameHandler = iNameHandler;
        this.mTypeHandler = iTypeHandler;
        this.mProcedureManager = procedureManager;
    }

    public AuxVarInfo constructAuxVarInfo(ILocation iLocation, ICType iCType, SFO.AUXVAR aUXVAR) {
        String string = this.mNameHandler.getTempVarUID(aUXVAR, iCType);
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, iCType);
        return this.constructAuxVarHelper(iLocation, string, aSTType, this.mProcedureManager.isGlobalScope());
    }

    public AuxVarInfo constructAuxVarInfo(ILocation iLocation, ICType iCType, ASTType aSTType, SFO.AUXVAR aUXVAR) {
        String string = this.mNameHandler.getTempVarUID(aUXVAR, iCType);
        return this.constructAuxVarHelper(iLocation, string, aSTType, false);
    }

    public AuxVarInfo constructAuxVarInfo(ILocation iLocation, ASTType aSTType, SFO.AUXVAR aUXVAR) {
        String string = this.mNameHandler.getTempVarUID(aUXVAR, null);
        return this.constructAuxVarHelper(iLocation, string, aSTType, false);
    }

    public AuxVarInfo constructGlobalAuxVarInfo(ILocation iLocation, ICType iCType, SFO.AUXVAR aUXVAR) {
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, iCType);
        return this.constructGlobalAuxVarInfo(iLocation, iCType, aSTType, aUXVAR);
    }

    public AuxVarInfo constructGlobalAuxVarInfo(ILocation iLocation, ICType iCType, ASTType aSTType, SFO.AUXVAR aUXVAR) {
        String string = this.mNameHandler.getTempVarUID(aUXVAR, iCType);
        return this.constructAuxVarHelper(iLocation, string, aSTType, true);
    }

    private AuxVarInfo constructAuxVarHelper(ILocation iLocation, String string, ASTType aSTType, boolean bl) {
        DeclarationInformation declarationInformation = bl ? DeclarationInformation.DECLARATIONINFO_GLOBAL : new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.mProcedureManager.getCurrentProcedureID());
        return this.constructAuxVarHelper(iLocation, string, aSTType, declarationInformation);
    }

    private AuxVarInfo constructAuxVarHelper(ILocation iLocation, String string, ASTType aSTType, DeclarationInformation declarationInformation) {
        VariableDeclaration variableDeclaration = new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{new VarList(iLocation, new String[]{string}, aSTType)});
        VariableLHS variableLHS = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)string, (DeclarationInformation)declarationInformation);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)string, (DeclarationInformation)declarationInformation);
        return new AuxVarInfo(variableDeclaration, variableLHS, identifierExpression);
    }

    public AuxVarInfo constructAuxVarInfoForBlockScope(ILocation iLocation, ICType iCType, SFO.AUXVAR aUXVAR, DeclarationInformation declarationInformation) {
        assert (aUXVAR == SFO.AUXVAR.COMPOUNDLITERAL) : "only block-scope aux vars are allowed here (extend the assertion if you added a new one)";
        String string = this.mNameHandler.getTempVarUIDForBlockScope(aUXVAR, iCType);
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, iCType);
        return this.constructAuxVarHelper(iLocation, string, aSTType, declarationInformation);
    }
}

