/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ArrayCellAccess {
    private final MultiDimensionalSelect mMdSelect;
    private final Term mSimpleArrayTerm;

    public ArrayCellAccess(MultiDimensionalSelect multiDimensionalSelect) {
        this.mMdSelect = multiDimensionalSelect;
        Term term = multiDimensionalSelect.getArray();
        while (SmtUtils.isFunctionApplication((Term)term, (String)"store")) {
            term = ((ApplicationTerm)term).getParameters()[0];
        }
        this.mSimpleArrayTerm = term;
    }

    public static List<ArrayCellAccess> extractArrayCellAccesses(Term term) {
        ArrayList<ArrayCellAccess> arrayList = new ArrayList<ArrayCellAccess>();
        List list = MultiDimensionalSelect.extractSelectShallow((Term)term);
        list.forEach(multiDimensionalSelect -> {
            boolean bl = arrayList.add(new ArrayCellAccess((MultiDimensionalSelect)multiDimensionalSelect));
        });
        return arrayList;
    }

    public Term getArray() {
        return this.mMdSelect.getArray();
    }

    public Term getSimpleArray() {
        return this.mSimpleArrayTerm;
    }

    public ArrayIndex getIndex() {
        return this.mMdSelect.getIndex();
    }

    public String toString() {
        return this.mMdSelect.toString();
    }

    public Set<Integer> getDimensionsOfIndexTerm(Term term) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        while (n < this.mMdSelect.getIndex().size()) {
            if (term.equals(this.mMdSelect.getIndex().get(n))) {
                hashSet.add(n);
            }
            ++n;
        }
        return hashSet;
    }

    public int hashCode() {
        return Objects.hash(this.mMdSelect);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArrayCellAccess arrayCellAccess = (ArrayCellAccess)object;
        return !(this.mMdSelect == null ? arrayCellAccess.mMdSelect != null : !this.mMdSelect.equals((Object)arrayCellAccess.mMdSelect));
    }
}

