/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.Parser;
import java.io.FileReader;
import java.io.InputStreamReader;

public class SMTLIBParser
implements IParser {
    @Override
    public int run(Script script, String string, OptionMap optionMap) {
        try {
            InputStreamReader inputStreamReader;
            SimpleSymbolFactory simpleSymbolFactory = new SimpleSymbolFactory();
            if (string == null) {
                string = "<stdin>";
                inputStreamReader = new InputStreamReader(System.in);
            } else {
                inputStreamReader = new FileReader(string);
            }
            Lexer lexer = new Lexer(inputStreamReader);
            lexer.setSymbolFactory(simpleSymbolFactory);
            Parser parser = new Parser(lexer, (SymbolFactory)simpleSymbolFactory);
            parser.setFileName(string);
            parser.setSolver(script, false);
            parser.parse();
            Term[] termArray = parser.benchmark.check();
            if (termArray != null) {
                int n = 0;
                while (n < termArray.length) {
                    System.out.println("Interpolant " + n + ": " + String.valueOf(termArray[n]));
                    ++n;
                }
            }
            parser.benchmark.close();
            return 0;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return 1;
        }
    }
}

