/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;

final class ProgressAwareTimer
implements IProgressAwareTimer {
    private final IProgressAwareTimer mParent;
    private final long mDeadline;

    private ProgressAwareTimer(IProgressAwareTimer iProgressAwareTimer, long l) {
        if (l <= 0L && l != -1L) {
            throw new IllegalArgumentException("deadline must be positive or -1");
        }
        this.mParent = iProgressAwareTimer;
        this.mDeadline = l;
    }

    private boolean isTimeout() {
        if (this.mDeadline == -1L) {
            return false;
        }
        return System.currentTimeMillis() > this.mDeadline;
    }

    public boolean continueProcessing() {
        if (this.mParent == null) {
            return !this.isTimeout();
        }
        return !this.isTimeout() && this.mParent.continueProcessing();
    }

    public IProgressAwareTimer getTimer(long l) {
        return ProgressAwareTimer.createWithTimeout(null, l);
    }

    public IProgressAwareTimer getChildTimer(long l) {
        return ProgressAwareTimer.createWithTimeout(this, l);
    }

    public IProgressAwareTimer getChildTimer(double d) {
        return ProgressAwareTimer.createWithPercentage(this, d);
    }

    public long getDeadline() {
        return this.mDeadline;
    }

    static IProgressAwareTimer createWithTimeout(IProgressAwareTimer iProgressAwareTimer, long l) {
        return ProgressAwareTimer.createWithDeadline(iProgressAwareTimer, System.currentTimeMillis() + l);
    }

    static IProgressAwareTimer createWithDeadline(IProgressAwareTimer iProgressAwareTimer, long l) {
        return new ProgressAwareTimer(iProgressAwareTimer, l);
    }

    static IProgressAwareTimer createWithPercentage(IProgressAwareTimer iProgressAwareTimer, double d) {
        if (iProgressAwareTimer == null) {
            throw new IllegalArgumentException("parent may not be null");
        }
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("percentage must be larger than zero and smaller or equal to one, but was " + d);
        }
        if (iProgressAwareTimer.getDeadline() == -1L) {
            return ProgressAwareTimer.createWithDeadline(iProgressAwareTimer, -1L);
        }
        long l = System.currentTimeMillis();
        long l2 = iProgressAwareTimer.getDeadline() - l;
        long l3 = (long)((double)l2 * d);
        return ProgressAwareTimer.createWithDeadline(iProgressAwareTimer, l + l3);
    }

    public IProgressAwareTimer getParent() {
        return this.mParent;
    }

    public long remainingTime() {
        long l;
        if (this.mDeadline == -1L) {
            if (this.mParent != null) {
                return this.mParent.remainingTime();
            }
            return -1L;
        }
        long l2 = System.currentTimeMillis();
        long l3 = Math.max(0L, this.mDeadline - l2);
        long l4 = l = this.mParent == null ? -1L : this.mParent.remainingTime();
        if (l == -1L) {
            return l3;
        }
        return Math.min(l3, l);
    }
}

