/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EqConstraint<NODE extends IEqNodeIdentifier<NODE>> {
    private final WeqCongruenceClosure<NODE> mWeqCc;
    private boolean mIsFrozen;
    final EqConstraintFactory<NODE> mFactory;
    private ImmutableSet<IProgramVar> mVariables;
    private Set<IProgramVarOrConst> mPvocs;
    private Term mTerm;
    private final int mId;

    public EqConstraint(int n, WeqCongruenceClosure<NODE> weqCongruenceClosure, EqConstraintFactory<NODE> eqConstraintFactory) {
        assert (n != Integer.MAX_VALUE) : "ran out of ids for EqConstraints";
        this.mId = n;
        this.mFactory = eqConstraintFactory;
        this.mWeqCc = weqCongruenceClosure;
    }

    private void freezeAndDontClose() {
        assert (!this.isInconsistent()) : "use EqBottomConstraint instead!!";
        assert (this.sanityCheck());
        assert (!this.mIsFrozen);
        this.mWeqCc.freezeOmitPropagations();
        this.mIsFrozen = true;
    }

    public boolean isBottom() {
        assert (!this.isInconsistent()) : "this should only be called on EqConstraints that are either consistent or an instance of EqBottomConstraint";
        assert (!this.mWeqCc.isInconsistent());
        return false;
    }

    public Set<NODE> getAllNodes() {
        return this.mWeqCc.getAllElements();
    }

    public boolean reportEqualityInPlace(NODE NODE, NODE NODE2) {
        assert (!this.isInconsistent());
        assert (!this.mIsFrozen);
        return this.mWeqCc.reportEquality(NODE, NODE2, false);
    }

    public boolean reportDisequalityInPlace(NODE NODE, NODE NODE2) {
        assert (!this.isInconsistent());
        assert (!this.mIsFrozen);
        boolean bl = this.mWeqCc.reportDisequality(NODE, NODE2);
        return bl;
    }

    public void reportWeakEquivalenceInPlace(NODE NODE, NODE NODE2, NODE NODE3) {
        assert (!this.isInconsistent());
        assert (!this.mIsFrozen);
        this.mFactory.getWeqCcManager().reportWeakEquivalence(this.mWeqCc, NODE, NODE2, NODE3, true);
    }

    public boolean isFrozen() {
        assert (!this.mIsFrozen || !this.isInconsistent()) : "an inconsistent constraint that is not EqBottomConstraint should never be frozen.";
        return this.mIsFrozen;
    }

    public boolean isInconsistent() {
        return this.mWeqCc.isInconsistent();
    }

    public boolean areEqual(NODE NODE, NODE NODE2, boolean bl) {
        if (bl) {
            WeqCongruenceClosure<NODE> weqCongruenceClosure = this.getWeqCcWithAddedNodes(NODE, NODE2);
            return weqCongruenceClosure.getEqualityStatus(NODE, NODE2) == EqualityStatus.EQUAL;
        }
        if (!this.mWeqCc.hasElement(NODE) || !this.mWeqCc.hasElement(NODE2)) {
            return false;
        }
        return this.mWeqCc.getEqualityStatus(NODE, NODE2) == EqualityStatus.EQUAL;
    }

    public boolean areUnequal(NODE NODE, NODE NODE2, boolean bl) {
        if (bl) {
            WeqCongruenceClosure<NODE> weqCongruenceClosure = this.getWeqCcWithAddedNodes(NODE, NODE2);
            return weqCongruenceClosure.getEqualityStatus(NODE, NODE2) == EqualityStatus.NOT_EQUAL;
        }
        if (!this.mWeqCc.hasElement(NODE) || !this.mWeqCc.hasElement(NODE2)) {
            return false;
        }
        return this.mWeqCc.getEqualityStatus(NODE, NODE2) == EqualityStatus.NOT_EQUAL;
    }

    private WeqCongruenceClosure<NODE> getWeqCcWithAddedNodes(NODE NODE, NODE NODE2) {
        assert (this.mWeqCc.isFrozen()) : "right?..";
        WeqCcManager<NODE> weqCcManager = this.mWeqCc.getManager();
        WeqCongruenceClosure<NODE> weqCongruenceClosure = weqCcManager.unfreeze(this.mWeqCc);
        weqCcManager.addNode(NODE, weqCongruenceClosure, true, false);
        weqCcManager.addNode(NODE2, weqCongruenceClosure, true, false);
        weqCongruenceClosure.freezeAndClose();
        return weqCongruenceClosure;
    }

    public Term getTerm(Script script) {
        assert (this.mIsFrozen) : "not yet frozen, term may not be final..";
        if (this.mTerm != null) {
            return this.mTerm;
        }
        Term term = WeqCcManager.weqCcToTerm(script, this.mWeqCc, this.mFactory.getWeqCcManager().getNonTheoryLiteralDisequalitiesIfNecessary());
        if (this.mIsFrozen) {
            this.mTerm = term;
        }
        return term;
    }

    public ImmutableSet<IProgramVar> getVariables(IIcfgSymbolTable iIcfgSymbolTable) {
        if (this.mVariables != null) {
            return this.mVariables;
        }
        Collection<TermVariable> collection = this.getAllTermVariables();
        this.mVariables = (ImmutableSet)collection.stream().map(iIcfgSymbolTable::getProgramVar).collect(ImmutableSet.collector());
        assert (!this.mVariables.stream().anyMatch(Objects::isNull));
        return this.mVariables;
    }

    public Set<IProgramVarOrConst> getPvocs(IIcfgSymbolTable iIcfgSymbolTable) {
        assert (this.mIsFrozen);
        if (this.mPvocs != null) {
            assert (!this.mPvocs.stream().anyMatch(Objects::isNull));
            return this.mPvocs;
        }
        this.mPvocs = new HashSet<IProgramVarOrConst>();
        this.mPvocs.addAll((Collection<IProgramVarOrConst>)this.getVariables(iIcfgSymbolTable));
        HashSet hashSet = new HashSet();
        this.mWeqCc.getAllElements().stream().forEach(iEqNodeIdentifier -> {
            boolean bl = hashSet.addAll(SmtUtils.extractConstants((Term)iEqNodeIdentifier.getTerm(), (boolean)false));
        });
        Function<IProgramFunction, IProgramConst> function = iProgramFunction -> (IProgramConst)iProgramFunction;
        this.mPvocs.addAll(hashSet.stream().map(applicationTerm -> iIcfgSymbolTable.getProgramFun(applicationTerm.getFunction())).map(function).collect(Collectors.toSet()));
        assert (!this.mPvocs.stream().anyMatch(Objects::isNull));
        return this.mPvocs;
    }

    public boolean isTop() {
        return this.mWeqCc.isTautological();
    }

    public EqConstraint<NODE> join(EqConstraint<NODE> eqConstraint) {
        if (this.isBottom()) {
            return eqConstraint;
        }
        if (eqConstraint.isBottom()) {
            return this;
        }
        if (this.isTop()) {
            return this;
        }
        if (eqConstraint.isTop()) {
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mFactory.getWeqCcManager().join(this.mWeqCc, eqConstraint.mWeqCc, true);
        return this.mFactory.getEqConstraint(weqCongruenceClosure, true);
    }

    public EqConstraint<NODE> widen(EqConstraint<NODE> eqConstraint) {
        if (this.isBottom()) {
            return eqConstraint;
        }
        if (eqConstraint.isBottom()) {
            return this;
        }
        if (this.isTop()) {
            return this;
        }
        if (eqConstraint.isTop()) {
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mFactory.getWeqCcManager().widen(this.mWeqCc, eqConstraint.mWeqCc, true);
        return this.mFactory.getEqConstraint(weqCongruenceClosure, true);
    }

    public boolean isStrongerThan(EqConstraint<NODE> eqConstraint) {
        return this.mFactory.getWeqCcManager().isStrongerThan(this.mWeqCc, eqConstraint.mWeqCc);
    }

    public Collection<TermVariable> getAllTermVariables() {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (IEqNodeIdentifier iEqNodeIdentifier : this.mWeqCc.getAllElements()) {
            if (iEqNodeIdentifier.isMixFunction()) {
                if (iEqNodeIdentifier.getMixFunction1() instanceof TermVariable) {
                    hashSet.add((TermVariable)iEqNodeIdentifier.getMixFunction1());
                }
                if (!(iEqNodeIdentifier.getMixFunction2() instanceof TermVariable)) continue;
                hashSet.add((TermVariable)iEqNodeIdentifier.getMixFunction2());
                continue;
            }
            hashSet.addAll(Arrays.asList(iEqNodeIdentifier.getTerm().getFreeVars()));
        }
        return hashSet;
    }

    boolean sanityCheck() {
        if (!this.mWeqCc.weqGraphFreeOfArrayEqualities()) {
            assert (false);
            return false;
        }
        return this.mWeqCc.sanityCheck();
    }

    public Integer getStatistics(VPStatistics vPStatistics) {
        switch (vPStatistics) {
            // Empty switch
        }
        return this.mWeqCc.getStatistics(vPStatistics);
    }

    public String toString() {
        return "EqConstraint#" + this.mId + "\n" + this.mWeqCc.toString();
    }

    public String toLogString() {
        return "EqConstraint#" + this.mId + "\n" + this.mWeqCc.toLogString();
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EqConstraint eqConstraint = (EqConstraint)object;
        return this.mId == eqConstraint.mId;
    }

    public WeqCongruenceClosure<NODE> getWeqCc() {
        return this.mWeqCc;
    }

    public void superficialFreeze() {
        assert (this.mWeqCc.isFrozen());
        this.mIsFrozen = true;
    }

    public void freezeIfNecessary() {
        if (!this.isFrozen()) {
            this.freezeAndDontClose();
        }
    }

    public Set<NODE> getAllLiteralNodes() {
        return this.mWeqCc.getAllLiterals();
    }

    public boolean isClosed() {
        return this.mWeqCc.isClosed();
    }

    public Set<NODE> getSetConstraintForExpression(NODE NODE) {
        SetConstraint setConstraint2;
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mFactory.getWeqCcManager().unfreezeIfNecessary(this.mWeqCc);
        weqCongruenceClosure.addElement(NODE, false);
        CCLiteralSetConstraints cCLiteralSetConstraints = weqCongruenceClosure.getCongruenceClosure().getLiteralSetConstraints();
        Set set = cCLiteralSetConstraints.getContainsConstraint(NODE);
        Optional<SetConstraint> optional = set.stream().filter(setConstraint -> setConstraint.hasOnlyLiterals()).findFirst();
        try {
            setConstraint2 = optional.get();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        assert (setConstraint2.hasOnlyLiterals());
        return setConstraint2.getLiterals();
    }
}

