/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UnmodifiableTransFormula
extends TransFormula
implements Serializable {
    private static final long serialVersionUID = 7058102586141801399L;
    private final Term mFormula;
    private final Set<IProgramVar> mAssignedVars;
    private final Set<TermVariable> mBranchEncoders;
    private final Infeasibility mInfeasibility;
    private final Term mClosedFormula;

    UnmodifiableTransFormula(Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, ImmutableSet<IProgramConst> immutableSet, ImmutableSet<TermVariable> immutableSet2, ImmutableSet<TermVariable> immutableSet3, Infeasibility infeasibility, ManagedScript managedScript) {
        super(map, map2, (Set<TermVariable>)immutableSet2, (Set<IProgramConst>)immutableSet);
        assert (UltimateNormalFormUtils.respectsUltimateNormalForm((Term)term)) : "Term not in UltimateNormalForm";
        this.mFormula = term;
        this.mBranchEncoders = immutableSet3;
        this.mInfeasibility = infeasibility;
        this.mClosedFormula = UnmodifiableTransFormula.computeClosedFormula(term, super.getInVars(), super.getOutVars(), super.getAuxVars(), managedScript);
        this.mAssignedVars = TransFormulaUtils.computeAssignedVars(map, map2);
        assert (SmtUtils.neitherKeyNorValueIsNull(map)) : "null in inVars";
        assert (SmtUtils.neitherKeyNorValueIsNull(map2)) : "null in outVars";
        assert (!immutableSet3.isEmpty() || this.mClosedFormula.getFreeVars().length == 0) : String.format("free variables %s", Arrays.asList(this.mClosedFormula.getFreeVars()));
        assert (this.allSubsetInOutAuxBranch()) : "unexpected vars in TransFormula";
        assert (this.eachAuxVarOccursInFormula() == null) : "Superfluous aux var: " + String.valueOf(this.eachAuxVarOccursInFormula());
        assert (this.termVariablesHaveUniqueProgramVar()) : "Same TermVariable used for different program variables";
        assert (this.doConstantConsistencyCheck()) : "consts inconsistent";
        assert (this.disjointVarSets()) : "non-disjoint vars in TransFormula";
    }

    public static Term computeClosedFormula(Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, Set<TermVariable> set, ManagedScript managedScript) {
        Object object;
        HashMap<TermVariable, Object> hashMap = new HashMap<TermVariable, Object>();
        for (Map.Entry<IProgramVar, TermVariable> termVariable : map.entrySet()) {
            object = termVariable.getValue();
            assert (!hashMap.containsKey(object));
            hashMap.put((TermVariable)object, UnmodifiableTransFormula.getConstantForInVar(termVariable.getKey()));
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : map2.entrySet()) {
            object = entry.getKey();
            TermVariable termVariable = entry.getValue();
            if (map.get(object) == termVariable) continue;
            hashMap.put(termVariable, UnmodifiableTransFormula.getConstantForOutVar(entry.getKey(), map, map2));
        }
        for (TermVariable termVariable : set) {
            object = ProgramVarUtils.constructConstantForAuxVar(managedScript, termVariable);
            hashMap.put(termVariable, object);
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
    }

    public static Term getConstantForInVar(IProgramVar iProgramVar) {
        return iProgramVar.getDefaultConstant();
    }

    public static Term getConstantForOutVar(IProgramVar iProgramVar, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Term term;
        Term term2 = (Term)map.get(iProgramVar);
        if (term2 == (term = (Term)map2.get(iProgramVar))) {
            return iProgramVar.getDefaultConstant();
        }
        return iProgramVar.getPrimedConstant();
    }

    private boolean allSubsetInOutAuxBranch() {
        boolean bl = true;
        TermVariable[] termVariableArray = this.mFormula.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable;
            assert (bl &= this.mInVars.containsValue(termVariable = termVariableArray[n2]) || this.mOutVars.containsValue(termVariable) || this.mAuxVars.contains(termVariable) || this.mBranchEncoders.contains(termVariable)) : "unexpected variable in formula";
            ++n2;
        }
        return bl;
    }

    private boolean disjointVarSets() {
        boolean bl = true;
        for (TermVariable termVariable : super.getInVars().values()) {
            assert (bl &= !super.getAuxVars().contains(termVariable)) : "in var is also aux var: " + String.valueOf(termVariable);
        }
        for (TermVariable termVariable : super.getOutVars().values()) {
            assert (bl &= !super.getAuxVars().contains(termVariable)) : "out var is also aux var: " + String.valueOf(termVariable);
        }
        return bl;
    }

    private TermVariable eachAuxVarOccursInFormula() {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(this.mFormula.getFreeVars()));
        for (TermVariable termVariable : super.getAuxVars()) {
            if (hashSet.contains(termVariable)) continue;
            return termVariable;
        }
        return null;
    }

    private boolean termVariablesHaveUniqueProgramVar() {
        IProgramVar iProgramVar;
        HashMap<TermVariable, IProgramVar> hashMap = new HashMap<TermVariable, IProgramVar>();
        for (Map.Entry entry : this.mInVars.entrySet()) {
            iProgramVar = (IProgramVar)hashMap.get(entry.getValue());
            if (iProgramVar != null && iProgramVar != entry.getKey()) {
                return false;
            }
            hashMap.put((TermVariable)entry.getValue(), (IProgramVar)entry.getKey());
        }
        for (Map.Entry entry : this.mOutVars.entrySet()) {
            iProgramVar = (IProgramVar)hashMap.get(entry.getValue());
            if (iProgramVar != null && iProgramVar != entry.getKey()) {
                return false;
            }
            hashMap.put((TermVariable)entry.getValue(), (IProgramVar)entry.getKey());
        }
        return true;
    }

    private boolean doConstantConsistencyCheck() {
        boolean bl = true;
        Set set = SmtUtils.extractConstants((Term)this.mFormula, (boolean)false);
        HashSet<ApplicationTerm> hashSet = new HashSet<ApplicationTerm>();
        for (IProgramConst iProgramConst : this.getNonTheoryConsts()) {
            assert (bl &= !iProgramConst.getDefaultConstant().getFunction().isIntern()) : "is theory symbol";
            hashSet.add(iProgramConst.getDefaultConstant());
            assert (bl &= set.contains(iProgramConst.getDefaultConstant())) : "not in formula";
        }
        for (IProgramConst iProgramConst : set) {
            if (!iProgramConst.getFunction().isIntern()) assert (bl &= hashSet.contains(iProgramConst)) : "not in const set: " + String.valueOf(iProgramConst);
        }
        return bl;
    }

    @Override
    public Term getFormula() {
        return this.mFormula;
    }

    public Set<TermVariable> getBranchEncoders() {
        return Collections.unmodifiableSet(this.mBranchEncoders);
    }

    public Term getClosedFormula() {
        return this.mClosedFormula;
    }

    @Override
    public Set<IProgramVar> getAssignedVars() {
        return Collections.unmodifiableSet(this.mAssignedVars);
    }

    public String toString() {
        return this.toStringInternal(this.mFormula.toString());
    }

    public String toStringDirect() {
        return this.toStringInternal(this.mFormula.toStringDirect());
    }

    private String toStringInternal(String string) {
        return "Formula: " + string + "  InVars " + String.valueOf(super.getInVars()) + "  OutVars" + String.valueOf(super.getOutVars()) + "  AuxVars" + String.valueOf(super.getAuxVars()) + "  AssignedVars" + String.valueOf(this.mAssignedVars);
    }

    public Infeasibility isInfeasible() {
        return this.mInfeasibility;
    }

    public static enum Infeasibility {
        INFEASIBLE,
        UNPROVEABLE,
        NOT_DETERMINED;

    }
}

