/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.ChainingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.MonolithicHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import java.util.function.Predicate;

public final class HoareTripleCheckerUtils {
    private static final boolean REVIEW_SMT_RESULTS_IF_ASSERTIONS_ENABLED = true;
    private static final boolean REVIEW_SD_RESULTS_IF_ASSERTIONS_ENABLED = true;
    private static final boolean UNKNOWN_FOR_ALL_QUANTIFIED_PREDICATES = false;
    private static final boolean UNKNOWN_FOR_ALL_QUANTIFIED_TRANSFORMULAS = false;

    private HoareTripleCheckerUtils() {
    }

    public static ChainingHoareTripleChecker constructEfficientHoareTripleChecker(IUltimateServiceProvider iUltimateServiceProvider, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit cfgSmtToolkit, IPredicateUnifier iPredicateUnifier) {
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(HoareTripleCheckerUtils.class);
        ChainingHoareTripleChecker chainingHoareTripleChecker = HoareTripleCheckerUtils.constructSdHoareTripleChecker(iLogger, cfgSmtToolkit, iPredicateUnifier);
        ChainingHoareTripleChecker chainingHoareTripleChecker2 = HoareTripleCheckerUtils.constructSmtHoareTripleChecker(iLogger, hoareTripleChecks, cfgSmtToolkit, iPredicateUnifier);
        return chainingHoareTripleChecker.andThen(chainingHoareTripleChecker2);
    }

    public static ChainingHoareTripleChecker constructSdHoareTripleChecker(ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, IPredicateUnifier iPredicateUnifier) {
        ChainingHoareTripleChecker chainingHoareTripleChecker = ChainingHoareTripleChecker.with(iLogger, new SdHoareTripleChecker(cfgSmtToolkit, iPredicateUnifier));
        chainingHoareTripleChecker = chainingHoareTripleChecker.reviewWith(new MonolithicHoareTripleChecker(cfgSmtToolkit));
        return chainingHoareTripleChecker;
    }

    public static ChainingHoareTripleChecker constructSmtHoareTripleChecker(ILogger iLogger, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit cfgSmtToolkit, IPredicateUnifier iPredicateUnifier) {
        IHoareTripleChecker iHoareTripleChecker = switch (hoareTripleChecks) {
            case HoareTripleChecks.MONOLITHIC -> new MonolithicHoareTripleChecker(cfgSmtToolkit);
            case HoareTripleChecks.INCREMENTAL -> new IncrementalHoareTripleChecker(cfgSmtToolkit, false);
            default -> throw new MatchException(null, null);
        };
        ChainingHoareTripleChecker chainingHoareTripleChecker = ChainingHoareTripleChecker.with(iLogger, iHoareTripleChecker);
        SubtermPropertyChecker subtermPropertyChecker = new SubtermPropertyChecker(QuantifiedFormula.class::isInstance);
        Predicate<IPredicate> predicate = iPredicate -> iPredicateUnifier.isIntricatePredicate((IPredicate)iPredicate);
        chainingHoareTripleChecker = chainingHoareTripleChecker.predicatesProtectedBy(predicate);
        chainingHoareTripleChecker = chainingHoareTripleChecker.reviewWith(new MonolithicHoareTripleChecker(cfgSmtToolkit));
        return chainingHoareTripleChecker;
    }

    public static IHoareTripleChecker constructEfficientHoareTripleCheckerWithCaching(IUltimateServiceProvider iUltimateServiceProvider, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit cfgSmtToolkit, IPredicateUnifier iPredicateUnifier) {
        return new CachingHoareTripleChecker(iUltimateServiceProvider, HoareTripleCheckerUtils.constructEfficientHoareTripleChecker(iUltimateServiceProvider, hoareTripleChecks, cfgSmtToolkit, iPredicateUnifier), iPredicateUnifier);
    }

    public static IHoareTripleChecker constructEfficientHoareTripleCheckerWithCaching(IUltimateServiceProvider iUltimateServiceProvider, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit cfgSmtToolkit, IPredicateUnifier iPredicateUnifier, HoareTripleCheckerCache hoareTripleCheckerCache) {
        return new CachingHoareTripleChecker(iUltimateServiceProvider, HoareTripleCheckerUtils.constructEfficientHoareTripleChecker(iUltimateServiceProvider, hoareTripleChecks, cfgSmtToolkit, iPredicateUnifier), iPredicateUnifier, hoareTripleCheckerCache);
    }

    public static enum HoareTripleChecks {
        MONOLITHIC,
        INCREMENTAL;

    }
}

