/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransitiveClosureIG<T extends IPredicate> {
    private Set<ImplicationVertex<T>> mVertices;
    private final Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> mDescendantsMapping;
    private final Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> mAncestorsMapping;

    public TransitiveClosureIG(ImplicationGraph<T> implicationGraph) {
        this.mVertices = new HashSet<ImplicationVertex<T>>(implicationGraph.getVertices());
        this.mDescendantsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.mAncestorsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.constructTransitiveClosure();
    }

    private void constructTransitiveClosure() {
        this.mVertices.forEach(implicationVertex -> {
            HashSet hashSet = this.mDescendantsMapping.put((ImplicationVertex<T>)implicationVertex, new HashSet(implicationVertex.getDescendants()));
        });
        this.mVertices.forEach(implicationVertex -> {
            HashSet hashSet = this.mAncestorsMapping.put((ImplicationVertex<T>)implicationVertex, new HashSet(implicationVertex.getAncestors()));
        });
    }

    public TransitiveClosureIG(ImplicationGraph<T> implicationGraph, Set<ImplicationVertex<T>> set) {
        this.mVertices = new HashSet<ImplicationVertex<T>>(set.iterator().next().getDescendants());
        for (ImplicationVertex<T> implicationVertex : set) {
            HashSet<ImplicationVertex<T>> hashSet = new HashSet<ImplicationVertex<T>>();
            for (ImplicationVertex<T> implicationVertex2 : this.mVertices) {
                if (!implicationVertex.getDescendants().contains(implicationVertex2)) continue;
                hashSet.add(implicationVertex2);
            }
            this.mVertices = hashSet;
        }
        this.mVertices.addAll(set);
        this.mDescendantsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.mAncestorsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.constructSubTransitiveClosure();
    }

    private void constructSubTransitiveClosure() {
        for (ImplicationVertex<T> implicationVertex : this.mVertices) {
            ImplicationVertex<T> implicationVertex22;
            HashSet<Object> hashSet = new HashSet<Object>();
            for (ImplicationVertex<T> implicationVertex22 : implicationVertex.getDescendants()) {
                if (!this.mVertices.contains(implicationVertex22)) continue;
                hashSet.add(implicationVertex22);
            }
            this.mDescendantsMapping.put(implicationVertex, hashSet);
            implicationVertex22 = new HashSet();
            for (ImplicationVertex<T> implicationVertex3 : implicationVertex.getAncestors()) {
                if (!this.mVertices.contains(implicationVertex3)) continue;
                implicationVertex22.add(implicationVertex3);
            }
            this.mAncestorsMapping.put(implicationVertex, (Set<ImplicationVertex<T>>)((Object)implicationVertex22));
        }
    }

    public TransitiveClosureIG(ImplicationVertex<T> implicationVertex, Set<ImplicationVertex<T>> set, ImplicationVertex<T> implicationVertex2) {
        this.mVertices = new HashSet<ImplicationVertex<T>>(set);
        this.mVertices.add(implicationVertex);
        this.mDescendantsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.mAncestorsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        for (ImplicationVertex<T> implicationVertex3 : this.mVertices) {
            ImplicationVertex<T> implicationVertex42;
            HashSet<Object> hashSet = new HashSet<Object>();
            for (ImplicationVertex<T> implicationVertex42 : implicationVertex3.getDescendants()) {
                if (!this.mVertices.contains(implicationVertex42)) continue;
                hashSet.add(implicationVertex42);
            }
            this.mDescendantsMapping.put(implicationVertex3, hashSet);
            implicationVertex42 = new HashSet();
            for (ImplicationVertex<T> implicationVertex5 : implicationVertex3.getAncestors()) {
                if (!this.mVertices.contains(implicationVertex5)) continue;
                implicationVertex42.add(implicationVertex5);
            }
            this.mAncestorsMapping.put(implicationVertex3, (Set<ImplicationVertex<T>>)((Object)implicationVertex42));
        }
        this.mVertices.add(implicationVertex2);
        this.mAncestorsMapping.put(implicationVertex2, new HashSet());
        this.mDescendantsMapping.put(implicationVertex2, new HashSet());
        for (ImplicationVertex<T> implicationVertex3 : this.mAncestorsMapping.keySet()) {
            if (!this.mAncestorsMapping.get(implicationVertex3).isEmpty()) continue;
            this.mAncestorsMapping.get(implicationVertex3).add(implicationVertex2);
            this.mDescendantsMapping.get(implicationVertex2).add(implicationVertex3);
        }
    }

    protected void removeVertex(ImplicationVertex<T> implicationVertex) {
        if (this.mVertices.remove(implicationVertex)) {
            Set<ImplicationVertex<ImplicationVertex>> set = this.mDescendantsMapping.remove(implicationVertex);
            set.forEach(implicationVertex2 -> {
                boolean bl = this.mAncestorsMapping.get(implicationVertex2).remove(implicationVertex);
            });
            Set<ImplicationVertex<ImplicationVertex>> set2 = this.mAncestorsMapping.remove(implicationVertex);
            set2.forEach(implicationVertex2 -> {
                boolean bl = this.mDescendantsMapping.get(implicationVertex2).remove(implicationVertex);
            });
        }
    }

    public void removeAncestorsFromTC(ImplicationVertex<T> implicationVertex) {
        while (!this.mAncestorsMapping.get(implicationVertex).isEmpty()) {
            ImplicationVertex<T> implicationVertex3 = this.mAncestorsMapping.get(implicationVertex).iterator().next();
            if (!this.mVertices.remove(implicationVertex3)) continue;
            Set<ImplicationVertex<ImplicationVertex>> set = this.mDescendantsMapping.remove(implicationVertex3);
            set.forEach(implicationVertex2 -> {
                boolean bl = this.mAncestorsMapping.get(implicationVertex2).remove(implicationVertex3);
            });
            Set<ImplicationVertex<ImplicationVertex>> set2 = this.mAncestorsMapping.remove(implicationVertex3);
            set2.forEach(implicationVertex2 -> {
                boolean bl = this.mDescendantsMapping.get(implicationVertex2).remove(implicationVertex3);
            });
        }
    }

    public void removeDescendantsFromTC(ImplicationVertex<T> implicationVertex, ImplicationVertex<T> implicationVertex2) {
        if (implicationVertex2 == null) {
            while (!this.mDescendantsMapping.get(implicationVertex).isEmpty()) {
                this.removeVertex(this.mDescendantsMapping.get(implicationVertex).iterator().next());
            }
        } else {
            HashSet hashSet = new HashSet(this.mDescendantsMapping.get(implicationVertex));
            while (!hashSet.isEmpty()) {
                implicationVertex = (ImplicationVertex)hashSet.iterator().next();
                hashSet.remove(implicationVertex);
                if (!implicationVertex.equals(implicationVertex2)) {
                    this.removeVertex(implicationVertex);
                    continue;
                }
                this.mAncestorsMapping.get(implicationVertex2).clear();
            }
            for (ImplicationVertex<T> implicationVertex3 : this.mDescendantsMapping.keySet()) {
                if (!this.mDescendantsMapping.get(implicationVertex3).isEmpty()) continue;
                this.mDescendantsMapping.get(implicationVertex3).add(implicationVertex2);
                this.mAncestorsMapping.get(implicationVertex2).add(implicationVertex3);
            }
        }
    }

    protected ImplicationVertex<T> getMaxTransitiveClosureCount(Set<ImplicationVertex<T>> set, boolean bl) {
        int n = 0;
        ImplicationVertex<T> implicationVertex = this.mVertices.iterator().next();
        for (ImplicationVertex<T> implicationVertex2 : this.mVertices) {
            if (set.contains(implicationVertex2)) continue;
            int n2 = this.mAncestorsMapping.get(implicationVertex2).size();
            int n3 = this.mDescendantsMapping.get(implicationVertex2).size();
            if (bl) {
                ++n3;
            } else {
                ++n2;
            }
            int n4 = n2 * n3 / (n2 + n3);
            if (n4 < n) continue;
            n = n4;
            implicationVertex = implicationVertex2;
        }
        return implicationVertex;
    }

    protected Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> getDescendantsMapping() {
        return this.mDescendantsMapping;
    }

    protected Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> getAncestorsMapping() {
        return this.mAncestorsMapping;
    }

    protected Set<ImplicationVertex<T>> getVertices() {
        return this.mVertices;
    }
}

