/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.HashMap;
import java.util.Map;

public class TgfBuilder<N> {
    private final StringBuilder mTgfNodes = new StringBuilder();
    private final StringBuilder mTgfEdges = new StringBuilder();
    private final Map<N, Integer> mNodeToId = new HashMap<N, Integer>();

    public TgfBuilder<N> addEdge(N n, Object object, N n2) {
        this.mTgfEdges.append(this.nodeId(n)).append(' ').append(this.nodeId(n2)).append(' ').append(TgfBuilder.labelOf(object)).append('\n');
        return this;
    }

    public TgfBuilder<N> addDisconnectedNode(N n) {
        this.nodeId(n);
        return this;
    }

    private int nodeId(N n) {
        return this.mNodeToId.computeIfAbsent(n, this::computeNewNodeIdAndAddToTgf);
    }

    private int computeNewNodeIdAndAddToTgf(N n) {
        int n2 = this.mNodeToId.size();
        this.mTgfNodes.append(n2).append(' ').append(TgfBuilder.labelOf(n)).append('\n');
        return n2;
    }

    private static String labelOf(Object object) {
        return object.toString().replace('\n', '@');
    }

    public String toString() {
        return this.mTgfNodes + "#\n" + this.mTgfEdges;
    }

    public void reset() {
        this.mTgfNodes.setLength(0);
        this.mTgfEdges.setLength(0);
        this.mNodeToId.clear();
    }
}

